/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dFont;
import hec.gfx2d.G2dFontPropertiesPanel;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPatternPropertiesPanel;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.G2dResolutionConst;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.text.TextSubstitutionManager;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import rma.swing.DefaultJPanel;
import rma.swing.RmaColor;
import rma.swing.RmaImage;
import rma.swing.RmaJMenuLabel;
import rma.util.FillPatternFactory;
import rma.util.RmaDrawConst;

public class G2dLabel
extends G2dComponent
implements Observer {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ROTATE_0 = 0;
    public static final int ROTATE_90 = 90;
    public static final int ROTATE_180 = 180;
    public static final int ROTATE_270 = 270;
    private static final int ICON_TEXT_SPACE = 2;
    String[] _text = null;
    G2dLabelDrawProp _drawProp = new G2dLabelDrawProp();
    Icon _icon = null;
    List<ActionListener> mPropertiesOKListeners = new ArrayList<ActionListener>();

    public G2dLabel(G2dPanel p, int align) {
        super(p);
        this._drawProp.align = align;
        this.setText("Label");
        super.setBackground(null);
    }

    public G2dLabel(G2dPanel p, int align, int rot) {
        this(p, align);
        this._drawProp.rotation = rot;
    }

    protected String getPopupMenuTitle() {
        return "G2d Label";
    }

    @Override
    public void createPopupMenu() {
        this._popupMenu = new JPopupMenu("Label Properties");
        RmaJMenuLabel label = new RmaJMenuLabel(this.getPopupMenuTitle());
        Font f = label.getFont();
        f = new Font(f.getName(), 2, f.getSize());
        label.setFont(f);
        this._popupMenu.add(label);
        this._popupMenu.addSeparator();
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.setName("EDIT_PROPERTIES");
        jm.addActionListener(new G2dComponent.EditPropertyListener());
        this._popupMenu.add(jm);
        this._popupMenu.add(jm);
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public void setProperties(G2dLabelDrawProp prop) {
        if (prop == null) {
            return;
        }
        this._drawProp = prop;
        if (prop.text != null && prop.text.length() > 0) {
            this.setText(prop.text, "\n");
        }
        this._icon = RmaImage.getImageIcon(this._drawProp.iconPath);
    }

    public G2dLabelDrawProp getProperties() {
        return this._drawProp;
    }

    public void setUseFontScaling(boolean b) {
        this._drawProp.useFontScaling = b;
    }

    public boolean getUseFontScaling() {
        return this._drawProp.useFontScaling();
    }

    public String getFontString() {
        Object fontString = this.getFontFamily();
        if (fontString == null || ((String)fontString).length() == 0) {
            fontString = this.getFont().getName();
        }
        fontString = (String)fontString + "," + this.getFontStyleString() + "," + this.getFontSize();
        return fontString;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.setFontInfo(f);
    }

    public void setFont(String fontString) {
        this.setFontInfo(G2dMarkerProperties.string2font(fontString));
    }

    public void setFontInfo(Font f) {
        try {
            this.setFontFamily(f.getFamily());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setFontStyle(f.getStyle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setFontSize(f.getSize());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFontSize(int sz) {
        this._drawProp.fontSize = sz;
    }

    public int getFontSize() {
        return this._drawProp.fontSize;
    }

    public void setFontSizes(int sz, int tiny, int min, int max) {
        this._drawProp.fontSize = sz;
        this._drawProp.tinyFontSize = tiny;
        this._drawProp.minFontSize = min;
        this._drawProp.maxFontSize = max;
        this._drawProp.font = null;
    }

    public int[] getFontSizes() {
        int[] sizes = new int[]{this._drawProp.fontSize, this._drawProp.tinyFontSize, this._drawProp.minFontSize, this._drawProp.maxFontSize};
        return sizes;
    }

    public void setFontStyle(String style) {
        if (style == null || style.length() == 0) {
            return;
        }
        style = style.toLowerCase();
        int fontStyle = 0;
        int index = style.indexOf("bold-italic");
        if (index != -1) {
            fontStyle = 3;
        }
        if (index == -1 && (index = style.indexOf("bolditalic")) != -1) {
            fontStyle = 3;
        }
        if (index == -1 && (index = style.indexOf("bold")) != -1) {
            fontStyle = 1;
        }
        if (index == -1 && (index = style.indexOf("italic")) != -1) {
            fontStyle = 2;
        }
        this.setFontStyle(fontStyle);
    }

    public int getFontStyle() {
        return this._drawProp.fontStyle;
    }

    public String getFontStyleString() {
        Object style = "";
        if ((this._drawProp.fontStyle & 1) != 0) {
            style = (String)style + "BOLD";
        }
        if ((this._drawProp.fontStyle & 2) != 0) {
            style = (String)style + "ITALIC";
        }
        if (((String)style).length() == 0) {
            return "PLAIN";
        }
        return style;
    }

    public void setFontStyle(int style) {
        this._drawProp.fontStyle = style;
    }

    public void setFontFamily(String fam) {
        this._drawProp.fontFamily = fam;
    }

    public String getFontFamily() {
        return this._drawProp.fontFamily;
    }

    public void setIcon(String iconPath) {
        ImageIcon icon = RmaImage.getImageIcon(iconPath);
        this._icon = null;
        if (icon == null) {
            this._drawProp.iconPath = "";
            return;
        }
        this._drawProp.iconPath = iconPath;
        this._icon = icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public String getIconPath() {
        return this._drawProp.iconPath;
    }

    public void setText(String txt) {
        this.setText(txt, "\n");
    }

    public void setText(String txt, String delim) {
        if (txt == null) {
            this._text = new String[0];
            this._drawProp.text = "";
            return;
        }
        StringTokenizer tok = new StringTokenizer(txt, delim);
        this._text = new String[tok.countTokens()];
        int icnt = 0;
        while (tok.hasMoreTokens()) {
            this._text[icnt] = tok.nextToken();
            ++icnt;
        }
        this._drawProp.text = txt;
    }

    public String getText() {
        if (this._text == null || this._text.length == 0) {
            return "";
        }
        Object text = "";
        for (int i = 0; i < this._text.length; ++i) {
            text = (String)text + this._text[i] + (i == this._text.length - 1 ? "" : "\n");
        }
        return text;
    }

    @Override
    public Dimension getMinimumSize() {
        Insets i;
        Border b;
        int g2dResolution = 1;
        if (this._parent != null) {
            g2dResolution = this._parent.getDeviceResoultion() / G2dResolutionConst.PRINTER_SCALE;
        }
        int width = 0;
        int height = 0;
        if (this._icon != null) {
            width = this._icon.getIconWidth();
            height = this._icon.getIconHeight();
        }
        if ((b = this.getBorder()) != null) {
            i = b.getBorderInsets(this);
            width += i.right + i.left;
            height += i.top + i.bottom;
        }
        if (this._drawProp.text != null) {
            if (this._icon != null) {
                height += 2;
            } else {
                i = this.getInsets();
                width += i.left + i.right;
                height += i.top + i.bottom;
            }
            Graphics g = this.getGraphics();
            Dimension d = this.getMinimumSize(g);
            if (!this._drawProp.text.equals("") || this._icon == null) {
                width += d.width;
                height += d.height;
            }
        }
        return new Dimension(width * g2dResolution, height * g2dResolution);
    }

    public Dimension getMinimumSize(Graphics g) {
        Dimension dim = new Dimension();
        if (g == null) {
            dim.width = 10;
            dim.height = 10;
            return dim;
        }
        this.setMinFont(g);
        return this.getTextSize(g);
    }

    @Override
    public Dimension getPreferredSizeLocal() {
        Insets i;
        Border b;
        int width = 0;
        int height = 0;
        if (this._icon != null) {
            width = this._icon.getIconWidth();
            height = this._icon.getIconHeight();
        }
        int g2dResolution = 1;
        if (this._parent != null) {
            g2dResolution = this._parent.getDeviceResoultion() / G2dResolutionConst.PRINTER_SCALE;
        }
        if ((b = this.getBorder()) != null) {
            i = b.getBorderInsets(this);
            width += (i.right + i.left) * g2dResolution;
            height += (i.top + i.bottom) * g2dResolution;
        }
        if (this._drawProp.text != null) {
            if (this._icon != null) {
                height += 2 * g2dResolution;
            } else {
                i = this.getInsets();
                width += (i.left + i.right) * g2dResolution;
                height += (i.top + i.bottom) * g2dResolution;
            }
            Graphics g = this.getGraphics();
            Dimension d = this.getPreferredSize(g);
            if (!this._drawProp.text.equals("") || this._icon == null) {
                if (this._drawProp.rotation == 90 || this._drawProp.rotation == 270) {
                    width += d.width;
                    height = Math.max(height, d.height);
                } else {
                    height += d.height;
                    width = Math.max(width, d.width);
                }
            }
        }
        return new Dimension(width, height);
    }

    public Dimension getPreferredSize(Graphics g) {
        if (g == null) {
            Font f = this.getG2dFont();
            if (f == null) {
                return new Dimension(10, 10);
            }
            FontMetrics fm = this.getToolkit().getFontMetrics(f);
            return this.getTextSize(fm);
        }
        this.setFont(g);
        return this.getTextSize(g);
    }

    public Object[] getTextSubstitutionObjects() {
        if (this.getG2dPanel() == null) {
            return new Object[0];
        }
        Vector plotObjects = this.getG2dPanel().getPlotObjects();
        return plotObjects.toArray();
    }

    @Override
    public void paintGfx(Graphics g) {
        Dimension dim = this.getSize();
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        g.setFont(this.getG2dFont());
        this.fitFont(g, dim);
        FontMetrics metrics = g.getFontMetrics();
        g.setColor(this.getForeground());
        if (g instanceof Graphics2D && this._drawProp.drawBackground) {
            g.setColor(this._drawProp.backgroundColor);
            Paint oldPaint = ((Graphics2D)g).getPaint();
            Composite oldAC = ((Graphics2D)g).getComposite();
            AlphaComposite ac = AlphaComposite.getInstance(3, this._drawProp.getAlphaComposite());
            ((Graphics2D)g).setComposite(ac);
            ((Graphics2D)g).setPaint(FillPatternFactory.createFillPattern(this._drawProp.fillPattern, g.getColor()));
            g.fillRect(0, 0, dim.width - 1, dim.height - 1);
            ((Graphics2D)g).setPaint(oldPaint);
            ((Graphics2D)g).setComposite(oldAC);
        }
        if (g instanceof Graphics2D && this._drawProp.drawBorder) {
            this.drawBorder((Graphics2D)g, dim);
        }
        int iconOffset = 0;
        if (this._icon != null) {
            int iconWidth = this._icon.getIconWidth();
            int iconHeight = this._icon.getIconHeight();
            if (iconHeight > 0 && iconWidth > 0) {
                iconOffset += iconHeight;
                this._icon.paintIcon(this, g, dim.width / 2 - iconWidth / 2, this.getInsets().top);
            }
        }
        if (this._drawProp.rotation == 90 || this._drawProp.rotation == 270) {
            float fhsz = (float)g.getFont().getSize() * 0.03f;
            float fwsz = (float)g.getFont().getSize() * 0.04f;
            int w = metrics.getMaxAdvance();
            int h = metrics.getHeight();
            if (g instanceof Graphics2D) {
                AffineTransform oldTx = ((Graphics2D)g).getTransform();
                AffineTransform rotate = AffineTransform.getRotateInstance(4.71238898038469);
                Font baseFont = g.getFont();
                Font rotatedFont = this.getG2dFont().deriveFont(rotate);
                Graphics2D g2d = (Graphics2D)g.create();
                for (int i = 0; i < this._text.length; ++i) {
                    String text = TextSubstitutionManager.getTextSubstitutionManager().replaceTokens(this._text[i], this.getTextSubstitutionObjects());
                    if (text == null) continue;
                    int iy = this.getHeight() / 2 + metrics.stringWidth(text) / 2;
                    int ix = (i + 1) * h + (i > 0 ? this._drawProp.space : 0);
                    g2d.setFont(rotatedFont);
                    g2d.setColor(this._drawProp.textColor);
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
                    g2d.drawString(text, ix, iy);
                }
                g2d.dispose();
            }
        } else {
            int w = metrics.getMaxAdvance();
            int h = metrics.getHeight();
            for (int i = 0; i < this._text.length; ++i) {
                int ioff;
                String text = TextSubstitutionManager.getTextSubstitutionManager().replaceTokens(this._text[i], this.getTextSubstitutionObjects());
                if (text == null) continue;
                int iy = metrics.getMaxAscent() + i * h + this._drawProp.space + iconOffset;
                switch (this._drawProp.align) {
                    case 1: {
                        ioff = (dim.width - metrics.stringWidth(text)) / 2;
                        break;
                    }
                    case 2: {
                        ioff = dim.width - metrics.stringWidth(text);
                        break;
                    }
                    default: {
                        ioff = (this._drawProp.space + 3) * 1;
                    }
                }
                if (ioff < 0) {
                    ioff = 0;
                }
                g.setColor(this._drawProp.textColor);
                Gfx2dDrawUtil.drawString(this, g, text, ioff, iy);
            }
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
        if (Boolean.getBoolean("DEBUG_PLOT_BOUNDS")) {
            Color c2 = g.getColor();
            g.setColor(Color.orange);
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
            g.setColor(c2);
        }
    }

    protected void drawBorder(Graphics2D g, Dimension dim) {
        Stroke oldStroke = g.getStroke();
        g.setColor(this._drawProp.borderColor);
        BasicStroke bs = new BasicStroke(this._drawProp.borderWeight, 0, 0, 10.0f, this._drawProp.borderStyle, 0.0f);
        g.setStroke(bs);
        g.drawRect(0, 0, dim.width - 1 - (int)(this._drawProp.borderWeight / 2.0f), dim.height - 1);
        g.setStroke(oldStroke);
    }

    void setMinFont(Graphics g) {
        Font font = g.getFont();
        int sz = this._drawProp.minFontSize;
        if (this._drawProp.fontFamily == null) {
            this._drawProp.fontFamily = font.getName();
        }
        if ((font = G2dFont.newFont(this._drawProp.fontFamily, this._drawProp.fontStyle, sz)) != null) {
            g.setFont(font);
        }
    }

    void setFont(Graphics g) {
        Font f = this.getG2dFont();
        if (f != null) {
            g.setFont(f);
        }
    }

    protected Font getG2dFont() {
        int g2dResolution = G2dResolutionConst.PRINTER_SCALE;
        double fontScale = 1.0;
        if (this._parent != null) {
            g2dResolution = this._parent.getDeviceResoultion();
            fontScale = this._parent.getFontScl();
        }
        double scl = g2dResolution / G2dResolutionConst.PRINTER_SCALE;
        if (!this._drawProp.useFontScaling) {
            return G2dFont.newFont(this._drawProp.fontFamily, this._drawProp.fontStyle, (int)((double)this._drawProp.fontSize * scl));
        }
        int sz = (int)((double)this._drawProp.fontSize * fontScale + 0.5);
        if ((double)sz < (double)this._drawProp.minFontSize * scl) {
            sz = (int)((double)this._drawProp.minFontSize * scl);
        }
        if ((double)sz > (double)this._drawProp.maxFontSize * scl) {
            sz = (int)((double)this._drawProp.maxFontSize * scl);
        }
        if (this._drawProp.fontFamily == null) {
            this._drawProp.fontFamily = "sansserif";
        }
        Font font = G2dFont.newFont(this._drawProp.fontFamily, this._drawProp.fontStyle, sz);
        return font;
    }

    void fitFont(Graphics g, Dimension dim) {
        Font font;
        Graphics tempGraphics = g.create();
        Font baseFont = g.getFont();
        int g2dResolution = 1;
        if (this._parent != null) {
            g2dResolution = this._parent.getDeviceResoultion() / G2dResolutionConst.PRINTER_SCALE;
        }
        int resolutionScale = g2dResolution;
        int sz = baseFont.getSize() * resolutionScale;
        if (this._drawProp.fontFamily == null) {
            this._drawProp.fontFamily = baseFont.getName();
        }
        if ((font = G2dFont.newFont(this._drawProp.fontFamily, this._drawProp.fontStyle, sz * resolutionScale)) == null) {
            font = baseFont;
        } else {
            g.setFont(font);
            Dimension tdim = this.getTextSize(g);
            sz = font.getSize();
            Font tmpFont = font;
            while ((tdim.height > dim.height || tdim.width > dim.width) && --sz >= this._drawProp.tinyFontSize) {
                tmpFont = font;
                font = G2dFont.newFont(this._drawProp.fontFamily, this._drawProp.fontStyle, sz);
                if (font == null) {
                    font = tmpFont;
                    continue;
                }
                tempGraphics.setFont(font);
                tdim = this.getTextSize(tempGraphics);
            }
        }
        g.setFont(font);
        if (Boolean.getBoolean("G2DLABEL_DEBUG")) {
            System.out.println("FitFont() - Font Size = " + sz);
        }
        tempGraphics.dispose();
    }

    Dimension getTextSize(Graphics g) {
        return this.getTextSize(g.getFontMetrics());
    }

    Dimension getTextSize(FontMetrics metrics) {
        int numLines;
        int g2dResolution = 1;
        if (this._parent != null) {
            g2dResolution = this._parent.getDeviceResoultion() / G2dResolutionConst.PRINTER_SCALE;
        }
        int dpspace = 2 * this._drawProp.space * g2dResolution;
        Dimension linedim = this.getMaxTextLineSize(metrics);
        Dimension dim = new Dimension();
        int n = numLines = this._text == null || this._text.length == 0 ? 1 : this._text.length;
        if (this._drawProp.rotation == 90 || this._drawProp.rotation == 270) {
            dim.width = numLines * linedim.width + dpspace;
            dim.height = linedim.height + dpspace;
        } else {
            dim.width = linedim.width + dpspace;
            dim.height = numLines * linedim.height + dpspace;
        }
        return dim;
    }

    Dimension getMaxTextLineSize(FontMetrics metrics) {
        int w = 0;
        for (int i = 0; i < this._text.length; ++i) {
            int l;
            String tempText = TextSubstitutionManager.getTextSubstitutionManager().replaceTokens(this._text[i], this.getTextSubstitutionObjects());
            if (tempText == null || w >= (l = metrics.stringWidth(tempText))) continue;
            w = l;
        }
        int h = metrics.getHeight();
        if (this._drawProp.rotation == 90 || this._drawProp.rotation == 270) {
            return new Dimension(h, w);
        }
        return new Dimension(w, h);
    }

    Dimension getTextSizeOld(Graphics g) {
        FontMetrics metrics = g.getFontMetrics();
        Dimension linedim = this.getMaxTextLineSize(metrics);
        Dimension dim = new Dimension();
        if (this._drawProp.rotation == 90 || this._drawProp.rotation == 270) {
            dim.width = this._text.length * (linedim.width + this._drawProp.space) + this._drawProp.space;
            dim.height = linedim.height + 2 * this._drawProp.space;
        } else {
            dim.width = linedim.width + 2 * this._drawProp.space;
            dim.height = this._text.length * linedim.height + 2 * this._drawProp.space;
        }
        return dim;
    }

    Dimension getMaxTextLineSizeOld(FontMetrics metrics) {
        int w;
        int h;
        if (this._drawProp.rotation == 90 || this._drawProp.rotation == 270) {
            h = 0;
            for (int i = 0; i < this._text.length; ++i) {
                int l = this._text[i].length();
                if (h >= l) continue;
                h = l;
            }
            h *= metrics.getMaxAscent();
            w = metrics.getMaxAdvance();
        } else {
            w = 0;
            for (int i = 0; i < this._text.length; ++i) {
                int l = metrics.stringWidth(this._text[i]);
                if (w >= l) continue;
                w = l;
            }
            h = metrics.getHeight();
        }
        return new Dimension(w, h);
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        Rectangle boundingRect = this.getBounds();
        if (!boundingRect.contains(new Point(pt.x, pt.y))) {
            return false;
        }
        this._popupMenu.show(this, pt.x - boundingRect.x, pt.y - boundingRect.y);
        return true;
    }

    public void addPropertiesOKListener(ActionListener listener) {
        if (listener != null) {
            this.mPropertiesOKListeners.add(listener);
        }
    }

    @Override
    public void editProperties() {
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        G2dPatternPropertiesPanel patternPanel = new G2dPatternPropertiesPanel();
        G2dFontPropertiesPanel fontPanel = new G2dFontPropertiesPanel();
        this._drawProp.text = this.getText();
        patternPanel.setData(this._drawProp);
        fontPanel.setData(this._drawProp);
        G2dPropertiesDlg dlg = null;
        PropertiesOKListener listener = new PropertiesOKListener();
        Window w = SwingUtilities.windowForComponent(this);
        dlg = w instanceof Dialog ? new G2dPropertiesDlg((Dialog)w, false, "Edit Label Properties", new DefaultJPanel[]{patternPanel, fontPanel}) : new G2dPropertiesDlg((Frame)w, false, "Edit Label Properties", new DefaultJPanel[]{patternPanel, fontPanel});
        if (dlg == null) {
            return;
        }
        dlg.addOKListener(listener);
        for (int i = 0; i < this.mPropertiesOKListeners.size(); ++i) {
            ActionListener alistener = this.mPropertiesOKListeners.get(i);
            if (alistener == null) continue;
            dlg.addOKListener(alistener);
        }
        this.setCursor(oldCursor);
        dlg.pack();
        dlg.setVisible(true);
    }

    @Override
    public void setBackground(Color c2) {
        if (this._drawProp == null) {
            super.setBackground(c2);
        } else {
            this._drawProp.backgroundColor = c2;
        }
    }

    public void setBackground(String colorString) {
        this.setBackground(RmaColor.parseColorString(colorString));
    }

    public String getBackgroundString() {
        return RmaColor.color2String(this.getBackground());
    }

    public void setForeground(String colorString) {
        Color c2 = RmaColor.parseColorString(colorString);
        if (c2 == null) {
            return;
        }
        this.setForeground(c2);
        this._drawProp.textColor = c2;
    }

    public String getForegroundString() {
        return RmaColor.color2String(this.getForeground());
    }

    public void setFillColor(Color c2) {
        this.setBackground(c2);
    }

    public void setFillColor(String colorString) {
        this.setBackground(colorString);
    }

    public Color getFillColor() {
        return this._drawProp.backgroundColor;
    }

    public String getFillColorString() {
        return RmaColor.color2String(this.getFillColor());
    }

    public void setBorderVisible(boolean state) {
        this._drawProp.drawBorder = state;
    }

    @Deprecated
    public void setDrawBorderOn() {
        this.setBorderVisible(true);
    }

    @Deprecated
    public void setDrawBorderOff() {
        this.setBorderVisible(false);
    }

    public boolean isBorderVisible() {
        return this._drawProp.drawBorder;
    }

    @Deprecated
    public boolean isBorderDrawn() {
        return this.isBorderVisible();
    }

    public void setBorderColor(String colorString) {
        this._drawProp.borderColor = RmaColor.parseColorString(colorString);
    }

    public void setBackgroundVisible(boolean state) {
        this._drawProp.drawBackground = state;
    }

    @Deprecated
    public void setDrawBackgroundOn() {
        this.setBackgroundVisible(true);
    }

    @Deprecated
    public void setDrawBackgroundOff() {
        this.setBackgroundVisible(false);
    }

    public boolean isBackgroundVisible() {
        return this._drawProp.drawBackground;
    }

    @Deprecated
    public boolean isBackgroundDrawn() {
        return this.isBackgroundVisible();
    }

    public void setBorderWeight(float weight) {
        this._drawProp.borderWeight = weight;
    }

    public float getBorderWeight() {
        return this._drawProp.borderWeight;
    }

    public void setFillPattern(String pattern) {
        this._drawProp.fillPattern = RmaDrawConst.lookupFillPattern(pattern);
    }

    public String getFillPatternString() {
        return RmaDrawConst.lookupFillPatternName(this._drawProp.fillPattern);
    }

    public int getFillPattern() {
        return this._drawProp.fillPattern;
    }

    public void setAlignment(String alignment) {
        this._drawProp.align = "left".equalsIgnoreCase(alignment) ? 0 : ("right".equalsIgnoreCase(alignment) ? 2 : 1);
    }

    public String getAlignmentString() {
        switch (this._drawProp.align) {
            case 0: {
                return "left";
            }
            case 2: {
                return "right";
            }
        }
        return "center";
    }

    @Override
    public int getAlignment() {
        return this._drawProp.align;
    }

    public void setRotation(int rotation) {
        switch (rotation) {
            case 0: 
            case 90: 
            case 180: 
            case 270: {
                this._drawProp.rotation = rotation;
                break;
            }
            default: {
                System.out.println("setRotation: invalid rotation " + rotation);
            }
        }
    }

    public int getRotation() {
        return this._drawProp.rotation;
    }

    public void setSpacing(int space) {
        this._drawProp.space = space;
    }

    public int getSpacing() {
        return this._drawProp.space;
    }

    public void setBorderStyle(String style) {
        this._drawProp.borderStyle = G2dLineProperties.lookupStyle(style);
    }

    public String getBorderStyleString() {
        return G2dLineProperties.lookupStyleName(this._drawProp.borderStyle);
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            G2dLabel.this.getG2dPanel().revalidate();
            G2dLabel.this.getG2dPanel().repaint();
        }
    }

    private class ClickListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            Rectangle labelBounds = G2dLabel.this.getBounds();
            labelBounds.x = 1;
            labelBounds.y = 0;
            Graphics g = G2dLabel.this.getGraphics();
            g.setColor(G2dLabel.this.getBackground());
            g.fillRect(labelBounds.x, labelBounds.y, labelBounds.width, labelBounds.height);
            String text = G2dLabel.this.getText();
            JTextField jtf = new JTextField(text);
            InputMap im = jtf.getInputMap(0);
            im.put(KeyStroke.getKeyStroke(10, 0), "Save");
            im.put(KeyStroke.getKeyStroke(27, 0), "Cancel");
            ActionMap am = jtf.getActionMap();
            am.put("Save", new SaveEventListener(jtf));
            am.put("Cancel", new CancelEventListener(jtf));
            jtf.setBounds(labelBounds);
            jtf.setFont(G2dLabel.this.getFont());
            G2dLabel.this.setText("");
            G2dLabel.this.repaint();
            G2dLabel.this.add(jtf);
            jtf.setEnabled(true);
            jtf.setEditable(true);
            jtf.requestFocus();
            jtf.validate();
            jtf.repaint();
        }
    }

    private class CancelEventListener
    extends PostbackListener {
        public CancelEventListener(JTextField jtf) {
            super(jtf);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            G2dLabel.this.setText(this.mOldText);
            this.removeTextField();
        }
    }

    private class SaveEventListener
    extends PostbackListener {
        public SaveEventListener(JTextField jtf) {
            super(jtf);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = this.mTextField.getText();
            G2dLabel.this.setText(text);
            this.removeTextField();
        }
    }

    private class PostbackListener
    extends AbstractAction {
        JTextField mTextField = null;
        String mOldText = "";

        public PostbackListener(JTextField jtf) {
            this.mTextField = jtf;
            this.mOldText = jtf.getText();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        protected void removeTextField() {
            G2dLabel.this.remove(this.mTextField);
            G2dLabel.this.revalidate();
            G2dLabel.this.repaint();
        }
    }
}

