/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.FontProperties;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.PatternProperties;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.PlotProperties;
import hec.gfx2d.PropertiesSerializer;
import hec.io.AsciiSerializable;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import rma.swing.RmaColor;
import rma.util.RMAIO;
import rma.util.RmaDrawConst;

public class G2dLabelDrawProp
extends PlotProperties
implements Cloneable,
PatternProperties,
FontProperties,
AsciiSerializable {
    protected static final char MULTI_LINE_CHARACTER = '\u0001';
    private static final String CLS_NAME = "G2dLabel_";
    public String text = "";
    protected boolean SAVE_TEXT_PROPERTY = true;
    protected static final String TEXT = "text";
    protected static final String FONT_SIZE = "fontSize";
    protected static final String TINY_FONT_SIZE = "tinyFontSizw";
    protected static final String MIN_FONT_SIZE = "minFontSize";
    protected static final String MAX_FONT_SIZE = "maxFontSize";
    protected static final String FONT_STYLE = "fontStyle";
    protected static final String FONT_FAMILY = "fontFamily";
    protected static final String TEXT_COLOR = "textColor";
    private static final String ALIGN = "align";
    private static final String ROTATION = "rotation";
    private static final String SPACE = "space";
    private static final String DRAW_BORDER = "drawBorder";
    private static final String SHOW_LABEL = "showLabel";
    private static final String DRAW_BACKGROUND = "drawBackground";
    private static final String BORDER_STYLE = "borderStyle";
    private static final String BORDER_WEIGHT = "borderWeight";
    private static final String BORDER_COLOR = "borderColor";
    private static final String BACKGROUND_COLOR = "backgroundColor";
    private static final String FILL_PATTERN = "fillPattern";
    private static final String DRAW_MAJOR_XGRID = "drawMajorXGrid";
    private static final String ICON_PATH = "iconPath";
    private static final String ALPHA_COMPOSITE = "alphaComposite";
    private static final String USE_FONT_SCALING = "useFontScaling";
    public int fontSize;
    public int tinyFontSize;
    public int minFontSize;
    public int maxFontSize;
    public int fontStyle;
    public String fontFamily;
    public Font font = null;
    public Color textColor = Color.black;
    public int align;
    public int rotation;
    public int space;
    public boolean showLabel;
    public boolean drawBorder;
    public boolean drawBackground;
    public float[] borderStyle;
    public float borderWeight;
    public Color borderColor;
    public Color backgroundColor;
    public int fillPattern;
    public String iconPath;
    public float alphaComposite;
    public boolean useFontScaling = true;
    public static final String LABEL_BEGIN = "Label Begin";
    public static final String LABEL_END = "Label End";

    static void init() {
        G2dLabelDrawProp.init(CLS_NAME);
    }

    static void init(String cls) {
        G2dLabelDrawProp.setDefault(cls + SHOW_LABEL, true);
        G2dLabelDrawProp.setDefault(cls + DRAW_BORDER, false);
        G2dLabelDrawProp.setDefault(cls + DRAW_MAJOR_XGRID, true);
        G2dLabelDrawProp.setDefault(cls + FONT_SIZE, 12);
        G2dLabelDrawProp.setDefault(cls + TINY_FONT_SIZE, 8);
        G2dLabelDrawProp.setDefault(cls + MIN_FONT_SIZE, 8);
        G2dLabelDrawProp.setDefault(cls + MAX_FONT_SIZE, 16);
        G2dLabelDrawProp.setDefault(cls + FONT_STYLE, 0);
        G2dLabelDrawProp.setDefault(cls + FONT_FAMILY, "Dialog");
        G2dLabelDrawProp.setDefault(cls + TEXT_COLOR, Color.black);
        G2dLabelDrawProp.setDefault(cls + ALIGN, 1);
        G2dLabelDrawProp.setDefault(cls + ROTATION, 0);
        G2dLabelDrawProp.setDefault(cls + SPACE, 2);
        G2dLabelDrawProp.setDefault(cls + DRAW_BACKGROUND, false);
        G2dLabelDrawProp.setDefault(cls + BORDER_STYLE, G2dLineProperties.SOLID_STYLE_PATTERN);
        G2dLabelDrawProp.setDefault(cls + BORDER_WEIGHT, 1.0f);
        G2dLabelDrawProp.setDefault(cls + BORDER_COLOR, (Color)null);
        G2dLabelDrawProp.setDefault(cls + BACKGROUND_COLOR, (Color)null);
        G2dLabelDrawProp.setDefault(cls + FILL_PATTERN, 0);
        G2dLabelDrawProp.setDefault(cls + ICON_PATH, "");
        G2dLabelDrawProp.setDefault(cls + ALPHA_COMPOSITE, 1.0f);
        G2dLabelDrawProp.setDefault(cls + USE_FONT_SCALING, true);
    }

    public G2dLabelDrawProp() {
        this(CLS_NAME);
    }

    protected G2dLabelDrawProp(String cls) {
        this.text = G2dLabelDrawProp.getDefaultString(cls + TEXT);
        this.fontSize = G2dLabelDrawProp.getDefaultInt(cls + FONT_SIZE);
        this.tinyFontSize = G2dLabelDrawProp.getDefaultInt(cls + TINY_FONT_SIZE);
        this.minFontSize = G2dLabelDrawProp.getDefaultInt(cls + MIN_FONT_SIZE);
        this.maxFontSize = G2dLabelDrawProp.getDefaultInt(cls + MAX_FONT_SIZE);
        this.fontStyle = G2dLabelDrawProp.getDefaultInt(cls + FONT_STYLE);
        this.fontFamily = G2dLabelDrawProp.getDefaultString(cls + FONT_FAMILY);
        this.textColor = G2dLabelDrawProp.getDefaultColor(cls + TEXT_COLOR);
        this.align = G2dLabelDrawProp.getDefaultInt(cls + ALIGN);
        this.rotation = G2dLabelDrawProp.getDefaultInt(cls + ROTATION);
        this.space = G2dLabelDrawProp.getDefaultInt(cls + SPACE);
        this.drawBorder = G2dLabelDrawProp.getDefaultBoolean(cls + DRAW_BORDER);
        this.showLabel = G2dLabelDrawProp.getDefaultBoolean(cls + SHOW_LABEL);
        this.drawBackground = G2dLabelDrawProp.getDefaultBoolean(cls + DRAW_BACKGROUND);
        this.borderStyle = G2dLabelDrawProp.getDefaultFloatArray(cls + BORDER_STYLE);
        this.borderWeight = G2dLabelDrawProp.getDefaultFloat(cls + BORDER_WEIGHT);
        this.borderColor = G2dLabelDrawProp.getDefaultColor(cls + BORDER_COLOR);
        this.backgroundColor = G2dLabelDrawProp.getDefaultColor(cls + BACKGROUND_COLOR);
        this.fillPattern = G2dLabelDrawProp.getDefaultInt(cls + FILL_PATTERN);
        this.iconPath = G2dLabelDrawProp.getDefaultString(cls + ICON_PATH);
        this.alphaComposite = G2dLabelDrawProp.getDefaultFloat(cls + ALPHA_COMPOSITE);
        this.useFontScaling = G2dLabelDrawProp.getDefaultBoolean(cls + USE_FONT_SCALING);
    }

    public G2dLabelDrawProp(G2dLabelDrawProp dp) {
        this.set(dp);
    }

    @Override
    public int getMaxFontSize() {
        return this.maxFontSize;
    }

    @Override
    public int getMinFontSize() {
        return this.minFontSize;
    }

    @Override
    public void setMaxFontSize(int size) {
        this.maxFontSize = size;
    }

    @Override
    public void setMinFontSize(int size) {
        this.minFontSize = size;
    }

    public void setFontSize(int i) {
        this.fontSize = i;
        this.font = null;
    }

    public void setTinyFontSize(int i) {
        this.tinyFontSize = i;
    }

    public void setFontStyle(int i) {
        this.fontStyle = i;
        this.font = null;
    }

    public void setFontFamily(String s) {
        this.fontFamily = s;
        this.font = null;
    }

    public void setAlign(int i) {
        this.align = i;
    }

    public void setRotation(int i) {
        this.rotation = i;
    }

    public void setSpace(int i) {
        this.space = i;
    }

    public void setShowLabel(boolean b) {
        this.showLabel = b;
    }

    @Override
    public void setDrawLine(boolean b) {
        this.drawBorder = b;
    }

    @Override
    public void setDrawBackground(boolean b) {
        this.drawBackground = b;
    }

    @Override
    public void setLineColor(Color c2) {
        this.borderColor = c2;
    }

    @Override
    public void setLineStyle(float[] s) {
        this.borderStyle = s;
    }

    @Override
    public void setLineWeight(float f) {
        this.borderWeight = f;
    }

    @Override
    public void setBackgroundColor(Color c2) {
        this.backgroundColor = c2;
    }

    @Override
    public void setBackgroundFill(int ft) {
        this.fillPattern = ft;
    }

    @Override
    public void setAlphaComposite(float alpha) {
        this.alphaComposite = alpha;
    }

    public void setUseFontScaling(boolean b) {
        this.useFontScaling = b;
    }

    @Override
    public Color getLineColor() {
        return this.borderColor;
    }

    @Override
    public float[] getLineStyle() {
        return this.borderStyle;
    }

    @Override
    public float getLineWeight() {
        return this.borderWeight;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean getShowLabel() {
        return this.showLabel;
    }

    @Override
    public boolean getDrawLine() {
        return this.drawBorder;
    }

    @Override
    public boolean getDrawBackground() {
        return this.drawBackground;
    }

    @Override
    public int getBackgroundFill() {
        return this.fillPattern;
    }

    public int getFontSize(int i) {
        return this.fontSize;
    }

    public int getTinyFontSize(int i) {
        return this.tinyFontSize;
    }

    public int getMinFontSize(int i) {
        return this.minFontSize;
    }

    public int getMaxFontSize(int i) {
        return this.maxFontSize;
    }

    public int getFontStyle(int i) {
        return this.fontStyle;
    }

    public String getFontFamily(String s) {
        return this.fontFamily;
    }

    public int getAlign(int i) {
        return this.align;
    }

    public int getRotation(int i) {
        return this.rotation;
    }

    public int getSpace(int i) {
        return this.space;
    }

    @Override
    public float getAlphaComposite() {
        return this.alphaComposite;
    }

    public boolean useFontScaling() {
        return this.useFontScaling;
    }

    public static String getFileName() {
        return "labelDefaults";
    }

    public Object getClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException e) {
            return new G2dLabelDrawProp(this);
        }
    }

    public void set(G2dLabelDrawProp dp) {
        this.text = dp.text;
        this.textColor = dp.textColor;
        this.fontSize = dp.fontSize;
        this.tinyFontSize = dp.tinyFontSize;
        this.minFontSize = dp.minFontSize;
        this.maxFontSize = dp.maxFontSize;
        this.fontStyle = dp.fontStyle;
        this.fontFamily = dp.fontFamily;
        this.align = dp.align;
        this.rotation = dp.rotation;
        this.space = dp.space;
        this.alphaComposite = dp.alphaComposite;
        this.drawBorder = dp.drawBorder;
        this.showLabel = dp.showLabel;
        this.drawBackground = dp.drawBackground;
        this.borderStyle = dp.borderStyle;
        this.borderWeight = dp.borderWeight;
        this.borderColor = dp.borderColor;
        this.backgroundColor = dp.backgroundColor;
        this.fillPattern = dp.fillPattern;
        this.iconPath = dp.iconPath;
        this.alphaComposite = dp.alphaComposite;
    }

    public void writeProperties(BufferedWriter writer, String endTag) {
        if (writer == null) {
            return;
        }
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        if (this.SAVE_TEXT_PROPERTY) {
            RMAIO.fout(writer, indent + "text=" + (this.text != null ? this.text.replace('\n', '\u0001') : this.text));
        }
        if (!G2dLabelDrawProp.isDefault(FONT_SIZE, this.fontSize)) {
            RMAIO.fout(writer, indent + "fontSize=" + this.fontSize);
        }
        if (!G2dLabelDrawProp.isDefault(TINY_FONT_SIZE, this.tinyFontSize)) {
            RMAIO.fout(writer, indent + "tinyFontSizw=" + this.tinyFontSize);
        }
        if (!G2dLabelDrawProp.isDefault(MIN_FONT_SIZE, this.minFontSize)) {
            RMAIO.fout(writer, indent + "minFontSize=" + this.minFontSize);
        }
        if (!G2dLabelDrawProp.isDefault(MAX_FONT_SIZE, this.maxFontSize)) {
            RMAIO.fout(writer, indent + "maxFontSize=" + this.maxFontSize);
        }
        if (!G2dLabelDrawProp.isDefault(FONT_STYLE, this.fontStyle)) {
            RMAIO.fout(writer, indent + "fontStyle=" + this.fontStyle);
        }
        if (!G2dLabelDrawProp.isDefault(FONT_FAMILY, this.fontFamily)) {
            RMAIO.fout(writer, indent + "fontFamily=" + this.fontFamily);
        }
        if (!G2dLabelDrawProp.isDefault(TEXT_COLOR, this.textColor)) {
            RMAIO.fout(writer, indent + "textColor=" + RmaColor.color2String(this.textColor));
        }
        if (!G2dLabelDrawProp.isDefault(ALIGN, this.align)) {
            RMAIO.fout(writer, indent + "align=" + this.align);
        }
        if (!G2dLabelDrawProp.isDefault(ROTATION, this.rotation)) {
            RMAIO.fout(writer, indent + "rotation=" + this.rotation);
        }
        if (!G2dLabelDrawProp.isDefault(SPACE, this.space)) {
            RMAIO.fout(writer, indent + "space=" + this.space);
        }
        if (!G2dLabelDrawProp.isDefault(DRAW_BORDER, this.drawBorder)) {
            RMAIO.fout(writer, indent + "drawBorder=" + this.drawBorder);
        }
        if (!G2dLabelDrawProp.isDefault(SHOW_LABEL, this.showLabel)) {
            RMAIO.fout(writer, indent + "showLabel=" + this.showLabel);
        }
        if (!G2dLabelDrawProp.isDefault(DRAW_BACKGROUND, this.drawBackground)) {
            RMAIO.fout(writer, indent + "drawBackground=" + this.drawBackground);
        }
        if (!G2dLabelDrawProp.isDefault(BORDER_STYLE, this.borderStyle)) {
            RMAIO.fout(writer, indent + "borderStyle=" + G2dLineProperties.lookupStyleName(this.borderStyle));
        }
        if (!G2dLabelDrawProp.isDefault(BORDER_WEIGHT, this.borderWeight)) {
            RMAIO.fout(writer, indent + "borderWeight=" + this.borderWeight);
        }
        if (!G2dLabelDrawProp.isDefault(BORDER_COLOR, this.borderColor)) {
            RMAIO.fout(writer, indent + "borderColor=" + RmaColor.color2String(this.borderColor));
        }
        if (!G2dLabelDrawProp.isDefault(BACKGROUND_COLOR, this.backgroundColor)) {
            RMAIO.fout(writer, indent + "backgroundColor=" + RmaColor.color2String(this.backgroundColor));
        }
        if (!G2dLabelDrawProp.isDefault(FILL_PATTERN, this.fillPattern)) {
            RMAIO.fout(writer, indent + "fillPattern=" + RmaDrawConst.lookupFillPatternName(this.fillPattern));
        }
        if (!G2dLabelDrawProp.isDefault(ICON_PATH, this.iconPath)) {
            RMAIO.fout(writer, indent + "iconPath=" + this.iconPath);
        }
        if (!G2dLabelDrawProp.isDefault(ALPHA_COMPOSITE, this.alphaComposite)) {
            RMAIO.fout(writer, indent + "alphaComposite=" + Float.toString(this.alphaComposite));
        }
        if (!G2dLabelDrawProp.isDefault(USE_FONT_SCALING, this.useFontScaling)) {
            RMAIO.fout(writer, indent + "useFontScaling=" + Boolean.toString(this.useFontScaling));
        }
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + endTag);
    }

    public void readProperties(BufferedReader in, String endTag) {
        if (in == null) {
            return;
        }
        try {
            String line;
            while ((line = in.readLine()) != null) {
                line.trim();
                String param = RMAIO.getParam(line, "=");
                String type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    this.assignValue(type, param);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readProperties(BufferedReader) of G2dLabelDrawProp");
            return;
        }
    }

    protected void assignValue(String type, String param) {
        if (type.equalsIgnoreCase(TEXT)) {
            this.text = param.replace('\u0001', '\n');
        } else if (type.equalsIgnoreCase(FONT_SIZE)) {
            this.fontSize = Integer.valueOf(param);
        } else if (type.equalsIgnoreCase(TEXT_COLOR)) {
            this.textColor = RmaColor.parseColorString(param);
        } else if (type.equalsIgnoreCase(TINY_FONT_SIZE)) {
            this.tinyFontSize = Integer.valueOf(param);
        } else if (type.equalsIgnoreCase(MIN_FONT_SIZE)) {
            this.minFontSize = Integer.valueOf(param);
        } else if (type.equalsIgnoreCase(MAX_FONT_SIZE)) {
            this.maxFontSize = Integer.valueOf(param);
        } else if (type.equalsIgnoreCase(FONT_STYLE)) {
            this.fontStyle = Integer.valueOf(param);
        } else if (type.equalsIgnoreCase(FONT_FAMILY)) {
            this.fontFamily = param;
        } else if (type.equalsIgnoreCase(ALIGN)) {
            this.align = Integer.valueOf(param);
        } else if (type.equalsIgnoreCase(ROTATION)) {
            this.rotation = Integer.valueOf(param);
        } else if (type.equalsIgnoreCase(SPACE)) {
            this.space = Integer.valueOf(param);
        } else if (type.equalsIgnoreCase(SHOW_LABEL)) {
            this.showLabel = Boolean.valueOf(param);
        } else if (type.equalsIgnoreCase(DRAW_BORDER)) {
            this.drawBorder = Boolean.valueOf(param);
        } else if (type.equalsIgnoreCase(DRAW_BACKGROUND)) {
            this.drawBackground = Boolean.valueOf(param);
        } else if (type.equalsIgnoreCase(BORDER_STYLE)) {
            this.borderStyle = G2dLineProperties.lookupStyle(param);
        } else if (type.equalsIgnoreCase(BORDER_WEIGHT)) {
            this.borderWeight = Float.valueOf(param).floatValue();
        } else if (type.equalsIgnoreCase(BORDER_COLOR)) {
            this.borderColor = RmaColor.parseColorString(param);
        } else if (type.equalsIgnoreCase(BACKGROUND_COLOR)) {
            this.backgroundColor = RmaColor.parseColorString(param);
        } else if (type.equalsIgnoreCase(FILL_PATTERN)) {
            this.fillPattern = RmaDrawConst.lookupFillPattern(param);
        } else if (type.equalsIgnoreCase(ICON_PATH)) {
            this.iconPath = param != null ? param : "";
        } else if (type.equalsIgnoreCase(ALPHA_COMPOSITE)) {
            this.alphaComposite = RMAIO.parseFloat(param, 1.0f);
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean loadDefaults(BufferedReader in) {
        return G2dLabelDrawProp.loadDefaults(in, LABEL_END, CLS_NAME);
    }

    protected static boolean loadDefaults(BufferedReader in, String endTag, String cls) {
        if (in == null) {
            return false;
        }
        try {
            String line;
            while ((line = in.readLine()) != null) {
                line.trim();
                String param = RMAIO.getParam(line, "=");
                String type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    G2dLabelDrawProp.parseDefaultLine(type, param, cls);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in loadDefaults(BufferedReader,endTag) of G2dLabelDrawProp");
            return false;
        }
        return true;
    }

    protected static void parseDefaultLine(String type, String param, String cls) {
        if (type.equalsIgnoreCase(FONT_SIZE)) {
            G2dLabelDrawProp.setDefault(cls + FONT_SIZE, Integer.valueOf(param));
        } else if (type.equalsIgnoreCase(TEXT)) {
            param = param.replace('\u0001', '\n');
            G2dLabelDrawProp.setDefault(cls + TEXT, param);
        } else if (type.equalsIgnoreCase(TINY_FONT_SIZE)) {
            G2dLabelDrawProp.setDefault(cls + TINY_FONT_SIZE, Integer.valueOf(param));
        } else if (type.equalsIgnoreCase(MIN_FONT_SIZE)) {
            G2dLabelDrawProp.setDefault(cls + MIN_FONT_SIZE, Integer.valueOf(param));
        } else if (type.equalsIgnoreCase(MAX_FONT_SIZE)) {
            G2dLabelDrawProp.setDefault(cls + MAX_FONT_SIZE, Integer.valueOf(param));
        } else if (type.equalsIgnoreCase(FONT_STYLE)) {
            G2dLabelDrawProp.setDefault(cls + FONT_STYLE, Integer.valueOf(param));
        } else if (type.equalsIgnoreCase(FONT_FAMILY)) {
            G2dLabelDrawProp.setDefault(cls + FONT_FAMILY, param);
        } else if (type.equalsIgnoreCase(TEXT_COLOR)) {
            G2dLabelDrawProp.setDefault(cls + TEXT_COLOR, RmaColor.parseColorString(param));
        } else if (type.equalsIgnoreCase(ALIGN)) {
            G2dLabelDrawProp.setDefault(cls + ALIGN, Integer.valueOf(param));
        } else if (type.equalsIgnoreCase(ROTATION)) {
            G2dLabelDrawProp.setDefault(cls + ROTATION, Integer.valueOf(param));
        } else if (type.equalsIgnoreCase(SPACE)) {
            G2dLabelDrawProp.setDefault(cls + SPACE, Integer.valueOf(param));
        } else if (type.equalsIgnoreCase(DRAW_BORDER)) {
            G2dLabelDrawProp.setDefault(cls + DRAW_BORDER, Boolean.valueOf(param));
        } else if (type.equalsIgnoreCase(DRAW_BACKGROUND)) {
            G2dLabelDrawProp.setDefault(cls + DRAW_BACKGROUND, Boolean.valueOf(param));
        } else if (type.equalsIgnoreCase(BORDER_STYLE)) {
            G2dLabelDrawProp.setDefault(cls + BORDER_STYLE, G2dLineProperties.lookupStyle(param));
        } else if (type.equalsIgnoreCase(BORDER_WEIGHT)) {
            G2dLabelDrawProp.setDefault(cls + BORDER_WEIGHT, Float.valueOf(param).floatValue());
        } else if (type.equalsIgnoreCase(BORDER_COLOR)) {
            G2dLabelDrawProp.setDefault(cls + BORDER_COLOR, RmaColor.parseColorString(param));
        } else if (type.equalsIgnoreCase(BACKGROUND_COLOR)) {
            G2dLabelDrawProp.setDefault(cls + BACKGROUND_COLOR, RmaColor.parseColorString(param));
        } else if (type.equalsIgnoreCase(FILL_PATTERN)) {
            G2dLabelDrawProp.setDefault(cls + FILL_PATTERN, RmaDrawConst.lookupFillPattern(param));
        } else if (type.equalsIgnoreCase(ALPHA_COMPOSITE)) {
            G2dLabelDrawProp.setDefault(cls + ALPHA_COMPOSITE, RMAIO.parseFloat(param, 1.0f));
        } else if (type.equalsIgnoreCase(USE_FONT_SCALING)) {
            G2dLabelDrawProp.setDefault(cls + USE_FONT_SCALING, Boolean.valueOf(param));
        }
    }

    public static boolean writeDefaults() {
        BufferedWriter writer = PlotDefaultsManager.getDefaults().getBufferedWriter(G2dLabelDrawProp.class);
        if (writer == null) {
            return false;
        }
        boolean value = G2dLabelDrawProp.writeDefaults(writer);
        try {
            writer.close();
        }
        catch (IOException ioe) {
            System.out.println("Error on writeDefaults() of G2sLabelDrawProp");
        }
        return value;
    }

    public static boolean writeDefaults(BufferedWriter writer) {
        String indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + LABEL_BEGIN);
        boolean b = G2dLabelDrawProp.writeDefaults(CLS_NAME, writer);
        return b;
    }

    protected static boolean writeDefaults(String cls, BufferedWriter writer) {
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        String s = G2dLabelDrawProp.getDefaultString(cls + TEXT);
        if (s != null) {
            RMAIO.fout(writer, indent + "text=" + s.replace('\n', '\u0001'));
        }
        RMAIO.fout(writer, indent + "fontSize=" + G2dLabelDrawProp.getDefaultInt(cls + FONT_SIZE));
        RMAIO.fout(writer, indent + "tinyFontSizw=" + G2dLabelDrawProp.getDefaultInt(cls + TINY_FONT_SIZE));
        RMAIO.fout(writer, indent + "minFontSize=" + G2dLabelDrawProp.getDefaultInt(cls + MIN_FONT_SIZE));
        RMAIO.fout(writer, indent + "maxFontSize=" + G2dLabelDrawProp.getDefaultInt(cls + MAX_FONT_SIZE));
        RMAIO.fout(writer, indent + "fontStyle=" + G2dLabelDrawProp.getDefaultInt(cls + FONT_STYLE));
        RMAIO.fout(writer, indent + "fontFamily=" + G2dLabelDrawProp.getDefaultString(cls + FONT_FAMILY));
        RMAIO.fout(writer, indent + "textColor=" + RmaColor.color2String(G2dLabelDrawProp.getDefaultColor(cls + TEXT_COLOR)));
        RMAIO.fout(writer, indent + "align=" + G2dLabelDrawProp.getDefaultInt(cls + ALIGN));
        RMAIO.fout(writer, indent + "rotation=" + G2dLabelDrawProp.getDefaultInt(cls + ROTATION));
        RMAIO.fout(writer, indent + "space=" + G2dLabelDrawProp.getDefaultInt(cls + SPACE));
        RMAIO.fout(writer, indent + "drawBorder=" + G2dLabelDrawProp.getDefaultBoolean(cls + DRAW_BORDER));
        RMAIO.fout(writer, indent + "drawBackground=" + G2dLabelDrawProp.getDefaultBoolean(cls + DRAW_BACKGROUND));
        RMAIO.fout(writer, indent + "borderStyle=" + G2dLineProperties.lookupStyleName(G2dLabelDrawProp.getDefaultFloatArray(cls + BORDER_STYLE)));
        RMAIO.fout(writer, indent + "borderWeight=" + G2dLabelDrawProp.getDefaultFloat(cls + BORDER_WEIGHT));
        RMAIO.fout(writer, indent + "borderColor=" + RmaColor.color2String(G2dLabelDrawProp.getDefaultColor(cls + BORDER_COLOR)));
        RMAIO.fout(writer, indent + "backgroundColor=" + RmaColor.color2String(G2dLabelDrawProp.getDefaultColor(cls + BACKGROUND_COLOR)));
        RMAIO.fout(writer, indent + "fillPattern=" + RmaDrawConst.lookupFillPatternName(G2dLabelDrawProp.getDefaultInt(cls + FILL_PATTERN)));
        RMAIO.fout(writer, indent + "alphaComposite=" + Float.toString(G2dLabelDrawProp.getDefaultFloat(cls + ALPHA_COMPOSITE)));
        RMAIO.fout(writer, indent + "useFontScaling=" + G2dLabelDrawProp.getDefaultBoolean(cls + USE_FONT_SCALING));
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + LABEL_END);
        return true;
    }

    public static void setDefaults(G2dLabelDrawProp defaultProps) {
        G2dLabelDrawProp.setDefaults(defaultProps, CLS_NAME);
    }

    protected static void setDefaults(G2dLabelDrawProp defaultProps, String cls) {
        if (defaultProps == null) {
            return;
        }
        if (cls == null) {
            cls = "";
        }
        G2dLabelDrawProp.setDefault(cls + TEXT, defaultProps.text);
        G2dLabelDrawProp.setDefault(cls + FONT_SIZE, defaultProps.fontSize);
        G2dLabelDrawProp.setDefault(cls + TINY_FONT_SIZE, defaultProps.tinyFontSize);
        G2dLabelDrawProp.setDefault(cls + MIN_FONT_SIZE, defaultProps.minFontSize);
        G2dLabelDrawProp.setDefault(cls + MAX_FONT_SIZE, defaultProps.maxFontSize);
        G2dLabelDrawProp.setDefault(cls + FONT_STYLE, defaultProps.fontStyle);
        G2dLabelDrawProp.setDefault(cls + FONT_FAMILY, defaultProps.fontFamily);
        G2dLabelDrawProp.setDefault(cls + TEXT_COLOR, defaultProps.textColor);
        G2dLabelDrawProp.setDefault(cls + ALIGN, defaultProps.align);
        G2dLabelDrawProp.setDefault(cls + ROTATION, defaultProps.rotation);
        G2dLabelDrawProp.setDefault(cls + SPACE, defaultProps.space);
        G2dLabelDrawProp.setDefault(cls + SHOW_LABEL, defaultProps.showLabel);
        G2dLabelDrawProp.setDefault(cls + DRAW_BORDER, defaultProps.drawBorder);
        G2dLabelDrawProp.setDefault(cls + DRAW_BACKGROUND, defaultProps.drawBackground);
        G2dLabelDrawProp.setDefault(cls + BORDER_STYLE, defaultProps.borderStyle);
        G2dLabelDrawProp.setDefault(cls + BORDER_WEIGHT, defaultProps.borderWeight);
        G2dLabelDrawProp.setDefault(cls + BORDER_COLOR, defaultProps.borderColor);
        G2dLabelDrawProp.setDefault(cls + BACKGROUND_COLOR, defaultProps.backgroundColor);
        G2dLabelDrawProp.setDefault(cls + FILL_PATTERN, defaultProps.fillPattern);
        G2dLabelDrawProp.setDefault(cls + ALPHA_COMPOSITE, defaultProps.alphaComposite);
        G2dLabelDrawProp.setDefault(cls + USE_FONT_SCALING, defaultProps.useFontScaling);
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            this.font = new Font(this.fontFamily, this.fontStyle, this.fontSize);
        }
        return this.font;
    }

    @Override
    public void setFont(Font f) {
        this.font = f;
        this.fontFamily = this.font.getFamily();
        this.fontSize = this.font.getSize();
        this.fontStyle = this.font.getStyle();
    }

    @Override
    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    public void setTextColor(Color c2) {
        this.textColor = c2;
    }

    static {
        G2dLabelDrawProp.init();
    }
}

