/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import hec.geometry.IScale;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dLinesPropPanel;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dPaint;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.LegendPanel;
import hec.gfx2d.Symbol;
import hec.heclib.util.intContainer;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.swing.RmaColor;
import rma.swing.RmaJMenuLabel;
import rma.util.FillPatternFactory;
import rma.util.RmaDrawConst;

public class G2dLine
extends NamedType
implements AsciiSerializable,
Serializable,
ActionListener {
    protected G2dLineProperties _properties;
    Vector _xdataVec = new Vector();
    Vector _ydataVec = new Vector();
    Vector _dataSizeVec = new Vector();
    double _stepInterval;
    double[] _xdata = null;
    double[] _ydata = null;
    double[] _selectedxdata = null;
    double[] _selectedydata = null;
    int _numPts = 0;
    protected JPopupMenu _popupMenu = null;
    protected RmaJMenuLabel _nameMenuItem = null;
    G2dGlyph _glyph = null;
    IScale _scale = null;
    LocalPt m_lPoint = null;
    Hashtable m_calloutTable = new Hashtable();
    protected boolean _clipToBounds = false;
    boolean mVisible = true;
    boolean _drawCallouts = true;
    G2dLinesPropPanel _linePropPanel;

    public G2dLine() {
        this._properties = new G2dLineProperties();
        this.createPopupMenu();
    }

    public void setStepInterval(double interval) {
        this._stepInterval = interval;
    }

    public double getStepInterval() {
        return this._stepInterval;
    }

    public G2dLine(G2dLineProperties prop) {
        this._properties = prop.clone();
        this.createPopupMenu();
    }

    public G2dLine(G2dLineProperties prop, double[] xarray, double[] yarray, int size) {
        this(prop);
        this.setLineData(xarray, yarray, size);
        this.createPopupMenu();
    }

    public void setLineData(double[] xarray, double[] yarray, int numPts) {
        this._numPts = numPts;
        this._xdata = new double[numPts];
        this._ydata = new double[numPts];
        System.arraycopy(xarray, 0, this._xdata, 0, this._numPts);
        System.arraycopy(yarray, 0, this._ydata, 0, this._numPts);
        this._xdataVec.removeAllElements();
        this._ydataVec.removeAllElements();
        this._dataSizeVec.removeAllElements();
        this._dataSizeVec.addElement(new intContainer(numPts));
        this._xdataVec.addElement(this._xdata);
        this._ydataVec.addElement(this._ydata);
    }

    public void setSelectedPoints(double[] xarray, double[] yarray, int numPts) {
        if (xarray != null) {
            this._selectedxdata = new double[numPts];
            this._selectedydata = new double[numPts];
            System.arraycopy(xarray, 0, this._selectedxdata, 0, numPts);
            System.arraycopy(yarray, 0, this._selectedydata, 0, numPts);
        } else {
            this._selectedxdata = null;
            this._selectedydata = null;
        }
    }

    public void copyCurveProperties(G2dLineProperties prop) {
        if (prop == null) {
            return;
        }
        this._properties.copyCurveProperties(prop);
    }

    public void setProperties(G2dLineProperties prop) {
        this._properties = prop.clone();
    }

    public void setScale(IScale s) {
        this._scale = s;
    }

    public IScale getScale() {
        return this._scale;
    }

    public void setGlyph(G2dGlyph g) {
        this._glyph = g;
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        return false;
    }

    public G2dLineProperties getProperties() {
        return this._properties.clone();
    }

    public int getNumPoints() {
        return this._numPts;
    }

    public float getLineWidth() {
        return this._properties._lineWidth;
    }

    public WorldPt getNearestDataPt(WorldPt pt, boolean interpolate) {
        if (this._numPts == 0) {
            return null;
        }
        double dist = Double.POSITIVE_INFINITY;
        WorldPt closestPt = null;
        int closestSegmentIndex = -1;
        int closestPointIndex = -1;
        for (int z = 0; z < this._xdataVec.size(); ++z) {
            this._xdata = (double[])this._xdataVec.elementAt(z);
            this._ydata = (double[])this._ydataVec.elementAt(z);
            int numPts = ((intContainer)this._dataSizeVec.elementAt((int)z)).value;
            if (closestPt == null) {
                closestPt = new WorldPt(this._xdata[0], this._ydata[0]);
            }
            for (int i = 0; i < numPts; ++i) {
                double x1 = this._xdata[i];
                double y1 = this._ydata[i];
                double dx = pt.e - x1;
                double dy = pt.n - y1;
                if (dx == 0.0 && dy == 0.0) {
                    return pt;
                }
                double tmp = Math.sqrt(dx * dx + dy * dy);
                if (!(tmp < dist)) continue;
                dist = tmp;
                closestPt.init(x1, y1);
                closestSegmentIndex = z;
                closestPointIndex = i;
            }
        }
        return closestPt;
    }

    public LocalPt getNearestDataPt(LocalPt pt) {
        return this.getNearestDataPt(pt, false);
    }

    protected Geometry toLocalGeometry() {
        int numPts = 0;
        GeometryFactory gf = new GeometryFactory();
        ArrayList<Point> geometryList = new ArrayList<Point>();
        for (int z = 0; z < this._xdataVec.size(); ++z) {
            this._xdata = (double[])this._xdataVec.elementAt(z);
            this._ydata = (double[])this._ydataVec.elementAt(z);
            int[] xdata = new int[this._xdata.length];
            int[] ydata = new int[this._ydata.length];
            this.scale(this._xdata, this._ydata, xdata, ydata, 0, xdata.length);
            ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>();
            int[] tempXData = null;
            int[] tempYData = null;
            if (this._properties._lineStepStyle == 0) {
                numPts = xdata.length;
                tempXData = new int[numPts];
                tempYData = new int[numPts];
                System.arraycopy(xdata, 0, tempXData, 0, numPts);
                System.arraycopy(ydata, 0, tempYData, 0, numPts);
            } else if (this._properties._lineStepStyle == 1) {
                numPts = xdata.length * 2;
                if (numPts < 0) {
                    numPts = 0;
                }
                tempXData = new int[numPts];
                tempYData = new int[numPts];
                if (this._properties._periodStepStyle == 1) {
                    this.generateStepLine(xdata, tempXData, 1);
                    this.generateStepLine(ydata, tempYData, 0);
                } else {
                    this.generateStepLine(xdata, tempXData, 0);
                    this.generateStepLine(ydata, tempYData, 1);
                    if (this._xdata.length >= 1) {
                        double pt1x = this._xdata[0] - this.getStepInterval();
                        double pt1y = this._ydata[0];
                        int[] tempEopXData = new int[tempXData.length + 1];
                        int[] tempEopYData = new int[tempXData.length + 1];
                        System.arraycopy(tempXData, 0, tempEopXData, 1, tempXData.length);
                        System.arraycopy(tempYData, 0, tempEopYData, 1, tempYData.length);
                        tempEopXData[0] = this._scale.e2x(pt1x);
                        tempEopYData[0] = this._scale.n2y(pt1y);
                        tempXData = tempEopXData;
                        tempYData = tempEopYData;
                    }
                }
            }
            if (tempXData != null) {
                for (int zz = 0; zz < tempXData.length; ++zz) {
                    coordinateList.add(new Coordinate((double)tempXData[zz], (double)tempYData[zz]));
                }
            }
            if (coordinateList.isEmpty()) continue;
            Object baseGeometry = coordinateList.size() == 1 ? gf.createPoint((Coordinate)coordinateList.get(0)) : gf.createLineString(coordinateList.toArray(new Coordinate[0]));
            geometryList.add((Point)baseGeometry);
        }
        return gf.buildGeometry(geometryList);
    }

    protected Geometry toWorldGeometry() {
        int numPts = 0;
        GeometryFactory gf = new GeometryFactory();
        ArrayList<Point> geometryList = new ArrayList<Point>();
        for (int z = 0; z < this._xdataVec.size(); ++z) {
            this._xdata = (double[])this._xdataVec.elementAt(z);
            this._ydata = (double[])this._ydataVec.elementAt(z);
            double[] xdata = new double[this._xdata.length];
            double[] ydata = new double[this._ydata.length];
            System.arraycopy(this._xdata, 0, xdata, 0, this._xdata.length);
            System.arraycopy(this._ydata, 0, ydata, 0, this._ydata.length);
            ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>();
            double[] tempXData = null;
            double[] tempYData = null;
            if (this._properties._lineStepStyle == 0) {
                numPts = xdata.length;
                tempXData = new double[numPts];
                tempYData = new double[numPts];
                System.arraycopy(xdata, 0, tempXData, 0, numPts);
                System.arraycopy(ydata, 0, tempYData, 0, numPts);
            } else if (this._properties._lineStepStyle == 1) {
                numPts = xdata.length * 2;
                if (numPts < 0) {
                    numPts = 0;
                }
                tempXData = new double[numPts];
                tempYData = new double[numPts];
                if (this._properties._periodStepStyle == 1) {
                    this.generateStepLine(xdata, tempXData, 1);
                    this.generateStepLine(ydata, tempYData, 0);
                } else {
                    this.generateStepLine(xdata, tempXData, 0);
                    this.generateStepLine(ydata, tempYData, 1);
                    if (this._xdata.length >= 1) {
                        double pt1x = this._xdata[0] - this.getStepInterval();
                        double pt1y = this._ydata[0];
                        double[] tempEopXData = new double[tempXData.length + 1];
                        double[] tempEopYData = new double[tempXData.length + 1];
                        System.arraycopy(tempXData, 0, tempEopXData, 1, tempXData.length);
                        System.arraycopy(tempYData, 0, tempEopYData, 1, tempYData.length);
                        tempEopXData[0] = pt1x;
                        tempEopYData[0] = pt1y;
                        tempXData = tempEopXData;
                        tempYData = tempEopYData;
                    }
                }
            }
            if (tempXData != null) {
                for (int zz = 0; zz < tempXData.length; ++zz) {
                    coordinateList.add(new Coordinate(tempXData[zz], tempYData[zz]));
                }
            }
            if (coordinateList.isEmpty()) continue;
            Object baseGeometry = coordinateList.size() == 1 ? gf.createPoint((Coordinate)coordinateList.get(0)) : gf.createLineString(coordinateList.toArray(new Coordinate[0]));
            geometryList.add((Point)baseGeometry);
        }
        return gf.buildGeometry(geometryList);
    }

    public LocalPt getNearestDataPt(LocalPt pt, boolean interpolate) {
        if (this._numPts == 0) {
            return null;
        }
        int y2 = -1;
        int y1 = -1;
        int x2 = -1;
        int x1 = -1;
        double dist = Double.POSITIVE_INFINITY;
        LocalPt closestPt = null;
        int closestSegmentIndex = -1;
        int closestPointIndex = -1;
        for (int z = 0; z < this._xdataVec.size(); ++z) {
            this._xdata = (double[])this._xdataVec.elementAt(z);
            this._ydata = (double[])this._ydataVec.elementAt(z);
            int numPts = ((intContainer)this._dataSizeVec.elementAt((int)z)).value;
            int[] xdata = new int[this._xdata.length];
            int[] ydata = new int[this._ydata.length];
            if (numPts == 0) continue;
            this.scale(this._xdata, this._ydata, xdata, ydata, 0, numPts);
            if (closestPt == null) {
                closestPt = new LocalPt(xdata[0], ydata[0]);
            }
            for (int i = 0; i < numPts; ++i) {
                x1 = xdata[i];
                y1 = ydata[i];
                double dx = pt.x - x1;
                double dy = pt.y - y1;
                if (dx == 0.0 && dy == 0.0) {
                    return pt;
                }
                double tmp = Math.sqrt(dx * dx + dy * dy);
                if (!(tmp < dist)) continue;
                dist = tmp;
                closestPt.init(x1, y1);
                closestSegmentIndex = z;
                closestPointIndex = i;
            }
        }
        return closestPt;
    }

    public double getNearestDataPt(LocalPt lpt, WorldPt ptnbest) {
        if (lpt == null || ptnbest == null || this._xdataVec.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        int y2 = -1;
        int y1 = -1;
        int x2 = -1;
        int x1 = -1;
        double dist = Double.POSITIVE_INFINITY;
        LocalPt closestPt = null;
        boolean ifound = false;
        double worldMinDist = Double.MAX_VALUE;
        int closestSegmentIndex = -1;
        int closestPointIndex = -1;
        for (int z = 0; z < this._xdataVec.size(); ++z) {
            this._xdata = (double[])this._xdataVec.elementAt(z);
            this._ydata = (double[])this._ydataVec.elementAt(z);
            int numPts = ((intContainer)this._dataSizeVec.elementAt((int)z)).value;
            int[] xdata = new int[this._xdata.length];
            int[] ydata = new int[this._ydata.length];
            this.scale(this._xdata, this._ydata, xdata, ydata, 0, numPts);
            if (closestPt == null) {
                closestPt = new LocalPt(xdata[0], ydata[0]);
            }
            for (int i = 0; i < numPts; ++i) {
                x1 = xdata[i];
                double dx = lpt.x - x1;
                y1 = ydata[i];
                double dy = lpt.y - y1;
                double tmp = Math.sqrt(dx * dx + dy * dy);
                if (!(tmp < dist)) continue;
                WorldPt tempPt = new WorldPt(this._scale.x2e(lpt.x), this._scale.y2n(lpt.y));
                dx = tempPt.n - this._ydata[i];
                dy = tempPt.e - this._xdata[i];
                worldMinDist = Math.sqrt(dx * dx + dy * dy);
                ptnbest.init(this._xdata[i], this._ydata[i]);
                dist = tmp;
                closestPt.init(x1, y1);
                closestSegmentIndex = z;
                closestPointIndex = i;
                ifound = true;
            }
        }
        return ifound ? worldMinDist : Double.NEGATIVE_INFINITY;
    }

    public double getNearestLocation(LocalPt lpt, WorldPt ptnbest) {
        Geometry worldGeometry;
        if (lpt == null || ptnbest == null || this._xdataVec.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        GeometryFactory gf = new GeometryFactory();
        Point lptGeometry = gf.createPoint(new Coordinate(this._scale.x2e(lpt.x), this._scale.y2n(lpt.y)));
        DistanceOp distanceOp = new DistanceOp((Geometry)lptGeometry, worldGeometry = this.toWorldGeometry());
        Coordinate[] nearestPoints = distanceOp.nearestPoints();
        if (nearestPoints == null || nearestPoints.length == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        Coordinate nearestCoordinate = nearestPoints[1];
        if (this._properties._lineStepStyle == 1) {
            int numGeometries = worldGeometry.getNumGeometries();
            boolean found = false;
            block0: for (int n = 0; n < numGeometries && !found; ++n) {
                Geometry geometryN = worldGeometry.getGeometryN(n);
                Coordinate[] coordinates = geometryN.getCoordinates();
                for (int z = 0; z < coordinates.length - 1; ++z) {
                    if (!(coordinates[z].x <= nearestCoordinate.x) || !(nearestCoordinate.x <= coordinates[z + 1].x)) continue;
                    if (this._properties._periodStepStyle == 0) {
                        nearestCoordinate.y = coordinates[z].y;
                        found = true;
                        continue block0;
                    }
                    nearestCoordinate.y = coordinates[z + 1].y;
                    found = true;
                    continue block0;
                }
            }
        }
        ptnbest.init(nearestCoordinate.x, nearestCoordinate.y);
        return distanceOp.distance();
    }

    @Override
    public Object getFieldObject(Field fld) {
        return null;
    }

    public void clearLineData() {
        this._xdata = null;
        this._ydata = null;
        this._xdataVec.removeAllElements();
        this._ydataVec.removeAllElements();
        this._dataSizeVec.removeAllElements();
        this._numPts = 0;
    }

    public void addCallout(LocalPt p) {
        Window w = SwingUtilities.windowForComponent(this._glyph.getViewport());
        String text = Boolean.getBoolean("DEBUG_CALLOUT") ? "+++" : JOptionPane.showInputDialog(w, "Callout Text", "Add Callout", 3);
        if (text == null || text.equals("")) {
            return;
        }
        WorldPt shortestPt = new WorldPt();
        this.getNearestLocation(p, shortestPt);
        this.m_calloutTable.put(shortestPt, text);
        if (w != null && this._glyph != null) {
            this._glyph.getViewport().setDirty();
            this._glyph.getViewport().paintGfx();
        }
    }

    public void setClipLineToBounds(boolean b) {
        this._clipToBounds = b;
    }

    public void setVisible(boolean visible) {
        this.mVisible = visible;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void drawLine(Graphics g, Rectangle clipRect) {
        int[] tempYData;
        int[] tempXData;
        if (!this.mVisible) {
            return;
        }
        int numPts = 1;
        boolean autoSkipPoints = this._properties.getAutoSkipPoints();
        int numOffsetPoints = this._properties.getOffsetPoint();
        int numSkipPoints = this._properties.getSkipPoints();
        for (int z = 0; z < this._xdataVec.size(); ++z) {
            Rectangle2D.Double worldRegion;
            WorldRect wr;
            HashMap<String, Object> drawParameters;
            Paint p;
            this._xdata = (double[])this._xdataVec.elementAt(z);
            this._ydata = (double[])this._ydataVec.elementAt(z);
            numPts = ((intContainer)this._dataSizeVec.elementAt((int)z)).value;
            int startX = 0;
            if (this._clipToBounds) {
                double wBoundMin = this._scale.x2e(clipRect.x);
                double wBoundMax = this._scale.x2e(clipRect.x + clipRect.width);
                startX = Arrays.binarySearch(this._xdata, wBoundMin);
                int endX = Arrays.binarySearch(this._xdata, wBoundMax);
                if (startX < 0) {
                    startX = -1 * startX - 1;
                }
                if (endX < 0) {
                    endX = -1 * endX - 1;
                }
                if (startX - 1 >= 0) {
                    --startX;
                }
                if (endX + 1 <= this._xdata.length) {
                    ++endX;
                }
                numPts = Math.abs(endX - startX);
                if (startX > endX) {
                    int temp = endX;
                    endX = startX;
                    startX = temp;
                }
                if (startX == endX) continue;
            }
            int[] xdata = new int[numPts];
            int[] ydata = new int[numPts];
            this.scale(this._xdata, this._ydata, xdata, ydata, startX, numPts);
            if (this._properties._lineStepStyle == 0) {
                tempXData = new int[numPts];
                tempYData = new int[numPts];
                System.arraycopy(xdata, 0, tempXData, 0, numPts);
                System.arraycopy(ydata, 0, tempYData, 0, numPts);
            } else if (this._properties._lineStepStyle == 1) {
                if ((numPts = numPts * 2 - 1) < 0) {
                    numPts = 0;
                }
                tempXData = new int[numPts];
                tempYData = new int[numPts];
                int eopOffset = 0;
                if (this._properties._periodStepStyle == 1) {
                    this.generateStepLine(xdata, tempXData, 1);
                    this.generateStepLine(ydata, tempYData, 0);
                } else {
                    this.generateStepLine(xdata, tempXData, 0);
                    this.generateStepLine(ydata, tempYData, 1);
                    if (this._xdata.length >= 1) {
                        double pt1x = this._xdata[0] - this.getStepInterval();
                        double pt1y = this._ydata[0];
                        int[] tempEopXData = new int[tempXData.length + 1];
                        int[] tempEopYData = new int[tempXData.length + 1];
                        System.arraycopy(tempXData, 0, tempEopXData, 1, tempXData.length);
                        System.arraycopy(tempYData, 0, tempEopYData, 1, tempYData.length);
                        tempEopXData[0] = this._scale.e2x(pt1x);
                        tempEopYData[0] = this._scale.n2y(pt1y);
                        tempXData = tempEopXData;
                        tempYData = tempEopYData;
                        eopOffset = 1;
                        numPts = tempXData.length;
                    }
                }
                numOffsetPoints = this._properties.getOffsetPoint() * 2 + eopOffset;
                numSkipPoints = 1 + this._properties.getSkipPoints() * 2;
            } else {
                tempXData = new int[1];
                tempYData = new int[1];
                numPts = 1;
            }
            if (this._properties.getFillType() == 1) {
                int onePtLine = 0;
                if (numPts == 1) {
                    onePtLine = 1;
                }
                int[] xtemp = new int[numPts + 3 + onePtLine];
                int[] ytemp = new int[numPts + 3 + onePtLine];
                System.arraycopy(tempXData, 0, xtemp, 0, numPts);
                System.arraycopy(tempYData, 0, ytemp, 0, numPts);
                if (numPts == 1) {
                    xtemp[1] = xtemp[0] + 1;
                    ytemp[1] = ytemp[0];
                }
                xtemp[numPts + onePtLine] = numPts > 1 ? xtemp[numPts - 1] : xtemp[0] + 1;
                ytemp[numPts + onePtLine] = clipRect.y;
                xtemp[numPts + 1 + onePtLine] = xtemp[0];
                ytemp[numPts + 1 + onePtLine] = 0;
                xtemp[numPts + 2 + onePtLine] = xtemp[0];
                ytemp[numPts + 2 + onePtLine] = ytemp[0];
                Color fillColor = this._properties.getFillColor();
                int alpha = (int)(255.0 * (100.0 - (double)this._properties.getFillTransparency()) / 100.0);
                fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), alpha);
                g.setColor(fillColor);
                Paint paint = p = this._properties.getFillPaint() != null ? this._properties.getFillPaint() : FillPatternFactory.createFillPattern(this._properties.getFillPattern(), fillColor);
                if (p instanceof G2dPaint) {
                    drawParameters = new HashMap<String, Object>();
                    wr = this._glyph.getBounds();
                    worldRegion = new Rectangle2D.Double(wr.w, wr.s, wr.e - wr.w, wr.n - wr.s);
                    drawParameters.put("WORLD_BOUNDS", worldRegion);
                    drawParameters.put("SCALE", this._glyph.getScale());
                    ((G2dPaint)p).setPaintParameters(drawParameters);
                }
                Gfx2dDrawUtil.fillPolygonClipped(g, clipRect, xtemp, ytemp, numPts + 3 + onePtLine, p);
            } else if (this._properties.getFillType() == 2) {
                int onePtLine = 0;
                if (numPts == 1) {
                    onePtLine = 1;
                }
                int[] xtemp = new int[numPts + 3 + onePtLine];
                int[] ytemp = new int[numPts + 3 + onePtLine];
                System.arraycopy(tempXData, 0, xtemp, 0, numPts);
                System.arraycopy(tempYData, 0, ytemp, 0, numPts);
                if (numPts == 1) {
                    xtemp[1] = xtemp[0] + 1;
                    ytemp[1] = ytemp[0];
                }
                xtemp[numPts + onePtLine] = numPts > 1 ? xtemp[numPts - 1] : xtemp[0] + 1;
                ytemp[numPts + onePtLine] = clipRect.y + clipRect.height;
                xtemp[numPts + 1 + onePtLine] = xtemp[0];
                ytemp[numPts + 1 + onePtLine] = clipRect.y + clipRect.height;
                xtemp[numPts + 2 + onePtLine] = xtemp[0];
                ytemp[numPts + 2 + onePtLine] = ytemp[0];
                Color fillColor = this._properties.getFillColor();
                int alpha = (int)(255.0 * (100.0 - (double)this._properties.getFillTransparency()) / 100.0);
                fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), alpha);
                g.setColor(fillColor);
                Paint paint = p = this._properties.getFillPaint() != null ? this._properties.getFillPaint() : FillPatternFactory.createFillPattern(this._properties.getFillPattern(), fillColor);
                if (p instanceof G2dPaint) {
                    drawParameters = new HashMap();
                    wr = this._glyph.getBounds();
                    worldRegion = new Rectangle2D.Double(wr.w, wr.s, wr.e - wr.w, wr.n - wr.s);
                    drawParameters.put("WORLD_BOUNDS", worldRegion);
                    drawParameters.put("SCALE", this._glyph.getScale());
                    ((G2dPaint)p).setPaintParameters(drawParameters);
                }
                Gfx2dDrawUtil.fillPolygonClipped(g, clipRect, xtemp, ytemp, numPts + onePtLine + 3, p);
            }
            Color lineColor = this._properties.getLineColor();
            int alpha = (int)(255.0 * (100.0 - (double)this._properties.getLineTransparency()) / 100.0);
            lineColor = new Color(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue(), alpha);
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                Stroke oldStroke = g2d.getStroke();
                BasicStroke bs = new BasicStroke(this._properties.getLineWidth(), this._properties._endStyle, 0, 10.0f, this._properties.getLinePattern(), 0.0f);
                g2d.setStroke(bs);
                Gfx2dDrawUtil.plotPolyLineClipped(g2d, clipRect, tempXData, tempYData, numPts, this._properties.drawLine(), lineColor, this._properties.getLineWidth(), this._properties.drawPoints(), this._properties.getSymbolType(), this._properties.getSymbolSize(), this._properties.getPointFillColor(), this._properties.getPointLineColor(), autoSkipPoints, numOffsetPoints, numSkipPoints, this._properties.hasLabel(), this._properties.getLabel(), this._properties.getLabelAlignment(), this._properties.getLabelPosition(), this._properties.getLabelFont(), this._properties.getLabelColor());
                g2d.setStroke(oldStroke);
                continue;
            }
            Gfx2dDrawUtil.plotPolyLineClipped(g, clipRect, tempXData, tempYData, numPts, this._properties.drawLine(), lineColor, this._properties.getLineWidth(), this._properties.drawPoints(), this._properties.getSymbolType(), this._properties.getSymbolSize(), this._properties.getPointFillColor(), this._properties.getPointLineColor(), autoSkipPoints, numOffsetPoints, numSkipPoints, this._properties.hasLabel(), this._properties.getLabel(), this._properties.getLabelAlignment(), this._properties.getLabelPosition(), this._properties.getLabelFont(), this._properties.getLabelColor());
        }
        if (this._selectedxdata != null) {
            tempXData = new int[this._selectedxdata.length];
            tempYData = new int[this._selectedxdata.length];
            this.scale(this._selectedxdata, this._selectedydata, tempXData, tempYData, 0, this._selectedxdata.length);
            boolean[] showPoints = new boolean[this._selectedxdata.length];
            Arrays.fill(showPoints, true);
            Gfx2dDrawUtil.drawPoints(g, tempXData, tempYData, this._selectedxdata.length, showPoints, this._properties.getSymbolType(), this._properties.getSelectedPointLineColor(), this._properties.getSelectedPointFillColor(), this._properties._symbolSize, false, 0, 0, this._properties.getSelectedSymbolThickness());
        }
        this.drawCallouts(g, clipRect);
    }

    public boolean isCalloutsVisible() {
        return this._drawCallouts;
    }

    public void setCalloutsVisible(boolean b) {
        this._drawCallouts = b;
    }

    public void clearCallouts() {
        this.m_calloutTable.clear();
    }

    public Color getLabelColor() {
        return this._properties.getLabelColor();
    }

    public String getLabelColorString() {
        return RmaColor.color2String(this.getLabelColor());
    }

    public void setLabelColor(Color c2) {
        if (c2 == null) {
            return;
        }
        this._properties.setLabelColor(c2);
    }

    public void setLabelColor(String c2) {
        if (c2 == null) {
            return;
        }
        this._properties.setLabelColor(RmaColor.parseColorString(c2));
    }

    public void drawCallouts(Graphics g, Rectangle clipRect) {
        if (!this._drawCallouts) {
            return;
        }
        Enumeration e = this.m_calloutTable.keys();
        while (e.hasMoreElements()) {
            WorldPt p = (WorldPt)e.nextElement();
            String calloutTxt = (String)this.m_calloutTable.get(p);
            Scale scl = this._glyph.getScale();
            WorldPt lpt1 = this.getNearestDataPt(p, false);
            int dx = this._scale.e2x(p.e) - this._scale.e2x(lpt1.e);
            int dy = this._scale.n2y(p.n) - this._scale.n2y(lpt1.n);
            int calloutLength = 20;
            double slope = 0.0;
            double theta = 0.0;
            int newX = 0;
            int newY = 0;
            double xoffset = 0.0;
            double yoffset = 0.0;
            if (dx != 0) {
                slope = dy / dx;
                theta = Math.atan(slope);
                xoffset = (double)calloutLength * Math.sin(theta);
                yoffset = (double)(-1 * calloutLength) * Math.cos(theta);
                newX = (int)((double)this._scale.e2x(p.e) + xoffset);
                newY = (int)((double)this._scale.n2y(p.n) + yoffset);
            } else {
                yoffset = calloutLength;
                newX = this._scale.e2x(p.e);
                newY = this._scale.n2y(p.n) + (int)yoffset;
            }
            if (Boolean.getBoolean("DEBUG")) {
                System.out.println("Callout Pt = (" + p.e + "," + p.n + ")");
                System.out.println("Line To PT = (" + newX + "," + newY + ")");
                System.out.println("Slope      = " + slope);
                System.out.println("Theta      = " + theta);
                System.out.println("Pt Nearest Callout Pt = (" + lpt1.e + "," + lpt1.n + ")");
            }
            FontMetrics fm = g.getFontMetrics();
            int height = fm.getHeight();
            int strLength = fm.stringWidth(calloutTxt);
            int rectLength = strLength + 4;
            g.setColor(Color.black);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            if (!clipRect.contains(newX - rectLength, newY - height) && newY + height >= clipRect.y + clipRect.height) {
                newX = (int)((double)newX - 2.0 * xoffset);
                newY = (int)((double)newY - 2.0 * yoffset);
            }
            int lpe = this._scale.e2x(p.e);
            int lpy = this._scale.n2y(p.n);
            Color backGroundColor = new Color(0xFFFFE1);
            if (newX < lpe && newY > lpy) {
                g.setColor(backGroundColor);
                g.fillRect(newX - rectLength, newY, rectLength, height);
                g.setColor(Color.black);
                g.drawString(calloutTxt, newX + 2 - rectLength, newY + height - fm.getDescent());
                g.drawRect(newX - rectLength, newY, rectLength, height);
            } else if (newX < lpe && newY <= lpy) {
                g.setColor(backGroundColor);
                g.fillRect(newX - rectLength, newY - height, rectLength, height);
                g.setColor(Color.black);
                g.drawString(calloutTxt, newX + 2 - rectLength, newY - fm.getDescent());
                g.drawRect(newX - rectLength, newY - height, rectLength, height);
            } else if (newX >= lpe && newY <= lpy) {
                g.setColor(backGroundColor);
                g.fillRect(newX, newY - height, rectLength, height);
                g.setColor(Color.black);
                g.drawString(calloutTxt, newX + 2, newY - fm.getDescent());
                g.drawRect(newX, newY - height, rectLength, height);
            } else {
                g.setColor(backGroundColor);
                g.fillRect(newX, newY, rectLength, height);
                g.setColor(Color.black);
                g.drawString(calloutTxt, newX + 2, newY + height - fm.getDescent());
                g.drawRect(newX, newY, rectLength, height + 2);
            }
            Symbol.draw(g, this._scale.e2x(p.e), this._scale.n2y(p.n), 1, Color.black, Color.black, 4.0f);
            g.drawLine(this._scale.e2x(p.e), this._scale.n2y(p.n), newX, newY);
        }
    }

    public void addLineData(double[] xarray, double[] yarray, int numPts) {
        this._numPts += numPts;
        if (this._xdataVec.size() == 0) {
            this.setLineData(xarray, yarray, numPts);
            return;
        }
        double[] tempXarray = (double[])this._xdataVec.get(this._xdataVec.size() - 1);
        double[] tempYarray = (double[])this._ydataVec.get(this._ydataVec.size() - 1);
        this._xdata = new double[numPts + tempXarray.length];
        this._ydata = new double[numPts + tempYarray.length];
        System.arraycopy(tempXarray, 0, this._xdata, 0, tempXarray.length);
        System.arraycopy(tempYarray, 0, this._ydata, 0, tempXarray.length);
        System.arraycopy(xarray, 0, this._xdata, tempXarray.length, numPts);
        System.arraycopy(yarray, 0, this._ydata, tempXarray.length, numPts);
        if (this._dataSizeVec.size() == 0) {
            this._dataSizeVec.addElement(new intContainer(this._xdata.length));
            this._xdataVec.addElement(this._xdata);
            this._ydataVec.addElement(this._ydata);
        } else {
            this._dataSizeVec.setElementAt(new intContainer(this._xdata.length), this._dataSizeVec.size() - 1);
            this._xdataVec.setElementAt(this._xdata, this._dataSizeVec.size() - 1);
            this._ydataVec.setElementAt(this._ydata, this._dataSizeVec.size() - 1);
        }
    }

    public void addLineSegment(double[] xarray, double[] yarray, int numPts) {
        this._numPts += numPts;
        this._xdata = new double[numPts];
        this._ydata = new double[numPts];
        System.arraycopy(xarray, 0, this._xdata, 0, numPts);
        System.arraycopy(yarray, 0, this._ydata, 0, numPts);
        this._dataSizeVec.addElement(new intContainer(numPts));
        this._xdataVec.addElement(this._xdata);
        this._ydataVec.addElement(this._ydata);
    }

    public int getNumLineSegments() {
        return this._dataSizeVec.size();
    }

    public double[][] getLineSegmentAt(int index) {
        if (index < 0 || index >= this.getNumLineSegments()) {
            return null;
        }
        double[][] lineSegment = new double[2][0];
        lineSegment[0] = (double[])this._xdataVec.get(index);
        lineSegment[1] = (double[])this._ydataVec.get(index);
        return lineSegment;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return null;
    }

    public void finalize() throws Throwable {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem;
        Object obj = e.getSource();
        if (obj instanceof JMenuItem && (menuItem = (JMenuItem)obj).getName().equals("EDIT_PROPERTIES")) {
            this.editLineProperties();
        }
    }

    protected DefaultJPanel[] buildPropertiesPanel() {
        this._linePropPanel = new G2dLinesPropPanel();
        LegendPanel lp = this._glyph._viewport._parent._legend;
        this._linePropPanel.setLegendPanel(lp);
        this._linePropPanel.setLineSelectorVisible(false);
        Vector<G2dGlyph> v = new Vector<G2dGlyph>(1);
        v.add(this._glyph);
        this._linePropPanel.setGlyphVector(v);
        DefaultJPanel[] propertiesPanels = new DefaultJPanel[]{this._linePropPanel};
        return propertiesPanels;
    }

    public G2dPropertiesDlg editLineProperties() {
        Window w = null;
        if (this._glyph != null && this._glyph.getViewport() != null) {
            w = SwingUtilities.windowForComponent(this._glyph.getViewport());
        }
        return this.editLineProperties(w);
    }

    public G2dPropertiesDlg editLineProperties(Window w) {
        DefaultJPanel[] propertiesPanels = this.buildPropertiesPanel();
        PropertiesOKListener listener = new PropertiesOKListener();
        G2dPropertiesDlg m_propertiesDialog = null;
        m_propertiesDialog = w instanceof Frame ? new G2dPropertiesDlg((Frame)w, false, this.getName() + " Properties", propertiesPanels) : new G2dPropertiesDlg((Dialog)w, false, this.getName() + " Properties", propertiesPanels);
        List listeners = this.getOKListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            ActionListener a = (ActionListener)listeners.get(i);
            m_propertiesDialog.addOKListener(a);
        }
        m_propertiesDialog.setVisible(true);
        return m_propertiesDialog;
    }

    protected List getOKListeners() {
        ArrayList<PropertiesOKListener> l = new ArrayList<PropertiesOKListener>();
        l.add(new PropertiesOKListener());
        return l;
    }

    public void showPopup(Component c2, int x, int y) {
        this.createPopupMenu();
        this._nameMenuItem.setText(this.getName());
        this.m_lPoint = new LocalPt(x, y);
        this._popupMenu.show(c2, x, y);
    }

    public boolean contains(LocalPt pt) {
        if (this._numPts == 0) {
            return false;
        }
        Point tsPoint = new GeometryFactory().createPoint(new Coordinate((double)pt.x, (double)pt.y));
        Geometry baseGeometry = this.toLocalGeometry();
        return baseGeometry.distance((Geometry)tsPoint) <= 5.0;
    }

    @Override
    public String toString() {
        return this._name;
    }

    protected void createPopupMenu() {
        this._popupMenu = new JPopupMenu("Line Properties");
        this._nameMenuItem = new RmaJMenuLabel("Line Properties");
        Font f = this._nameMenuItem.getFont();
        f = new Font(f.getName(), 2, f.getSize());
        this._nameMenuItem.setFont(f);
        this._popupMenu.add(this._nameMenuItem);
        this._popupMenu.addSeparator();
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.setName("EDIT_PROPERTIES");
        jm.addActionListener(this);
        this._popupMenu.add(jm);
        this._popupMenu.addSeparator();
        jm = new JMenuItem(this.isVisible() ? "Hide Curve" : "Show Curve");
        jm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                G2dLine.this.setVisible(!G2dLine.this.isVisible());
                G2dLine.this._glyph.getViewport().setDirty();
                SwingUtilities.windowForComponent(G2dLine.this._glyph.getViewport()).repaint();
            }
        });
        this._popupMenu.add(jm);
        jm = new JMenuItem("Remove Curve");
        jm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                G2dLine.this.setVisible(!G2dLine.this.isVisible());
                G2dLine.this._glyph.getViewport().getG2dPanel().removeGlyph(G2dLine.this._glyph);
                Window w = SwingUtilities.windowForComponent(G2dLine.this._glyph.getViewport());
                if (w != null) {
                    w.repaint();
                }
            }
        });
        this._popupMenu.add(jm);
        this._popupMenu.addSeparator();
        jm = new JMenuItem("Add Callout");
        jm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                G2dLine.this.addCallout(G2dLine.this.m_lPoint);
            }
        });
        this._popupMenu.add(jm);
        if (this.m_calloutTable.size() > 0) {
            jm = new JMenuItem(this._drawCallouts ? "Hide Callouts" : "Show Callouts");
            jm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    G2dLine.this._drawCallouts = !G2dLine.this._drawCallouts;
                    G2dLine.this._glyph.getViewport().setDirty();
                    SwingUtilities.windowForComponent(G2dLine.this._glyph.getViewport()).repaint();
                }
            });
            this._popupMenu.add(jm);
            jm = new JMenuItem("Clear Callouts");
            jm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    G2dLine.this.m_calloutTable.clear();
                    G2dLine.this._glyph.getViewport().setDirty();
                    SwingUtilities.windowForComponent(G2dLine.this._glyph.getViewport()).repaint();
                }
            });
        }
        this._popupMenu.add(jm);
    }

    protected void scale(double[] worldXData, double[] worldYData, int[] scaledXData, int[] scaledYData, int startPt, int numPoints) {
        int cntr = 0;
        int end = startPt + numPoints;
        if (end > worldXData.length) {
            end = worldXData.length;
        }
        if (end > worldYData.length) {
            end = worldYData.length;
        }
        for (int i = startPt; i < end; ++i) {
            scaledXData[cntr] = this._scale.e2x(worldXData[i]);
            scaledYData[cntr] = this._scale.n2y(worldYData[i]);
            ++cntr;
        }
    }

    protected void scale(double[] worldXData, double[] worldYData, double[] scaledXData, double[] scaledYData, int startPt, int numPoints) {
        int cntr = 0;
        int end = startPt + numPoints;
        if (end > worldXData.length) {
            end = worldXData.length;
        }
        if (end > worldYData.length) {
            end = worldYData.length;
        }
        for (int i = startPt; i < end; ++i) {
            scaledXData[cntr] = this._scale.e2x(worldXData[i]);
            scaledYData[cntr] = this._scale.n2y(worldYData[i]);
            ++cntr;
        }
    }

    private void generateStepLine(int[] dataArray, int[] outArray, int axis) {
        int rows = 0;
        int npts2 = dataArray.length * 2 - 2;
        for (int i = 0; i < dataArray.length; ++i) {
            int data = dataArray[i];
            outArray[rows++] = data;
            if (axis == 0) {
                if (rows < npts2) {
                    outArray[rows++] = data;
                    continue;
                }
                boolean bl = false;
                continue;
            }
            if (rows <= 1) continue;
            outArray[rows++] = data;
        }
    }

    private void generateStepLine(double[] dataArray, double[] outArray, int axis) {
        int rows = 0;
        int npts2 = dataArray.length * 2 - 2;
        for (int i = 0; i < dataArray.length; ++i) {
            double data = dataArray[i];
            outArray[rows++] = data;
            if (axis == 0) {
                if (rows < npts2) {
                    outArray[rows++] = data;
                    continue;
                }
                boolean bl = false;
                continue;
            }
            if (rows <= 1) continue;
            outArray[rows++] = data;
        }
    }

    private void generateCubicLine(int[] dataArray, int[] outArray, int axis) {
    }

    public int getLabelAlignment() {
        return this._properties.getLabelAlignment();
    }

    public String getLabelAlignmentString() {
        return G2dLineProperties.LABEL_ALIGN_NAMES[this.getLabelAlignment()];
    }

    public void setLabelAlignment(int align) {
        this._properties.setLabelAlignment(align);
    }

    public void setLabelAlignment(String align) {
        if (align == null) {
            return;
        }
        for (int i = 0; i < G2dLineProperties.LABEL_ALIGN_NAMES.length; ++i) {
            if (!align.equalsIgnoreCase(G2dLineProperties.LABEL_ALIGN_NAMES[i])) continue;
            this.setLabelAlignment(i);
            return;
        }
        System.out.printf("G2dLine.setLabelAlignment: \"%d\" is not a valid label alignment.\n", align);
    }

    public int getLabelPosition() {
        return this._properties.getLabelPosition();
    }

    public String getLabelPositionString() {
        return G2dLineProperties.LABEL_POS_NAMES[this.getLabelPosition()];
    }

    public void setLabelPosition(int position) {
        this._properties.setLabelPosition(position);
    }

    public void setLabelPosition(String pos) {
        if (pos == null) {
            return;
        }
        for (int i = 0; i < G2dLineProperties.LABEL_POS_NAMES.length; ++i) {
            if (!pos.equalsIgnoreCase(G2dLineProperties.LABEL_POS_NAMES[i])) continue;
            this.setLabelPosition(i);
            return;
        }
        System.out.printf("G2dLine.setLabelPosition: \"%d\" is not a valid label position.\n", pos);
    }

    public Font getLabelFont() {
        return this._properties.getLabelFont();
    }

    public String getLabelFontString() {
        Font f = this.getLabelFont();
        if (f == null) {
            return null;
        }
        Object fontString = f.getFamily();
        if (fontString == null || ((String)fontString).length() == 0) {
            fontString = f.getName();
        }
        fontString = (String)fontString + ",";
        int style = f.getStyle();
        if ((style & 1) != 0) {
            fontString = (String)fontString + "BOLD";
        }
        if ((style & 2) != 0) {
            fontString = (String)fontString + "ITALIC";
        }
        if (((String)fontString).endsWith(",")) {
            fontString = (String)fontString + "PLAIN";
        }
        fontString = (String)fontString + "," + f.getSize();
        return fontString;
    }

    public void setLabelFont(Font f) {
        this._properties.setLabelFont(f);
    }

    public void setLabelFont(String fontString) {
        this.setLabelFont(G2dMarkerProperties.string2font(fontString));
    }

    public void setLabelVisible(boolean b) {
        this._properties.setHasLabel(b);
    }

    public void setLineLabelVisible(boolean b) {
        this.setLabelVisible(b);
    }

    public boolean isLabelVisible() {
        return this._properties.hasLabel();
    }

    public boolean isLineLabelVisible() {
        return this.isLabelVisible();
    }

    public String getLabel() {
        return this._properties._label;
    }

    public void setLabel(String label) {
        if (label == null) {
            label = "";
        }
        this._properties._label = label;
    }

    public String getLineLabel() {
        return this.getLabel();
    }

    public void setLineLabel(String label) {
        this.setLabel(label);
    }

    public void setFillType(String fillStyle) {
        if (fillStyle == null) {
            this._properties.setFillType(0);
            return;
        }
        this._properties.setFillType(G2dLineProperties.lookupFill(fillStyle));
    }

    public String getFillTypeString() {
        return G2dLineProperties.lookupFillName(this._properties.getFillType());
    }

    public int getFillType() {
        return this._properties.getFillType();
    }

    public void setFillPattern(String fillPattern) {
        if (fillPattern == null) {
            this._properties.setFillPattern(RmaDrawConst.lookupFillPattern("solid"));
            return;
        }
        this._properties.setFillPattern(RmaDrawConst.lookupFillPattern(fillPattern));
    }

    public String getFillPatternString() {
        return G2dLineProperties.lookupFillName(this._properties.getFillPattern());
    }

    public int getFillPattern() {
        return this._properties.getFillPattern();
    }

    public void setFillColor(String fillColor) {
        if (fillColor == null) {
            this._properties.setFillColor(null);
            return;
        }
        this._properties.setFillColor(RmaColor.parseColorString(fillColor));
    }

    public void setFillColor(Color c2) {
        this._properties.setFillColor(c2);
    }

    public String getFillColorString() {
        return RmaColor.color2String(this._properties.getFillColor());
    }

    public Color getFillColor() {
        return this._properties.getFillColor();
    }

    public void setLineColor(String lineColor) {
        if (lineColor == null) {
            this._properties.setLineColor(null);
            return;
        }
        this._properties.setLineColor(RmaColor.parseColorString(lineColor));
    }

    public void setLineColor(Color c2) {
        if (c2 == null) {
            return;
        }
        this._properties.setLineColor(c2);
    }

    public String getLineColorString() {
        return RmaColor.color2String(this._properties.getLineColor());
    }

    public Color getLineColor() {
        return this._properties.getLineColor();
    }

    public void setLineStyle(String lineStyle) {
        this._properties.setLinePattern(G2dLineProperties.lookupStyle(lineStyle));
    }

    public String getLineStyleString() {
        return G2dLineProperties.lookupStyleName(this._properties.getLinePattern());
    }

    public float[] getLineStyle() {
        return this._properties.getLinePattern();
    }

    public void setLineVisible(boolean state) {
        this._properties.setDrawLine(state);
    }

    @Deprecated
    public void setDrawLineOn() {
        this.setLineVisible(true);
    }

    @Deprecated
    public void setDrawLineOff() {
        this.setLineVisible(false);
    }

    public boolean isLineVisible() {
        return this._properties._drawLine;
    }

    @Deprecated
    public boolean isLineDrawn() {
        return this.isLineVisible();
    }

    public void setSymbolFillColor(String symbolFillColor) {
        if (symbolFillColor == null) {
            this._properties.setSymbolFillColor(null);
            return;
        }
        this._properties.setSymbolFillColor(RmaColor.parseColorString(symbolFillColor));
    }

    public String getSymbolFillColorString() {
        return RmaColor.color2String(this._properties.getPointFillColor());
    }

    public Color getSymbolFillColor() {
        return this._properties.getPointFillColor();
    }

    public void setSymbolLineColor(String symbolLineColor) {
        if (symbolLineColor == null) {
            this._properties.setSymbolLineColor(null);
            return;
        }
        this._properties.setSymbolLineColor(RmaColor.parseColorString(symbolLineColor));
    }

    public String getSymbolLineColorString() {
        return RmaColor.color2String(this._properties.getPointLineColor());
    }

    public Color getSymbolLineColor() {
        return this._properties.getPointLineColor();
    }

    public void setSymbolsVisible(boolean state) {
        this._properties.setDrawPoints(state);
    }

    @Deprecated
    public void setDrawSymbolsOn() {
        this.setSymbolsVisible(true);
    }

    @Deprecated
    public void setDrawSymbolsOff() {
        this.setSymbolsVisible(false);
    }

    public boolean areSymbolsVisible() {
        return this._properties._drawPoints;
    }

    @Deprecated
    public boolean areSymbolsDrawn() {
        return this.areSymbolsVisible();
    }

    public void setLineStepStyle(String stepStyle) {
        if (stepStyle == null) {
            this._properties.setLineStepStyle(0);
            return;
        }
        if ((stepStyle = stepStyle.toLowerCase()).startsWith("step")) {
            this._properties.setLineStepStyle(1);
        } else if (stepStyle.startsWith("cubic")) {
            this._properties.setLineStepStyle(3);
        } else {
            this._properties.setLineStepStyle(0);
        }
    }

    public void setPeriodStepStyle(String stepStyle) {
        if ("EOP".equalsIgnoreCase(stepStyle)) {
            this._properties.setPeriodStepStyle(0);
        } else if ("BOP".equalsIgnoreCase(stepStyle)) {
            this._properties.setPeriodStepStyle(1);
        } else {
            this._properties.setPeriodStepStyle(0);
        }
    }

    public int getLineStepStyle() {
        return this._properties.getLineStepStyle();
    }

    public String getLineStepStyleString() {
        switch (this._properties.getLineStepStyle()) {
            case 1: {
                return "step";
            }
            case 3: {
                return "cubic";
            }
        }
        return "normal";
    }

    public void setLineWidth(float width) {
        this._properties.setLineWidth(width);
    }

    public void setFirstSymbolOffset(int offset) {
        this._properties.setOffsetPoint(offset);
    }

    @Deprecated
    public void setSymbolOffset(int offset) {
        this.setFirstSymbolOffset(offset);
    }

    public int getFirstSymbolOffset() {
        return this._properties.getOffsetPoint();
    }

    @Deprecated
    public int getSymbolOffset() {
        return this.getFirstSymbolOffset();
    }

    public void setSymbolSkipCount(int skipCount) {
        this._properties.setSkipPoints(skipCount);
    }

    public void setSymbolInterval(int interval) {
        this.setSymbolSkipCount(interval - 1);
    }

    @Deprecated
    public void setSymbolsSkipInterval(int skipInterval) {
        this.setSymbolSkipCount(skipInterval);
    }

    public int getSymbolSkipCount() {
        return this._properties.getSkipPoints();
    }

    public int getSymbolInterval() {
        return this.getSymbolSkipCount() + 1;
    }

    @Deprecated
    public int getSymbolSkipInterval() {
        return this.getSymbolSkipCount();
    }

    public void setSymbolSize(float size) {
        this._properties.setSymbolSize(size);
    }

    public float getSymbolSize() {
        return this._properties.getSymbolSize();
    }

    public void setSymbolType(int type) {
        this._properties.setSymbolType(type);
    }

    public void setSymbolType(String name) {
        int type = Symbol.getSymbolType(name);
        if (type != Integer.MIN_VALUE) {
            this._properties.setSymbolType(type);
        }
    }

    public int getSymbolType() {
        return this._properties.getSymbolType();
    }

    public String getSymbolTypeString() {
        return Symbol.getSymbolName(this._properties.getSymbolType());
    }

    public void setSymbolsAutoInterval(boolean state) {
        this._properties.setAutoSkipPoints(state);
    }

    @Deprecated
    public void setAutoSkipSymbolsOn() {
        this.setSymbolsAutoInterval(true);
    }

    @Deprecated
    public void setAutoSkipSymbolsOff() {
        this.setSymbolsAutoInterval(false);
    }

    public boolean areSymbolsAutoInterval() {
        return this._properties.getAutoSkipPoints();
    }

    @Deprecated
    public boolean getAutoSkipSymbols() {
        return this.areSymbolsAutoInterval();
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window w;
            if (G2dLine.this._glyph != null && (w = SwingUtilities.windowForComponent(G2dLine.this._glyph.getViewport())) != null) {
                if (G2dLine.this._glyph != null) {
                    G2dLine.this._glyph.getViewport().setDirty();
                }
                w.repaint();
            }
            if (G2dLine.this._glyph != null && G2dLine.this._glyph._viewport != null) {
                if (G2dLine.this._glyph._viewport._parent._legend != null) {
                    G2dLine.this._glyph._viewport._parent._legend.refreshLegendItems();
                }
                G2dLine.this._glyph._viewport._parent.repaint();
            }
        }
    }
}

