/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.LineLabelProperties;
import hec.gfx2d.components.CheckBoxPanel;
import hec.gfx2d.components.ComponentPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTextField;

public class G2dLineLabelPropertiesPanel
extends DefaultJPanel
implements ActionListener,
ComponentPanel {
    private static final String LEFT = "Left";
    private static final String RIGHT = "Right";
    private static final String CENTER = "Center";
    private static final String ABOVE = "Above";
    private static final String BELOW = "Below";
    private String _align = "Left";
    private String _position = "Above";
    SamplePanel samplePanel = new SamplePanel();
    RmaJComboBox jAlignmentCombo = new RmaJComboBox();
    RmaJComboBox jPositionCombo = new RmaJComboBox();
    JLabel jLabelLabel = new JLabel("Label Text:");
    RmaJTextField jLabelText = new RmaJTextField();
    JLabel jLabelAlignment = new JLabel("Alignment:");
    JLabel jLabelPositition = new JLabel("Position:");
    protected JPanel jLabelPanel = new JPanel(new GridBagLayout());
    CheckBoxPanel checkBoxPanel = new CheckBoxPanel("Show Label");
    private LineLabelProperties _properties = null;

    public G2dLineLabelPropertiesPanel() {
        this.setLayout(new GridBagLayout());
        Insets ins = this.getInsets();
        this.setName("Label");
        this.add((Component)this.jLabelPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.samplePanel, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 12, 2, RmaInsets.insets(5, 5, 5, 5), 0, 25));
        this.jLabelPanel.add((Component)this.checkBoxPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 0, RmaInsets.insets(0, 5, 0, 0), 0, 0));
        this.jLabelPanel.add((Component)this.jLabelLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        this.jLabelPanel.add((Component)this.jLabelText, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.jLabelPanel.add((Component)this.jLabelAlignment, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        this.jLabelPanel.add((Component)this.jAlignmentCombo, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        this.jLabelPanel.add((Component)this.jLabelPositition, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.insets(5, 5, 5, 0), 0, 0));
        this.jLabelPanel.add((Component)this.jPositionCombo, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 2, RmaInsets.insets(5, 5, 5, 5), 0, 0));
        this.jPositionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{ABOVE, CENTER, BELOW}));
        this.jAlignmentCombo.setModel(new DefaultComboBoxModel<String>(new String[]{LEFT, CENTER, RIGHT}));
        this.jLabelPanel.setBorder(new TitledBorder("Label"));
        this.jPositionCombo.setModifiable(true);
        this.jAlignmentCombo.setModifiable(true);
        this.jPositionCombo.addActionListener(this);
        this.jAlignmentCombo.addActionListener(this);
        this.checkBoxPanel.addComponentPanel(this);
    }

    public void disablePanel() {
        this.checkBoxPanel.setSelected(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.jPositionCombo) {
            this.PositionCombo_ActionPerformed();
        } else if (obj == this.jAlignmentCombo) {
            this.AlignmentCombo_ActionPerformed();
        }
    }

    private void PositionCombo_ActionPerformed() {
        this._position = (String)this.jPositionCombo.getSelectedItem();
        this.samplePanel.repaint();
    }

    private void AlignmentCombo_ActionPerformed() {
        this._align = (String)this.jAlignmentCombo.getSelectedItem();
        this.samplePanel.repaint();
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        this.jAlignmentCombo.setEnabled(enabled);
        this.jPositionCombo.setEnabled(enabled);
        this.jLabelPositition.setEnabled(enabled);
        this.jLabelAlignment.setEnabled(enabled);
        this.jLabelLabel.setEnabled(enabled);
        this.jLabelText.setEnabled(enabled);
        this.samplePanel.repaint();
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        this.jAlignmentCombo.removeActionListener(this);
        this.jPositionCombo.removeActionListener(this);
        this.checkBoxPanel.setSelected(this._properties.hasLabel());
        switch (this._properties.getLabelAlignment()) {
            case 0: {
                this.jAlignmentCombo.setSelectedItem(LEFT);
                break;
            }
            case 1: {
                this.jAlignmentCombo.setSelectedItem(RIGHT);
                break;
            }
            case 2: {
                this.jAlignmentCombo.setSelectedItem(CENTER);
            }
        }
        switch (this._properties.getLabelPosition()) {
            case 0: {
                this.jPositionCombo.setSelectedItem(ABOVE);
                break;
            }
            case 1: {
                this.jPositionCombo.setSelectedItem(BELOW);
                break;
            }
            case 2: {
                this.jPositionCombo.setSelectedItem(CENTER);
            }
        }
        this.jLabelText.setText(this._properties.getLabel());
        this.jAlignmentCombo.addActionListener(this);
        this.jPositionCombo.addActionListener(this);
        this.samplePanel.repaint();
        this.setModified(false);
    }

    public void setData(LineLabelProperties p) {
        this._properties = p;
    }

    public void refresh() {
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        this._properties.setHasLabel(this.checkBoxPanel.isSelected());
        String align = (String)this.jAlignmentCombo.getSelectedItem();
        if (align.equals(LEFT)) {
            this._properties.setLabelAlignment(0);
        } else if (align.equals(RIGHT)) {
            this._properties.setLabelAlignment(1);
        } else if (align.equals(CENTER)) {
            this._properties.setLabelAlignment(2);
        }
        String pos = (String)this.jPositionCombo.getSelectedItem();
        if (pos.equals(ABOVE)) {
            this._properties.setLabelPosition(0);
        } else if (pos.equals(BELOW)) {
            this._properties.setLabelPosition(1);
        } else if (pos.equals(CENTER)) {
            this._properties.setLabelPosition(2);
        }
        this._properties.setLabel(this.jLabelText.getText().trim());
        if (this.isModified()) {
            this._properties.setModified(true);
        }
        return true;
    }

    public LineLabelProperties getProperties() {
        return this._properties;
    }

    public class SamplePanel
    extends JPanel {
        int strLen = 0;
        String sample = "Sample Text";
        String _position = "Left";
        String _align = "Above";

        public SamplePanel() {
            this.setBorder(new TitledBorder("Sample"));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (!G2dLineLabelPropertiesPanel.this.checkBoxPanel.isSelected()) {
                Dimension d = this.getSize();
                g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(Color.black);
            Dimension d = this.getSize();
            this._position = (String)G2dLineLabelPropertiesPanel.this.jPositionCombo.getSelectedItem();
            this._align = (String)G2dLineLabelPropertiesPanel.this.jAlignmentCombo.getSelectedItem();
            this.strLen = g.getFontMetrics().stringWidth(this.sample);
            if (this._position.equals(G2dLineLabelPropertiesPanel.ABOVE) && this._align.equals(G2dLineLabelPropertiesPanel.LEFT)) {
                this.drawAboveLeft(g);
            } else if (this._position.equals(G2dLineLabelPropertiesPanel.ABOVE) && this._align.equals(G2dLineLabelPropertiesPanel.CENTER)) {
                this.drawAboveCenter(g);
            } else if (this._position.equals(G2dLineLabelPropertiesPanel.ABOVE) && this._align.equals(G2dLineLabelPropertiesPanel.RIGHT)) {
                this.drawAboveRight(g);
            } else if (this._position.equals(G2dLineLabelPropertiesPanel.BELOW) && this._align.equals(G2dLineLabelPropertiesPanel.LEFT)) {
                this.drawBelowLeft(g);
            } else if (this._position.equals(G2dLineLabelPropertiesPanel.BELOW) && this._align.equals(G2dLineLabelPropertiesPanel.CENTER)) {
                this.drawBelowCenter(g);
            } else if (this._position.equals(G2dLineLabelPropertiesPanel.BELOW) && this._align.equals(G2dLineLabelPropertiesPanel.RIGHT)) {
                this.drawBelowRight(g);
            } else if (this._position.equals(G2dLineLabelPropertiesPanel.CENTER) && this._align.equals(G2dLineLabelPropertiesPanel.CENTER)) {
                this.drawCenterCenter(g);
            } else if (this._position.equals(G2dLineLabelPropertiesPanel.CENTER) && this._align.equals(G2dLineLabelPropertiesPanel.RIGHT)) {
                this.drawCenterRight(g);
            } else if (this._position.equals(G2dLineLabelPropertiesPanel.CENTER) && this._align.equals(G2dLineLabelPropertiesPanel.LEFT)) {
                this.drawCenterLeft(g);
            }
            g.setColor(oldColor);
        }

        private void drawAboveLeft(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            Gfx2dDrawUtil.drawString(this, g, this.sample, 10, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }

        private void drawAboveCenter(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            Gfx2dDrawUtil.drawString(this, g, this.sample, d.width / 2 - this.strLen / 2, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }

        private void drawAboveRight(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            Gfx2dDrawUtil.drawString(this, g, this.sample, d.width - 10 - this.strLen, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }

        private void drawBelowLeft(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            g.drawString(this.sample, 10, d.height / 2 + 2 + g.getFontMetrics().getAscent());
        }

        private void drawBelowCenter(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            Gfx2dDrawUtil.drawString(this, g, this.sample, d.width / 2 - this.strLen / 2, d.height / 2 + 2 + g.getFontMetrics().getAscent());
        }

        private void drawBelowRight(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            Gfx2dDrawUtil.drawString(this, g, this.sample, d.width - 10 - this.strLen, d.height / 2 + 2 + g.getFontMetrics().getAscent());
        }

        private void drawCenterRight(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width - 12 - this.strLen, d.height / 2 + 2);
            g.drawLine(d.width - 10 + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            Gfx2dDrawUtil.drawString(this, g, this.sample, d.width - 10 - this.strLen, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }

        private void drawCenterCenter(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, d.width / 2 - this.strLen / 2 - 2, d.height / 2 + 2);
            g.drawLine(d.width / 2 + this.strLen / 2 + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            Gfx2dDrawUtil.drawString(this, g, this.sample, d.width / 2 - this.strLen / 2, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }

        private void drawCenterLeft(Graphics g) {
            Dimension d = this.getSize();
            g.drawLine(5, d.height / 2 + 2, 8, d.height / 2 + 2);
            g.drawLine(10 + this.strLen + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            Gfx2dDrawUtil.drawString(this, g, this.sample, 10, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }
    }
}

