/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.components.LabelPanel;
import hec.gfx2d.components.LinePropertiesPanel;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import rma.swing.DateTimePanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.util.FillPatternFactory;

public class G2dLineMarkerPropertiesPanel
extends DefaultJPanel
implements ActionListener {
    public static final int TIME_AXIS = 0;
    public static final int NUMERIC_AXIS = 1;
    G2dMarkerProperties _properties = null;
    Object[] lineCustomColor = new Object[]{Color.white, "Custom"};
    Object[] fillCustomColor = new Object[]{Color.white, "Custom"};
    private JPanel _cardPanel;
    private LinePropertiesPanel _linePanel;
    private SamplePanel _samplePanel;
    private RmaJDecimalField _markerValue;
    private DateTimePanel _dateTimePanel;
    private TimeZone _dataTimeZone;
    private int _axisType = 1;
    private LabelPanel _labelPanel;

    public G2dLineMarkerPropertiesPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this.setName("Marker Lines");
        this._cardPanel = new JPanel(new CardLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._cardPanel, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Marker Value:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)label, gbc);
        this._markerValue = new RmaJDecimalField();
        label.setLabelFor(this._markerValue);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)this._markerValue, gbc);
        this._cardPanel.add(Integer.toString(1), panel);
        this._dateTimePanel = new DateTimePanel(1, "Date", "Time", "DDMMMYYYY"){

            @Override
            public void setTimeZone(TimeZone tz) {
                if (tz == null) {
                    return;
                }
                if (this._dataTimeZone == null) {
                    return;
                }
                super.setTimeZone(tz);
            }
        };
        this._dateTimePanel.setTimeZone(TimeZone.getDefault());
        this._cardPanel.add(Integer.toString(0), this._dateTimePanel);
        this._linePanel = new LinePropertiesPanel("Draw Line");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._linePanel, gbc);
        this._samplePanel = new SamplePanel();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS0505;
        this.add((Component)this._samplePanel, gbc);
        this._labelPanel = new LabelPanel("Draw Label");
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._labelPanel, gbc);
        this._labelPanel.setSamplePanel(this._samplePanel);
        this._linePanel.setSamplePanel(this._samplePanel);
    }

    public String getFillAboveRadioText() {
        return "Fill Above";
    }

    public String getFillBelowRadioText() {
        return "Fill Below";
    }

    public void setData(G2dMarkerProperties prop) {
        this._properties = prop;
        this._dataTimeZone = TimeZone.getDefault();
    }

    public void setData(G2dMarkerProperties prop, TimeZone dataTimeZone) {
        this._properties = prop;
        this._dataTimeZone = dataTimeZone;
    }

    public G2dMarkerProperties getData() {
        return this._properties;
    }

    public void setAxisType(int axisType) {
        if (axisType != 0 && axisType != 1) {
            throw new IllegalArgumentException("Invalid Axis type passed to G2dMarkerValueLabelPropertiesPanel");
        }
        this._axisType = axisType;
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, Integer.toString(this._axisType));
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        this._linePanel.setSelected(this._properties.drawLine);
        this._linePanel.setLineColor(this._properties.lineColor);
        this._linePanel.setLineStyle(this._properties.lineStylePattern);
        this._linePanel.setLineWidth(this._properties.lineWidth);
        this._linePanel.setFillColor(this._properties.fillColor);
        this._linePanel.setFillType(this._properties.fillType);
        this._linePanel.setFillPattern(this._properties.fillPattern);
        this._labelPanel.setSelected(this._properties.drawLabel);
        this._labelPanel.setSelectedFont(this._properties.getLabelFont());
        this._labelPanel.setText(this._properties.getLabel());
        this._labelPanel.setTextColor(this._properties.getLabelColor());
        this._labelPanel.setAlignment(this._properties.getLabelAlignment());
        this._labelPanel.setPosition(this._properties.getLabelPosition());
        if (this._axisType == 1) {
            this._markerValue.setValue(this._properties.getMarkerValue());
        } else {
            HecTime hTime = new HecTime();
            hTime.setMinutes(this._properties.getMarkerValue());
            TimeZone clientTimeZone = RmaJDialog.getTimeZone();
            TimeZone tz = this._dataTimeZone != null ? this._dataTimeZone : (clientTimeZone != null ? clientTimeZone : TimeZone.getDefault());
            this._dateTimePanel.setDateTime(hTime, tz);
        }
        this._samplePanel.repaint();
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        this._properties.drawLine = this._linePanel.isSelected();
        this._properties.lineColor = this._linePanel.getLineColor();
        this._properties.lineStylePattern = this._linePanel.getLineStyle();
        this._properties.lineWidth = this._linePanel.getLineWidth();
        this._properties.fillColor = this._linePanel.getFillColor();
        this._properties.fillType = this._linePanel.getFillType();
        this._properties.fillPattern = this._linePanel.getFillPattern();
        this._properties.drawLabel = this._labelPanel.isSelected();
        this._properties.setLabelFont(this._labelPanel.getSelectedFont());
        this._properties.setLabel(this._labelPanel.getText());
        this._properties.setLabelAlignment(this._labelPanel.getAlignment());
        this._properties.setLabelPosition(this._labelPanel.getPosition());
        this._properties.setLabelColor(this._labelPanel.getTextColor());
        if (this._axisType == 1) {
            this._properties.setMarkerValue(this._markerValue.getValue());
        } else {
            HecTimeArray hTime = this._dateTimePanel.getDateTime();
            this._properties.setMarkerValue(hTime.element(0).value());
        }
        return true;
    }

    public void setSamplePanelVisible(boolean b) {
        this._samplePanel.setVisible(b);
    }

    public boolean isSamplePanelVisible() {
        return this._samplePanel.isVisible();
    }

    public void clearPanel() {
        this._linePanel.clearPanel();
        this._labelPanel.clearPanel();
        this._dateTimePanel.clear();
    }

    public void setCustomLineRadioOptionsVisible(boolean visible) {
        this._linePanel.setCheckBoxVisible(visible);
    }

    public void setRenderColorNames(boolean b) {
        this._linePanel.setRenderColorNames(b);
    }

    public void setMarkerValuePanelVisible(boolean visible) {
        this._cardPanel.setVisible(visible);
    }

    public void setLabelTextVisible(boolean visible) {
        this._labelPanel.setLabelTextVisible(visible);
    }

    public class SamplePanel
    extends JPanel {
        int strLen = 0;
        String sample = "Sample Text";
        String _position = "Left";
        String _align = "Above";
        float _lineThickness;
        float[] _linePattern;

        public SamplePanel() {
            this.setBackground(null);
            this.setBorder(new TitledBorder("Sample"));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (!G2dLineMarkerPropertiesPanel.this._linePanel.isSelected() && !G2dLineMarkerPropertiesPanel.this._labelPanel.isSelected()) {
                return;
            }
            this._linePattern = G2dLineMarkerPropertiesPanel.this._linePanel.getLineStyle();
            if (this._linePattern != null && this._linePattern.length == 1 && this._linePattern[0] == 50.0f) {
                this._linePattern = null;
            }
            Dimension d = this.getSize();
            this._lineThickness = G2dLineMarkerPropertiesPanel.this._linePanel.getLineWidth();
            Graphics2D g2d = (Graphics2D)g;
            Stroke oldStroke = g2d.getStroke();
            BasicStroke bs = new BasicStroke(this._lineThickness, 0, 0, 10.0f, this._linePattern, 0.0f);
            g2d.setStroke(bs);
            Color oldColor = g.getColor();
            g.setColor(G2dLineMarkerPropertiesPanel.this._linePanel.getLineColor());
            if (G2dLineMarkerPropertiesPanel.this._linePanel.isSelected()) {
                int filltype = G2dLineMarkerPropertiesPanel.this._linePanel.getFillType();
                int fillPattern = G2dLineMarkerPropertiesPanel.this._linePanel.getFillPattern();
                if (fillPattern == 0) {
                    g2d.setColor(G2dLineMarkerPropertiesPanel.this._linePanel.getFillColor());
                    if (filltype == 1) {
                        g2d.fillRect(5, 15, d.width - 10, d.height / 2 - 13);
                    } else if (filltype == 2) {
                        g2d.fillRect(5, d.height / 2 + 2, d.width - 10, d.height / 2 - 10);
                    }
                } else {
                    Composite oldac = ((Graphics2D)g).getComposite();
                    AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                    Paint op = g2d.getPaint();
                    Paint tp = FillPatternFactory.createFillPattern(fillPattern, G2dLineMarkerPropertiesPanel.this._linePanel.getFillColor());
                    g2d.setPaint(tp);
                    ((Graphics2D)g).setComposite(ac);
                    if (filltype == 1) {
                        g2d.fillRect(5, 15, d.width - 10, d.height / 2 - 13);
                    } else if (filltype == 2) {
                        g2d.fillRect(5, d.height / 2 + 2, d.width - 10, d.height / 2 - 10);
                    }
                    g2d.setComposite(oldac);
                    g2d.setPaint(op);
                }
                if (!G2dLineMarkerPropertiesPanel.this._labelPanel.isSelected()) {
                    g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
                }
            }
            if (G2dLineMarkerPropertiesPanel.this._labelPanel.isSelected()) {
                this._position = G2dLineMarkerPropertiesPanel.this._labelPanel.getPositionString();
                this._align = G2dLineMarkerPropertiesPanel.this._labelPanel.getAlignmentString();
                this.strLen = g.getFontMetrics().stringWidth(this.sample);
                if (this._position.equals("Above") && this._align.equals("Left")) {
                    this.drawAboveLeft(g);
                } else if (this._position.equals("Above") && this._align.equals("Center")) {
                    this.drawAboveCenter(g);
                } else if (this._position.equals("Above") && this._align.equals("Right")) {
                    this.drawAboveRight(g);
                } else if (this._position.equals("Below") && this._align.equals("Left")) {
                    this.drawBelowLeft(g);
                } else if (this._position.equals("Below") && this._align.equals("Center")) {
                    this.drawBelowCenter(g);
                } else if (this._position.equals("Below") && this._align.equals("Right")) {
                    this.drawBelowRight(g);
                } else if (this._position.equals("Center") && this._align.equals("Center")) {
                    this.drawCenterCenter(g);
                } else if (this._position.equals("Center") && this._align.equals("Right")) {
                    this.drawCenterRight(g);
                } else if (this._position.equals("Center") && this._align.equals("Left")) {
                    this.drawCenterLeft(g);
                }
            }
            g.setColor(oldColor);
            g2d.setStroke(oldStroke);
        }

        private void drawAboveLeft(Graphics g) {
            Dimension d = this.getSize();
            if (G2dLineMarkerPropertiesPanel.this._linePanel.isSelected()) {
                g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            g.setColor(G2dLineMarkerPropertiesPanel.this._labelPanel.getTextColor());
            g.drawString(this.sample, 10, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }

        private void drawAboveCenter(Graphics g) {
            Dimension d = this.getSize();
            if (G2dLineMarkerPropertiesPanel.this._linePanel.isSelected()) {
                g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            g.setColor(G2dLineMarkerPropertiesPanel.this._labelPanel.getTextColor());
            g.drawString(this.sample, d.width / 2 - this.strLen / 2, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }

        private void drawAboveRight(Graphics g) {
            Dimension d = this.getSize();
            if (G2dLineMarkerPropertiesPanel.this._linePanel.isSelected()) {
                g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            g.setColor(G2dLineMarkerPropertiesPanel.this._labelPanel.getTextColor());
            g.drawString(this.sample, d.width - 10 - this.strLen, d.height / 2 + 2 - g.getFontMetrics().getDescent());
        }

        private void drawBelowLeft(Graphics g) {
            Dimension d = this.getSize();
            if (G2dLineMarkerPropertiesPanel.this._linePanel.isSelected()) {
                g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            g.setColor(G2dLineMarkerPropertiesPanel.this._labelPanel.getTextColor());
            g.drawString(this.sample, 10, d.height / 2 + 2 + g.getFontMetrics().getAscent());
        }

        private void drawBelowCenter(Graphics g) {
            Dimension d = this.getSize();
            if (G2dLineMarkerPropertiesPanel.this._linePanel.isSelected()) {
                g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            g.setColor(G2dLineMarkerPropertiesPanel.this._labelPanel.getTextColor());
            g.drawString(this.sample, d.width / 2 - this.strLen / 2, d.height / 2 + 2 + g.getFontMetrics().getAscent());
        }

        private void drawBelowRight(Graphics g) {
            Dimension d = this.getSize();
            if (G2dLineMarkerPropertiesPanel.this._linePanel.isSelected()) {
                g.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            g.setColor(G2dLineMarkerPropertiesPanel.this._labelPanel.getTextColor());
            g.drawString(this.sample, d.width - 10 - this.strLen, d.height / 2 + 2 + g.getFontMetrics().getAscent());
        }

        private void drawCenterRight(Graphics g) {
            Dimension d = this.getSize();
            if (G2dLineMarkerPropertiesPanel.this._linePanel.isSelected()) {
                g.drawLine(5, d.height / 2 + 2, d.width - 12 - this.strLen, d.height / 2 + 2);
                g.drawLine(d.width - 10 + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            g.setColor(G2dLineMarkerPropertiesPanel.this._labelPanel.getTextColor());
            g.drawString(this.sample, d.width - 10 - this.strLen, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }

        private void drawCenterCenter(Graphics g) {
            Dimension d = this.getSize();
            if (G2dLineMarkerPropertiesPanel.this._linePanel.isSelected()) {
                g.drawLine(5, d.height / 2 + 2, d.width / 2 - this.strLen / 2 - 2, d.height / 2 + 2);
                g.drawLine(d.width / 2 + this.strLen / 2 + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            g.setColor(G2dLineMarkerPropertiesPanel.this._labelPanel.getTextColor());
            g.drawString(this.sample, d.width / 2 - this.strLen / 2, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }

        private void drawCenterLeft(Graphics g) {
            Dimension d = this.getSize();
            if (G2dLineMarkerPropertiesPanel.this._linePanel.isSelected()) {
                g.drawLine(5, d.height / 2 + 2, 8, d.height / 2 + 2);
                g.drawLine(10 + this.strLen + 2, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
            }
            g.setColor(G2dLineMarkerPropertiesPanel.this._labelPanel.getTextColor());
            g.drawString(this.sample, 10, d.height / 2 + 2 + g.getFontMetrics().getAscent() / 2 - 1);
        }
    }
}

