/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class G2dLinePatternRenderer
extends JLabel
implements ListCellRenderer {
    private Color _color = Color.blue;
    private LineIcon _icon = new LineIcon();

    public G2dLinePatternRenderer() {
        this.setOpaque(true);
        this.setIcon(this._icon);
    }

    public G2dLinePatternRenderer(Color c2) {
        this();
        this.setColor(c2);
    }

    public void setColor(Color c2) {
        if (c2 == null) {
            return;
        }
        this._color = c2;
    }

    public void setLineIcon(LineIcon icon) {
        if (icon != null) {
            this._icon = icon;
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        float[] array = (float[])value;
        this._icon.setColor(this._color);
        this._icon.setLinePattern(array);
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        return this;
    }

    protected class LineIcon
    implements Icon {
        private Color _color;
        private float[] _linePattern = null;
        private int _w;
        private int _h;

        public LineIcon() {
            this(Color.blue, 50, 15);
        }

        public LineIcon(Color color) {
            this(color, 70, 15);
        }

        public LineIcon(Color color, int w, int h) {
            this._color = color;
            this._w = w;
            this._h = h;
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.black);
            g2d.setColor(this._color);
            if (this._linePattern == null || this._linePattern.length > 1) {
                BasicStroke bs = new BasicStroke(1.0f, 0, 0, 10.0f, this._linePattern, 0.0f);
                g2d.setStroke(bs);
            }
            g2d.drawLine(x, c2.getSize().height / 2, c2.getSize().width, c2.getSize().height / 2);
        }

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color color) {
            this._color = color;
        }

        public void setLinePattern(float[] array) {
            this._linePattern = array;
        }

        @Override
        public int getIconWidth() {
            return this._w;
        }

        @Override
        public int getIconHeight() {
            return this._h;
        }
    }
}

