/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dFont;
import hec.gfx2d.LineLabelProperties;
import hec.gfx2d.LineProperties;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.PlotProperties;
import hec.gfx2d.PropertiesSerializer;
import hec.io.AsciiSerializable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import rma.util.RMAIO;
import rma.util.RMAUtil;
import rma.util.RmaDrawConst;

public class G2dLineProperties
extends PlotProperties
implements AsciiSerializable,
Serializable,
Cloneable,
LineLabelProperties,
LineProperties {
    public static final String USE_DEFAULT_LINE_STYLES = "DefaultLineStyles";
    public static final int FILL_NONE = 0;
    public static final int FILL_ABOVE = 1;
    public static final int FILL_BELOW = 2;
    public static final String[] FILL_STYLE_NAMES = new String[]{"None", "Above", "Below"};
    public static final String[] LINE_STYLE_NAMES = new String[]{"Solid", "Dash", "Dot", "Dash Dot", "Dash Dot-Dot"};
    public static final float[] SOLID_STYLE_PATTERN = RmaDrawConst.SOLID_STYLE_PATTERN;
    public static final float[] DASH_STYLE_PATTERN = RmaDrawConst.DASH_STYLE_PATTERN;
    public static final float[] DOT_STYLE_PATTERN = RmaDrawConst.DOT_STYLE_PATTERN;
    public static final float[] DASHDOT_STYLE_PATTERN = RmaDrawConst.DASHDOT_STYLE_PATTERN;
    public static final float[] DASHDOTDOT_STYLE_PATTERN = RmaDrawConst.DASHDOTDOT_STYLE_PATTERN;
    public static final int END_STYLE_NONE = 0;
    public static final int END_SYTLE_ROUND = 1;
    public static final int END_SYTLE_RECTANGLE = 2;
    public static final int END_STYLE_ARROW = 3;
    public static final int END_STYLE_TEE = 4;
    public static final String[] END_STYLE_NAMES = new String[]{"None", "Round", "Arrow", "Rectangle", "Tee"};
    public static final int NORMAL_LINE = 0;
    public static final int STEP_LINE = 1;
    public static final int CUBIC_LINE = 3;
    public static final int END_OF_PERIOD = 0;
    public static final int BEGINNING_OF_PERIOD = 1;
    public static final int LABEL_ALIGN_LEFT = 0;
    public static final int LABEL_ALIGN_RIGHT = 1;
    public static final int LABEL_ALIGN_CENTER = 2;
    public static final int LABEL_ALIGN_RELATIVE = 3;
    public static String[] LABEL_ALIGN_NAMES = new String[]{"Left", "Right", "Center"};
    public static final int LABEL_POS_ABOVE = 0;
    public static final int LABEL_POS_BELOW = 1;
    public static final int LABEL_POS_CENTER = 2;
    public static String[] LABEL_POS_NAMES = new String[]{"Above", "Below", "Center"};
    private static final Color DEFAULT_LINE_COLOR = Color.blue;
    private static final Color DEFAULT_FILL_COLOR = Color.blue;
    private static final Color DEFAULT_POINT_FILL_COLOR = Color.blue;
    private static final Color DEFAULT_POINT_LINE_COLOR = Color.blue;
    private static final int DEFAULT_POINT_THICKNESS = 1;
    private static final int DEFAULT_SYMBOL = 0;
    private static final float DEFAULT_SYMBOL_SIZE = 7.0f;
    private static final boolean DEFAULT_DRAW_POINTS = false;
    private static final boolean DEFAULT_DRAW_LINE = true;
    private static final int DEFAULT_FILL_TYPE = 0;
    private static final Paint DEFAULT_FILL_PAINT = null;
    private static final int DEFAULT_FILL_PATTERN = 0;
    private static final int DEFAULT_FILL_TRANSPARENCY = 0;
    private static final int DEFAULT_LINE_TRANSPARENCY = 0;
    private static final int DEFAULT_END_SYTLE = 0;
    private static final int DEFAULT_LABEL_ALIGN = 1;
    private static final int DEFAULT_LABEL_POS = 0;
    private static final boolean DEFAULT_USE_LABEL = false;
    private static final float DEFAULT_LINE_WIDTH = 1.75f;
    private static final float[] DEFAULT_LINE_STYLE = SOLID_STYLE_PATTERN;
    private static final boolean DEFAULT_DRAW_ON_POINTS = true;
    private static final int DEFAULT_NUM_POINTS_SKIP = 0;
    private static final int DEFAULT_POINT_OFFSET = 0;
    private static final String DEFAULT_LABEL = "";
    private static final int DEFAULT_STEP_STYLE = 0;
    private static final int DEFAULT_PERIOD_STEP_STYLE = 0;
    private static final String DEFAULT_NAME = "";
    private static final boolean DEFAULT_AUTO_SKIP_POINTS = false;
    private static final Font DEFAULT_LABEL_FONT = G2dFont.newFont("Dialog", 0, 10);
    private static final Color DEFAULT_LABEL_COLOR = Color.black;
    private static final boolean DEFAULT_INTERPOLATE_MISSING = false;
    private static final boolean DEFAULT_ENABLE_QUALITY_DATA = false;
    private static final boolean DEFAULT_DRAW_QUALITY_DATA = false;
    private static final boolean DEFAULT_DRAW_MISSING_DATA = false;
    private static final int DEFAULT_MISSING_SYMBOL = 10;
    private static final float DEFAULT_MISSING_SYMBOL_SIZE = 8.0f;
    private static final Color DEFAULT_MISSING_POINT_FILL_COLOR = Color.red;
    private static final Color DEFAULT_MISSING_POINT_LINE_COLOR = Color.red;
    public boolean _interpolateMissing = false;
    public int _periodStepStyle = 0;
    public int _lineStepStyle = 0;
    public Color _lineColor = DEFAULT_LINE_COLOR;
    public Color _fillColor = DEFAULT_FILL_COLOR;
    public Color _pointFillColor = DEFAULT_POINT_FILL_COLOR;
    public Color _pointLineColor = DEFAULT_POINT_LINE_COLOR;
    public int _pointThickness = 1;
    public Color _selectedPointFillColor = DEFAULT_POINT_FILL_COLOR;
    public Color _selectedPointLineColor = DEFAULT_POINT_LINE_COLOR;
    public int _selectedPointThickness = 1;
    public int _symbolType = 0;
    public float _symbolSize = 7.0f;
    public boolean _drawPoints = false;
    public boolean _drawLine = true;
    public int _fillType = 0;
    public int _fillPattern = 0;
    public int _fillTransparency = 0;
    public int _lineTransparency = 0;
    public Paint _fillPaint = DEFAULT_FILL_PAINT;
    public int _endStyle = 0;
    private int _labelAlign = 1;
    private int _labelPos = 0;
    private boolean _useLabel = false;
    public float _lineWidth = 1.75f;
    public float[] _lineStylePattern = DEFAULT_LINE_STYLE;
    public boolean _drawOnDataPts = true;
    public int _numPtsSkip = 0;
    public int _ptOffset = 0;
    public String _label = "";
    public String _name = "";
    public Font _labelFont = DEFAULT_LABEL_FONT;
    public Color _labelColor = DEFAULT_LABEL_COLOR;
    public boolean _autoSkipPoints = false;
    public boolean _enableQualityDataPts = G2dLineProperties.getDefaultBoolean("Line_enableQualityPoints");
    public boolean _drawQualityData = G2dLineProperties.getDefaultBoolean("Line_drawQualityData");
    public boolean _drawMissingData = G2dLineProperties.getDefaultBoolean("Line_drawMissingData");
    public int _placeholderSymbolType = G2dLineProperties.getDefaultInt("Line_placeholderSymbolType");
    public float _placeholderSymbolSize = G2dLineProperties.getDefaultFloat("Line_placeholderSymbolSize");
    public Color _placeholderPointFillColor = G2dLineProperties.getDefaultColor("Line_placeholderPointFillColor");
    public Color _placeholderPointLineColor = G2dLineProperties.getDefaultColor("Line_placeholderPointLineColor");
    public int _questionableSymbolType = G2dLineProperties.getDefaultInt("Line_questionableSymbolType");
    public float _questionableSymbolSize = G2dLineProperties.getDefaultFloat("Line_questionableSymbolSize");
    public Color _questionablePointFillColor = G2dLineProperties.getDefaultColor("Line_questionablePointFillColor");
    public Color _questionablePointLineColor = G2dLineProperties.getDefaultColor("Line_questionablePointLineColor");
    public int _rejectedSymbolType = G2dLineProperties.getDefaultInt("Line_rejectedSymbolType");
    public float _rejectedSymbolSize = G2dLineProperties.getDefaultFloat("Line_rejectedSymbolSize");
    public Color _rejectedPointFillColor = G2dLineProperties.getDefaultColor("Line_rejectedPointFillColor");
    public Color _rejectedPointLineColor = G2dLineProperties.getDefaultColor("Line_rejectedPointLineColor");
    public int _missingSymbolType = G2dLineProperties.getDefaultInt("Line_missingPointSymbolType");
    public float _missingSymbolSize = G2dLineProperties.getDefaultFloat("Line_missingPointSymbolSize");
    public Color _missingPointFillColor = G2dLineProperties.getDefaultColor("Line_missingPointFillColor");
    public Color _missingPointLineColor = G2dLineProperties.getDefaultColor("Line_missingPointLineColor");
    public int _okSymbolType = G2dLineProperties.getDefaultInt("Line_okSymbolType");
    public float _okSymbolSize = G2dLineProperties.getDefaultFloat("Line_okSymbolSize");
    public Color _okPointFillColor = G2dLineProperties.getDefaultColor("Line_okPointFillColor");
    public Color _okPointLineColor = G2dLineProperties.getDefaultColor("Line_okPointLineColor");
    private boolean _isModified = false;
    private boolean _useDefaultLineStyles = false;
    public static final String LINE_BEGIN = "Line Begin";
    public static final String LINE_END = "Line End";
    private static final String CLS_NAME = "Line_";
    private static final String NAME = "name";
    private static final String LINE_STEP_STYLE = "lineStepStyle";
    private static final String PERIOD_STEP_STYLE = "periodStepStyle";
    private static final String INTERPOLATE_MISSING = "interpolateMissing";
    private static final String LINE_COLOR = "lineColor";
    private static final String FILL_COLOR = "fillColor";
    private static final String POINT_FILL_COLOR = "pointFillColor";
    private static final String POINT_LINE_COLOR = "pointLineColor";
    private static final String POINT_THICKNESS = "pointThickness";
    private static final String SELECTED_POINT_FILL_COLOR = "selectedPointFillColor";
    private static final String SELECTED_POINT_LINE_COLOR = "selectedPointLineColor";
    private static final String SELECTED_POINT_THICKNESS = "selectedPointThickness";
    private static final String SYMBOL_TYPE = "symbolType";
    private static final String SYMBOL_SIZE = "symbolSize";
    private static final String DRAW_POINTS = "drawPoints";
    private static final String DRAW_LINE = "drawLine";
    private static final String FILL_TYPE = "fillType";
    private static final String FILL_PATTERN = "fillPattern";
    private static final String FILL_PAINT = "fillPaint";
    private static final String LINE_SYTLE_PATTERN = "lineStylePattern";
    private static final String LINE_WIDTH = "lineWidth";
    private static final String DRAW_ON_DATA_POINTS = "drawOnDataPts";
    private static final String NUM_POINTS_SKIP = "numPtsSkip";
    private static final String POINTS_OFFSET = "ptsOffset";
    private static final String AUTO_SKIP_POINTS = "autoSkipPoints";
    private static final String ENABLE_QUALITY_POINTS = "enableQualityPoints";
    private static final String DRAW_QUALITY_DATA = "drawQualityData";
    private static final String DRAW_MISSING_DATA = "drawMissingData";
    private static final String MISSING_POINT_SYMBOL_TYPE = "missingPointSymbolType";
    private static final String MISSING_POINT_SYMBOL_SIZE = "missingPointSymbolSize";
    private static final String MISSING_POINT_FILL_COLOR = "missingPointFillColor";
    private static final String MISSING_POINT_LINE_COLOR = "missingPointLineColor";
    private static final String REJECTED_SYMBOL_TYPE = "rejectedSymbolType";
    private static final String REJECTED_SYMBOL_SIZE = "rejectedSymbolSize";
    private static final String REJECTED_POINT_FILL_COLOR = "rejectedPointFillColor";
    private static final String REJECTED_POINT_LINE_COLOR = "rejectedPointLineColor";
    private static final String QUESTIONABLE_SYMBOL_TYPE = "questionableSymbolType";
    private static final String QUESTIONABLE_SYMBOL_SIZE = "questionableSymbolSize";
    private static final String QUESTIONABLE_POINT_FILL_COLOR = "questionablePointFillColor";
    private static final String QUESTIONABLE_POINT_LINE_COLOR = "questionablePointLineColor";
    private static final String PLACEHOLDER_SYMBOL_TYPE = "placeholderSymbolType";
    private static final String PLACEHOLDER_SYMBOL_SIZE = "placeholderSymbolSize";
    private static final String PLACEHOLDER_FILL_COLOR = "placeholderPointFillColor";
    private static final String PLACEHOLDER_LINE_COLOR = "placeholderPointLineColor";
    private static final String OK_SYMBOL_TYPE = "okSymbolType";
    private static final String OK_SYMBOL_SIZE = "okSymbolSize";
    private static final String OK_POINT_FILL_COLOR = "okPointFillColor";
    private static final String OK_POINT_LINE_COLOR = "okPointLineColor";

    public static void init() {
        G2dLineProperties.init(CLS_NAME);
    }

    static void init(String cls) {
        G2dLineProperties.setDefault("Line_enableQualityPoints", false);
        G2dLineProperties.setDefault("Line_drawQualityData", false);
        G2dLineProperties.setDefault("Line_drawMissingData", false);
        G2dLineProperties.setDefault("Line_placeholderSymbolType", 10);
        G2dLineProperties.setDefault("Line_placeholderSymbolSize", 8.0f);
        G2dLineProperties.setDefault("Line_placeholderPointFillColor", DEFAULT_MISSING_POINT_FILL_COLOR);
        G2dLineProperties.setDefault("Line_placeholderPointLineColor", DEFAULT_MISSING_POINT_LINE_COLOR);
        G2dLineProperties.setDefault("Line_questionableSymbolType", 10);
        G2dLineProperties.setDefault("Line_questionableSymbolSize", 8.0f);
        G2dLineProperties.setDefault("Line_questionablePointFillColor", DEFAULT_MISSING_POINT_FILL_COLOR);
        G2dLineProperties.setDefault("Line_questionablePointLineColor", DEFAULT_MISSING_POINT_LINE_COLOR);
        G2dLineProperties.setDefault("Line_rejectedSymbolType", 10);
        G2dLineProperties.setDefault("Line_rejectedSymbolSize", 8.0f);
        G2dLineProperties.setDefault("Line_rejectedPointFillColor", DEFAULT_MISSING_POINT_FILL_COLOR);
        G2dLineProperties.setDefault("Line_rejectedPointLineColor", DEFAULT_MISSING_POINT_LINE_COLOR);
        G2dLineProperties.setDefault("Line_missingPointSymbolType", 10);
        G2dLineProperties.setDefault("Line_missingPointSymbolSize", 8.0f);
        G2dLineProperties.setDefault("Line_missingPointFillColor", DEFAULT_MISSING_POINT_FILL_COLOR);
        G2dLineProperties.setDefault("Line_missingPointLineColor", DEFAULT_MISSING_POINT_LINE_COLOR);
        G2dLineProperties.setDefault("Line_okSymbolType", 10);
        G2dLineProperties.setDefault("Line_okSymbolSize", 8.0f);
        G2dLineProperties.setDefault("Line_okPointFillColor", DEFAULT_MISSING_POINT_FILL_COLOR);
        G2dLineProperties.setDefault("Line_okPointLineColor", DEFAULT_MISSING_POINT_LINE_COLOR);
    }

    public G2dLineProperties() {
    }

    public G2dLineProperties(G2dLineProperties copyFrom) {
        this();
        if (copyFrom == null) {
            return;
        }
        this._lineColor = copyFrom._lineColor;
        this._fillColor = copyFrom._fillColor;
        this._fillType = copyFrom._fillType;
        this._fillPattern = copyFrom._fillPattern;
        this._fillPaint = copyFrom._fillPaint;
        this._fillTransparency = copyFrom._fillTransparency;
        this._lineTransparency = copyFrom._lineTransparency;
        this._endStyle = copyFrom._endStyle;
        this._labelAlign = copyFrom._labelAlign;
        this._labelPos = copyFrom._labelPos;
        this._pointFillColor = copyFrom._pointFillColor;
        this._pointLineColor = copyFrom._pointLineColor;
        this._pointThickness = copyFrom._pointThickness;
        this._selectedPointFillColor = copyFrom._selectedPointFillColor;
        this._selectedPointLineColor = copyFrom._selectedPointLineColor;
        this._selectedPointThickness = copyFrom._selectedPointThickness;
        this._symbolType = copyFrom._symbolType;
        this._drawLine = copyFrom._drawLine;
        this._drawPoints = copyFrom._drawPoints;
        this._lineWidth = copyFrom._lineWidth;
        this._symbolSize = copyFrom._symbolSize;
        this._drawOnDataPts = copyFrom._drawOnDataPts;
        this._numPtsSkip = copyFrom._numPtsSkip;
        this._ptOffset = copyFrom._ptOffset;
        this._autoSkipPoints = copyFrom._autoSkipPoints;
        this._labelAlign = copyFrom._labelAlign;
        this._labelPos = copyFrom._labelPos;
        this._useLabel = copyFrom._useLabel;
        this._label = copyFrom._label;
        this._interpolateMissing = copyFrom._interpolateMissing;
        if (copyFrom._lineStylePattern == null) {
            this._lineStylePattern = null;
        } else {
            this._lineStylePattern = new float[copyFrom._lineStylePattern.length];
            System.arraycopy(copyFrom._lineStylePattern, 0, this._lineStylePattern, 0, copyFrom._lineStylePattern.length);
        }
        this._enableQualityDataPts = copyFrom._enableQualityDataPts;
        this._drawQualityData = copyFrom._drawQualityData;
        this._drawMissingData = copyFrom._drawMissingData;
        this._placeholderSymbolType = copyFrom._placeholderSymbolType;
        this._placeholderSymbolSize = copyFrom._placeholderSymbolSize;
        this._placeholderPointFillColor = copyFrom._placeholderPointFillColor;
        this._placeholderPointLineColor = copyFrom._placeholderPointLineColor;
        this._questionableSymbolType = copyFrom._questionableSymbolType;
        this._questionableSymbolSize = copyFrom._questionableSymbolSize;
        this._questionablePointFillColor = copyFrom._questionablePointFillColor;
        this._questionablePointLineColor = copyFrom._questionablePointLineColor;
        this._rejectedSymbolType = copyFrom._rejectedSymbolType;
        this._rejectedSymbolSize = copyFrom._rejectedSymbolSize;
        this._rejectedPointFillColor = copyFrom._rejectedPointFillColor;
        this._rejectedPointLineColor = copyFrom._rejectedPointLineColor;
        this._missingSymbolType = copyFrom._missingSymbolType;
        this._missingSymbolSize = copyFrom._missingSymbolSize;
        this._missingPointFillColor = copyFrom._missingPointFillColor;
        this._missingPointLineColor = copyFrom._missingPointLineColor;
        this._okSymbolType = copyFrom._okSymbolType;
        this._okSymbolSize = copyFrom._okSymbolSize;
        this._okPointFillColor = copyFrom._okPointFillColor;
        this._okPointLineColor = copyFrom._okPointLineColor;
    }

    public void copyCurveProperties(G2dLineProperties properties) {
        if (properties == null) {
            return;
        }
        this._lineStepStyle = properties._lineStepStyle;
        this._periodStepStyle = properties._periodStepStyle;
        this._lineColor = properties._lineColor;
        this._fillColor = properties._fillColor;
        this._fillType = properties._fillType;
        this._pointFillColor = properties._pointFillColor;
        this._pointLineColor = properties._pointLineColor;
        this._pointThickness = properties._pointThickness;
        this._selectedPointFillColor = properties._selectedPointFillColor;
        this._selectedPointLineColor = properties._selectedPointLineColor;
        this._selectedPointThickness = properties._selectedPointThickness;
        this._symbolType = properties._symbolType;
        this._drawLine = properties._drawLine;
        this._drawPoints = properties._drawPoints;
        this._lineWidth = properties._lineWidth;
        this._symbolSize = properties._symbolSize;
        this._drawOnDataPts = properties._drawOnDataPts;
        this._numPtsSkip = properties._numPtsSkip;
        this._ptOffset = properties._ptOffset;
        this._autoSkipPoints = properties._autoSkipPoints;
        this._fillPattern = properties._fillPattern;
        this._fillPaint = properties._fillPaint;
        this._fillTransparency = properties._fillTransparency;
        this._lineTransparency = properties._lineTransparency;
        this._lineStylePattern = properties._lineStylePattern;
        this._interpolateMissing = properties._interpolateMissing;
        if (properties._lineStylePattern == null) {
            this._lineStylePattern = null;
        } else {
            float[] tempLineStylePattern = properties._lineStylePattern;
            this._lineStylePattern = new float[properties._lineStylePattern.length];
            System.arraycopy(tempLineStylePattern, 0, this._lineStylePattern, 0, tempLineStylePattern.length);
        }
        this._enableQualityDataPts = properties._enableQualityDataPts;
        this._drawMissingData = properties._drawMissingData;
        this._placeholderSymbolType = properties._placeholderSymbolType;
        this._placeholderSymbolSize = properties._placeholderSymbolSize;
        this._placeholderPointFillColor = properties._placeholderPointFillColor;
        this._placeholderPointLineColor = properties._placeholderPointLineColor;
        this._questionableSymbolType = properties._questionableSymbolType;
        this._questionableSymbolSize = properties._questionableSymbolSize;
        this._questionablePointFillColor = properties._questionablePointFillColor;
        this._questionablePointLineColor = properties._questionablePointLineColor;
        this._rejectedSymbolType = properties._rejectedSymbolType;
        this._rejectedSymbolSize = properties._rejectedSymbolSize;
        this._rejectedPointFillColor = properties._rejectedPointFillColor;
        this._rejectedPointLineColor = properties._rejectedPointLineColor;
        this._missingSymbolType = properties._missingSymbolType;
        this._missingSymbolSize = properties._missingSymbolSize;
        this._missingPointFillColor = properties._missingPointFillColor;
        this._missingPointLineColor = properties._missingPointLineColor;
        this._okSymbolType = properties._okSymbolType;
        this._okSymbolSize = properties._okSymbolSize;
        this._okPointFillColor = properties._okPointFillColor;
        this._okPointLineColor = properties._okPointLineColor;
    }

    @Override
    public void setModified(boolean modified) {
        this._isModified = modified;
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void setUseDefaultLineStyles(boolean defaultLineStyles) {
        this._useDefaultLineStyles = defaultLineStyles;
    }

    public boolean useDefaultLineStyles() {
        return this._useDefaultLineStyles;
    }

    public G2dLineProperties clone() {
        G2dLineProperties lp;
        try {
            lp = (G2dLineProperties)super.clone();
        }
        catch (CloneNotSupportedException cne) {
            return new G2dLineProperties(this);
        }
        if (this._lineStylePattern == null) {
            lp._lineStylePattern = null;
        } else {
            lp._lineStylePattern = new float[this._lineStylePattern.length];
            System.arraycopy(this._lineStylePattern, 0, lp._lineStylePattern, 0, this._lineStylePattern.length);
        }
        lp._lineStepStyle = this._lineStepStyle;
        lp._periodStepStyle = this._periodStepStyle;
        lp._lineColor = this._lineColor;
        lp._fillColor = this._fillColor;
        lp._fillType = this._fillType;
        lp._fillPattern = this._fillPattern;
        lp._fillPaint = this._fillPaint;
        lp._fillTransparency = this._fillTransparency;
        lp._lineTransparency = this._lineTransparency;
        lp._endStyle = this._endStyle;
        lp._labelAlign = this._labelAlign;
        lp._labelPos = this._labelPos;
        lp._pointFillColor = this._pointFillColor;
        lp._pointLineColor = this._pointLineColor;
        lp._pointThickness = this._pointThickness;
        lp._selectedPointFillColor = this._selectedPointFillColor;
        lp._selectedPointLineColor = this._selectedPointLineColor;
        lp._selectedPointThickness = this._selectedPointThickness;
        lp._symbolType = this._symbolType;
        lp._drawLine = this._drawLine;
        lp._drawPoints = this._drawPoints;
        lp._lineWidth = this._lineWidth;
        lp._interpolateMissing = this._interpolateMissing;
        lp._symbolSize = this._symbolSize;
        lp._drawOnDataPts = this._drawOnDataPts;
        lp._numPtsSkip = this._numPtsSkip;
        lp._ptOffset = this._ptOffset;
        lp._autoSkipPoints = this._autoSkipPoints;
        lp._labelAlign = this._labelAlign;
        lp._labelPos = this._labelPos;
        lp._useLabel = this._useLabel;
        lp._label = this._label;
        lp._labelFont = this._labelFont;
        lp._labelColor = this._labelColor;
        lp._enableQualityDataPts = this._enableQualityDataPts;
        lp._drawMissingData = this._drawMissingData;
        lp._placeholderSymbolType = this._placeholderSymbolType;
        lp._placeholderSymbolSize = this._placeholderSymbolSize;
        lp._placeholderPointFillColor = this._placeholderPointFillColor;
        lp._placeholderPointLineColor = this._placeholderPointLineColor;
        lp._drawQualityData = this._drawQualityData;
        lp._questionableSymbolType = this._questionableSymbolType;
        lp._questionableSymbolSize = this._questionableSymbolSize;
        lp._questionablePointFillColor = this._questionablePointFillColor;
        lp._questionablePointLineColor = this._questionablePointLineColor;
        lp._rejectedSymbolType = this._rejectedSymbolType;
        lp._rejectedSymbolSize = this._rejectedSymbolSize;
        lp._rejectedPointFillColor = this._rejectedPointFillColor;
        lp._rejectedPointLineColor = this._rejectedPointLineColor;
        lp._missingSymbolType = this._missingSymbolType;
        lp._missingSymbolSize = this._missingSymbolSize;
        lp._missingPointFillColor = this._missingPointFillColor;
        lp._missingPointLineColor = this._missingPointLineColor;
        lp._okSymbolType = this._okSymbolType;
        lp._okSymbolSize = this._okSymbolSize;
        lp._okPointFillColor = this._okPointFillColor;
        lp._okPointLineColor = this._okPointLineColor;
        return lp;
    }

    @Override
    public boolean drawPoints() {
        return this._drawPoints;
    }

    @Override
    public boolean drawLine() {
        return this._drawLine;
    }

    @Override
    public boolean hasLabel() {
        return this._useLabel;
    }

    public void setDrawLine(boolean d) {
        this._drawLine = d;
    }

    public void setDrawPoints(boolean d) {
        this._drawPoints = d;
    }

    @Override
    public void setHasLabel(boolean d) {
        this._useLabel = d;
    }

    public void setFillType(int f) {
        this._fillType = f;
    }

    public void setFillColor(Color c2) {
        this._fillColor = c2;
    }

    public boolean getInterpolateMissing() {
        return this._interpolateMissing;
    }

    @Override
    public float getLineWidth() {
        return this._lineWidth;
    }

    @Override
    public float[] getLinePattern() {
        return this._lineStylePattern;
    }

    @Override
    public Color getLineColor() {
        return this._lineColor;
    }

    public int getLineStepStyle() {
        return this._lineStepStyle;
    }

    public int getPeriodStepStyle() {
        return this._periodStepStyle;
    }

    @Override
    public Color getFillColor() {
        return this._fillColor;
    }

    @Override
    public Color getPointFillColor() {
        return this._pointFillColor;
    }

    @Override
    public Color getPointLineColor() {
        return this._pointLineColor;
    }

    public int getSymbolThickness() {
        return this._pointThickness;
    }

    public Color getSelectedPointFillColor() {
        return this._selectedPointFillColor;
    }

    public Color getSelectedPointLineColor() {
        return this._selectedPointLineColor;
    }

    public int getSelectedSymbolThickness() {
        return this._selectedPointThickness;
    }

    @Override
    public int getSymbolType() {
        return this._symbolType;
    }

    @Override
    public float getSymbolSize() {
        return this._symbolSize;
    }

    @Override
    public int getFillType() {
        return this._fillType;
    }

    public int getSkipPoints() {
        return this._numPtsSkip;
    }

    public int getOffsetPoint() {
        return this._ptOffset;
    }

    public boolean getDrawOnPoints() {
        return this._drawOnDataPts;
    }

    @Override
    public int getLabelAlignment() {
        return this._labelAlign;
    }

    @Override
    public int getLabelPosition() {
        return this._labelPos;
    }

    public Paint getFillPaint() {
        return this._fillPaint;
    }

    @Override
    public int getFillPattern() {
        return this._fillPattern;
    }

    public int getFillTransparency() {
        return this._fillTransparency;
    }

    public int getLineTransparency() {
        return this._lineTransparency;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    public Font getLabelFont() {
        return this._labelFont;
    }

    public Color getLabelColor() {
        return this._labelColor;
    }

    public String getName() {
        return this._name;
    }

    public boolean getAutoSkipPoints() {
        return this._autoSkipPoints;
    }

    public void setInterpolateMissing(boolean b) {
        this._interpolateMissing = b;
    }

    public void setLineWidth(float f) {
        this._lineWidth = f;
    }

    public void setLinePattern(float[] f) {
        this._lineStylePattern = f;
    }

    public void setLineColor(Color c2) {
        this._lineColor = c2;
    }

    public void setPointLineColor(Color c2) {
        this._pointLineColor = c2;
    }

    public void setLineStepStyle(int s) {
        this._lineStepStyle = s;
    }

    public void setPeriodStepStyle(int s) {
        this._periodStepStyle = s;
    }

    public void setSymbolType(int t) {
        this._symbolType = t;
    }

    public void setSymbolSize(float f) {
        this._symbolSize = f;
    }

    public void setSymbolFillColor(Color c2) {
        this._pointFillColor = c2;
    }

    public void setSymbolLineColor(Color c2) {
        this._pointLineColor = c2;
    }

    public void setSymbolThickness(int i) {
        this._pointThickness = i;
    }

    public void setSelectedSymbolFillColor(Color c2) {
        this._selectedPointFillColor = c2;
    }

    public void setSelectedSymbolLineColor(Color c2) {
        this._selectedPointLineColor = c2;
    }

    public void setSelectedSymbolThickness(int i) {
        this._selectedPointThickness = i;
    }

    public void setSkipPoints(int i) {
        this._numPtsSkip = i;
    }

    public void setOffsetPoint(int i) {
        this._ptOffset = i;
    }

    public void setDrawOnPoints(boolean b) {
        this._drawOnDataPts = b;
    }

    @Override
    public void setLabelAlignment(int i) {
        this._labelAlign = i;
    }

    @Override
    public void setLabelPosition(int i) {
        this._labelPos = i;
    }

    public void setFillPaint(Paint p) {
        this._fillPaint = p;
    }

    public void setFillPattern(int i) {
        this._fillPattern = i;
    }

    public void setFillTransparency(int i) {
        this._fillTransparency = i;
    }

    public void setLineTransparency(int i) {
        this._lineTransparency = i;
    }

    @Override
    public void setLabel(String lbl) {
        this._label = lbl;
    }

    public void setLabelFont(Font f) {
        this._labelFont = f;
    }

    public void setLabelColor(Color c2) {
        this._labelColor = c2;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setAutoSkipPoints(boolean as) {
        this._autoSkipPoints = as;
    }

    public static String lookupStyleName(float[] lnStyle) {
        if (Arrays.equals(lnStyle, SOLID_STYLE_PATTERN)) {
            return LINE_STYLE_NAMES[0];
        }
        if (Arrays.equals(lnStyle, DASH_STYLE_PATTERN)) {
            return LINE_STYLE_NAMES[1];
        }
        if (Arrays.equals(lnStyle, DOT_STYLE_PATTERN)) {
            return LINE_STYLE_NAMES[2];
        }
        if (Arrays.equals(lnStyle, DASHDOT_STYLE_PATTERN)) {
            return LINE_STYLE_NAMES[3];
        }
        if (Arrays.equals(lnStyle, DASHDOTDOT_STYLE_PATTERN)) {
            return LINE_STYLE_NAMES[4];
        }
        return null;
    }

    public static float[] lookupStyle(String name) {
        if (name.equalsIgnoreCase(LINE_STYLE_NAMES[0])) {
            return SOLID_STYLE_PATTERN;
        }
        if (name.equalsIgnoreCase(LINE_STYLE_NAMES[1])) {
            return DASH_STYLE_PATTERN;
        }
        if (name.equalsIgnoreCase(LINE_STYLE_NAMES[2])) {
            return DOT_STYLE_PATTERN;
        }
        if (name.equalsIgnoreCase(LINE_STYLE_NAMES[3])) {
            return DASHDOT_STYLE_PATTERN;
        }
        if (name.equalsIgnoreCase(LINE_STYLE_NAMES[4])) {
            return DASHDOTDOT_STYLE_PATTERN;
        }
        return null;
    }

    public static String lookupFillName(int fill) {
        switch (fill) {
            case 0: {
                return FILL_STYLE_NAMES[0];
            }
            case 1: {
                return FILL_STYLE_NAMES[1];
            }
            case 2: {
                return FILL_STYLE_NAMES[2];
            }
        }
        return null;
    }

    public static int lookupFill(String name) {
        if (name.equalsIgnoreCase(FILL_STYLE_NAMES[0])) {
            return 0;
        }
        if (name.equalsIgnoreCase(FILL_STYLE_NAMES[1])) {
            return 1;
        }
        if (name.equalsIgnoreCase(FILL_STYLE_NAMES[2])) {
            return 2;
        }
        return 0;
    }

    private boolean isDefaultValues() {
        return true;
    }

    @Override
    public void writeProperties(BufferedWriter writer, String endTag) {
        if (writer == null) {
            return;
        }
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        if (!this.isModified()) {
            RMAIO.fout(writer, indent + "DefaultLineStyles=true");
        }
        if (!"".equals(this._name)) {
            RMAIO.fout(writer, indent + "name=" + this._name);
        }
        if (this._lineStepStyle != 0) {
            RMAIO.fout(writer, indent + "lineStepStyle=" + this._lineStepStyle);
        }
        if (this._periodStepStyle != 0) {
            RMAIO.fout(writer, indent + "periodStepStyle=" + this._periodStepStyle);
        }
        if (this._interpolateMissing) {
            RMAIO.fout(writer, indent + "interpolateMissing=" + this._interpolateMissing);
        }
        if (!DEFAULT_LINE_COLOR.equals(this._lineColor)) {
            RMAIO.fout(writer, indent + "lineColor=" + RMAIO.color2String(this._lineColor));
        }
        if (!DEFAULT_FILL_COLOR.equals(this._fillColor)) {
            RMAIO.fout(writer, indent + "fillColor=" + RMAIO.color2String(this._fillColor));
        }
        if (!DEFAULT_POINT_FILL_COLOR.equals(this._pointFillColor)) {
            RMAIO.fout(writer, indent + "pointFillColor=" + RMAIO.color2String(this._pointFillColor));
        }
        if (!DEFAULT_POINT_LINE_COLOR.equals(this._pointLineColor)) {
            RMAIO.fout(writer, indent + "pointLineColor=" + RMAIO.color2String(this._pointLineColor));
        }
        if (1 != this._pointThickness) {
            RMAIO.fout(writer, indent + "pointThickness=" + this._pointThickness);
        }
        if (!DEFAULT_POINT_FILL_COLOR.equals(this._selectedPointFillColor)) {
            RMAIO.fout(writer, indent + "pointFillColor=" + RMAIO.color2String(this._selectedPointFillColor));
        }
        if (!DEFAULT_POINT_LINE_COLOR.equals(this._selectedPointLineColor)) {
            RMAIO.fout(writer, indent + "pointLineColor=" + RMAIO.color2String(this._selectedPointLineColor));
        }
        if (1 != this._selectedPointThickness) {
            RMAIO.fout(writer, indent + "pointThickness=" + this._selectedPointThickness);
        }
        if (this._symbolType != 0) {
            RMAIO.fout(writer, indent + "symbolType=" + this._symbolType);
        }
        if (this._symbolSize != 7.0f) {
            RMAIO.fout(writer, indent + "symbolSize=" + this._symbolSize);
        }
        if (this._drawPoints) {
            RMAIO.fout(writer, indent + "drawPoints=" + this._drawPoints);
        }
        if (!this._drawLine) {
            RMAIO.fout(writer, indent + "drawLine=" + this._drawLine);
        }
        if (this._fillType != 0) {
            RMAIO.fout(writer, indent + "fillType=" + G2dLineProperties.lookupFillName(this._fillType));
        }
        if (this._fillPattern != 0) {
            RMAIO.fout(writer, indent + "fillPattern=" + RmaDrawConst.lookupFillPatternName(this._fillPattern));
        }
        if (this._fillTransparency != 0) {
            RMAIO.fout(writer, indent + "fillTransparency=" + this._fillTransparency);
        }
        if (this._lineTransparency != 0) {
            RMAIO.fout(writer, indent + "lineTransparency=" + this._lineTransparency);
        }
        if (this._lineWidth != 1.75f) {
            RMAIO.fout(writer, indent + "lineWidth=" + this._lineWidth);
        }
        if (!Arrays.equals(this._lineStylePattern, DEFAULT_LINE_STYLE)) {
            RMAIO.fout(writer, indent + "lineStylePattern=" + G2dLineProperties.lookupStyleName(this._lineStylePattern));
        }
        if (!this._drawOnDataPts) {
            RMAIO.fout(writer, indent + "drawOnDataPts=" + this._drawOnDataPts);
        }
        if (this._numPtsSkip != 0) {
            RMAIO.fout(writer, indent + "numPtsSkip=" + this._numPtsSkip);
        }
        if (this._ptOffset != 0) {
            RMAIO.fout(writer, indent + "ptsOffset=" + this._ptOffset);
        }
        if (this._autoSkipPoints) {
            RMAIO.fout(writer, indent + "autoSkipPoints=" + this._autoSkipPoints);
        }
        if (this._enableQualityDataPts) {
            RMAIO.fout(writer, indent + "enableQualityPoints=" + this._enableQualityDataPts);
        }
        if (this._drawQualityData) {
            RMAIO.fout(writer, indent + "drawQualityData=" + this._drawQualityData);
        }
        if (this._drawMissingData) {
            RMAIO.fout(writer, indent + "drawMissingData=" + this._drawMissingData);
        }
        if (this._missingSymbolType != 10) {
            RMAIO.fout(writer, indent + "missingPointSymbolType=" + this._missingSymbolType);
        }
        if (this._missingSymbolSize != 8.0f) {
            RMAIO.fout(writer, indent + "missingPointSymbolSize=" + this._missingSymbolSize);
        }
        if (this._missingPointFillColor != DEFAULT_MISSING_POINT_FILL_COLOR) {
            RMAIO.fout(writer, indent + "missingPointFillColor=" + RMAIO.color2String(this._missingPointFillColor));
        }
        if (this._missingPointLineColor != DEFAULT_MISSING_POINT_LINE_COLOR) {
            RMAIO.fout(writer, indent + "missingPointLineColor=" + RMAIO.color2String(this._missingPointLineColor));
        }
        if (this._rejectedSymbolType != 10) {
            RMAIO.fout(writer, indent + "rejectedSymbolType=" + this._rejectedSymbolType);
        }
        if (this._rejectedSymbolSize != 8.0f) {
            RMAIO.fout(writer, indent + "rejectedSymbolSize=" + this._rejectedSymbolSize);
        }
        if (this._rejectedPointFillColor != DEFAULT_MISSING_POINT_FILL_COLOR) {
            RMAIO.fout(writer, indent + "rejectedPointFillColor=" + RMAIO.color2String(this._rejectedPointFillColor));
        }
        if (this._rejectedPointLineColor != DEFAULT_MISSING_POINT_LINE_COLOR) {
            RMAIO.fout(writer, indent + "rejectedPointLineColor=" + RMAIO.color2String(this._rejectedPointLineColor));
        }
        if (this._questionableSymbolType != 10) {
            RMAIO.fout(writer, indent + "questionableSymbolType=" + this._questionableSymbolType);
        }
        if (this._questionableSymbolSize != 8.0f) {
            RMAIO.fout(writer, indent + "questionableSymbolSize=" + this._questionableSymbolSize);
        }
        if (this._questionablePointFillColor != DEFAULT_MISSING_POINT_FILL_COLOR) {
            RMAIO.fout(writer, indent + "questionablePointFillColor=" + RMAIO.color2String(this._questionablePointFillColor));
        }
        if (this._questionablePointLineColor != DEFAULT_MISSING_POINT_LINE_COLOR) {
            RMAIO.fout(writer, indent + "questionablePointLineColor=" + RMAIO.color2String(this._questionablePointLineColor));
        }
        if (this._placeholderSymbolType != 10) {
            RMAIO.fout(writer, indent + "placeholderSymbolType=" + this._placeholderSymbolType);
        }
        if (this._placeholderSymbolSize != 8.0f) {
            RMAIO.fout(writer, indent + "placeholderSymbolSize=" + this._placeholderSymbolSize);
        }
        if (this._placeholderPointFillColor != DEFAULT_MISSING_POINT_FILL_COLOR) {
            RMAIO.fout(writer, indent + "placeholderPointFillColor=" + RMAIO.color2String(this._placeholderPointFillColor));
        }
        if (this._placeholderPointLineColor != DEFAULT_MISSING_POINT_LINE_COLOR) {
            RMAIO.fout(writer, indent + "placeholderPointLineColor=" + RMAIO.color2String(this._placeholderPointLineColor));
        }
        if (this._okSymbolType != 10) {
            RMAIO.fout(writer, indent + "okSymbolType=" + this._okSymbolType);
        }
        if (this._okSymbolSize != 8.0f) {
            RMAIO.fout(writer, indent + "okSymbolSize=" + this._okSymbolSize);
        }
        if (this._okPointFillColor != DEFAULT_MISSING_POINT_FILL_COLOR) {
            RMAIO.fout(writer, indent + "okPointFillColor=" + RMAIO.color2String(this._okPointFillColor));
        }
        if (this._okPointLineColor != DEFAULT_MISSING_POINT_LINE_COLOR) {
            RMAIO.fout(writer, indent + "okPointLineColor=" + RMAIO.color2String(this._okPointLineColor));
        }
        if (this._useLabel) {
            RMAIO.fout(writer, indent + "useLabel=" + this._useLabel);
        }
        if (this._label != "") {
            RMAIO.fout(writer, indent + "label=" + this._label);
        }
        if (this._labelAlign != 1) {
            RMAIO.fout(writer, indent + "labelAlign=" + LABEL_ALIGN_NAMES[this._labelAlign]);
        }
        if (this._labelPos != 0) {
            RMAIO.fout(writer, indent + "labelPosition=" + LABEL_POS_NAMES[this._labelPos]);
        }
        if (this._labelFont != DEFAULT_LABEL_FONT) {
            RMAIO.fout(writer, indent + "labelFont=" + RMAUtil.getFontString(this._labelFont));
        }
        if (this._labelColor != DEFAULT_LABEL_COLOR) {
            RMAIO.fout(writer, indent + "labelColor=" + RMAIO.color2String(this._labelColor));
        }
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        if (endTag != null) {
            RMAIO.fout(writer, indent + endTag);
        }
    }

    public void readProperties(BufferedReader in, String endTag) {
        if (in == null) {
            return;
        }
        String line = "";
        String param = "";
        String type = "";
        try {
            boolean useDefaultLineStyles = false;
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    int constVal;
                    if (type.equals(USE_DEFAULT_LINE_STYLES)) {
                        useDefaultLineStyles = "true".equals(param);
                        this.setUseDefaultLineStyles(useDefaultLineStyles);
                        this.setModified(!useDefaultLineStyles);
                    }
                    if (type.equalsIgnoreCase(LINE_STEP_STYLE)) {
                        this._lineStepStyle = Integer.valueOf(param);
                        if (this._lineStepStyle < 0 || this._lineStepStyle > 1) {
                            this._lineStepStyle = 0;
                        }
                    }
                    if (type.equalsIgnoreCase("periodStepStype")) {
                        this._periodStepStyle = Integer.valueOf(param);
                        if (this._periodStepStyle != 1 && this._periodStepStyle != 0) {
                            this._periodStepStyle = 0;
                        }
                    }
                    if (type.equalsIgnoreCase(LINE_COLOR)) {
                        this._lineColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(INTERPOLATE_MISSING)) {
                        this._interpolateMissing = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_COLOR)) {
                        this._fillColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(POINT_FILL_COLOR)) {
                        this._pointFillColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(POINT_LINE_COLOR)) {
                        this._pointLineColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("symbolThickness")) {
                        this._pointThickness = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(SELECTED_POINT_FILL_COLOR)) {
                        this._selectedPointFillColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(SELECTED_POINT_LINE_COLOR)) {
                        this._selectedPointLineColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("selectedSymbolThickness")) {
                        this._selectedPointThickness = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(SYMBOL_TYPE)) {
                        this._symbolType = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(SYMBOL_SIZE)) {
                        this._symbolSize = Float.valueOf(param).floatValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_POINTS)) {
                        this._drawPoints = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_LINE)) {
                        this._drawLine = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_TYPE)) {
                        this._fillType = G2dLineProperties.lookupFill(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_PATTERN)) {
                        this._fillPattern = RmaDrawConst.lookupFillPattern(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("fillTransparency")) {
                        this._fillTransparency = RMAIO.parseInt(param, 0);
                        continue;
                    }
                    if (type.equalsIgnoreCase("lineTransparency")) {
                        this._lineTransparency = RMAIO.parseInt(param, 0);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LINE_WIDTH)) {
                        this._lineWidth = Float.valueOf(param).floatValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(LINE_SYTLE_PATTERN)) {
                        this._lineStylePattern = G2dLineProperties.lookupStyle(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_ON_DATA_POINTS)) {
                        this._drawOnDataPts = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(NUM_POINTS_SKIP)) {
                        this._numPtsSkip = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(POINTS_OFFSET)) {
                        this._ptOffset = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(NAME)) {
                        this._name = param;
                        continue;
                    }
                    if (type.equalsIgnoreCase(AUTO_SKIP_POINTS)) {
                        this._autoSkipPoints = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(ENABLE_QUALITY_POINTS)) {
                        this._enableQualityDataPts = "true".equals(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_QUALITY_DATA)) {
                        this._drawQualityData = "true".equals(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_MISSING_DATA)) {
                        this._drawMissingData = "true".equals(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MISSING_POINT_SYMBOL_TYPE)) {
                        this._missingSymbolType = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MISSING_POINT_SYMBOL_SIZE)) {
                        this._missingSymbolSize = Integer.valueOf(param).intValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(MISSING_POINT_FILL_COLOR)) {
                        this._missingPointFillColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MISSING_POINT_LINE_COLOR)) {
                        this._missingPointLineColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(QUESTIONABLE_SYMBOL_TYPE)) {
                        this._questionableSymbolType = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(QUESTIONABLE_SYMBOL_SIZE)) {
                        this._questionableSymbolSize = Integer.valueOf(param).intValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(QUESTIONABLE_POINT_FILL_COLOR)) {
                        this._questionablePointFillColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(QUESTIONABLE_POINT_LINE_COLOR)) {
                        this._questionablePointLineColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(REJECTED_SYMBOL_TYPE)) {
                        this._rejectedSymbolType = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(REJECTED_SYMBOL_SIZE)) {
                        this._rejectedSymbolSize = Integer.valueOf(param).intValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(REJECTED_POINT_FILL_COLOR)) {
                        this._rejectedPointFillColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(REJECTED_POINT_LINE_COLOR)) {
                        this._rejectedPointLineColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(PLACEHOLDER_SYMBOL_TYPE)) {
                        this._placeholderSymbolType = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(PLACEHOLDER_SYMBOL_SIZE)) {
                        this._placeholderSymbolSize = Integer.valueOf(param).intValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(PLACEHOLDER_FILL_COLOR)) {
                        this._placeholderPointFillColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(PLACEHOLDER_LINE_COLOR)) {
                        this._placeholderPointLineColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(OK_SYMBOL_TYPE)) {
                        this._okSymbolType = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(OK_SYMBOL_SIZE)) {
                        this._okSymbolSize = Integer.valueOf(param).intValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(OK_POINT_FILL_COLOR)) {
                        this._okPointFillColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(OK_POINT_LINE_COLOR)) {
                        this._okPointLineColor = RMAIO.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("useLabel")) {
                        this._useLabel = Boolean.parseBoolean(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase("label")) {
                        this._label = param;
                        continue;
                    }
                    if (type.equalsIgnoreCase("labelAlign")) {
                        constVal = this.getLabelAlginConst(param);
                        this._labelAlign = constVal != -1 ? constVal : 1;
                        continue;
                    }
                    if (type.equalsIgnoreCase("labelPosition")) {
                        constVal = this.getLabelPositionConst(param);
                        this._labelPos = constVal != -1 ? constVal : 0;
                        continue;
                    }
                    if (type.equalsIgnoreCase("labelFont")) {
                        this._labelFont = Font.decode(param);
                        continue;
                    }
                    if (!type.equalsIgnoreCase("labelColor")) continue;
                    this._labelColor = RMAIO.parseColorString(param);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readProperties(BufferedReader)");
            return;
        }
    }

    private int getLabelAlginConst(String param) {
        for (int i = 0; i < LABEL_ALIGN_NAMES.length; ++i) {
            if (!LABEL_ALIGN_NAMES[i].equalsIgnoreCase(param)) continue;
            return i;
        }
        return -1;
    }

    private int getLabelPositionConst(String param) {
        for (int i = 0; i < LABEL_POS_NAMES.length; ++i) {
            if (!LABEL_POS_NAMES[i].equalsIgnoreCase(param)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof G2dLineProperties)) {
            return false;
        }
        G2dLineProperties gobj = (G2dLineProperties)obj;
        float[] gLinePattern = gobj._lineStylePattern;
        boolean b = false;
        if (this._lineStylePattern == null && gLinePattern == null) {
            b = true;
        } else if (this._lineStylePattern == null || gLinePattern == null) {
            b = false;
        } else if (this._lineStylePattern.length != gLinePattern.length) {
            b = false;
        } else {
            boolean allElementsEquals = true;
            for (int j = 0; j < this._lineStylePattern.length; ++j) {
                if (this._lineStylePattern[j] != gLinePattern[j]) {
                    allElementsEquals = false;
                    break;
                }
                b = allElementsEquals;
            }
        }
        return b && this._interpolateMissing == gobj._interpolateMissing && this._lineStepStyle == gobj._lineStepStyle && this._periodStepStyle == gobj._periodStepStyle && this._lineColor.equals(gobj._lineColor) && this._fillColor.equals(gobj._fillColor) && this._pointFillColor.equals(gobj._pointFillColor) && this._pointLineColor.equals(gobj._pointLineColor) && this._pointThickness == gobj._pointThickness && this._selectedPointFillColor.equals(gobj._selectedPointFillColor) && this._selectedPointLineColor.equals(gobj._selectedPointLineColor) && this._selectedPointThickness == gobj._selectedPointThickness && this._symbolType == gobj._symbolType && this._symbolSize == gobj._symbolSize && this._drawPoints == gobj._drawPoints && this._drawLine == gobj._drawLine && this._fillType == gobj._fillType && this._fillPattern == gobj._fillPattern && Objects.equals(this._fillPaint, gobj._fillPaint) && this._fillTransparency == gobj._fillTransparency && this._lineTransparency == gobj._lineTransparency && this._endStyle == gobj._endStyle && this._labelAlign == gobj._labelAlign && this._labelPos == gobj._labelPos && this._useLabel == gobj._useLabel && this._lineWidth == gobj._lineWidth && this._drawOnDataPts == gobj._drawOnDataPts && this._numPtsSkip == gobj._numPtsSkip && this._ptOffset == gobj._ptOffset && this._label == gobj._label && this._name.equals(gobj._name) && this._labelFont.equals(gobj._labelFont) && this._labelColor.equals(gobj._labelColor) && this._autoSkipPoints == gobj._autoSkipPoints && this._enableQualityDataPts == gobj._enableQualityDataPts && this._drawQualityData == gobj._drawQualityData && this._drawMissingData == gobj._drawMissingData && this._placeholderSymbolType == gobj._placeholderSymbolType && this._placeholderSymbolSize == gobj._placeholderSymbolSize && this._placeholderPointFillColor.equals(gobj._placeholderPointFillColor) && this._placeholderPointLineColor.equals(gobj._placeholderPointLineColor) && this._questionableSymbolType == gobj._questionableSymbolType && this._questionableSymbolSize == gobj._questionableSymbolSize && this._questionablePointFillColor.equals(gobj._questionablePointFillColor) && this._questionablePointLineColor.equals(gobj._questionablePointLineColor) && this._rejectedSymbolType == gobj._rejectedSymbolType && this._rejectedSymbolSize == gobj._rejectedSymbolSize && this._rejectedPointFillColor.equals(gobj._rejectedPointFillColor) && this._rejectedPointLineColor.equals(gobj._rejectedPointLineColor) && this._missingSymbolType == gobj._missingSymbolType && this._missingSymbolSize == gobj._missingSymbolSize && this._missingPointFillColor.equals(gobj._missingPointFillColor) && this._missingPointLineColor.equals(gobj._missingPointLineColor) && this._okSymbolType == gobj._okSymbolType && this._okSymbolSize == gobj._okSymbolSize && this._okPointFillColor.equals(gobj._okPointFillColor) && this._okPointLineColor.equals(gobj._okPointLineColor);
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void setDefaults(G2dLineProperties defaultProps) {
        if (defaultProps == null) {
            return;
        }
        G2dLineProperties.setDefault("Line_name", defaultProps._name);
        G2dLineProperties.setDefault("Line_lineStepStyle", defaultProps._lineStepStyle);
        G2dLineProperties.setDefault("Line_periodStepStyle", defaultProps._periodStepStyle);
        G2dLineProperties.setDefault("Line_interpolateMissing", defaultProps._interpolateMissing);
        G2dLineProperties.setDefault("Line_lineColor", defaultProps._lineColor);
        G2dLineProperties.setDefault("Line_fillColor", defaultProps._fillColor);
        G2dLineProperties.setDefault("Line_pointFillColor", defaultProps._pointFillColor);
        G2dLineProperties.setDefault("Line_pointLineColor", defaultProps._pointLineColor);
        G2dLineProperties.setDefault("Line_pointThickness", defaultProps._pointThickness);
        G2dLineProperties.setDefault("Line_selectedPointFillColor", defaultProps._selectedPointFillColor);
        G2dLineProperties.setDefault("Line_selectedPointLineColor", defaultProps._selectedPointLineColor);
        G2dLineProperties.setDefault("Line_selectedPointThickness", defaultProps._selectedPointThickness);
        G2dLineProperties.setDefault("Line_symbolType", defaultProps._symbolType);
        G2dLineProperties.setDefault("Line_symbolSize", defaultProps._symbolSize);
        G2dLineProperties.setDefault("Line_drawPoints", defaultProps._drawPoints);
        G2dLineProperties.setDefault("Line_drawLine", defaultProps._drawLine);
        G2dLineProperties.setDefault("Line_fillType", defaultProps._fillType);
        G2dLineProperties.setDefault("Line_fillPattern", defaultProps._fillPattern);
        G2dLineProperties.setDefault("Line_fillPaint", defaultProps._fillPaint);
        G2dLineProperties.setDefault("Line_lineStylePattern", defaultProps._lineStylePattern);
        G2dLineProperties.setDefault("Line_lineWidth", defaultProps._lineWidth);
        G2dLineProperties.setDefault("Line_drawOnDataPts", defaultProps._drawOnDataPts);
        G2dLineProperties.setDefault("Line_numPtsSkip", defaultProps._numPtsSkip);
        G2dLineProperties.setDefault("Line_ptsOffset", defaultProps._ptOffset);
        G2dLineProperties.setDefault("Line_autoSkipPoints", defaultProps._autoSkipPoints);
        G2dLineProperties.setDefault("Line_enableQualityPoints", defaultProps._enableQualityDataPts);
        G2dLineProperties.setDefault("Line_drawQualityData", defaultProps._drawQualityData);
        G2dLineProperties.setDefault("Line_drawMissingData", defaultProps._drawMissingData);
        G2dLineProperties.setDefault("Line_missingPointSymbolType", defaultProps._missingSymbolType);
        G2dLineProperties.setDefault("Line_missingPointSymbolSize", defaultProps._missingSymbolSize);
        G2dLineProperties.setDefault("Line_missingPointFillColor", defaultProps._missingPointFillColor);
        G2dLineProperties.setDefault("Line_missingPointLineColor", defaultProps._missingPointLineColor);
        G2dLineProperties.setDefault("Line_rejectedSymbolType", defaultProps._rejectedSymbolType);
        G2dLineProperties.setDefault("Line_rejectedSymbolSize", defaultProps._rejectedSymbolSize);
        G2dLineProperties.setDefault("Line_rejectedPointLineColor", defaultProps._rejectedPointLineColor);
        G2dLineProperties.setDefault("Line_rejectedPointFillColor", defaultProps._rejectedPointFillColor);
        G2dLineProperties.setDefault("Line_questionableSymbolType", defaultProps._questionableSymbolType);
        G2dLineProperties.setDefault("Line_questionableSymbolSize", defaultProps._questionableSymbolSize);
        G2dLineProperties.setDefault("Line_questionablePointLineColor", defaultProps._questionablePointLineColor);
        G2dLineProperties.setDefault("Line_questionablePointFillColor", defaultProps._questionablePointFillColor);
        G2dLineProperties.setDefault("Line_placeholderSymbolType", defaultProps._placeholderSymbolType);
        G2dLineProperties.setDefault("Line_placeholderSymbolSize", defaultProps._placeholderSymbolSize);
        G2dLineProperties.setDefault("Line_placeholderPointLineColor", defaultProps._placeholderPointLineColor);
        G2dLineProperties.setDefault("Line_placeholderPointFillColor", defaultProps._placeholderPointFillColor);
        G2dLineProperties.setDefault("Line_okSymbolType", defaultProps._okSymbolType);
        G2dLineProperties.setDefault("Line_okSymbolSize", defaultProps._okSymbolSize);
        G2dLineProperties.setDefault("Line_okPointLineColor", defaultProps._okPointLineColor);
        G2dLineProperties.setDefault("Line_okPointFillColor", defaultProps._okPointFillColor);
    }

    public static String getFileName() {
        return "LineDefaults";
    }

    public static boolean writeDefaults() {
        BufferedWriter writer = PlotDefaultsManager.getDefaults().getBufferedWriter(G2dLineProperties.class);
        boolean b = G2dLineProperties.writeDefaults(writer);
        try {
            writer.close();
        }
        catch (IOException ioe) {
            System.out.println("");
        }
        return b;
    }

    public static boolean writeDefaults(BufferedWriter writer) {
        return G2dLineProperties.writeDefaults(CLS_NAME, writer);
    }

    protected static boolean writeDefaults(String cls, BufferedWriter writer) {
        if (writer == null) {
            return false;
        }
        RMAIO.fout(writer, LINE_BEGIN);
        new G2dLineProperties().writeProperties(writer, LINE_END);
        return true;
    }

    public static boolean loadDefaults(BufferedReader in) {
        G2dLineProperties properties = new G2dLineProperties();
        properties.readProperties(in, LINE_END);
        G2dLineProperties.setDefaults(properties);
        return true;
    }

    static {
        G2dLineProperties.init();
    }
}

