/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dFillPatternRenderer;
import hec.gfx2d.G2dLinePatternRenderer;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dLineWidthRenderer;
import hec.gfx2d.PointPropertiesPanel;
import hec.gfx2d.Symbol;
import hec.gfx2d.components.CheckBoxPanel;
import hec.gfx2d.components.ComponentPanel;
import hec.gfx2d.components.G2dDefaultJPanel;
import hec.gfx2d.components.LinePointPropertiesPanel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJRadioButton;
import rma.util.FillPatternFactory;

public class G2dLinePropertiesPanel
extends G2dDefaultJPanel
implements ActionListener,
ComponentPanel {
    public static final float[] SOLID_LINE = new float[]{50.0f};
    G2dLineProperties _properties = null;
    Object[] lineCustomColor = new Object[]{Color.white, "Custom"};
    Object[] fillCustomColor = new Object[]{Color.white, "Custom"};
    JPanel lineStylePanel = new JPanel(new GridBagLayout());
    RmaJComboBox lineStyleCombo = new RmaJComboBox();
    RmaJColorComboBox lineColorCombo = new RmaJColorComboBox();
    RmaJComboBox lineWeightCombo = new RmaJComboBox();
    JLabel lineStyleLabel = new JLabel("Style:");
    JLabel lineColorLabel = new JLabel("Color:");
    JLabel lineWeightLabel = new JLabel("Weight:");
    CheckBoxPanel lineCheckBoxPanel = new CheckBoxPanel("Draw Line");
    RmaJRadioButton lineFillAboveRadio = new RmaJRadioButton("Above");
    RmaJRadioButton lineFillBelowRadio = new RmaJRadioButton("Below");
    RmaJRadioButton lineFillNoneRadio = new RmaJRadioButton("None");
    RmaJColorComboBox lineFillColorCombo = new RmaJColorComboBox();
    RmaJComboBox lineFillPatternCombo = new RmaJComboBox();
    JLabel lineFillColorLabel = new JLabel("Fill Color:");
    JLabel lineFillPatternLabel = new JLabel("Fill Pattern:");
    RmaJCheckBox lineInterpolateMissing = new RmaJCheckBox("Interpolate for missing values");
    RmaJRadioButton lineSteppedTypeRadio = new RmaJRadioButton("Stepped");
    RmaJRadioButton lineLinearTypeRadio = new RmaJRadioButton("Linear");
    JPanel missingSymbolPanel = new JPanel(new GridBagLayout());
    PointPropertiesPanel fillerSymbolPanel = new PointPropertiesPanel();
    CheckBoxPanel missingCheckboxPanel = new CheckBoxPanel("Draw Missing Value Symbols");
    SamplePanel samplePanel = new SamplePanel();
    LinePointPropertiesPanel linePointPropertiesPanel = new LinePointPropertiesPanel(this.samplePanel);

    public G2dLinePropertiesPanel() {
        this.setLayout(new GridBagLayout());
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + 430, ins.top + ins.bottom + 270);
        this.setName("Style");
        JPanel fillPanel = new JPanel();
        fillPanel.add(new JLabel("Fill:   "));
        fillPanel.add(this.lineFillNoneRadio);
        fillPanel.add(this.lineFillBelowRadio);
        fillPanel.add(this.lineFillAboveRadio);
        JPanel typePanel = new JPanel();
        typePanel.add(new JLabel("Type:   "));
        typePanel.add(this.lineSteppedTypeRadio);
        typePanel.add(this.lineLinearTypeRadio);
        this.lineStylePanel.add((Component)this.lineCheckBoxPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.lineStylePanel.add((Component)this.lineColorLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.lineStylePanel.add((Component)this.lineColorCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.lineStylePanel.add((Component)this.lineStyleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.lineStylePanel.add((Component)this.lineStyleCombo, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.lineStylePanel.add((Component)this.lineWeightLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.lineStylePanel.add((Component)this.lineWeightCombo, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.lineStylePanel.add((Component)fillPanel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 18, 0, new Insets(20, 10, 0, 5), 0, 0));
        this.lineStylePanel.add((Component)this.lineFillColorLabel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 15, 5, 5), 0, 0));
        this.lineStylePanel.add((Component)this.lineFillColorCombo, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.lineStylePanel.add((Component)this.lineFillPatternCombo, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.lineStylePanel.add((Component)this.lineFillPatternLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 5, 0), 0, 0));
        this.lineStylePanel.add((Component)typePanel, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.lineStylePanel.add((Component)this.lineInterpolateMissing, new GridBagConstraints(0, 9, 2, 1, 0.0, 1.0, 18, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.lineFillAboveRadio.setMargin(new Insets(0, 0, 0, 0));
        this.lineFillNoneRadio.setMargin(new Insets(0, 0, 0, 0));
        this.lineFillBelowRadio.setMargin(new Insets(0, 0, 0, 0));
        this.lineSteppedTypeRadio.setMargin(new Insets(0, 0, 0, 0));
        this.lineLinearTypeRadio.setMargin(new Insets(0, 0, 0, 0));
        this.lineColorCombo.addItem(this.lineCustomColor);
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(new Object[]{SOLID_LINE, G2dLineProperties.DASH_STYLE_PATTERN, G2dLineProperties.DOT_STYLE_PATTERN, G2dLineProperties.DASHDOT_STYLE_PATTERN, G2dLineProperties.DASHDOTDOT_STYLE_PATTERN});
        this.lineStyleCombo.setModel(comboModel);
        this.lineStyleCombo.setRenderer(new G2dLinePatternRenderer(Color.blue));
        comboModel = new DefaultComboBoxModel<Object>(new Object[]{new Float(1.0f), new Float(2.0f), new Float(3.0f), new Float(4.0f), new Float(5.0f), new Float(6.0f), new Float(7.0f), new Float(8.0f), new Float(9.0f), new Float(10.0f)});
        this.lineWeightCombo.setModel(comboModel);
        this.lineWeightCombo.setRenderer(new G2dLineWidthRenderer(Color.blue));
        ButtonGroup fillRadioGroup = new ButtonGroup();
        fillRadioGroup.add(this.lineFillNoneRadio);
        fillRadioGroup.add(this.lineFillAboveRadio);
        fillRadioGroup.add(this.lineFillBelowRadio);
        this.lineFillNoneRadio.setSelected(true);
        this.lineFillColorCombo.addItem(this.fillCustomColor);
        comboModel = new DefaultComboBoxModel<Object>(new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(4), new Integer(3), new Integer(5), new Integer(6)});
        this.lineFillPatternCombo.setModel(comboModel);
        this.lineFillPatternCombo.setRenderer(new G2dFillPatternRenderer());
        ButtonGroup lineTypeRadio = new ButtonGroup();
        lineTypeRadio.add(this.lineSteppedTypeRadio);
        lineTypeRadio.add(this.lineLinearTypeRadio);
        this.missingSymbolPanel.add((Component)this.missingCheckboxPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.missingSymbolPanel.add((Component)this.fillerSymbolPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.lineStylePanel.setBorder(new TitledBorder("Line"));
        this.missingSymbolPanel.setBorder(BorderFactory.createTitledBorder("Missing Value Symbols"));
        this.samplePanel.setBorder(new TitledBorder("Sample"));
        this.add((Component)this.lineStylePanel, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.linePointPropertiesPanel, new GridBagConstraints(1, 0, 1, 4, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.missingSymbolPanel, new GridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.samplePanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 14, 2, new Insets(5, 5, 5, 0), 0, 25));
        this.lineColorCombo.setModifiable(true);
        this.lineStyleCombo.setModifiable(true);
        this.lineWeightCombo.setModifiable(true);
        this.lineFillColorCombo.setModifiable(true);
        this.lineFillPatternCombo.setModifiable(true);
        this.lineColorCombo.addActionListener(this);
        this.lineStyleCombo.addActionListener(this);
        this.lineWeightCombo.addActionListener(this);
        this.lineFillNoneRadio.addActionListener(this);
        this.lineFillAboveRadio.addActionListener(this);
        this.lineFillBelowRadio.addActionListener(this);
        this.lineFillColorCombo.addActionListener(this);
        this.lineFillPatternCombo.addActionListener(this);
        this.lineLinearTypeRadio.addActionListener(this);
        this.lineSteppedTypeRadio.addActionListener(this);
        this.lineCheckBoxPanel.addComponentPanel(this);
        this.missingCheckboxPanel.addComponentPanel(this.fillerSymbolPanel);
        this.lineCheckBoxPanel.setSelected(true);
        this.missingCheckboxPanel.setSelected(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.lineColorCombo) {
            this.lineColorComboChanged();
        } else if (o == this.lineStyleCombo) {
            this.lineStyleComboChanged();
        } else if (o == this.lineWeightCombo) {
            this.lineWeightComboChanged();
        } else if (o == this.lineFillNoneRadio) {
            this.enableFillComponents(false);
        } else if (o == this.lineFillAboveRadio || o == this.lineFillBelowRadio) {
            this.enableFillComponents(true);
        } else if (o == this.lineFillColorCombo) {
            this.lineFillColorComboChanged();
        } else if (o == this.lineFillPatternCombo) {
            this.lineFillPatternComboChanged();
        }
    }

    private void enableFillComponents(boolean enable) {
        this.lineFillColorCombo.setEnabled(enable);
        this.lineFillColorLabel.setEnabled(enable);
        this.lineFillPatternCombo.setEnabled(enable);
        this.lineFillPatternLabel.setEnabled(enable);
        this.samplePanel.repaint();
    }

    private void lineColorComboChanged() {
        Object[] item = (Object[])this.lineColorCombo.getSelectedItem();
        if (item == null) {
            return;
        }
        if (item == this.lineCustomColor) {
            JDialog dlg = JColorChooser.createDialog(this, "Choose A Color", true, this.getColorChooser(), new lineCustomColorOKListener(), null);
            dlg.setVisible(true);
        }
        ((G2dLineWidthRenderer)this.lineWeightCombo.getRenderer()).setColor((Color)item[0]);
        ((G2dLinePatternRenderer)this.lineStyleCombo.getRenderer()).setColor((Color)item[0]);
        this.lineStyleCombo.repaint();
        this.lineWeightCombo.repaint();
        this.samplePanel.repaint();
    }

    private void lineFillColorComboChanged() {
        Object[] item = (Object[])this.lineFillColorCombo.getSelectedItem();
        if (item == null) {
            return;
        }
        if (item == this.fillCustomColor) {
            JDialog dlg = JColorChooser.createDialog(this, "Choose A Color", true, this.getColorChooser(), new lineFillCustomColorOKListener(), null);
            dlg.setVisible(true);
        }
        ((G2dFillPatternRenderer)this.lineFillPatternCombo.getRenderer()).setColor((Color)item[0]);
        this.samplePanel.repaint();
    }

    private void lineFillPatternComboChanged() {
        this.samplePanel.repaint();
    }

    private void lineStyleComboChanged() {
        this.samplePanel.repaint();
    }

    private void lineWeightComboChanged() {
        this.samplePanel.repaint();
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        this.lineStyleCombo.setEnabled(enabled);
        this.lineWeightCombo.setEnabled(enabled);
        this.lineColorCombo.setEnabled(enabled);
        this.lineColorLabel.setEnabled(enabled);
        this.lineWeightLabel.setEnabled(enabled);
        this.lineStyleLabel.setEnabled(enabled);
        this.lineFillNoneRadio.setEnabled(enabled);
        this.lineFillAboveRadio.setEnabled(enabled);
        this.lineFillBelowRadio.setEnabled(enabled);
        this.lineFillColorCombo.setEnabled(enabled);
        this.lineFillColorLabel.setEnabled(enabled);
        this.lineFillPatternLabel.setEnabled(enabled);
        this.lineFillPatternCombo.setEnabled(enabled);
        this.lineInterpolateMissing.setEnabled(enabled);
        this.samplePanel.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.lineCheckBoxPanel.setEnabled(enabled);
        if (!enabled) {
            this.setComponentsEnabled(enabled);
        } else {
            this.setComponentsEnabled(this.lineCheckBoxPanel.isSelected());
        }
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        this.lineColorCombo.removeActionListener(this);
        this.lineFillColorCombo.removeActionListener(this);
        this.lineCheckBoxPanel.setSelected(this._properties.drawLine());
        if (this._properties.getLinePattern() == null) {
            this.lineStyleCombo.setSelectedItem(SOLID_LINE);
        } else {
            ComboBoxModel propertiesModel = this.lineStyleCombo.getModel();
            for (int i = 0; i < propertiesModel.getSize(); ++i) {
                if (!Arrays.equals(this._properties.getLinePattern(), (float[])propertiesModel.getElementAt(i))) continue;
                this.lineStyleCombo.setSelectedIndex(i);
                break;
            }
        }
        this.lineWeightCombo.setSelectedItem(new Float(this._properties.getLineWidth()));
        this.lineFillPatternCombo.setSelectedItem(new Integer(this._properties.getFillPattern()));
        this.selectColorItem(this.lineColorCombo, this._properties.getLineColor());
        ((G2dLineWidthRenderer)this.lineWeightCombo.getRenderer()).setColor(this._properties.getLineColor());
        ((G2dLinePatternRenderer)this.lineStyleCombo.getRenderer()).setColor(this._properties.getLineColor());
        ((G2dFillPatternRenderer)this.lineFillPatternCombo.getRenderer()).setColor(this._properties.getFillColor());
        switch (this._properties.getFillType()) {
            case 0: {
                this.lineFillNoneRadio.doClick();
                break;
            }
            case 1: {
                this.lineFillAboveRadio.doClick();
                break;
            }
            case 2: {
                this.lineFillBelowRadio.doClick();
            }
        }
        this.lineInterpolateMissing.setSelected(this._properties.getInterpolateMissing());
        int lineStepStyle = this._properties.getLineStepStyle();
        if (lineStepStyle == 1) {
            this.lineSteppedTypeRadio.setSelected(true);
        } else if (lineStepStyle == 0) {
            this.lineLinearTypeRadio.setSelected(true);
        }
        this.selectColorItem(this.lineFillColorCombo, this._properties.getFillColor());
        G2dLineProperties properties = new G2dLineProperties();
        properties.setSymbolFillColor(this._properties._placeholderPointFillColor);
        properties.setSymbolLineColor(this._properties._placeholderPointLineColor);
        properties.setSymbolSize(this._properties._placeholderSymbolSize);
        properties.setSymbolType(this._properties._placeholderSymbolType);
        this.fillerSymbolPanel.setData(properties);
        this.missingCheckboxPanel.setSelected(this._properties._drawMissingData);
        this.samplePanel.repaint();
        this.lineColorCombo.addActionListener(this);
        this.lineFillColorCombo.addActionListener(this);
        this.linePointPropertiesPanel.fillPanel();
        this.setModified(false);
    }

    public void refresh() {
    }

    public boolean validatePanel() {
        return this.linePointPropertiesPanel.validatePanel();
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        if (!this.validatePanel()) {
            return false;
        }
        if (this.lineCheckBoxPanel.isSelected()) {
            this._properties.setInterpolateMissing(this.lineInterpolateMissing.isSelected());
            if (this.lineLinearTypeRadio.isSelected()) {
                this._properties.setLineStepStyle(0);
            } else if (this.lineSteppedTypeRadio.isSelected()) {
                this._properties.setLineStepStyle(1);
            }
            this._properties.setDrawLine(this.lineCheckBoxPanel.isSelected());
            float[] linePattern = (float[])this.lineStyleCombo.getSelectedItem();
            if (linePattern != null && (linePattern == SOLID_LINE || linePattern.length == 1 && linePattern[0] == SOLID_LINE[0])) {
                linePattern = null;
            }
            this._properties.setLinePattern(linePattern);
            float lineThickness = ((Float)this.lineWeightCombo.getSelectedItem()).floatValue();
            this._properties.setLineWidth(lineThickness);
            this._properties.setLineColor((Color)((Object[])this.lineColorCombo.getSelectedItem())[0]);
            if (this.lineFillNoneRadio.isSelected()) {
                this._properties.setFillType(0);
            } else if (this.lineFillAboveRadio.isSelected()) {
                this._properties.setFillType(1);
            } else if (this.lineFillBelowRadio.isSelected()) {
                this._properties.setFillType(2);
            }
            this._properties.setFillColor((Color)((Object[])this.lineFillColorCombo.getSelectedItem())[0]);
            this._properties.setFillPattern((Integer)this.lineFillPatternCombo.getSelectedItem());
        } else {
            this._properties.setDrawLine(false);
            this._properties.setFillType(0);
        }
        this.linePointPropertiesPanel.savePanel();
        if (this.missingCheckboxPanel.isSelected()) {
            G2dLineProperties pointProperties = this.fillerSymbolPanel.getData();
            if (pointProperties != null) {
                this._properties._placeholderPointFillColor = pointProperties.getPointFillColor();
                this._properties._placeholderPointLineColor = pointProperties.getPointLineColor();
                this._properties._placeholderSymbolSize = pointProperties.getSymbolSize();
                this._properties._placeholderSymbolType = pointProperties.getSymbolType();
                this._properties._drawMissingData = true;
            }
        } else {
            this._properties._drawMissingData = false;
        }
        if (this.isModified()) {
            this._properties.setModified(true);
        }
        return true;
    }

    public void setData(G2dLineProperties prop) {
        this._properties = prop;
        this.linePointPropertiesPanel.setData(prop);
    }

    public G2dLineProperties getData() {
        return this._properties;
    }

    public class SamplePanel
    extends JPanel {
        SamplePanel() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (!this.isEnabled()) {
                return;
            }
            Color lineColor = (Color)((Object[])G2dLinePropertiesPanel.this.lineColorCombo.getSelectedItem())[0];
            Color pointFColor = G2dLinePropertiesPanel.this.linePointPropertiesPanel.getPointFillColor();
            Color pointLColor = G2dLinePropertiesPanel.this.linePointPropertiesPanel.getPointLineColor();
            Color lineFColor = (Color)((Object[])G2dLinePropertiesPanel.this.lineFillColorCombo.getSelectedItem())[0];
            float[] linePattern = (float[])G2dLinePropertiesPanel.this.lineStyleCombo.getSelectedItem();
            if (linePattern.length == 1 && linePattern[0] == 50.0f) {
                linePattern = null;
            }
            float lineThickness = ((Float)G2dLinePropertiesPanel.this.lineWeightCombo.getSelectedItem()).floatValue();
            int symbolType = G2dLinePropertiesPanel.this.linePointPropertiesPanel.getSymbolType();
            int size = G2dLinePropertiesPanel.this.linePointPropertiesPanel.getPointSize();
            Dimension d = this.getSize();
            Color oldColor = g.getColor();
            Graphics2D g2d = (Graphics2D)g;
            if (G2dLinePropertiesPanel.this.lineCheckBoxPanel.isSelected()) {
                int filltype = (Integer)G2dLinePropertiesPanel.this.lineFillPatternCombo.getSelectedItem();
                if (filltype == 0) {
                    g2d.setColor(lineFColor);
                    if (G2dLinePropertiesPanel.this.lineFillAboveRadio.isSelected()) {
                        g2d.fillRect(5, 15, d.width - 10, d.height / 2 - 13);
                    } else if (G2dLinePropertiesPanel.this.lineFillBelowRadio.isSelected()) {
                        g2d.fillRect(5, d.height / 2 + 2, d.width - 10, d.height / 2 - 10);
                    }
                } else {
                    Composite oldac = ((Graphics2D)g).getComposite();
                    AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                    Paint op = g2d.getPaint();
                    Paint tp = FillPatternFactory.createFillPattern(filltype, lineFColor);
                    g2d.setPaint(tp);
                    ((Graphics2D)g).setComposite(ac);
                    if (G2dLinePropertiesPanel.this.lineFillAboveRadio.isSelected()) {
                        g2d.fillRect(5, 15, d.width - 10, d.height / 2 - 13);
                    } else if (G2dLinePropertiesPanel.this.lineFillBelowRadio.isSelected()) {
                        g2d.fillRect(5, d.height / 2 + 2, d.width - 10, d.height / 2 - 10);
                    }
                    g2d.setComposite(oldac);
                    g2d.setPaint(op);
                }
                g2d.setColor(lineColor);
                Stroke oldStroke = g2d.getStroke();
                BasicStroke bs = new BasicStroke(lineThickness, 0, 0, 10.0f, linePattern, 0.0f);
                g2d.setStroke(bs);
                g2d.drawLine(5, d.height / 2 + 2, d.width - 5, d.height / 2 + 2);
                g2d.setStroke(oldStroke);
            }
            if (G2dLinePropertiesPanel.this.linePointPropertiesPanel.isSelected()) {
                Symbol.draw(g, d.width / 2, d.height / 2 + 2, symbolType, pointLColor, pointFColor, size);
            }
            g.setColor(oldColor);
        }
    }

    class lineCustomColorOKListener
    implements ActionListener {
        lineCustomColorOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            G2dLinePropertiesPanel.this.lineCustomColor[0] = G2dLinePropertiesPanel.this.getColorChooser().getColor();
            G2dLinePropertiesPanel.this.lineColorCombo.repaint();
            G2dLinePropertiesPanel.this.repaint();
        }
    }

    class lineFillCustomColorOKListener
    implements ActionListener {
        lineFillCustomColorOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            G2dLinePropertiesPanel.this.fillCustomColor[0] = G2dLinePropertiesPanel.this.getColorChooser().getColor();
            G2dLinePropertiesPanel.this.lineFillColorCombo.repaint();
            G2dLinePropertiesPanel.this.repaint();
        }
    }

    private class ArrayWrapper {
        float[] m_data = null;

        public ArrayWrapper(float[] data) {
            this.m_data = data;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof float[])) {
                return false;
            }
            if (((float[])obj).length != this.m_data.length) {
                return false;
            }
            for (int i = 0; i < this.m_data.length; ++i) {
                if (this.m_data[i] == ((float[])obj)[i]) continue;
                return false;
            }
            return true;
        }

        public float[] getData() {
            return this.m_data;
        }
    }
}

