/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.PointPropertiesPanel;
import hec.gfx2d.components.CheckBoxPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJRadioButton;

public class G2dLineStylePropertiesPanel
extends DefaultJPanel {
    private RmaJRadioButton _useDefinedStylesRadio;
    private RmaJRadioButton _useSimpleStylesRadio;
    private PointPropertiesPanel _missingValuesPanel;
    private CheckBoxPanel _drawMissingCheck;
    G2dLineProperties _lineProperties = null;

    public G2dLineStylePropertiesPanel() {
        super(new GridBagLayout());
        this.buildControls();
        this.addListeners();
        this.setName("Style");
    }

    protected void buildControls() {
        JPanel radioPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._useDefinedStylesRadio = new RmaJRadioButton("Use Defined Line Styles base on Parameter", true);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        radioPanel.add((Component)this._useDefinedStylesRadio, gbc);
        this._useSimpleStylesRadio = new RmaJRadioButton("Use Simple Line Styles");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        radioPanel.add((Component)this._useSimpleStylesRadio, gbc);
        this._missingValuesPanel = new PointPropertiesPanel();
        this._missingValuesPanel.setBorder(BorderFactory.createTitledBorder("Missing Value Symbols"));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.001;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._missingValuesPanel, gbc);
        this._drawMissingCheck = new CheckBoxPanel("Draw Missing Values Symbols");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._missingValuesPanel.add((Component)this._drawMissingCheck, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._useDefinedStylesRadio);
        bg.add(this._useSimpleStylesRadio);
    }

    protected void addListeners() {
        this._drawMissingCheck.addComponentPanel(this._missingValuesPanel);
        this._drawMissingCheck.setSelected(false);
    }

    @Override
    public void fillPanel() {
        this._drawMissingCheck.setSelected(this._lineProperties._drawMissingData);
        G2dLineProperties properties = new G2dLineProperties();
        properties.setSymbolFillColor(this._lineProperties._placeholderPointFillColor);
        properties.setSymbolLineColor(this._lineProperties._placeholderPointLineColor);
        properties.setSymbolSize(this._lineProperties._placeholderSymbolSize);
        properties.setSymbolType(this._lineProperties._placeholderSymbolType);
        this._missingValuesPanel.setData(properties);
    }

    @Override
    public boolean savePanel() {
        G2dLineProperties pointProperties = this._missingValuesPanel.getData();
        if (pointProperties != null) {
            this._lineProperties._placeholderPointFillColor = pointProperties.getPointFillColor();
            this._lineProperties._placeholderPointLineColor = pointProperties.getPointLineColor();
            this._lineProperties._placeholderSymbolSize = pointProperties.getSymbolSize();
            this._lineProperties._placeholderSymbolType = pointProperties.getSymbolType();
            this._lineProperties._drawMissingData = this._drawMissingCheck.isSelected();
        }
        return true;
    }

    void setData(G2dLineProperties lineProps) {
        this._lineProperties = lineProps;
    }
}

