/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class G2dLineWidthRenderer
extends JLabel
implements ListCellRenderer {
    private Color _color = Color.blue;
    private LineIcon _icon = new LineIcon();

    public G2dLineWidthRenderer() {
        this.setOpaque(true);
        this.setIcon(this._icon);
    }

    public G2dLineWidthRenderer(Color c2) {
        this();
        this.setColor(c2);
    }

    public void setColor(Color c2) {
        if (c2 == null) {
            return;
        }
        this._color = c2;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Float val = (Float)value;
        this._icon.setColor(this._color);
        this._icon.setLineWidth(val.floatValue());
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        return this;
    }

    class LineIcon
    implements Icon {
        private Color _color;
        private float _width = 0.0f;
        private int _w;
        private int _h;

        public LineIcon() {
            this(Color.blue, 50, 15);
        }

        public LineIcon(Color color) {
            this(color, 50, 15);
        }

        public LineIcon(Color color, int w, int h) {
            this._color = color;
            this._w = w;
            this._h = h;
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.black);
            g2d.setColor(this._color);
            BasicStroke bs = new BasicStroke(this._width, 0, 0, 10.0f, null, 0.0f);
            g2d.setStroke(bs);
            if (this._width == 0.0f) {
                return;
            }
            g2d.drawLine(x, this._h / 2, this._w, this._h / 2);
        }

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color color) {
            this._color = color;
        }

        public void setLineWidth(float w) {
            this._width = w;
        }

        @Override
        public int getIconWidth() {
            return this._w;
        }

        @Override
        public int getIconHeight() {
            return this._h;
        }
    }
}

