/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dDataQualityPropertiesPanel2;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dLineLabelPropertiesPanel;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dLinePropertiesPanel;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dTimeSeriesLine;
import hec.gfx2d.LabelPropertiesPanel;
import hec.gfx2d.LegendItem;
import hec.gfx2d.LegendPanel;
import hec.gfx2d.MarkerlineGlyph;
import hec.gfx2d.PairedDataPropertiesPanel;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.TimeSeriesDataSetBase;
import hec.io.PairedDataContainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJList;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;

public class G2dLinesPropPanel
extends DefaultJPanel
implements ListSelectionListener,
ActionListener {
    private JTabbedPane _tabPane;
    private JLabel _selecterLabel;
    private RmaJList _selecter;
    private JButton _spinUpBtn;
    private JButton _spinDownBtn;
    private G2dLinePropertiesPanel _linePanel;
    private LabelPropertiesPanel _legendPane;
    private G2dLineLabelPropertiesPanel _lineLabelPanel;
    private G2dDataQualityPropertiesPanel2 _qualityPanel;
    private PairedDataPropertiesPanel _pairedDataPanel;
    private List<G2dLineProperties> _propsVector = new ArrayList<G2dLineProperties>();
    private List _glyphVector;
    private RmaJCheckBox _drawCurveCheck;
    private RmaJCheckBox _showInLegendCheck;
    private G2dLineProperties _properties;
    private RmaJTextField _dssPathTxt;
    private JPanel _pathPanel;
    private JScrollPane _selectorScrollPane;
    private GlyphListItem _lastItem;
    LegendPanel _legendPanel = null;
    private boolean _isPairedData;

    public G2dLinesPropPanel() {
        this.setName("Curves");
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        this._selecterLabel = new JLabel("Curves");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)this._selecterLabel, gbc);
        this._selecter = new RmaJList(new RmaListModel(false)){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 50;
                return d;
            }
        };
        this._selecter.setSelectionMode(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this._selectorScrollPane = new JScrollPane(this._selecter);
        this.add((Component)this._selectorScrollPane, gbc);
        Insets btnMargin = new Insets(0, 0, 0, 0);
        this._spinUpBtn = new JButton(RmaImage.getImageIcon("Images/spinUp2.gif"));
        this._spinUpBtn.setToolTipText("Move Curve Up");
        this._spinUpBtn.setName("curve_up");
        this._spinUpBtn.setEnabled(false);
        this._spinUpBtn.setMargin(btnMargin);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(15, 5, 0, 5);
        this.add((Component)this._spinUpBtn, gbc);
        this._spinDownBtn = new JButton(RmaImage.getImageIcon("Images/spinDown2.gif"));
        this._spinDownBtn.setToolTipText("Move Curve Down");
        this._spinDownBtn.setName("curve_down");
        this._spinDownBtn.setEnabled(false);
        this._spinDownBtn.setMargin(btnMargin);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(0, 5, 0, 5);
        this.add((Component)this._spinDownBtn, gbc);
        JPanel btnPanel = new JPanel(new GridBagLayout());
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this.add((Component)btnPanel, gbc);
        this._drawCurveCheck = new RmaJCheckBox("Draw Curve");
        this._drawCurveCheck.setEnabled(false);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.1;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        btnPanel.add((Component)this._drawCurveCheck, gbc);
        this._showInLegendCheck = new RmaJCheckBox("Show in Legend");
        this._showInLegendCheck.setEnabled(false);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.1;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        btnPanel.add((Component)this._showInLegendCheck, gbc);
        this._pathPanel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this.add((Component)this._pathPanel, gbc);
        JLabel label = new JLabel("DSS Path:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._pathPanel.add((Component)label, gbc);
        this._dssPathTxt = new RmaJTextField();
        this._dssPathTxt.setEditable(false);
        this._dssPathTxt.setBorder(null);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._pathPanel.add((Component)this._dssPathTxt, gbc);
        this._tabPane = new JTabbedPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)this._tabPane, gbc);
        this._linePanel = new G2dLinePropertiesPanel();
        this._lineLabelPanel = new G2dLineLabelPropertiesPanel();
        this._legendPane = new LabelPropertiesPanel();
        this._qualityPanel = new G2dDataQualityPropertiesPanel2();
        this._pairedDataPanel = new PairedDataPropertiesPanel();
        this._tabPane.addTab(this._linePanel.getName(), this._linePanel);
        this._tabPane.addTab(this._lineLabelPanel.getName(), this._lineLabelPanel);
        this._tabPane.addTab("Legend Item", this._legendPane);
        this._tabPane.addTab(this._qualityPanel.getName(), this._qualityPanel);
    }

    protected void addListeners() {
        this._selecter.addListSelectionListener(this);
        this._spinUpBtn.addActionListener(this);
        this._spinDownBtn.addActionListener(this);
        this._showInLegendCheck.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this._spinUpBtn) {
            this.spin(true);
        } else if (obj == this._spinDownBtn) {
            this.spin(false);
        }
    }

    public void setLegendPanel(LegendPanel legendPanel) {
        this._legendPanel = legendPanel;
    }

    void spin(boolean moveUp) {
        int idx = this._selecter.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        RmaListModel model = (RmaListModel)this._selecter.getModel();
        if (moveUp && idx < 1) {
            return;
        }
        if (!moveUp && idx == model.size() - 1) {
            return;
        }
        Object obj = model.elementAt(idx);
        G2dLineProperties prop = this._propsVector.get(idx);
        model.removeElementAt(idx);
        this._propsVector.remove(idx);
        idx = moveUp ? --idx : ++idx;
        model.insertElementAt(obj, idx);
        this._propsVector.add(idx, prop);
        this._selecter.setSelectedValue(obj, true);
        this.setModified(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        G2dObject g2dObject;
        LegendItem legendItem;
        GlyphListItem item;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this._lastItem != null) {
            this._lastItem.glyph.getLine().setVisible(this._drawCurveCheck.isSelected());
            this._lastItem.glyph.setLegendItemsVisible(this._showInLegendCheck.isSelected());
        }
        this._lastItem = item = (GlyphListItem)this._selecter.getSelectedValue();
        if (item == null) {
            this._drawCurveCheck.setEnabled(false);
            this._showInLegendCheck.setEnabled(false);
            return;
        }
        G2dGlyph glyph = item.glyph;
        if (glyph == null) {
            this._drawCurveCheck.setEnabled(false);
            this._showInLegendCheck.setEnabled(false);
            return;
        }
        int lineIdx = item.curveNum;
        int idx = this._selecter.getSelectedIndex();
        if (idx == 0) {
            this._spinUpBtn.setEnabled(false);
        } else if (idx == this._selecter.getModel().getSize() - 1) {
            this._spinDownBtn.setEnabled(false);
        }
        if (lineIdx == 0 && this._selecter.getModel().getSize() != 1) {
            this._spinUpBtn.setEnabled(true);
            this._spinDownBtn.setEnabled(true);
        } else {
            this._spinUpBtn.setEnabled(false);
            this._spinDownBtn.setEnabled(false);
        }
        if (lineIdx == 0) {
            this._drawCurveCheck.setEnabled(true);
            this._drawCurveCheck.setSelected(item.glyph.getLine().isVisible());
            this._showInLegendCheck.setEnabled(true);
            this._showInLegendCheck.setSelected(item.glyph.isLegendItemsVisible());
        } else {
            this._drawCurveCheck.setEnabled(false);
            this._showInLegendCheck.setEnabled(false);
        }
        int glyphIdx = item.glyphIdx;
        if (glyphIdx >= 0 && glyphIdx < this._glyphVector.size()) {
            if (((G2dGlyph)this._glyphVector.get(glyphIdx)).getLine() instanceof G2dTimeSeriesLine) {
                this._tabPane.setEnabledAt(1, true);
            } else {
                this._tabPane.setEnabledAt(1, true);
            }
        }
        G2dLineProperties lineProps = this._propsVector.get(idx);
        this._linePanel.savePanel();
        this._lineLabelPanel.savePanel();
        if (this._tabPane.getComponentAt(2) == this._pairedDataPanel) {
            this._pairedDataPanel.savePanel();
        } else {
            this._qualityPanel.savePanel();
        }
        boolean visible = this._drawCurveCheck.isSelected();
        RmaJDialog dialog = (RmaJDialog)SwingUtilities.getAncestorOfClass(RmaJDialog.class, this);
        if (dialog != null) {
            dialog.setIgnoreModifiedEvents(true);
        }
        this._properties = lineProps;
        this._linePanel.setData(lineProps);
        this._lineLabelPanel.setData(lineProps);
        G2dObject g2dObj = glyph.getG2dObject();
        if (g2dObj instanceof PairedDataSet) {
            PairedDataContainer pdc;
            this._pathPanel.setVisible(true);
            PairedDataSet pds = (PairedDataSet)g2dObj;
            this._dssPathTxt.setText(pds.getData().fullName);
            this._dssPathTxt.setToolTipText(pds.getData().fileName);
            if (this._tabPane.getComponentAt(2) == this._qualityPanel) {
                this._tabPane.remove(this._qualityPanel);
                this._tabPane.addTab(this._pairedDataPanel.getName(), this._pairedDataPanel);
            }
            if ((pdc = pds.getData()) != null) {
                this._pairedDataPanel.setShowAllLegendItems(glyph.showAllCurvesOnLegend());
                this._pairedDataPanel.setLabelInterval(glyph._drawProp.getLabelInterval());
                this._pairedDataPanel.setMajorLineInterval(glyph._drawProp.getMajorMinorInterval());
                this._pairedDataPanel.setPlotState(glyph._drawProp.getDrawingMode());
            }
        } else if (g2dObj instanceof TimeSeriesDataSetBase) {
            this._pathPanel.setVisible(true);
            TimeSeriesDataSetBase tsobj = (TimeSeriesDataSetBase)g2dObj;
            this._dssPathTxt.setText(tsobj.getData().fullName);
            this._dssPathTxt.setToolTipText(tsobj.getData().fileName);
            if (this._tabPane.getComponentAt(2) == this._pairedDataPanel) {
                this._tabPane.remove(this._pairedDataPanel);
                this._tabPane.addTab(this._qualityPanel.getName(), this._qualityPanel);
            }
            this._qualityPanel.setData(lineProps);
            this._qualityPanel.fillPanel();
        } else {
            this._pathPanel.setVisible(false);
        }
        this._linePanel.fillPanel();
        if (this._legendPanel != null && (legendItem = this._legendPanel.getLegendItem(g2dObject = item.glyph.getG2dObject(), lineIdx)) != null) {
            this._legendPane.setData(legendItem.getProperties());
            this._legendPane.fillPanel();
        }
        if (this._properties != null) {
            this._drawCurveCheck.setSelected(item.glyph.getLine().isVisible());
        }
        this._lineLabelPanel.fillPanel();
        if (this._tabPane.getComponentAt(2) == this._qualityPanel) {
            this._tabPane.setEnabledAt(2, lineProps._enableQualityDataPts);
        }
        if (dialog != null) {
            dialog.setIgnoreModifiedEvents(false);
        }
    }

    void setGlyphVector(List glyphVector) {
        RmaListModel model = (RmaListModel)this._selecter.getModel();
        model.clear();
        this._propsVector.clear();
        this._spinUpBtn.setEnabled(false);
        this._spinDownBtn.setEnabled(false);
        this._drawCurveCheck.setEnabled(false);
        this._showInLegendCheck.setEnabled(false);
        if (glyphVector == null || glyphVector.isEmpty()) {
            return;
        }
        ArrayList<GlyphListItem> clonedVector = new ArrayList<GlyphListItem>(glyphVector.size());
        for (int i = 0; i < glyphVector.size(); ++i) {
            Object obj = glyphVector.get(i);
            if (obj instanceof MarkerlineGlyph) continue;
            G2dGlyph glyph = (G2dGlyph)obj;
            for (int g = 0; g < glyph.getCurveCount(); ++g) {
                if (!glyph.isCurveDrawn(g)) continue;
                clonedVector.add(new GlyphListItem(glyph, g, i));
            }
        }
        model.addAll(clonedVector);
        this._selecter.setModel(model);
        if (clonedVector.size() > 1) {
            this._spinUpBtn.setEnabled(true);
            this._spinDownBtn.setEnabled(true);
        }
        this._glyphVector = glyphVector;
        for (int i = 0; i < clonedVector.size(); ++i) {
            GlyphListItem item = (GlyphListItem)clonedVector.get(i);
            if (item.glyph.getLine(item.curveNum) == null) continue;
            this._propsVector.add(item.glyph.getLine(item.curveNum).getProperties().clone());
            this._showInLegendCheck.setSelected(item.glyph.isLegendItemsVisible());
        }
        this._selecter.setSelectedIndex(-1);
        this._selecter.setSelectedIndex(0);
    }

    @Override
    public boolean savePanel() {
        this._linePanel.savePanel();
        this._lineLabelPanel.savePanel();
        this._qualityPanel.savePanel();
        this._legendPane.savePanel();
        boolean visible = this._drawCurveCheck.isSelected();
        boolean allLabelsVisible = this._legendPane.isAllLabelsCheckVisible();
        boolean allLabelsUseSameFont = this._legendPane.isAllLabelsCheckSelected();
        GlyphListItem item = (GlyphListItem)this._selecter.getSelectedValue();
        if (item != null) {
            item.glyph.getLine().setVisible(this._drawCurveCheck.isSelected());
            item.glyph.setLegendItemsVisible(this._showInLegendCheck.isSelected());
        }
        ArrayList clonedVector = new ArrayList(((RmaListModel)this._selecter.getModel()).getVector());
        if (this._glyphVector != null) {
            int i;
            for (i = this._glyphVector.size() - 1; i >= 0; --i) {
                G2dGlyph glyph = (G2dGlyph)this._glyphVector.get(i);
                if (glyph instanceof MarkerlineGlyph) continue;
                this._glyphVector.remove(i);
            }
            for (i = 0; i < clonedVector.size(); ++i) {
                item = (GlyphListItem)clonedVector.get(i);
                if (item.curveNum != 0) continue;
                this._glyphVector.add(item.glyph);
            }
            for (int i2 = 0; i2 < clonedVector.size(); ++i2) {
                item = (GlyphListItem)clonedVector.get(i2);
                if (i2 >= this._propsVector.size() || this._propsVector.get(i2) == null) break;
                G2dLineProperties props = this._propsVector.get(i2);
                if (item.glyph.getLine(item.curveNum) == null) continue;
                G2dGlyphDrawProp drawProp = item.glyph._drawProp;
                if (item.curveNum < drawProp.lineProperties.size()) {
                    drawProp.lineProperties.set(item.curveNum, props);
                }
                item.glyph.getLine(item.curveNum).setProperties(props);
            }
        }
        if (this._legendPanel != null) {
            this._legendPanel.refreshLegendItems();
        }
        if ((item = (GlyphListItem)this._selecter.getSelectedValue()) != null) {
            LegendItem legendItem;
            G2dObject g2dObject = item.glyph.getG2dObject();
            G2dLabelDrawProp legendItemDrawProperties = this._legendPane.getData();
            LegendItem legendItem2 = legendItem = this._legendPanel != null ? this._legendPanel.getLegendItem(g2dObject, item.curveNum) : null;
            if (legendItem == null) {
                LegendItem legendItem3 = legendItem = this._legendPanel != null ? this._legendPanel.getLegendItem(g2dObject, 0) : null;
            }
            if (legendItem != null) {
                legendItem.setProperties(legendItemDrawProperties);
            }
            if (allLabelsUseSameFont) {
                List legendItemProperties = this._legendPanel != null ? this._legendPanel.getProperties().getLegendItemProperties() : Collections.EMPTY_LIST;
                for (Object legendItemProperty : legendItemProperties) {
                    ((G2dLabelDrawProp)legendItemProperty).setFont(legendItemDrawProperties.getFont());
                }
            }
        }
        return true;
    }

    public void setLineSelectorVisible(boolean visible) {
        this._spinUpBtn.setVisible(visible);
        this._spinDownBtn.setVisible(visible);
        this._selecterLabel.setVisible(visible);
        this._selectorScrollPane.setVisible(visible);
    }

    public void setSelectedLineIndex(int curveNum) {
        if (curveNum < 0) {
            return;
        }
        if (curveNum >= this._selecter.getItemCount()) {
            return;
        }
        this._selecter.setSelectedIndex(curveNum);
    }

    public void setSelectedTabIndex(int idx) {
        if (idx < 0 || this._tabPane == null) {
            return;
        }
        if (idx >= this._tabPane.getTabCount()) {
            return;
        }
        this._tabPane.setSelectedIndex(idx);
    }

    class GlyphListItem {
        public G2dGlyph glyph;
        public int curveNum;
        public int glyphIdx;

        public GlyphListItem(G2dGlyph g, int num, int gIdx) {
            this.glyph = g;
            this.curveNum = num;
            this.glyphIdx = gIdx;
        }

        public String toString() {
            if (this.glyph.getCurveName(this.curveNum) == null) {
                return "";
            }
            return this.glyph.getCurveName(this.curveNum);
        }
    }
}

