/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLine;
import hec.gfx2d.LogarithmicPathIterator;
import hec.heclib.util.intContainer;
import hec.io.PairedDataContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class G2dLogarithmicLine
extends G2dLine {
    private boolean _newData = false;
    private double[] _originalxarray;
    private double[] _originalyarray;
    private static final int _resolution = 100;
    LogFunction _function;

    @Override
    public void drawLine(Graphics g, Rectangle clipRect) {
        int idx = 0;
        int numSamples = 100;
        double[] inputXData = (double[])this._xdataVec.get(0);
        double[] inputYData = (double[])this._ydataVec.get(0);
        double[] xarray = new double[(inputXData.length - 1) * numSamples + inputXData.length];
        double[] yarray = new double[xarray.length];
        int[] xdata = new int[xarray.length];
        int[] ydata = new int[xarray.length];
        LogarithmicPathIterator pathIterator = new LogarithmicPathIterator(inputXData, inputYData, inputYData.length, numSamples, null);
        double[] values = new double[6];
        do {
            pathIterator.currentSegment(values);
            xarray[idx] = values[0];
            yarray[idx] = values[1];
            pathIterator.next();
            ++idx;
        } while (!pathIterator.isDone());
        this.scale(xarray, yarray, xdata, ydata, 0, xdata.length);
        g.setColor(Color.GREEN);
        Polyline2D logLine = new Polyline2D(xdata, ydata, xdata.length);
        ((Graphics2D)g).draw(logLine);
    }

    private Point2D computePoint(List<Point2D> points, double t) {
        return this.computePointPrivate(points, t).get(0);
    }

    private List<Point2D> computePointPrivate(List<Point2D> points, double t) {
        if (points.size() == 1) {
            return points;
        }
        ArrayList<Point2D> interpPoints = new ArrayList<Point2D>();
        for (int i = 0; i < points.size() - 1; ++i) {
            Point2D p1 = points.get(i);
            Point2D p2 = points.get(i + 1);
            double x1 = p1.getX() + t * (p2.getX() - p1.getX());
            double y1 = p1.getY() + t * (p2.getY() - p1.getY());
            interpPoints.add(new Point2D.Double(x1, y1));
        }
        return this.computePointPrivate(interpPoints, t);
    }

    private void resetArrays() {
        for (int i = 0; i < this._xdataVec.size(); ++i) {
            this._function = new LogFunction((double[])this._xdataVec.get(i), (double[])this._ydataVec.get(i));
            double xmin = ((double[])this._xdataVec.get(i))[0];
            double xmax = ((double[])this._xdataVec.get(i))[((double[])this._xdataVec.get(i)).length - 1];
            double[] xarray = new double[101];
            double[] yarray = new double[101];
            for (int j = 0; j < 101; ++j) {
                xarray[j] = xmin + (double)j / 100.0 * (xmax - xmin);
                yarray[j] = this._function.logEquation(xarray[j]);
            }
            this._xdataVec.set(i, xarray);
            this._ydataVec.set(i, yarray);
            this._dataSizeVec.set(i, new intContainer(xarray.length));
        }
    }

    private void fitDataPdc() {
        for (int z = 0; z < this._xdataVec.size(); ++z) {
            PairedDataContainer pairedDataContainer = this.createPdc(z);
        }
    }

    private PairedDataContainer createPdc(int z) {
        PairedDataContainer pdc = new PairedDataContainer();
        pdc.numberCurves = 1;
        pdc.xOrdinates = (double[])this._xdataVec.get(z);
        pdc.numberOrdinates = pdc.xOrdinates.length;
        for (int i = 0; i < pdc.numberOrdinates; ++i) {
            pdc.yOrdinates[i][0] = ((double[])this._ydataVec.get(z))[i];
        }
        return pdc;
    }

    @Override
    public void addLineData(double[] xarray, double[] yarray, int numPts) {
        this._newData = true;
        super.addLineData(xarray, yarray, numPts);
    }

    @Override
    public void setLineData(double[] xarray, double[] yarray, int numPts) {
        this._newData = true;
        super.setLineData(xarray, yarray, numPts);
    }

    public class Polyline2D
    implements Shape,
    Cloneable,
    Serializable {
        private static final float ASSUME_ZERO = 0.001f;
        public int npoints;
        public float[] xpoints;
        public float[] ypoints;
        protected Rectangle2D bounds;
        private GeneralPath path;
        private GeneralPath closedPath;

        public Polyline2D() {
            this.xpoints = new float[4];
            this.ypoints = new float[4];
        }

        public Polyline2D(float[] xpoints, float[] ypoints, int npoints) {
            if (npoints > xpoints.length || npoints > ypoints.length) {
                throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
            }
            this.npoints = npoints;
            this.xpoints = new float[npoints + 1];
            this.ypoints = new float[npoints + 1];
            System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
            System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
            this.calculatePath();
        }

        public Polyline2D(double[] xpoints, double[] ypoints, int npoints) {
            if (npoints > xpoints.length || npoints > ypoints.length) {
                throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
            }
            this.npoints = npoints;
            this.xpoints = new float[npoints + 1];
            this.ypoints = new float[npoints + 1];
            for (int i = 0; i < ypoints.length; ++i) {
                this.xpoints[i] = (float)xpoints[i];
                this.ypoints[i] = (float)ypoints[i];
            }
            this.calculatePath();
        }

        public Polyline2D(int[] xpoints, int[] ypoints, int npoints) {
            if (npoints > xpoints.length || npoints > ypoints.length) {
                throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
            }
            this.npoints = npoints;
            this.xpoints = new float[npoints];
            this.ypoints = new float[npoints];
            for (int i = 0; i < npoints; ++i) {
                this.xpoints[i] = xpoints[i];
                this.ypoints[i] = ypoints[i];
            }
            this.calculatePath();
        }

        public Polyline2D(Line2D line) {
            this.npoints = 2;
            this.xpoints = new float[2];
            this.ypoints = new float[2];
            this.xpoints[0] = (float)line.getX1();
            this.xpoints[1] = (float)line.getX2();
            this.ypoints[0] = (float)line.getY1();
            this.ypoints[1] = (float)line.getY2();
            this.calculatePath();
        }

        public void reset() {
            this.npoints = 0;
            this.bounds = null;
            this.path = new GeneralPath();
            this.closedPath = null;
        }

        public Object clone() {
            Polyline2D pol = new Polyline2D();
            for (int i = 0; i < this.npoints; ++i) {
                pol.addPoint(this.xpoints[i], this.ypoints[i]);
            }
            return pol;
        }

        private void calculatePath() {
            this.path = new GeneralPath();
            this.path.moveTo(this.xpoints[0], this.ypoints[0]);
            for (int i = 1; i < this.npoints; ++i) {
                this.path.lineTo(this.xpoints[i], this.ypoints[i]);
            }
            this.bounds = this.path.getBounds2D();
            this.closedPath = null;
        }

        private void updatePath(float x, float y) {
            this.closedPath = null;
            if (this.path == null) {
                this.path = new GeneralPath(0);
                this.path.moveTo(x, y);
                this.bounds = new Rectangle2D.Float(x, y, 0.0f, 0.0f);
            } else {
                this.path.lineTo(x, y);
                float _xmax = (float)this.bounds.getMaxX();
                float _ymax = (float)this.bounds.getMaxY();
                float _xmin = (float)this.bounds.getMinX();
                float _ymin = (float)this.bounds.getMinY();
                if (x < _xmin) {
                    _xmin = x;
                } else if (x > _xmax) {
                    _xmax = x;
                }
                if (y < _ymin) {
                    _ymin = y;
                } else if (y > _ymax) {
                    _ymax = y;
                }
                this.bounds = new Rectangle2D.Float(_xmin, _ymin, _xmax - _xmin, _ymax - _ymin);
            }
        }

        public void addPoint(Point2D p) {
            this.addPoint((float)p.getX(), (float)p.getY());
        }

        public void addPoint(float x, float y) {
            if (this.npoints == this.xpoints.length) {
                float[] tmp = new float[this.npoints * 2];
                System.arraycopy(this.xpoints, 0, tmp, 0, this.npoints);
                this.xpoints = tmp;
                tmp = new float[this.npoints * 2];
                System.arraycopy(this.ypoints, 0, tmp, 0, this.npoints);
                this.ypoints = tmp;
            }
            this.xpoints[this.npoints] = x;
            this.ypoints[this.npoints] = y;
            ++this.npoints;
            this.updatePath(x, y);
        }

        @Override
        public Rectangle getBounds() {
            if (this.bounds == null) {
                return null;
            }
            return this.bounds.getBounds();
        }

        private void updateComputingPath() {
            if (this.npoints >= 1 && this.closedPath == null) {
                this.closedPath = (GeneralPath)this.path.clone();
                this.closedPath.closePath();
            }
        }

        public boolean contains(Point p) {
            return false;
        }

        @Override
        public boolean contains(double x, double y) {
            return false;
        }

        public boolean contains(int x, int y) {
            return false;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return this.bounds;
        }

        @Override
        public boolean contains(Point2D p) {
            return false;
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            if (this.npoints <= 0 || !this.bounds.intersects(x, y, w, h)) {
                return false;
            }
            this.updateComputingPath();
            return this.closedPath.intersects(x, y, w, h);
        }

        @Override
        public boolean intersects(Rectangle2D r) {
            return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            return false;
        }

        @Override
        public boolean contains(Rectangle2D r) {
            return false;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            if (this.path == null) {
                return null;
            }
            return this.path.getPathIterator(at);
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at, double flatness) {
            return this.path.getPathIterator(at);
        }
    }

    public static class LogFunction {
        double _a;
        double _b;
        double[] _xarray;
        double[] _yarray;
        double _meanX;
        double _meanY;
        double _varX;
        double _varY;
        double _covXY;

        public LogFunction(double[] xarray, double[] yarray) {
            this._xarray = new double[xarray.length];
            this._yarray = new double[yarray.length];
            for (int i = 0; i < xarray.length; ++i) {
                this._yarray[i] = Math.log10(yarray[i]);
                this._xarray[i] = Math.log10(xarray[i]);
            }
            this.fitLogData();
        }

        private void fitLogData() {
            this._meanX = this.mean(this._xarray);
            this._meanY = this.mean(this._yarray);
            this._varX = this.var(this._xarray, this._meanX);
            this._covXY = this.cov();
            this._a = this._covXY / this._varX;
            this._b = this._yarray[0] - this._a * this._xarray[0];
        }

        public double logEquation(double x) {
            return Math.pow(10.0, this._a * Math.log10(x) + this._b);
        }

        protected double logEquationSlope(double x) {
            return this._a * Math.pow(10.0, this._a * Math.log10(x) + this._b) / x;
        }

        private double cov() {
            double sumXY = 0.0;
            for (int i = 0; i < this._xarray.length; ++i) {
                sumXY += (this._xarray[i] - this._meanX) * (this._yarray[i] - this._meanY);
            }
            return sumXY / (double)(this._xarray.length - 1);
        }

        private double mean(double[] array) {
            double sum = 0.0;
            for (int i = 0; i < array.length; ++i) {
                sum += array[i];
            }
            return sum / (double)array.length;
        }

        private double var(double[] array, double mean) {
            double sum = 0.0;
            for (int i = 0; i < array.length; ++i) {
                sum += Math.pow(array[i] - mean, 2.0);
            }
            return sum / (double)(array.length - 1);
        }
    }
}

