/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Axis;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.TSAxis;
import hec.gfx2d.G2dLineMarkerPropertiesPanel;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dMarkerValueLabelPropertiesPanel;
import hec.gfx2d.G2dPaint;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.G2dResolutionConst;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.Viewport;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJMenuLabel;
import rma.util.FillPatternFactory;

public class G2dMarkerLine
implements ActionListener {
    private static final int PIXEL_TOLERANCE = 2;
    G2dMarkerProperties _properties = new G2dMarkerProperties();
    Scale _scale = null;
    JPopupMenu _popupMenu = null;
    Viewport _viewport = null;

    public G2dMarkerLine(G2dMarkerProperties prop, Scale s) {
        if (s == null || prop == null) {
            throw new IllegalArgumentException("NULL Constructor Parameters");
        }
        this._properties = prop;
        this._scale = s;
        this.createPopupMenu();
    }

    public G2dMarkerLine(Scale s) {
        if (s == null) {
            throw new IllegalArgumentException("NULL Constructor Parameters");
        }
        this._scale = s;
        this.createPopupMenu();
    }

    public void setScale(Scale s) {
        if (s == null) {
            return;
        }
        this._scale = s;
    }

    public double getMarkerValue() {
        return this._properties.markerValue;
    }

    public Scale getScale() {
        return this._scale;
    }

    private void createPopupMenu() {
        this._popupMenu = new JPopupMenu("Marker Properties");
        RmaJMenuLabel label = new RmaJMenuLabel("Marker Line");
        Font f = label.getFont();
        f = new Font(f.getName(), 2, f.getSize());
        label.setFont(f);
        this._popupMenu.add(label);
        this._popupMenu.addSeparator();
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.setName("EDIT_PROPERTIES");
        jm.addActionListener(this);
        this._popupMenu.add(jm);
        jm = new JMenuItem("Delete");
        jm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                G2dMarkerLine.this._viewport.deleteMarkerLine(G2dMarkerLine.this);
                G2dMarkerLine.this._viewport.setDirty();
                G2dMarkerLine.this._viewport.repaint();
            }
        });
        this._popupMenu.add(jm);
    }

    public G2dMarkerProperties getProperties() {
        return this._properties;
    }

    public void setProperties(G2dMarkerProperties propValue) {
        if (propValue == null) {
            return;
        }
        this._properties = propValue;
    }

    public void setViewport(Viewport g) {
        this._viewport = g;
    }

    public void drawLine(Graphics g, Rectangle clipRect) {
        Rectangle2D.Double worldRegion;
        Axis xAxis;
        int[] xarray = new int[2];
        int[] yarray = new int[2];
        FontMetrics fm = g.getFontMetrics();
        g = g.create();
        g.setClip(null);
        int scale = 1;
        if (this._viewport != null) {
            int g2dResolution = this._viewport._parent.getDeviceResoultion();
            scale = g2dResolution / G2dResolutionConst.PRINTER_SCALE;
        }
        if ((xAxis = this._viewport.getAxis("X1")) == null) {
            xAxis = this._viewport.getAxis("X2");
        }
        if (xAxis == null) {
            return;
        }
        Axis yAxis = this._viewport.getAxis("Y1");
        if (yAxis == null) {
            yAxis = this._viewport.getAxis("Y2");
        }
        if (yAxis == null) {
            return;
        }
        this._properties.markerLabel.trim();
        if (this._properties.drawOnAxis == 1) {
            xarray[1] = (clipRect.x + clipRect.width) * scale;
            xarray[0] = clipRect.x;
            yarray[0] = this._scale.n2y(this._properties.markerValue);
            yarray[1] = this._scale.n2y(this._properties.markerValue);
            double y = this._properties.markerValue;
            double height = this._properties.fillType == 2 ? y - yAxis.getMin() : yAxis.getMax() - y;
            worldRegion = new Rectangle2D.Double(xAxis.getMin(), yAxis.getMin(), xAxis.getMax() - xAxis.getMin(), height);
        } else {
            yarray[1] = clipRect.y + clipRect.height;
            yarray[0] = clipRect.y;
            xarray[0] = this._scale.e2x(this._properties.markerValue);
            xarray[1] = this._scale.e2x(this._properties.markerValue);
            double x = this._properties.markerValue;
            double width = this._properties.fillType == 2 ? x - xAxis.getMin() : xAxis.getMax() - x;
            worldRegion = new Rectangle2D.Double(x, yAxis.getMin(), width, yAxis.getMax() - yAxis.getMin());
        }
        int xpos = 0;
        int ypos = 0;
        int stringWidth = 0;
        if (this._properties.markerLabel != null && !this._properties.markerLabel.equals("") && this._properties.drawLabel) {
            Font f;
            Font oldFont = g.getFont();
            if (this._properties.labelFont == null) {
                f = new Font(oldFont.getName(), oldFont.getStyle(), 10 * scale);
            } else {
                f = this._properties.labelFont;
                f = new Font(f.getName(), f.getStyle(), f.getSize() * scale);
            }
            g.setFont(f);
            fm = g.getFontMetrics(f);
            stringWidth = fm.stringWidth(this._properties.markerLabel.trim());
            int descent = fm.getDescent();
            int ascent = fm.getAscent();
            int height = fm.getHeight();
            if (this._properties.drawOnAxis == 1) {
                switch (this._properties.labelAlign) {
                    case 0: {
                        xpos = xarray[0] + 10;
                        break;
                    }
                    case 1: {
                        xpos = xarray[1] - 10 - stringWidth;
                        break;
                    }
                    case 2: {
                        xpos = (xarray[1] + xarray[0]) / 2 - stringWidth / 2;
                    }
                }
                switch (this._properties.labelPosition) {
                    case 0: {
                        ypos = yarray[0] - descent - (int)this._properties.lineWidth;
                        break;
                    }
                    case 1: {
                        ypos = yarray[0] + ascent + (int)this._properties.lineWidth;
                        break;
                    }
                    case 2: {
                        ypos = yarray[0] + ascent / 2 - 1;
                    }
                }
            } else {
                switch (this._properties.labelPosition) {
                    case 1: {
                        xpos = xarray[0] + ascent + (int)this._properties.lineWidth;
                        break;
                    }
                    case 0: {
                        xpos = xarray[0] - descent - (int)this._properties.lineWidth;
                        break;
                    }
                    case 2: {
                        xpos = xarray[0] + ascent / 2 - 2;
                    }
                }
                switch (this._properties.labelAlign) {
                    case 1: {
                        ypos = yarray[0] + 10 + stringWidth;
                        break;
                    }
                    case 0: {
                        ypos = yarray[1] - 10;
                        break;
                    }
                    case 2: {
                        ypos = (yarray[1] + yarray[0]) / 2 + stringWidth / 2 - 1;
                    }
                }
            }
        }
        if (this._properties.drawLine && this._properties.lineWidth > 0.0f) {
            int[] ytemp;
            int[] xtemp;
            if (this._properties.fillType == 2) {
                Paint p;
                xtemp = new int[xarray.length + 3];
                ytemp = new int[xarray.length + 3];
                System.arraycopy(xarray, 0, xtemp, 0, xarray.length);
                System.arraycopy(yarray, 0, ytemp, 0, xarray.length);
                if (this._properties.drawOnAxis == 1) {
                    xtemp[xarray.length] = xtemp[xarray.length - 1];
                    ytemp[xarray.length] = clipRect.y + clipRect.height;
                    xtemp[xarray.length + 1] = xtemp[0];
                    ytemp[xarray.length + 1] = clipRect.y + clipRect.height;
                    xtemp[xarray.length + 2] = xtemp[0];
                    ytemp[xarray.length + 2] = ytemp[0];
                } else {
                    xtemp[xarray.length] = clipRect.x;
                    ytemp[yarray.length] = ytemp[yarray.length - 1];
                    xtemp[xarray.length + 1] = clipRect.x;
                    ytemp[xarray.length + 1] = clipRect.y;
                    xtemp[xarray.length + 2] = xtemp[0];
                    ytemp[xarray.length + 2] = ytemp[0];
                }
                Paint paint = p = this._properties.fillPaint != null ? this._properties.fillPaint : FillPatternFactory.createFillPattern(this._properties.fillPattern, this._properties.fillColor);
                if (p instanceof G2dPaint) {
                    HashMap<String, Object> drawParameters = new HashMap<String, Object>();
                    drawParameters.put("WORLD_BOUNDS", worldRegion);
                    drawParameters.put("SCALE", this._scale);
                    ((G2dPaint)p).setPaintParameters(drawParameters);
                }
                Gfx2dDrawUtil.fillPolygonClipped(g, clipRect, xtemp, ytemp, xtemp.length, p);
            } else if (this._properties.fillType == 1) {
                Paint p;
                xtemp = new int[xarray.length + 3];
                ytemp = new int[yarray.length + 3];
                System.arraycopy(xarray, 0, xtemp, 0, xarray.length);
                System.arraycopy(yarray, 0, ytemp, 0, yarray.length);
                if (this._properties.drawOnAxis == 1) {
                    xtemp[xarray.length] = xtemp[xarray.length - 1];
                    ytemp[xarray.length] = clipRect.y;
                    xtemp[xarray.length + 1] = xtemp[0];
                    ytemp[xarray.length + 1] = 0;
                    xtemp[xarray.length + 2] = xtemp[0];
                    ytemp[xarray.length + 2] = ytemp[0];
                } else {
                    xtemp[xarray.length] = clipRect.x + clipRect.width;
                    ytemp[xarray.length] = ytemp[yarray.length - 1];
                    xtemp[xarray.length + 1] = clipRect.x + clipRect.width;
                    ytemp[xarray.length + 1] = ytemp[0];
                    xtemp[xarray.length + 2] = xtemp[0];
                    ytemp[xarray.length + 2] = ytemp[0];
                }
                Paint paint = p = this._properties.fillPaint != null ? this._properties.fillPaint : FillPatternFactory.createFillPattern(this._properties.fillPattern, this._properties.fillColor);
                if (p instanceof G2dPaint) {
                    HashMap<String, Object> drawParameters = new HashMap<String, Object>();
                    drawParameters.put("WORLD_BOUNDS", worldRegion);
                    drawParameters.put("SCALE", this._scale);
                    ((G2dPaint)p).setPaintParameters(drawParameters);
                }
                Gfx2dDrawUtil.fillPolygonClipped(g, clipRect, xtemp, ytemp, xtemp.length, p);
            }
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                Stroke oldStroke = g2d.getStroke();
                BasicStroke bs = new BasicStroke(this._properties.lineWidth, 0, 0, 10.0f, this._properties.lineStylePattern, 0.0f);
                g2d.setStroke(bs);
                g.setColor(this._properties.lineColor);
                if (this._properties.labelPosition != 2 && this._properties.drawOnAxis == 1 || this._properties.labelPosition != 2 && this._properties.drawOnAxis == 0) {
                    Gfx2dDrawUtil.plotPolyLineClipped(g2d, clipRect, xarray, yarray, xarray.length);
                } else {
                    int[] tempArray = new int[2];
                    if (this._properties.drawOnAxis == 1) {
                        tempArray[0] = xarray[0];
                        tempArray[1] = xpos - 5;
                        Gfx2dDrawUtil.plotPolyLineClipped(g2d, clipRect, tempArray, yarray, 2);
                        tempArray[0] = xpos + fm.stringWidth(this._properties.markerLabel);
                        tempArray[1] = xarray[1];
                        Gfx2dDrawUtil.plotPolyLineClipped(g2d, clipRect, tempArray, yarray, 2);
                    } else {
                        tempArray[0] = yarray[0];
                        tempArray[1] = ypos - stringWidth;
                        Gfx2dDrawUtil.plotPolyLineClipped(g2d, clipRect, xarray, tempArray, 2);
                        tempArray[0] = ypos + 2;
                        tempArray[1] = yarray[1];
                        Gfx2dDrawUtil.plotPolyLineClipped(g2d, clipRect, xarray, tempArray, 2);
                    }
                }
                g2d.setStroke(oldStroke);
            } else {
                g.setColor(this._properties.lineColor);
                Gfx2dDrawUtil.plotPolyLineClipped(g, clipRect, xarray, yarray, xarray.length);
            }
        }
        if (this._properties.drawLabel) {
            g.setColor(this._properties.labelColor);
            if (g instanceof Graphics2D && this._properties.drawOnAxis == 0) {
                g.translate(xpos, ypos);
                ((Graphics2D)g).rotate(-1.5707963267948966);
                Gfx2dDrawUtil.drawString(this._viewport, g, this._properties.markerLabel, 0, 0);
                ((Graphics2D)g).rotate(1.5707963267948966);
                g.translate(-xpos, -ypos);
            } else {
                Gfx2dDrawUtil.drawString(this._viewport, g, this._properties.markerLabel, xpos, ypos);
            }
        }
        g.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem;
        Object obj = e.getSource();
        if (obj instanceof JMenuItem && (menuItem = (JMenuItem)obj).getName().equals("EDIT_PROPERTIES")) {
            this.editMarkerLineProperties();
        }
    }

    public void editMarkerLineProperties() {
        G2dPropertiesDlg dialog = this.createPropertiesDialog();
        PropertiesOKListener listener = new PropertiesOKListener();
        dialog.addOKListener(listener);
        dialog.setVisible(true);
    }

    public G2dPropertiesDlg createPropertiesDialog() {
        int axisType = 1;
        if (this._properties.drawOnAxis == 0 && this._scale.getAxis(0) instanceof TSAxis) {
            axisType = G2dMarkerValueLabelPropertiesPanel.TIME_AXIS;
        }
        G2dLineMarkerPropertiesPanel panel = new G2dLineMarkerPropertiesPanel();
        SimpleTimeZone tz = this._scale.getGmtOffset() != Integer.MIN_VALUE ? new SimpleTimeZone(this._scale.getGmtOffset() * 1000 * 60 * 60, "Marker Time Zone") : null;
        panel.setAxisType(axisType);
        panel.setData(this._properties, tz);
        Window w = null;
        if (this._viewport != null) {
            w = SwingUtilities.windowForComponent(this._viewport);
        }
        G2dPropertiesDlg dialog = null;
        dialog = w instanceof Frame ? new G2dPropertiesDlg((Frame)w, false, "Edit Marker Line Properties", new DefaultJPanel[]{panel}) : new G2dPropertiesDlg((Dialog)w, false, "Edit Marker Line Properties", new DefaultJPanel[]{panel});
        return dialog;
    }

    public boolean contains(LocalPt pt) {
        return this._properties.drawOnAxis == 1 ? pt.y >= this._scale.n2y(this._properties.markerValue) - 2 && pt.y <= this._scale.n2y(this._properties.markerValue) + 2 : pt.x <= this._scale.e2x(this._properties.markerValue) + 2 && pt.x >= this._scale.e2x(this._properties.markerValue) - 2;
    }

    public void showPopup(Component c2, int x, int y) {
        Component c1 = this._popupMenu.getComponent(0);
        if (c1 instanceof RmaJMenuLabel) {
            RmaJMenuLabel title = (RmaJMenuLabel)c1;
            String name = this._properties.markerLabel;
            if (name != null && this._properties.drawLabel) {
                title.setText("Marker Line " + name);
            }
        }
        this._popupMenu.show(c2, x, y);
    }

    public String toString() {
        Object tostring;
        Object object = tostring = this._properties.drawOnAxis == 0 ? "X Axis Marker " : "Y Axis Marker ";
        if (this._properties.drawLabel) {
            tostring = (String)tostring + this._properties.getLabel();
        }
        return tostring;
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (G2dMarkerLine.this._viewport != null) {
                Window w = SwingUtilities.windowForComponent(G2dMarkerLine.this._viewport);
                G2dMarkerLine.this._viewport.setDirty();
                if (w != null) {
                    w.repaint();
                }
            }
        }
    }
}

