/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Axis;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.TSAxis;
import hec.gfx2d.G2dMarkerPointProperties;
import hec.gfx2d.G2dMarkerPointPropertiesPanel;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.G2dResolutionConst;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.Viewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.SimpleTimeZone;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJMenuLabel;

public class G2dMarkerPoint
implements ActionListener {
    private static final int PIXEL_TOLERANCE = 2;
    G2dMarkerPointProperties _properties = new G2dMarkerPointProperties();
    Scale _scale = null;
    JPopupMenu _popupMenu = null;
    Viewport _viewport = null;
    private transient LocalPt _lpt = new LocalPt();

    public G2dMarkerPoint(G2dMarkerPointProperties prop, Scale s) {
        if (s == null || prop == null) {
            throw new IllegalArgumentException("NULL Constructor Parameters");
        }
        this._properties = prop;
        this._scale = s;
        this.createPopupMenu();
    }

    public G2dMarkerPoint(Scale s) {
        if (s == null) {
            throw new IllegalArgumentException("NULL Constructor Parameters");
        }
        this._scale = s;
        this.createPopupMenu();
    }

    public void setScale(Scale s) {
        if (s == null) {
            return;
        }
        this._scale = s;
    }

    public double getMarkerXValue() {
        return this._properties.markerXValue;
    }

    public double getMarkerYValue() {
        return this._properties.markerYValue;
    }

    public Scale getScale() {
        return this._scale;
    }

    private void createPopupMenu() {
        this._popupMenu = new JPopupMenu("Marker Properties");
        RmaJMenuLabel label = new RmaJMenuLabel("Marker Point");
        Font f = label.getFont();
        f = new Font(f.getName(), 2, f.getSize());
        label.setFont(f);
        this._popupMenu.add(label);
        this._popupMenu.addSeparator();
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.setName("EDIT_PROPERTIES");
        jm.addActionListener(this);
        this._popupMenu.add(jm);
        jm = new JMenuItem("Delete");
        jm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                G2dMarkerPoint.this._viewport.deleteMarkerPoint(G2dMarkerPoint.this);
                G2dMarkerPoint.this._viewport.setDirty();
                G2dMarkerPoint.this._viewport.repaint();
            }
        });
        this._popupMenu.add(jm);
    }

    public G2dMarkerPointProperties getProperties() {
        return this._properties;
    }

    public void setProperties(G2dMarkerPointProperties propValue) {
        if (propValue == null) {
            return;
        }
        this._properties = propValue;
    }

    public void setViewport(Viewport g) {
        this._viewport = g;
    }

    public void drawPoint(Graphics g, Rectangle clipRect) {
        if (!this._properties.drawPoint) {
            return;
        }
        Scale scl = this.getScale();
        int x = scl.e2x(this._properties.markerXValue);
        int y = scl.n2y(this._properties.markerYValue);
        int[] tempXData = new int[]{x};
        int[] tempYData = new int[]{y};
        boolean[] drawPoints = new boolean[]{true};
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke oldStroke = g2d.getStroke();
            Gfx2dDrawUtil.drawPoints(g2d, tempXData, tempYData, 1, drawPoints, this._properties.getPointStyle(), this._properties.getPointColor(), this._properties.getFillColor(), this._properties.getPointSize(), false, 0, 0);
            g2d.setStroke(oldStroke);
        } else {
            Gfx2dDrawUtil.drawPoints(g, tempXData, tempYData, 1, drawPoints, this._properties.getPointStyle(), this._properties.getPointColor(), this._properties.getFillColor(), this._properties.getPointSize(), false, 0, 0);
        }
        if (this._properties.drawLabel && this._properties.markerLabel != null && this._properties.markerLabel.length() > 0) {
            int scale = 1;
            if (this._viewport != null) {
                int g2dResolution = this._viewport._parent.getDeviceResoultion();
                scale = g2dResolution / G2dResolutionConst.PRINTER_SCALE;
            }
            FontMetrics fm = g.getFontMetrics();
            String txt = this._properties.markerLabel.trim();
            int xpos = 0;
            int ypos = 0;
            int stringWidth = 0;
            Font oldFont = g.getFont();
            Font f = this._properties.labelFont == null ? new Font(oldFont.getName(), oldFont.getStyle(), 10 * scale) : this._properties.labelFont;
            g.setFont(f);
            fm = g.getFontMetrics(f);
            stringWidth = fm.stringWidth(txt);
            int descent = fm.getDescent();
            int ascent = fm.getAscent();
            int height = fm.getHeight();
            switch (this._properties.labelAlign) {
                case 0: {
                    xpos = tempXData[0] + 10;
                    break;
                }
                case 1: {
                    xpos = tempXData[0] - 10 - stringWidth;
                    break;
                }
                case 2: {
                    xpos = tempXData[0] - stringWidth / 2;
                }
            }
            switch (this._properties.labelPosition) {
                case 0: {
                    ypos = tempYData[0] - descent - this._properties.pointSize;
                    break;
                }
                case 1: {
                    ypos = tempYData[0] + ascent + this._properties.pointSize;
                    break;
                }
                case 2: {
                    ypos = tempYData[0] + ascent / 2 - 1;
                }
            }
            Color oldColor = g.getColor();
            g.setColor(this._properties.labelColor);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            Gfx2dDrawUtil.drawString(this._viewport, g, this._properties.markerLabel, xpos, ypos);
            g.setColor(oldColor);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem;
        Object obj = e.getSource();
        if (obj instanceof JMenuItem && (menuItem = (JMenuItem)obj).getName().equals("EDIT_PROPERTIES")) {
            this.editMarkerLineProperties();
        }
    }

    public void editMarkerLineProperties() {
        G2dPropertiesDlg dialog = this.createPropertiesDialog();
        PropertiesOKListener listener = new PropertiesOKListener();
        dialog.addOKListener(listener);
        dialog.setVisible(true);
    }

    public G2dPropertiesDlg createPropertiesDialog() {
        int yAxisType = G2dMarkerPointPropertiesPanel.NUMERIC_AXIS;
        int xAxisType = G2dMarkerPointPropertiesPanel.TIME_AXIS;
        Axis yaxis = this._viewport.getAxis("y1");
        Axis xaxis = this._viewport.getAxis("x1");
        if (!(xaxis instanceof TSAxis)) {
            xAxisType = G2dMarkerPointPropertiesPanel.NUMERIC_AXIS;
        }
        if (yaxis instanceof TSAxis) {
            yAxisType = G2dMarkerPointPropertiesPanel.TIME_AXIS;
        }
        G2dMarkerPointPropertiesPanel panel = new G2dMarkerPointPropertiesPanel();
        SimpleTimeZone tz = this._scale.getGmtOffset() != Integer.MIN_VALUE ? new SimpleTimeZone(this._scale.getGmtOffset() * 1000 * 60 * 60, "Marker Time Zone") : null;
        panel.setYAxisType(yAxisType);
        panel.setXAxisType(xAxisType);
        panel.setData(this._properties, tz);
        panel.fillPanel();
        Window w = null;
        if (this._viewport != null) {
            w = SwingUtilities.windowForComponent(this._viewport);
        }
        G2dPropertiesDlg dialog = null;
        dialog = w instanceof Frame ? new G2dPropertiesDlg((Frame)w, false, "Edit Marker Line Properties", new DefaultJPanel[]{panel}) : new G2dPropertiesDlg((Dialog)w, false, "Edit Marker Line Properties", new DefaultJPanel[]{panel});
        dialog.setModified(false);
        return dialog;
    }

    public boolean contains(LocalPt pt) {
        if (this._properties == null) {
            return false;
        }
        int pixTol = this._properties.pointSize;
        return pt.y >= this._scale.n2y(this._properties.markerYValue) - pixTol && pt.y <= this._scale.n2y(this._properties.markerYValue) + pixTol && pt.x <= this._scale.e2x(this._properties.markerXValue) + pixTol && pt.x >= this._scale.e2x(this._properties.markerXValue) - pixTol;
    }

    public void showPopup(Component c2, int x, int y) {
        Component c1 = this._popupMenu.getComponent(0);
        if (c1 instanceof RmaJMenuLabel) {
            RmaJMenuLabel title = (RmaJMenuLabel)c1;
            String name = this._properties.markerLabel;
            if (name != null && this._properties.drawLabel) {
                title.setText("Marker Line " + name);
            }
        }
        this._popupMenu.show(c2, x, y);
    }

    public String toString() {
        Object tostring;
        Object object = tostring = this._properties.drawOnAxis == 0 ? "X Axis Marker " : "Y Axis Marker ";
        if (this._properties.drawLabel) {
            tostring = (String)tostring + this._properties.getLabel();
        }
        return tostring;
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (G2dMarkerPoint.this._viewport != null) {
                Window w = SwingUtilities.windowForComponent(G2dMarkerPoint.this._viewport);
                G2dMarkerPoint.this._viewport.setDirty();
                if (w != null) {
                    w.repaint();
                }
            }
        }
    }
}

