/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dFont;
import hec.gfx2d.LineLabelProperties;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.PlotProperties;
import hec.gfx2d.PropertiesSerializer;
import hec.io.AsciiSerializable;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import rma.swing.RmaColor;
import rma.util.RMAIO;

public class G2dMarkerPointProperties
extends PlotProperties
implements AsciiSerializable,
LineLabelProperties,
Cloneable {
    private static final int DEFAULT_SYMBOL = 1;
    private static final String CLS_NAME = "G2dMarker";
    private static final String MARKER_X_VALUE = "markerXValue";
    private static final String MARKER_Y_VALUE = "markerYValue";
    private static final String MARKER_LABEL = "markerLabel";
    private static final String DRAW_ON_AXIS = "drawOnAxis";
    private static final String POINT_COLOR = "pointColor";
    private static final String FILL_COLOR = "fillColor";
    private static final String DRAW_POINT = "drawPoint";
    private static final String DRAW_LABEL = "drawLabel";
    private static final String POINT_SIZE = "pointSize";
    private static final String LABEL_POSITION = "labelPosition";
    private static final String LABEL_ALIGNMENT = "labelAlignment";
    private static final String EDITABLE_PROPERTIES = "editableProperties";
    private static final String LABEL_COLOR = "labelColor";
    private static final String LABEL_FONT = "labelFont";
    private static final String POINT_TYPE = "pointStyle";
    public double markerXValue;
    public double markerYValue;
    public String markerLabel;
    public int drawOnAxis;
    public Color pointColor;
    public Color fillColor;
    public boolean drawPoint;
    public boolean drawLabel;
    public int pointSize;
    public int labelPosition;
    public int labelAlign;
    public boolean editableProperties;
    public Color labelColor = Color.BLACK;
    public Font labelFont = G2dFont.newFont("Dialog", 0, 10);
    public int pointStyle;
    public static final String MARKER_BEGIN = "MarkerPoint Begin";
    public static final String MARKER_END = "MarkerPoint End";

    public G2dMarkerPointProperties() {
        this(CLS_NAME);
    }

    protected G2dMarkerPointProperties(String cls) {
        this.markerXValue = G2dMarkerPointProperties.getDefaultDouble(cls + MARKER_X_VALUE);
        this.markerYValue = G2dMarkerPointProperties.getDefaultDouble(cls + MARKER_Y_VALUE);
        this.markerLabel = G2dMarkerPointProperties.getDefaultString(cls + MARKER_LABEL);
        this.drawOnAxis = G2dMarkerPointProperties.getDefaultInt(cls + DRAW_ON_AXIS);
        this.pointColor = G2dMarkerPointProperties.getDefaultColor(cls + POINT_COLOR);
        this.fillColor = G2dMarkerPointProperties.getDefaultColor(cls + FILL_COLOR);
        this.drawPoint = G2dMarkerPointProperties.getDefaultBoolean(cls + DRAW_POINT);
        this.drawLabel = G2dMarkerPointProperties.getDefaultBoolean(cls + DRAW_LABEL);
        this.pointSize = G2dMarkerPointProperties.getDefaultInt(cls + POINT_SIZE);
        this.labelPosition = G2dMarkerPointProperties.getDefaultInt(cls + LABEL_POSITION);
        this.labelAlign = G2dMarkerPointProperties.getDefaultInt(cls + LABEL_ALIGNMENT);
        this.editableProperties = G2dMarkerPointProperties.getDefaultBoolean(cls + EDITABLE_PROPERTIES);
        this.labelColor = G2dMarkerPointProperties.getDefaultColor(cls + LABEL_COLOR);
        this.labelFont = G2dMarkerPointProperties.getDefaultFont(cls + LABEL_FONT);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof G2dMarkerPointProperties)) {
            return false;
        }
        G2dMarkerPointProperties tObj = (G2dMarkerPointProperties)obj;
        boolean equals = this.markerXValue == tObj.markerXValue && this.markerYValue == tObj.markerYValue;
        equals &= this.equals(this.markerLabel, tObj.markerLabel);
        equals &= this.drawOnAxis == tObj.drawOnAxis;
        equals &= this.drawPoint == tObj.drawPoint;
        equals &= this.drawLabel == tObj.drawLabel;
        equals &= this.pointSize == tObj.pointSize;
        equals &= this.labelPosition == tObj.labelPosition;
        equals &= this.labelAlign == tObj.labelAlign;
        equals &= this.editableProperties == tObj.editableProperties;
        equals &= this.equals(this.pointColor, tObj.pointColor);
        equals &= this.equals(this.fillColor, tObj.fillColor);
        equals &= this.equals(this.labelColor, tObj.labelColor);
        equals &= this.equals(this.labelFont, tObj.labelFont);
        return equals &= this.equals(this.pointStyle, tObj.pointStyle);
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    static void init(String cls) {
        G2dMarkerPointProperties.setDefault(cls + MARKER_X_VALUE, 0.0);
        G2dMarkerPointProperties.setDefault(cls + MARKER_Y_VALUE, 0.0);
        G2dMarkerPointProperties.setDefault(cls + MARKER_LABEL, "");
        G2dMarkerPointProperties.setDefault(cls + DRAW_ON_AXIS, 0);
        G2dMarkerPointProperties.setDefault(cls + POINT_COLOR, Color.black);
        G2dMarkerPointProperties.setDefault(cls + FILL_COLOR, Color.black);
        G2dMarkerPointProperties.setDefault(cls + DRAW_POINT, true);
        G2dMarkerPointProperties.setDefault(cls + DRAW_LABEL, false);
        G2dMarkerPointProperties.setDefault(cls + POINT_SIZE, 7);
        G2dMarkerPointProperties.setDefault(cls + LABEL_POSITION, 0);
        G2dMarkerPointProperties.setDefault(cls + LABEL_ALIGNMENT, 0);
        G2dMarkerPointProperties.setDefault(cls + EDITABLE_PROPERTIES, true);
        G2dMarkerPointProperties.setDefault(cls + LABEL_COLOR, Color.black);
        G2dMarkerPointProperties.setDefault(cls + LABEL_FONT, G2dFont.newFont("Dialog", 0, 10));
        G2dMarkerPointProperties.setDefault(cls + POINT_TYPE, 1);
    }

    @Override
    public void setModified(boolean modified) {
    }

    public void setMarkerLabel(String s) {
        this.markerLabel = s;
    }

    public void setPointColor(Color c2) {
        this.pointColor = c2;
    }

    public void setFillColor(Color c2) {
        this.fillColor = c2;
    }

    public void setDrawPoint(boolean b) {
        this.drawPoint = b;
    }

    public void setDrawLabel(boolean b) {
        this.drawLabel = b;
    }

    public void setPointSize(int i) {
        this.pointSize = i;
    }

    @Override
    public void setLabelPosition(int i) {
        this.labelPosition = i;
    }

    public void setLabelAlign(int i) {
        this.labelAlign = i;
    }

    public void setEditableProperties(boolean b) {
        this.editableProperties = b;
    }

    public void setLabelColor(Color c2) {
        this.labelColor = c2;
    }

    public void setLabelFont(Font f) {
        this.labelFont = f;
    }

    public double getMarkerXValue() {
        return this.markerXValue;
    }

    public double getMarkerYValue() {
        return this.markerYValue;
    }

    public String getMarkerLabel() {
        return this.markerLabel;
    }

    public int getDrawOnAxis() {
        return this.drawOnAxis;
    }

    public Color getPointColor() {
        return this.pointColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public boolean getDrawPoint() {
        return this.drawPoint;
    }

    public boolean getDrawLabel() {
        return this.drawLabel;
    }

    public int getPointSize() {
        return this.pointSize;
    }

    @Override
    public int getLabelPosition() {
        return this.labelPosition;
    }

    public int getLabelAlign() {
        return this.labelAlign;
    }

    public boolean getEditableProperties() {
        return this.editableProperties;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public static String getFileName() {
        return "MarkerPointDefault";
    }

    public int getPointStyle() {
        return this.pointStyle;
    }

    public void setPointStyle(int sType) {
        this.pointStyle = sType;
    }

    public void setDrawOnAxis(int propValue) {
        if (propValue != 0 && propValue != 1) {
            throw new IllegalArgumentException("Axis must value must either be Axis.XAXIS or Axis.YAXIS");
        }
        this.drawOnAxis = propValue;
    }

    public void setMarkerXValue(double propValue) {
        double temp = this.markerXValue;
        this.markerXValue = propValue;
    }

    public void setMarkerYValue(double yValue) {
        double temp = this.markerYValue;
        this.markerYValue = yValue;
    }

    public boolean drawLine() {
        return this.drawPoint;
    }

    @Override
    public void setHasLabel(boolean b) {
        this.drawLabel = b;
    }

    @Override
    public void setLabelAlignment(int align) {
        this.labelAlign = align;
    }

    @Override
    public void setLabel(String lbl) {
        this.markerLabel = lbl;
    }

    @Override
    public int getLabelAlignment() {
        return this.labelAlign;
    }

    @Override
    public String getLabel() {
        return this.markerLabel;
    }

    @Override
    public boolean hasLabel() {
        return this.drawLabel;
    }

    public static String font2string(Font font) {
        if (font == null) {
            return "null";
        }
        int style = font.getStyle();
        Object styleString = "";
        if ((style & 1) != 0) {
            styleString = (String)styleString + "BOLD";
        }
        if ((style & 2) != 0) {
            styleString = (String)styleString + "ITALIC";
        }
        if (((String)styleString).length() == 0) {
            styleString = "PLAIN";
        }
        return font.getName() + "," + (String)styleString + "," + font.getSize();
    }

    public static Font string2font(String str) {
        String[] parts;
        Font font = null;
        if (str != null && str.length() > 0 && !str.equalsIgnoreCase("null") && (parts = str.split(",")).length > 0) {
            int style = 0;
            int size = 10;
            try {
                if (parts.length > 1) {
                    String styleStr = parts[1].toUpperCase();
                    if (styleStr.indexOf("BOLD") > -1) {
                        style |= 1;
                    }
                    if (styleStr.indexOf("ITALIC") > -1) {
                        style |= 2;
                    }
                    if (parts.length > 2) {
                        size = Integer.parseInt(parts[2]);
                    }
                }
                font = new Font(parts[0], style, size);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return font;
    }

    public void writeProperties(BufferedWriter writer, String endTag) {
        if (writer == null) {
            return;
        }
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        if (!G2dMarkerPointProperties.isDefault(MARKER_X_VALUE, this.markerXValue)) {
            RMAIO.fout(writer, indent + "markerXValue=" + this.markerXValue);
        }
        if (!G2dMarkerPointProperties.isDefault(MARKER_Y_VALUE, this.markerYValue)) {
            RMAIO.fout(writer, indent + "markerYValue=" + this.markerYValue);
        }
        if (!G2dMarkerPointProperties.isDefault(MARKER_LABEL, this.markerLabel)) {
            RMAIO.fout(writer, indent + "markerLabel=" + this.markerLabel);
        }
        if (!G2dMarkerPointProperties.isDefault(DRAW_ON_AXIS, this.drawOnAxis)) {
            RMAIO.fout(writer, indent + "drawOnAxis=" + this.drawOnAxis);
        }
        if (!G2dMarkerPointProperties.isDefault(POINT_COLOR, this.pointColor)) {
            RMAIO.fout(writer, indent + "pointColor=" + RmaColor.color2String(this.pointColor));
        }
        if (!G2dMarkerPointProperties.isDefault(FILL_COLOR, this.fillColor)) {
            RMAIO.fout(writer, indent + "fillColor=" + RmaColor.color2String(this.fillColor));
        }
        if (!G2dMarkerPointProperties.isDefault(DRAW_POINT, this.drawPoint)) {
            RMAIO.fout(writer, indent + "drawPoint=" + this.drawPoint);
        }
        if (!G2dMarkerPointProperties.isDefault(DRAW_LABEL, this.drawLabel)) {
            RMAIO.fout(writer, indent + "drawLabel=" + this.drawLabel);
        }
        if (!G2dMarkerPointProperties.isDefault(POINT_SIZE, this.pointSize)) {
            RMAIO.fout(writer, indent + "pointSize=" + this.pointSize);
        }
        if (!G2dMarkerPointProperties.isDefault(LABEL_POSITION, this.labelPosition)) {
            RMAIO.fout(writer, indent + "labelPosition=" + this.labelPosition);
        }
        if (!G2dMarkerPointProperties.isDefault(LABEL_ALIGNMENT, this.labelAlign)) {
            RMAIO.fout(writer, indent + "labelAlignment=" + this.labelAlign);
        }
        if (!G2dMarkerPointProperties.isDefault(EDITABLE_PROPERTIES, this.editableProperties)) {
            RMAIO.fout(writer, indent + "editableProperties=" + this.editableProperties);
        }
        if (!G2dMarkerPointProperties.isDefault(LABEL_COLOR, this.labelColor)) {
            RMAIO.fout(writer, indent + "labelColor=" + RmaColor.color2String(this.labelColor));
        }
        if (!G2dMarkerPointProperties.isDefault(LABEL_FONT, this.labelFont)) {
            RMAIO.fout(writer, indent + "labelFont=" + G2dMarkerPointProperties.font2string(this.labelFont));
        }
        if (!G2dMarkerPointProperties.isDefault(POINT_TYPE, this.pointStyle)) {
            RMAIO.fout(writer, indent + "pointStyle=" + this.pointStyle);
        }
        PropertiesSerializer.decrementRecursion();
        if (endTag != null) {
            indent = PropertiesSerializer.getIndent();
            RMAIO.fout(writer, indent + endTag);
        }
    }

    public static boolean writeDefaults() {
        return G2dMarkerPointProperties.writeDefaults(CLS_NAME);
    }

    protected static boolean writeDefaults(String cls) {
        BufferedWriter writer = PlotDefaultsManager.getDefaults().getBufferedWriter(G2dMarkerPointProperties.class);
        if (writer == null) {
            return false;
        }
        String indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + MARKER_BEGIN);
        PropertiesSerializer.incrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + "markerXValue=" + G2dMarkerPointProperties.getDefaultDouble(cls + MARKER_X_VALUE));
        RMAIO.fout(writer, indent + "markerYValue=" + G2dMarkerPointProperties.getDefaultDouble(cls + MARKER_Y_VALUE));
        RMAIO.fout(writer, indent + "markerLabel=" + G2dMarkerPointProperties.getDefaultString(cls + MARKER_LABEL));
        RMAIO.fout(writer, indent + "drawOnAxisdrawOnAxis=" + G2dMarkerPointProperties.getDefaultInt(cls + DRAW_ON_AXIS));
        RMAIO.fout(writer, indent + "pointColor=" + RmaColor.color2String(G2dMarkerPointProperties.getDefaultColor(cls + POINT_COLOR)));
        RMAIO.fout(writer, indent + "fillColor=" + RmaColor.color2String(G2dMarkerPointProperties.getDefaultColor(cls + FILL_COLOR)));
        RMAIO.fout(writer, indent + "drawPoint=" + G2dMarkerPointProperties.getDefaultBoolean(cls + DRAW_POINT));
        RMAIO.fout(writer, indent + "drawLabel=" + G2dMarkerPointProperties.getDefaultBoolean(cls + DRAW_LABEL));
        RMAIO.fout(writer, indent + "pointSize=" + G2dMarkerPointProperties.getDefaultInt(cls + POINT_SIZE));
        RMAIO.fout(writer, indent + "labelPosition=" + G2dMarkerPointProperties.getDefaultInt(cls + LABEL_POSITION));
        RMAIO.fout(writer, indent + "labelAlignment=" + G2dMarkerPointProperties.getDefaultInt(cls + LABEL_ALIGNMENT));
        RMAIO.fout(writer, indent + "labelColor=" + RmaColor.color2String(G2dMarkerPointProperties.getDefaultColor(cls + LABEL_COLOR)));
        RMAIO.fout(writer, indent + "labelFont=" + G2dMarkerPointProperties.getDefaultFont(cls + LABEL_FONT));
        RMAIO.fout(writer, indent + "pointStyle=" + G2dMarkerPointProperties.getDefaultInt(cls + POINT_TYPE));
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + MARKER_END);
        try {
            writer.close();
        }
        catch (IOException ioe) {
            System.out.println("Error in writeDefaults()  G2dMarkerPointProperties");
        }
        return true;
    }

    public void readProperties(BufferedReader in, String endTag) {
        if (in == null) {
            return;
        }
        String line = "";
        String param = "";
        String type = "";
        try {
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    if (type.equalsIgnoreCase(MARKER_X_VALUE)) {
                        this.markerXValue = Double.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MARKER_Y_VALUE)) {
                        this.markerYValue = Double.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MARKER_LABEL)) {
                        this.markerLabel = param;
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_ON_AXIS)) {
                        this.drawOnAxis = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(POINT_COLOR)) {
                        this.pointColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_COLOR)) {
                        this.fillColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_POINT)) {
                        this.drawPoint = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_LABEL)) {
                        this.drawLabel = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(POINT_SIZE)) {
                        this.pointSize = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_POSITION)) {
                        this.labelPosition = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_ALIGNMENT)) {
                        this.labelAlign = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(EDITABLE_PROPERTIES)) {
                        this.editableProperties = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_COLOR)) {
                        this.labelColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_FONT)) {
                        this.labelFont = G2dMarkerPointProperties.string2font(param);
                        continue;
                    }
                    if (!type.equalsIgnoreCase(POINT_TYPE)) continue;
                    this.pointStyle = Integer.valueOf(param);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readProperties(BufferedReader) of G2dMarkerPointProperties");
            return;
        }
    }

    public Object clone() {
        try {
            G2dMarkerPointProperties clonedProps = (G2dMarkerPointProperties)super.clone();
            clonedProps.pointColor = new Color(this.pointColor.getRGB());
            clonedProps.fillColor = new Color(this.fillColor.getRGB());
            return clonedProps;
        }
        catch (CloneNotSupportedException e) {
            System.out.println("G2dMarkerLineProperties.clone() Exception:" + e);
            return null;
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean loadDefaults(BufferedReader in) {
        return G2dMarkerPointProperties.loadDefaults(in, MARKER_END, CLS_NAME);
    }

    private static boolean loadDefaults(BufferedReader in, String endTag, String cls) {
        if (in == null) {
            return false;
        }
        String line = "";
        String param = "";
        String type = "";
        try {
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    if (type.equalsIgnoreCase(MARKER_X_VALUE)) {
                        G2dMarkerPointProperties.setDefault(cls + MARKER_X_VALUE, Double.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(MARKER_Y_VALUE)) {
                        G2dMarkerPointProperties.setDefault(cls + MARKER_Y_VALUE, Double.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(MARKER_LABEL)) {
                        G2dMarkerPointProperties.setDefault(cls + MARKER_LABEL, param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_ON_AXIS)) {
                        G2dMarkerPointProperties.setDefault(cls + DRAW_ON_AXIS, Integer.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(POINT_COLOR)) {
                        G2dMarkerPointProperties.setDefault(cls + POINT_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_COLOR)) {
                        G2dMarkerPointProperties.setDefault(cls + FILL_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_POINT)) {
                        G2dMarkerPointProperties.setDefault(cls + DRAW_POINT, Boolean.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_LABEL)) {
                        G2dMarkerPointProperties.setDefault(cls + DRAW_LABEL, Boolean.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(POINT_SIZE)) {
                        G2dMarkerPointProperties.setDefault(cls + POINT_SIZE, Integer.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_POSITION)) {
                        G2dMarkerPointProperties.setDefault(cls + LABEL_POSITION, Integer.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_ALIGNMENT)) {
                        G2dMarkerPointProperties.setDefault(cls + LABEL_ALIGNMENT, Integer.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(EDITABLE_PROPERTIES)) {
                        G2dMarkerPointProperties.setDefault(cls + EDITABLE_PROPERTIES, Boolean.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_COLOR)) {
                        G2dMarkerPointProperties.setDefault(cls + LABEL_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_FONT)) {
                        G2dMarkerPointProperties.setDefault(cls + LABEL_FONT, G2dMarkerPointProperties.string2font(param));
                        continue;
                    }
                    if (!type.equalsIgnoreCase(POINT_TYPE)) continue;
                    G2dMarkerPointProperties.setDefault(cls + POINT_TYPE, Integer.valueOf(param));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in loadDefaults(BufferedReader endTag) of G2dMarkerPointProperties");
            return false;
        }
        return true;
    }

    public static void setDefaults(G2dMarkerPointProperties defaultProps) {
        G2dMarkerPointProperties.setDefaults(defaultProps, CLS_NAME);
    }

    protected static void setDefaults(G2dMarkerPointProperties defaultProps, String cls) {
        if (defaultProps == null) {
            return;
        }
        if (cls == null) {
            cls = "";
        }
        G2dMarkerPointProperties.setDefault(cls + MARKER_X_VALUE, defaultProps.markerYValue);
        G2dMarkerPointProperties.setDefault(cls + MARKER_Y_VALUE, defaultProps.markerXValue);
        G2dMarkerPointProperties.setDefault(cls + MARKER_LABEL, defaultProps.markerLabel);
        G2dMarkerPointProperties.setDefault(cls + DRAW_ON_AXIS, defaultProps.drawOnAxis);
        G2dMarkerPointProperties.setDefault(cls + POINT_COLOR, defaultProps.pointColor);
        G2dMarkerPointProperties.setDefault(cls + FILL_COLOR, defaultProps.fillColor);
        G2dMarkerPointProperties.setDefault(cls + DRAW_POINT, defaultProps.drawPoint);
        G2dMarkerPointProperties.setDefault(cls + DRAW_LABEL, defaultProps.drawLabel);
        G2dMarkerPointProperties.setDefault(cls + POINT_SIZE, defaultProps.pointSize);
        G2dMarkerPointProperties.setDefault(cls + LABEL_POSITION, defaultProps.labelPosition);
        G2dMarkerPointProperties.setDefault(cls + LABEL_ALIGNMENT, defaultProps.labelAlign);
        G2dMarkerPointProperties.setDefault(cls + EDITABLE_PROPERTIES, defaultProps.editableProperties);
        G2dMarkerPointProperties.setDefault(cls + LABEL_COLOR, defaultProps.labelColor);
        G2dMarkerPointProperties.setDefault(cls + LABEL_FONT, defaultProps.labelFont);
        G2dMarkerPointProperties.setDefault(cls + POINT_TYPE, defaultProps.pointStyle);
    }

    static {
        G2dMarkerPointProperties.init(CLS_NAME);
        PlotDefaultsManager.getDefaults().loadPlotComponentDefaults(G2dMarkerPointProperties.class);
    }
}

