/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dMarkerPointProperties;
import hec.gfx2d.SamplePanel;
import hec.gfx2d.components.LabelPanel;
import hec.gfx2d.components.SimplePointPropertiesPanel;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.DateTimePanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;

public class G2dMarkerPointPropertiesPanel
extends DefaultJPanel {
    public static int TIME_AXIS = 0;
    public static int NUMERIC_AXIS = 1;
    private SimplePointPropertiesPanel _pointPanel;
    private LabelPanel _labelPanel;
    private SamplePanel _samplePanel;
    private JPanel _cardXPanel = null;
    private RmaJDecimalField _markerXValue = null;
    private DateTimePanel _dateTimeXPanel = null;
    private TimeZone _dataTimeXZone = null;
    private int _axisXType = NUMERIC_AXIS;
    private JPanel _cardYPanel = null;
    private RmaJDecimalField _markerYValue = null;
    private DateTimePanel _dateTimeYPanel = null;
    private TimeZone _dataTimeYZone = null;
    private int _axisYType = NUMERIC_AXIS;
    private G2dMarkerPointProperties _markerProperties = null;
    private TimeZone _dataTimeZone;

    public G2dMarkerPointPropertiesPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    private void buildControls() {
        JPanel locationPanel = new JPanel(new GridBagLayout());
        locationPanel.setBorder(BorderFactory.createTitledBorder("Location"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)locationPanel, gbc);
        this._cardXPanel = new JPanel(new CardLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        locationPanel.add((Component)this._cardXPanel, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("X Value:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)label, gbc);
        this._markerXValue = new RmaJDecimalField();
        label.setLabelFor(this._markerXValue);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)this._markerXValue, gbc);
        this._cardXPanel.add(Integer.toString(NUMERIC_AXIS), panel);
        this._dateTimeXPanel = new DateTimePanel(1, "X Value:", "Time", "DDMMMYYYY"){

            @Override
            public void setTimeZone(TimeZone tz) {
                if (tz == null) {
                    return;
                }
                if (this._dataTimeZone == null) {
                    return;
                }
                super.setTimeZone(tz);
            }
        };
        this._dateTimeXPanel.setTimeZone(TimeZone.getDefault());
        this._cardXPanel.add(Integer.toString(TIME_AXIS), this._dateTimeXPanel);
        this._cardYPanel = new JPanel(new CardLayout());
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        locationPanel.add((Component)this._cardYPanel, gbc);
        panel = new JPanel(new GridBagLayout());
        label = new JLabel("Y Value:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)label, gbc);
        this._markerYValue = new RmaJDecimalField();
        label.setLabelFor(this._markerYValue);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)this._markerYValue, gbc);
        this._cardYPanel.add(Integer.toString(NUMERIC_AXIS), panel);
        this._dateTimeYPanel = new DateTimePanel(1, "Y Value:", "Time", "DDMMMYYYY"){

            @Override
            public void setTimeZone(TimeZone tz) {
                if (tz == null) {
                    return;
                }
                if (this._dataTimeZone == null) {
                    return;
                }
                super.setTimeZone(tz);
            }
        };
        this._dateTimeYPanel.setTimeZone(TimeZone.getDefault());
        this._cardXPanel.add(Integer.toString(TIME_AXIS), this._dateTimeXPanel);
        this._samplePanel = new SamplePanel();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._pointPanel = new SimplePointPropertiesPanel(this._samplePanel);
        this._pointPanel.setSelected(true);
        this._pointPanel.setCheckBoxVisible(false);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._pointPanel, gbc);
        this._labelPanel = new LabelPanel("Draw Label");
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._labelPanel, gbc);
    }

    public void setYAxisType(int axisType) {
        if (axisType != TIME_AXIS && axisType != NUMERIC_AXIS) {
            throw new IllegalArgumentException("Invalid Axis type passed to G2dMarkerPointPropertiesPanel");
        }
        this._axisYType = axisType;
        ((CardLayout)this._cardYPanel.getLayout()).show(this._cardYPanel, Integer.toString(this._axisYType));
    }

    public void setXAxisType(int axisType) {
        if (axisType != TIME_AXIS && axisType != NUMERIC_AXIS) {
            throw new IllegalArgumentException("Invalid Axis type passed to G2dMarkerPointPropertiesPanel");
        }
        this._axisXType = axisType;
        ((CardLayout)this._cardXPanel.getLayout()).show(this._cardXPanel, Integer.toString(this._axisXType));
    }

    public void setData(G2dMarkerPointProperties properties, TimeZone dataTimeZone) {
        this._markerProperties = properties;
        this._dataTimeZone = dataTimeZone;
    }

    @Override
    public void fillPanel() {
        TimeZone tz;
        TimeZone clientTimeZone;
        HecTime hTime;
        if (this._markerProperties == null) {
            return;
        }
        this._labelPanel.setSelected(this._markerProperties.drawLabel);
        this._labelPanel.setSelectedFont(this._markerProperties.getLabelFont());
        this._labelPanel.setText(this._markerProperties.getLabel());
        this._labelPanel.setAlignment(this._markerProperties.getLabelAlign());
        this._labelPanel.setPosition(this._markerProperties.getLabelPosition());
        this._labelPanel.setTextColor(this._markerProperties.getLabelColor());
        this._pointPanel.setPointFillColor(this._markerProperties.getFillColor());
        this._pointPanel.setPointLineColor(this._markerProperties.getPointColor());
        this._pointPanel.setPointStyle(this._markerProperties.getPointStyle());
        this._pointPanel.setPointSize(this._markerProperties.getPointSize());
        if (this._axisXType == NUMERIC_AXIS) {
            this._markerXValue.setValue(this._markerProperties.getMarkerXValue());
        } else {
            hTime = new HecTime();
            hTime.setMinutes(this._markerProperties.getMarkerXValue());
            clientTimeZone = RmaJDialog.getTimeZone();
            tz = this._dataTimeZone != null ? this._dataTimeZone : (clientTimeZone != null ? clientTimeZone : TimeZone.getDefault());
            this._dateTimeXPanel.setDateTime(hTime, tz);
        }
        if (this._axisYType == NUMERIC_AXIS) {
            this._markerYValue.setValue(this._markerProperties.getMarkerYValue());
        } else {
            hTime = new HecTime();
            hTime.setMinutes(this._markerProperties.getMarkerYValue());
            clientTimeZone = RmaJDialog.getTimeZone();
            tz = this._dataTimeZone != null ? this._dataTimeZone : (clientTimeZone != null ? clientTimeZone : TimeZone.getDefault());
            this._dateTimeYPanel.setDateTime(hTime, tz);
        }
    }

    @Override
    public boolean savePanel() {
        HecTimeArray hTime;
        if (this._markerProperties == null) {
            return true;
        }
        this._markerProperties.setDrawLabel(this._labelPanel.isSelected());
        this._markerProperties.setLabel(this._labelPanel.getText());
        this._markerProperties.setLabelAlign(this._labelPanel.getAlignment());
        this._markerProperties.setLabelPosition(this._labelPanel.getPosition());
        this._markerProperties.setLabelFont(this._labelPanel.getSelectedFont());
        this._markerProperties.setLabelColor(this._labelPanel.getTextColor());
        this._markerProperties.setFillColor(this._pointPanel.getPointFillColor());
        this._markerProperties.setPointColor(this._pointPanel.getPointLineColor());
        this._markerProperties.setPointStyle(this._pointPanel.getPointStyle());
        this._markerProperties.setPointSize(this._pointPanel.getPointSize());
        if (this._axisXType == NUMERIC_AXIS) {
            this._markerProperties.setMarkerXValue(this._markerXValue.getValue());
        } else {
            hTime = this._dateTimeXPanel.getDateTime();
            this._markerProperties.setMarkerXValue(hTime.element(0).value());
        }
        if (this._axisYType == NUMERIC_AXIS) {
            this._markerProperties.setMarkerYValue(this._markerYValue.getValue());
        } else {
            hTime = this._dateTimeYPanel.getDateTime();
            this._markerProperties.setMarkerYValue(hTime.element(0).value());
        }
        return true;
    }
}

