/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dFont;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.LineLabelProperties;
import hec.gfx2d.LineProperties;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.PlotProperties;
import hec.gfx2d.PropertiesSerializer;
import hec.gfx2d.paint.PaintReader;
import hec.gfx2d.paint.PaintReaderFactory;
import hec.gfx2d.paint.PaintWriter;
import hec.gfx2d.paint.PaintWriterFactory;
import hec.io.AsciiSerializable;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import rma.swing.RmaColor;
import rma.util.RMAIO;
import rma.util.RmaDrawConst;

public class G2dMarkerProperties
extends PlotProperties
implements AsciiSerializable,
LineLabelProperties,
Cloneable,
LineProperties {
    private static final String CLS_NAME = "G2dMarker";
    private static final String DEFAULT_NAME = "";
    private static final String MARKER_VALUE = "markerValue";
    private static final String MARKER_LABEL = "markerLabel";
    private static final String DRAW_ON_AXIS = "drawOnAxis";
    private static final String LINE_COLOR = "lineColor";
    private static final String FILL_COLOR = "fillColor";
    private static final String DRAW_LINE = "drawLine";
    private static final String DRAW_LABEL = "drawLabel";
    private static final String FILL_TYPE = "fillType";
    private static final String FILL_PATTERN = "fillPattern";
    private static final String LINE_WIDTH = "lineWidth";
    private static final String FILL_PAINT = "fillPaint";
    private static final String LINE_STYLE = "lineStylePattern";
    private static final String LABEL_POSITION = "labelPosition";
    private static final String LABEL_ALIGNMENT = "labelAlignment";
    private static final String EDITABLE_PROPERTIES = "editableProperties";
    private static final String LABEL_COLOR = "labelColor";
    private static final String LABEL_FONT = "labelFont";
    private static final String PAINT_BEGIN = "Paint Begin";
    private static final String PAINT_END = "Paint End";
    public String _name = "";
    public double markerValue;
    public String markerLabel;
    public int drawOnAxis;
    public Color lineColor;
    public Color fillColor;
    public boolean drawLine;
    public boolean drawLabel;
    public int fillType;
    public int fillPattern;
    public Paint fillPaint;
    public float lineWidth;
    public float[] lineStylePattern;
    public int labelPosition;
    public int labelAlign;
    public boolean editableProperties;
    public Color labelColor = Color.BLACK;
    public Font labelFont = G2dFont.newFont("Dialog", 0, 10);
    public static final String MARKER_BEGIN = "Marker Begin";
    public static final String MARKER_END = "Marker End";

    public static void init() {
        G2dMarkerProperties.init(CLS_NAME);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof G2dMarkerProperties)) {
            return false;
        }
        G2dMarkerProperties tObj = (G2dMarkerProperties)obj;
        boolean equals = this.markerValue == tObj.markerValue;
        equals &= this.equals(this.markerLabel, tObj.markerLabel);
        equals &= this.drawOnAxis == tObj.drawOnAxis;
        equals &= this.drawLine == tObj.drawLine;
        equals &= this.drawLabel == tObj.drawLabel;
        equals &= this.fillType == tObj.fillType;
        equals &= this.equals(this.fillPaint, tObj.fillPaint);
        equals &= this.fillPattern == tObj.fillPattern;
        equals &= this.lineWidth == tObj.lineWidth;
        equals &= this.labelPosition == tObj.labelPosition;
        equals &= this.labelAlign == tObj.labelAlign;
        equals &= this.editableProperties == tObj.editableProperties;
        equals &= this.equals(this.lineColor, tObj.lineColor);
        equals &= this.equals(this.fillColor, tObj.fillColor);
        equals &= this.equals(this.labelColor, tObj.labelColor);
        return equals &= this.equals(this.labelFont, tObj.labelFont);
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    static void init(String cls) {
        G2dMarkerProperties.setDefault(cls + MARKER_VALUE, 0.0);
        G2dMarkerProperties.setDefault(cls + MARKER_LABEL, DEFAULT_NAME);
        G2dMarkerProperties.setDefault(cls + DRAW_ON_AXIS, 0);
        G2dMarkerProperties.setDefault(cls + LINE_COLOR, Color.black);
        G2dMarkerProperties.setDefault(cls + FILL_COLOR, Color.black);
        G2dMarkerProperties.setDefault(cls + DRAW_LINE, true);
        G2dMarkerProperties.setDefault(cls + DRAW_LABEL, false);
        G2dMarkerProperties.setDefault(cls + FILL_TYPE, 0);
        G2dMarkerProperties.setDefault(cls + FILL_PATTERN, 0);
        G2dMarkerProperties.setDefault(cls + LINE_WIDTH, 1.0f);
        G2dMarkerProperties.setDefault(cls + LINE_STYLE, G2dLineProperties.SOLID_STYLE_PATTERN);
        G2dMarkerProperties.setDefault(cls + LABEL_POSITION, 0);
        G2dMarkerProperties.setDefault(cls + LABEL_ALIGNMENT, 0);
        G2dMarkerProperties.setDefault(cls + EDITABLE_PROPERTIES, true);
        G2dMarkerProperties.setDefault(cls + LABEL_COLOR, Color.black);
        G2dMarkerProperties.setDefault(cls + LABEL_FONT, G2dFont.newFont("Dialog", 0, 10));
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void setModified(boolean modified) {
    }

    public void setMarkerLabel(String s) {
        this.markerLabel = s;
    }

    public void setLineColor(Color c2) {
        this.lineColor = c2;
    }

    public void setFillColor(Color c2) {
        this.fillColor = c2;
    }

    public void setDrawLine(boolean b) {
        this.drawLine = b;
    }

    public void setDrawLabel(boolean b) {
        this.drawLabel = b;
    }

    public void setFillType(int i) {
        this.fillType = i;
    }

    public void setFillPattern(int i) {
        this.fillPattern = i;
    }

    public void setFillPaint(Paint p) {
        this.fillPaint = p;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
    }

    public void setLinePattern(float[] f) {
        this.lineStylePattern = f;
    }

    @Override
    public void setLabelPosition(int i) {
        this.labelPosition = i;
    }

    public void setLabelAlign(int i) {
        this.labelAlign = i;
    }

    public void setEditableProperties(boolean b) {
        this.editableProperties = b;
    }

    public void setLabelColor(Color c2) {
        this.labelColor = c2;
    }

    public void setLabelFont(Font f) {
        this.labelFont = f;
    }

    public double getMarkerValue() {
        return this.markerValue;
    }

    public String getMarkerLabel() {
        return this.markerLabel;
    }

    public int getDrawOnAxis() {
        return this.drawOnAxis;
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public Color getFillColor() {
        return this.fillColor;
    }

    public boolean getDrawLine() {
        return this.drawLine;
    }

    public boolean getDrawLabel() {
        return this.drawLabel;
    }

    @Override
    public int getFillType() {
        return this.fillType;
    }

    @Override
    public int getFillPattern() {
        return this.fillPattern;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    @Override
    public float getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public float[] getLinePattern() {
        return this.lineStylePattern;
    }

    @Override
    public int getLabelPosition() {
        return this.labelPosition;
    }

    public int getLabelAlign() {
        return this.labelAlign;
    }

    public boolean getEditableProperties() {
        return this.editableProperties;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public String getName() {
        return this._name;
    }

    public G2dMarkerProperties() {
        this(CLS_NAME);
    }

    public G2dMarkerProperties(G2dMarkerProperties copyFrom) {
        this();
        if (copyFrom == null) {
            return;
        }
        this.markerValue = copyFrom.markerValue;
        this.markerLabel = copyFrom.markerLabel;
        this.drawOnAxis = copyFrom.drawOnAxis;
        this.lineColor = copyFrom.lineColor;
        this.fillColor = copyFrom.fillColor;
        this.drawLine = copyFrom.drawLine;
        this.drawLabel = copyFrom.drawLabel;
        this.fillType = copyFrom.fillType;
        this.fillPattern = copyFrom.fillPattern;
        this.fillPaint = copyFrom.fillPaint;
        this.lineWidth = copyFrom.lineWidth;
        this.lineStylePattern = copyFrom.lineStylePattern;
        this.labelPosition = copyFrom.labelPosition;
        this.labelAlign = copyFrom.labelAlign;
        this.editableProperties = copyFrom.editableProperties;
        this.labelColor = copyFrom.labelColor;
        this.labelFont = copyFrom.labelFont;
    }

    protected G2dMarkerProperties(String cls) {
        this.markerValue = G2dMarkerProperties.getDefaultDouble(cls + MARKER_VALUE);
        this.markerLabel = G2dMarkerProperties.getDefaultString(cls + MARKER_LABEL);
        this.drawOnAxis = G2dMarkerProperties.getDefaultInt(cls + DRAW_ON_AXIS);
        this.lineColor = G2dMarkerProperties.getDefaultColor(cls + LINE_COLOR);
        this.fillColor = G2dMarkerProperties.getDefaultColor(cls + FILL_COLOR);
        this.drawLine = G2dMarkerProperties.getDefaultBoolean(cls + DRAW_LINE);
        this.drawLabel = G2dMarkerProperties.getDefaultBoolean(cls + DRAW_LABEL);
        this.fillType = G2dMarkerProperties.getDefaultInt(cls + FILL_TYPE);
        this.fillPattern = G2dMarkerProperties.getDefaultInt(cls + FILL_PATTERN);
        this.lineWidth = G2dMarkerProperties.getDefaultFloat(cls + LINE_WIDTH);
        this.lineStylePattern = G2dMarkerProperties.getDefaultFloatArray(cls + LINE_STYLE);
        this.labelPosition = G2dMarkerProperties.getDefaultInt(cls + LABEL_POSITION);
        this.labelAlign = G2dMarkerProperties.getDefaultInt(cls + LABEL_ALIGNMENT);
        this.editableProperties = G2dMarkerProperties.getDefaultBoolean(cls + EDITABLE_PROPERTIES);
        this.labelColor = G2dMarkerProperties.getDefaultColor(cls + LABEL_COLOR);
        this.labelFont = G2dMarkerProperties.getDefaultFont(cls + LABEL_FONT);
    }

    public static String getFileName() {
        return "MarkerDefault";
    }

    public void setDrawOnAxis(int propValue) {
        if (propValue != 0 && propValue != 1) {
            throw new IllegalArgumentException("Axis must value must either be Axis.XAXIS or Axis.YAXIS");
        }
        this.drawOnAxis = propValue;
    }

    public void setMarkerValue(double propValue) {
        double temp = this.markerValue;
        this.markerValue = propValue;
    }

    @Override
    public boolean drawLine() {
        return this.drawLine;
    }

    @Override
    public void setHasLabel(boolean b) {
        this.drawLabel = b;
    }

    @Override
    public void setLabelAlignment(int align) {
        this.labelAlign = align;
    }

    @Override
    public void setLabel(String lbl) {
        this.markerLabel = lbl;
    }

    @Override
    public int getLabelAlignment() {
        return this.labelAlign;
    }

    @Override
    public String getLabel() {
        return this.markerLabel;
    }

    @Override
    public boolean hasLabel() {
        return this.drawLabel;
    }

    public static String font2string(Font font) {
        if (font == null) {
            return "null";
        }
        int style = font.getStyle();
        Object styleString = DEFAULT_NAME;
        if ((style & 1) != 0) {
            styleString = (String)styleString + "BOLD";
        }
        if ((style & 2) != 0) {
            styleString = (String)styleString + "ITALIC";
        }
        if (((String)styleString).length() == 0) {
            styleString = "PLAIN";
        }
        return font.getName() + "," + (String)styleString + "," + font.getSize();
    }

    public static Font string2font(String str) {
        String[] parts;
        Font font = null;
        if (str != null && str.length() > 0 && !str.equalsIgnoreCase("null") && (parts = str.split(",")).length > 0) {
            int style = 0;
            int size = 10;
            try {
                if (parts.length > 1) {
                    String styleStr = parts[1].toUpperCase();
                    if (styleStr.indexOf("BOLD") > -1) {
                        style |= 1;
                    }
                    if (styleStr.indexOf("ITALIC") > -1) {
                        style |= 2;
                    }
                    if (parts.length > 2) {
                        size = Integer.parseInt(parts[2]);
                    }
                }
                font = new Font(parts[0], style, size);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return font;
    }

    @Override
    public void writeProperties(BufferedWriter writer, String endTag) {
        PaintWriter paintWriter;
        if (writer == null) {
            return;
        }
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        if (!DEFAULT_NAME.equals(this._name)) {
            RMAIO.fout(writer, indent + "name=" + this._name);
        }
        if (!G2dMarkerProperties.isDefault(MARKER_VALUE, this.markerValue)) {
            RMAIO.fout(writer, indent + "markerValue=" + this.markerValue);
        }
        if (!G2dMarkerProperties.isDefault(MARKER_LABEL, this.markerLabel)) {
            RMAIO.fout(writer, indent + "markerLabel=" + this.markerLabel);
        }
        if (!G2dMarkerProperties.isDefault(DRAW_ON_AXIS, this.drawOnAxis)) {
            RMAIO.fout(writer, indent + "drawOnAxis=" + this.drawOnAxis);
        }
        if (!G2dMarkerProperties.isDefault(LINE_COLOR, this.lineColor)) {
            RMAIO.fout(writer, indent + "lineColor=" + RmaColor.color2String(this.lineColor));
        }
        if (!G2dMarkerProperties.isDefault(FILL_COLOR, this.fillColor)) {
            RMAIO.fout(writer, indent + "fillColor=" + RmaColor.color2String(this.fillColor));
        }
        if (!G2dMarkerProperties.isDefault(DRAW_LINE, this.drawLine)) {
            RMAIO.fout(writer, indent + "drawLine=" + this.drawLine);
        }
        if (!G2dMarkerProperties.isDefault(DRAW_LABEL, this.drawLabel)) {
            RMAIO.fout(writer, indent + "drawLabel=" + this.drawLabel);
        }
        if (!G2dMarkerProperties.isDefault(FILL_TYPE, this.fillType)) {
            RMAIO.fout(writer, indent + "fillType=" + G2dLineProperties.lookupFillName(this.fillType));
        }
        if (!G2dMarkerProperties.isDefault(FILL_PATTERN, this.fillPattern)) {
            RMAIO.fout(writer, indent + "fillPattern=" + RmaDrawConst.lookupFillPatternName(this.fillPattern));
        }
        if (!G2dMarkerProperties.isDefault(LINE_WIDTH, this.lineWidth)) {
            RMAIO.fout(writer, indent + "lineWidth=" + this.lineWidth);
        }
        if (!G2dMarkerProperties.isDefault(LINE_STYLE, this.lineStylePattern)) {
            RMAIO.fout(writer, indent + "lineStylePattern=" + G2dLineProperties.lookupStyleName(this.lineStylePattern));
        }
        if (!G2dMarkerProperties.isDefault(LABEL_POSITION, this.labelPosition)) {
            RMAIO.fout(writer, indent + "labelPosition=" + this.labelPosition);
        }
        if (!G2dMarkerProperties.isDefault(LABEL_ALIGNMENT, this.labelAlign)) {
            RMAIO.fout(writer, indent + "labelAlignment=" + this.labelAlign);
        }
        if (!G2dMarkerProperties.isDefault(EDITABLE_PROPERTIES, this.editableProperties)) {
            RMAIO.fout(writer, indent + "editableProperties=" + this.editableProperties);
        }
        if (!G2dMarkerProperties.isDefault(LABEL_COLOR, this.labelColor)) {
            RMAIO.fout(writer, indent + "labelColor=" + RmaColor.color2String(this.labelColor));
        }
        if (!G2dMarkerProperties.isDefault(LABEL_FONT, this.labelFont)) {
            RMAIO.fout(writer, indent + "labelFont=" + G2dMarkerProperties.font2string(this.labelFont));
        }
        if (this.fillPaint != null && (paintWriter = PaintWriterFactory.getInstance().getPaintWriter(this.fillPaint.getClass())) != null) {
            RMAIO.fout(writer, indent + PAINT_BEGIN);
            PropertiesSerializer.incrementRecursion();
            Map<String, String> writePaint = paintWriter.writePaint(this.fillPaint);
            Set<Map.Entry<String, String>> entrySet = writePaint.entrySet();
            for (Map.Entry<String, String> object : entrySet) {
                RMAIO.fout(writer, PropertiesSerializer.getIndent() + object.getKey().toString() + "=" + object.getValue().toString());
            }
            PropertiesSerializer.decrementRecursion();
            RMAIO.fout(writer, indent + PAINT_END);
        }
        PropertiesSerializer.decrementRecursion();
        if (endTag != null) {
            indent = PropertiesSerializer.getIndent();
            RMAIO.fout(writer, indent + endTag);
        }
    }

    public static boolean writeDefaults() {
        BufferedWriter writer = PlotDefaultsManager.getDefaults().getBufferedWriter(G2dMarkerProperties.class);
        boolean b = G2dMarkerProperties.writeDefaults(writer);
        try {
            writer.close();
        }
        catch (IOException ioe) {
            System.out.println("Error in writeDefaults()  G2dMarkerProperties");
        }
        return b;
    }

    public static boolean writerDefaults(BufferedWriter writer) {
        return G2dMarkerProperties.writeDefaults(CLS_NAME, writer);
    }

    protected static boolean writeDefaults(String cls, BufferedWriter writer) {
        if (writer == null) {
            return false;
        }
        String indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + MARKER_BEGIN);
        PropertiesSerializer.incrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + "markerValue=" + G2dMarkerProperties.getDefaultDouble(cls + MARKER_VALUE));
        RMAIO.fout(writer, indent + "markerLabel=" + G2dMarkerProperties.getDefaultString(cls + MARKER_LABEL));
        RMAIO.fout(writer, indent + "drawOnAxisdrawOnAxis=" + G2dMarkerProperties.getDefaultInt(cls + DRAW_ON_AXIS));
        RMAIO.fout(writer, indent + "lineColor=" + RmaColor.color2String(G2dMarkerProperties.getDefaultColor(cls + LINE_COLOR)));
        RMAIO.fout(writer, indent + "fillColor=" + RmaColor.color2String(G2dMarkerProperties.getDefaultColor(cls + FILL_COLOR)));
        RMAIO.fout(writer, indent + "drawLine=" + G2dMarkerProperties.getDefaultBoolean(cls + DRAW_LINE));
        RMAIO.fout(writer, indent + "drawLabel=" + G2dMarkerProperties.getDefaultBoolean(cls + DRAW_LABEL));
        RMAIO.fout(writer, indent + "fillType=" + G2dLineProperties.lookupFillName(G2dMarkerProperties.getDefaultInt(cls + FILL_TYPE)));
        RMAIO.fout(writer, indent + "fillPattern=" + RmaDrawConst.lookupFillPatternName(G2dMarkerProperties.getDefaultInt(cls + FILL_PATTERN)));
        RMAIO.fout(writer, indent + "lineWidth=" + G2dMarkerProperties.getDefaultFloat(cls + LINE_WIDTH));
        RMAIO.fout(writer, indent + "lineStylePattern=" + G2dLineProperties.lookupStyleName(G2dMarkerProperties.getDefaultFloatArray(cls + LINE_STYLE)));
        RMAIO.fout(writer, indent + "labelPosition=" + G2dMarkerProperties.getDefaultInt(cls + LABEL_POSITION));
        RMAIO.fout(writer, indent + "labelAlignment=" + G2dMarkerProperties.getDefaultInt(cls + LABEL_ALIGNMENT));
        RMAIO.fout(writer, indent + "labelColor=" + RmaColor.color2String(G2dMarkerProperties.getDefaultColor(cls + LABEL_COLOR)));
        RMAIO.fout(writer, indent + "labelFont=" + G2dMarkerProperties.getDefaultFont(cls + LABEL_FONT));
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + MARKER_END);
        return true;
    }

    public void readProperties(BufferedReader in, String endTag) {
        if (in == null) {
            return;
        }
        String line = DEFAULT_NAME;
        String param = DEFAULT_NAME;
        String type = DEFAULT_NAME;
        try {
            while ((line = in.readLine()) != null) {
                String trim = line.trim();
                param = RMAIO.getParam(trim, "=");
                type = RMAIO.getType(trim, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    if (type.equalsIgnoreCase("name")) {
                        this._name = param;
                        continue;
                    }
                    if (type.equalsIgnoreCase(MARKER_VALUE)) {
                        this.markerValue = Double.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(MARKER_LABEL)) {
                        this.markerLabel = param;
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_ON_AXIS)) {
                        this.drawOnAxis = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LINE_COLOR)) {
                        this.lineColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_COLOR)) {
                        this.fillColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_LINE)) {
                        this.drawLine = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_LABEL)) {
                        this.drawLabel = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_TYPE)) {
                        this.fillType = G2dLineProperties.lookupFill(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_PATTERN)) {
                        this.fillPattern = RmaDrawConst.lookupFillPattern(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LINE_WIDTH)) {
                        this.lineWidth = Float.valueOf(param).floatValue();
                        continue;
                    }
                    if (type.equalsIgnoreCase(LINE_STYLE)) {
                        this.lineStylePattern = G2dLineProperties.lookupStyle(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_POSITION)) {
                        this.labelPosition = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_ALIGNMENT)) {
                        this.labelAlign = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(EDITABLE_PROPERTIES)) {
                        this.editableProperties = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_COLOR)) {
                        this.labelColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_FONT)) {
                        this.labelFont = G2dMarkerProperties.string2font(param);
                        continue;
                    }
                    if (!type.equalsIgnoreCase(PAINT_BEGIN)) continue;
                    HashMap<String, String> properties = new HashMap<String, String>();
                    while ((line = in.readLine()) != null && !(trim = line.trim()).equalsIgnoreCase(PAINT_END)) {
                        param = RMAIO.getParam(trim, "=");
                        type = RMAIO.getType(trim, "=");
                        properties.put(type, param);
                    }
                    PaintReader paintReader = PaintReaderFactory.getInstance().getPaintReader((String)properties.get("name"));
                    if (paintReader == null) continue;
                    this.fillPaint = paintReader.readPaint(properties);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readProperties(BufferedReader) of G2dMarkerProperties");
            return;
        }
    }

    public G2dMarkerProperties clone() {
        try {
            G2dMarkerProperties clonedProps = (G2dMarkerProperties)super.clone();
            if (this.lineStylePattern != null) {
                clonedProps.lineStylePattern = new float[this.lineStylePattern.length];
                System.arraycopy(this.lineStylePattern, 0, clonedProps.lineStylePattern, 0, this.lineStylePattern.length);
            }
            clonedProps.lineColor = new Color(this.lineColor.getRGB());
            clonedProps.fillColor = new Color(this.fillColor.getRGB());
            return clonedProps;
        }
        catch (CloneNotSupportedException e) {
            System.out.println("G2dMarkerLineProperties.clone() Exception:" + e);
            return null;
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean loadDefaults(BufferedReader in) {
        return G2dMarkerProperties.loadDefaults(in, MARKER_END, CLS_NAME);
    }

    private static boolean loadDefaults(BufferedReader in, String endTag, String cls) {
        if (in == null) {
            return false;
        }
        String line = DEFAULT_NAME;
        String param = DEFAULT_NAME;
        String type = DEFAULT_NAME;
        try {
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    if (type.equalsIgnoreCase(MARKER_VALUE)) {
                        G2dMarkerProperties.setDefault(cls + MARKER_VALUE, Double.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(MARKER_LABEL)) {
                        G2dMarkerProperties.setDefault(cls + MARKER_LABEL, param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_ON_AXIS)) {
                        G2dMarkerProperties.setDefault(cls + DRAW_ON_AXIS, Integer.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(LINE_COLOR)) {
                        G2dMarkerProperties.setDefault(cls + LINE_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_COLOR)) {
                        G2dMarkerProperties.setDefault(cls + FILL_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_LINE)) {
                        G2dMarkerProperties.setDefault(cls + DRAW_LINE, Boolean.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(DRAW_LABEL)) {
                        G2dMarkerProperties.setDefault(cls + DRAW_LABEL, Boolean.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_TYPE)) {
                        G2dMarkerProperties.setDefault(cls + FILL_TYPE, G2dLineProperties.lookupFill(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(FILL_PATTERN)) {
                        G2dMarkerProperties.setDefault(cls + FILL_PATTERN, RmaDrawConst.lookupFillPattern(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(LINE_WIDTH)) {
                        G2dMarkerProperties.setDefault(cls + LINE_WIDTH, Float.valueOf(param).floatValue());
                        continue;
                    }
                    if (type.equalsIgnoreCase(LINE_STYLE)) {
                        G2dMarkerProperties.setDefault(cls + LINE_STYLE, G2dLineProperties.lookupStyle(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_POSITION)) {
                        G2dMarkerProperties.setDefault(cls + LABEL_POSITION, Integer.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_ALIGNMENT)) {
                        G2dMarkerProperties.setDefault(cls + LABEL_ALIGNMENT, Integer.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(EDITABLE_PROPERTIES)) {
                        G2dMarkerProperties.setDefault(cls + EDITABLE_PROPERTIES, Boolean.valueOf(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(LABEL_COLOR)) {
                        G2dMarkerProperties.setDefault(cls + LABEL_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (!type.equalsIgnoreCase(LABEL_FONT)) continue;
                    G2dMarkerProperties.setDefault(cls + LABEL_FONT, G2dMarkerProperties.string2font(param));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in loadDefaults(BufferedReader endTag) of G2dMarkerProperties");
            return false;
        }
        return true;
    }

    public static void setDefaults(G2dMarkerProperties defaultProps) {
        G2dMarkerProperties.setDefaults(defaultProps, CLS_NAME);
    }

    protected static void setDefaults(G2dMarkerProperties defaultProps, String cls) {
        if (defaultProps == null) {
            return;
        }
        if (cls == null) {
            cls = DEFAULT_NAME;
        }
        G2dMarkerProperties.setDefault(cls + MARKER_VALUE, defaultProps.markerValue);
        G2dMarkerProperties.setDefault(cls + MARKER_LABEL, defaultProps.markerLabel);
        G2dMarkerProperties.setDefault(cls + DRAW_ON_AXIS, defaultProps.drawOnAxis);
        G2dMarkerProperties.setDefault(cls + LINE_COLOR, defaultProps.lineColor);
        G2dMarkerProperties.setDefault(cls + FILL_COLOR, defaultProps.fillColor);
        G2dMarkerProperties.setDefault(cls + DRAW_LINE, defaultProps.drawLine);
        G2dMarkerProperties.setDefault(cls + DRAW_LABEL, defaultProps.drawLabel);
        G2dMarkerProperties.setDefault(cls + FILL_TYPE, defaultProps.fillType);
        G2dMarkerProperties.setDefault(cls + FILL_PATTERN, defaultProps.fillPattern);
        G2dMarkerProperties.setDefault(cls + LINE_WIDTH, defaultProps.lineWidth);
        G2dMarkerProperties.setDefault(cls + LINE_STYLE, defaultProps.lineStylePattern);
        G2dMarkerProperties.setDefault(cls + LABEL_POSITION, defaultProps.labelPosition);
        G2dMarkerProperties.setDefault(cls + LABEL_ALIGNMENT, defaultProps.labelAlign);
        G2dMarkerProperties.setDefault(cls + EDITABLE_PROPERTIES, defaultProps.editableProperties);
        G2dMarkerProperties.setDefault(cls + LABEL_COLOR, defaultProps.labelColor);
        G2dMarkerProperties.setDefault(cls + LABEL_FONT, defaultProps.labelFont);
    }

    @Override
    public boolean drawPoints() {
        return false;
    }

    @Override
    public int getSymbolType() {
        return 0;
    }

    @Override
    public Color getPointFillColor() {
        return Color.BLACK;
    }

    @Override
    public Color getPointLineColor() {
        return Color.BLACK;
    }

    @Override
    public float getSymbolSize() {
        return 0.0f;
    }

    public static void main(String[] args) throws IOException {
        G2dMarkerProperties properties = new G2dMarkerProperties();
        properties.fillPaint = new GradientPaint(0.0f, 0.0f, Color.black, 1.0f, 1.0f, Color.blue);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        properties.writeProperties(bw, CLS_NAME);
        bw.flush();
        System.out.println(sw.getBuffer().toString());
        properties = new G2dMarkerProperties();
        properties.readProperties(new BufferedReader(new StringReader(sw.getBuffer().toString())), CLS_NAME);
        System.out.println(properties.fillPaint);
    }

    static {
        G2dMarkerProperties.init();
    }
}

