/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLineLabelPropertiesPanel;
import hec.gfx2d.G2dMarkerProperties;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import java.awt.CardLayout;
import java.util.TimeZone;
import javax.swing.JPanel;
import rma.swing.DateTimePanel;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;

public class G2dMarkerValueLabelPropertiesPanel
extends G2dLineLabelPropertiesPanel {
    public static int TIME_AXIS = 0;
    public static int NUMERIC_AXIS = 1;
    private G2dMarkerProperties m_markerProperties = null;
    private RmaJDecimalField m_markerValue = null;
    private DateTimePanel m_dateTimePanel = null;
    private TimeZone m_dataTimeZone = null;
    private int m_axisType = NUMERIC_AXIS;
    private JPanel m_cardPanel = null;

    public G2dMarkerValueLabelPropertiesPanel(int axisType) {
        this();
        this.setAxisType(axisType);
    }

    public G2dMarkerValueLabelPropertiesPanel() {
    }

    public void setData(G2dMarkerProperties p, TimeZone dataTimeZone) {
        super.setData(p);
        this.m_markerProperties = p;
        this.m_dataTimeZone = dataTimeZone;
    }

    @Override
    public String getName() {
        return "Label/Value";
    }

    @Override
    public boolean savePanel() {
        if (this.m_markerProperties != null) {
            if (this.m_axisType == NUMERIC_AXIS) {
                this.m_markerProperties.setMarkerValue(this.m_markerValue.getValue());
            } else {
                HecTimeArray hTimeArray = this.m_dateTimePanel.getDateTime();
                this.m_markerProperties.setMarkerValue(hTimeArray.element(0).value());
            }
        }
        return super.savePanel();
    }

    @Override
    public void fillPanel() {
        super.fillPanel();
        if (this.m_markerProperties == null) {
            return;
        }
        if (this.m_axisType == NUMERIC_AXIS) {
            this.m_markerValue.setValue(this.m_markerProperties.getMarkerValue());
        } else {
            HecTime hTime = new HecTime();
            hTime.setMinutes(this.m_markerProperties.getMarkerValue());
            TimeZone clientTimeZone = RmaJDialog.getTimeZone();
            TimeZone tz = this.m_dataTimeZone != null ? this.m_dataTimeZone : (clientTimeZone != null ? clientTimeZone : TimeZone.getDefault());
            this.m_dateTimePanel.setDateTime(hTime, tz);
        }
    }

    public void setAxisType(int axisType) {
        if (axisType != TIME_AXIS && axisType != NUMERIC_AXIS) {
            throw new IllegalArgumentException("Invalid Axis type passed to G2dMarkerValueLabelPropertiesPanel");
        }
        this.m_axisType = axisType;
        ((CardLayout)this.m_cardPanel.getLayout()).show(this.m_cardPanel, Integer.toString(this.m_axisType));
    }
}

