/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaIntegerJSpinBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTextField;

public class G2dMiscPropertiesPanel
extends DefaultJPanel {
    private RmaJIntegerField _windowWidthFld;
    private RmaJIntegerField _windowHeightFld;
    private RmaJTextField _windowCaptionTxt;
    private RmaIntegerJSpinBox _spacerSizeSpinBox;
    private RmaJColorComboBox _backgroundColorCombo;
    private JButton _setToCurrentWindowBtn;
    private static final String DEFAULT = "Default";
    private Object[] DEFAULT_BACKGROUND = new Object[]{Color.white, "Default"};
    public G2dPanelProp _panelProperties = null;
    private G2dPanel _panel = null;

    public G2dMiscPropertiesPanel() {
        super(new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        JPanel sizePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)sizePanel, gbc);
        JLabel label = new JLabel("Window Size in Pixels");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        sizePanel.add((Component)label, gbc);
        label = new JLabel("Width:");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        sizePanel.add((Component)label, gbc);
        this._windowWidthFld = new RmaJIntegerField();
        label.setLabelFor(this._windowWidthFld);
        this._windowWidthFld.setColumns(20);
        this._windowWidthFld.setMinValue(1);
        label.setLabelFor(this._windowWidthFld);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        sizePanel.add((Component)this._windowWidthFld, gbc);
        label = new JLabel("Height:");
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        sizePanel.add((Component)label, gbc);
        this._windowHeightFld = new RmaJIntegerField();
        label.setLabelFor(this._windowHeightFld);
        this._windowHeightFld.setColumns(20);
        this._windowHeightFld.setMinValue(1);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        sizePanel.add((Component)this._windowHeightFld, gbc);
        this._setToCurrentWindowBtn = new JButton("Set to Current Plot Window Size");
        this._setToCurrentWindowBtn.setVisible(false);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 0.001;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        sizePanel.add((Component)this._setToCurrentWindowBtn, gbc);
        label = new JLabel("Window Caption:");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(15, 5, 0, 5);
        this._windowCaptionTxt = new RmaJTextField();
        label.setLabelFor(this._windowCaptionTxt);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        label = new JLabel("Panel Background Color:");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)label, gbc);
        this._backgroundColorCombo = new RmaJColorComboBox();
        this._backgroundColorCombo.setModifiable(true);
        this._backgroundColorCombo.addItem(this.DEFAULT_BACKGROUND);
        label.setLabelFor(this._backgroundColorCombo);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)this._backgroundColorCombo, gbc);
        label = new JLabel("Space size in pixels:");
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)label, gbc);
        this._spacerSizeSpinBox = new RmaIntegerJSpinBox();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.001;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)this._spacerSizeSpinBox, gbc);
    }

    protected void addListeners() {
        this._setToCurrentWindowBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                G2dMiscPropertiesPanel.this.setToCurrentWindowSizeAction();
            }
        });
    }

    protected void setToCurrentWindowSizeAction() {
        Window w = SwingUtilities.windowForComponent(this);
        Container c2 = w.getParent();
        if (c2 instanceof JFrame) {
            JFrame frame = (JFrame)c2;
            this._windowCaptionTxt.setText(frame.getTitle());
            Dimension d = frame.getSize();
            this._windowWidthFld.setValue(d.width);
            this._windowHeightFld.setValue(d.height);
        }
        this.setModified(true);
    }

    public void setData(G2dPanel panel) {
        this._panel = panel;
        if (panel != null) {
            this._panelProperties = this._panel.getProperties();
        }
    }

    public void setData(G2dPanelProp panelProps) {
        this._panelProperties = panelProps;
    }

    @Override
    public void fillPanel() {
        if (this._panelProperties == null) {
            return;
        }
        if (this._panelProperties.backgroundColor == null) {
            this._backgroundColorCombo.setSelectedItem(this.DEFAULT_BACKGROUND);
        } else {
            this._backgroundColorCombo.setSelectedColor(this._panelProperties.backgroundColor);
        }
        if (this._panelProperties.viewportSpaceSize == -1) {
            this._spacerSizeSpinBox.setValue(0);
        } else {
            this._spacerSizeSpinBox.setValue(this._panelProperties.getViewportSpaceSize());
        }
        Window w = SwingUtilities.windowForComponent(this);
        Container c2 = w.getParent();
        if (c2 instanceof JFrame) {
            JFrame frame = (JFrame)c2;
            this._windowCaptionTxt.setText(frame.getTitle());
            this._windowWidthFld.setValue(this._panelProperties.dialogWidth);
            this._windowHeightFld.setValue(this._panelProperties.dialogHeight);
        }
    }

    @Override
    public boolean savePanel() {
        if (this._panelProperties == null) {
            return true;
        }
        Object[] selectedItem = (Object[])this._backgroundColorCombo.getSelectedItem();
        this._panelProperties.backgroundColor = selectedItem == null || selectedItem == this.DEFAULT_BACKGROUND ? null : (Color)selectedItem[0];
        if (this._panel != null) {
            this._panel.setBackground(this._panelProperties.backgroundColor);
        }
        this._panelProperties.dialogWidth = this._windowWidthFld.getValueUndefined();
        this._panelProperties.dialogHeight = this._windowHeightFld.getValueUndefined();
        this._panelProperties.setViewportSpaceSize(this._spacerSizeSpinBox.getValue());
        return true;
    }

    public void setSetToCurrentButtonVisible(boolean visible) {
        this._setToCurrentWindowBtn.setVisible(visible);
    }
}

