/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.LabelLayoutConstants;
import hec.gfx2d.SamplePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaIntegerJSpinBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTextArea;

public class G2dMultiLineLabelPanel
extends DefaultJPanel
implements ActionListener,
LabelLayoutConstants {
    private String _align = "Left";
    private String _position = "Above";
    private RmaJComboBox _alignmentCombo;
    private RmaIntegerJSpinBox _sizeSpinBox;
    private RmaJTextArea _titleText;
    private SamplePanel _samplePanel;

    public G2dMultiLineLabelPanel() {
        this.buildControls();
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Title:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)label, gbc);
        this._titleText = new RmaJTextArea(3, 20);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)new JScrollPane(this._titleText), gbc);
        label = new JLabel("Alignment:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)label, gbc);
        this._alignmentCombo = new RmaJComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"Left", "Center", "Right"}));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)this._alignmentCombo, gbc);
        label = new JLabel("Size:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)label, gbc);
        this._sizeSpinBox = new RmaIntegerJSpinBox();
        this._sizeSpinBox.setMaximum(45);
        this._sizeSpinBox.setMinimum(1);
        this._sizeSpinBox.setValue(10);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)this._sizeSpinBox, gbc);
        this._sizeSpinBox.addActionListener(this);
        this._alignmentCombo.addActionListener(this);
        this._alignmentCombo.setModifiable(true);
    }

    public void setSamplePanel(SamplePanel samplePanel) {
        this._samplePanel = samplePanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (this._samplePanel == null) {
            return;
        }
        if (src == this._sizeSpinBox) {
            this._samplePanel.setTextSize(this._sizeSpinBox.getValue());
        } else if (src == this._alignmentCombo) {
            this._samplePanel.setTextAlignment((String)this._alignmentCombo.getSelectedItem());
        }
    }

    public void setText(String text) {
        if (text == null) {
            this._titleText.setText("");
            return;
        }
        this._titleText.setText(text);
    }

    public void setTextSize(int size) {
        this._sizeSpinBox.setValue(size);
    }

    public void setMinTextSize(int minSize) {
        this._sizeSpinBox.setMinimum(minSize);
    }

    public void setMaxTextSize(int maxSize) {
        this._sizeSpinBox.setMaximum(maxSize);
    }

    public void setTextAlignment(int alignment) {
        switch (alignment) {
            case 0: {
                this._alignmentCombo.setSelectedItem("Left");
                break;
            }
            case 2: {
                this._alignmentCombo.setSelectedItem("Right");
                break;
            }
            default: {
                this._alignmentCombo.setSelectedItem("Center");
            }
        }
    }

    public int getTextAlignment() {
        String align = (String)this._alignmentCombo.getSelectedItem();
        if ("Left".equals(align)) {
            return 0;
        }
        if ("Right".equals(align)) {
            return 2;
        }
        return 1;
    }

    public String getText() {
        return this._titleText.getText();
    }

    public int getTextSize() {
        return this._sizeSpinBox.getValue();
    }
}

