/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.Units;
import hec.geometry.Axis;
import hec.geometry.AxisFactory;
import hec.geometry.AxisProp;
import hec.geometry.LocalPt;
import hec.geometry.ProbabilityAxis;
import hec.geometry.Scale;
import hec.geometry.TSAxis;
import hec.geometry.WorldRect;
import hec.gfx2d.AxisLabel;
import hec.gfx2d.AxisScrollbar;
import hec.gfx2d.AxisTicFactory;
import hec.gfx2d.AxisTics;
import hec.gfx2d.AxisTicsDrawProp;
import hec.gfx2d.DataType;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.DefaultPopupPlotCreator;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dLabel;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerPointProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dMouseAdapter;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.G2dPointerAdapter;
import hec.gfx2d.G2dPointerComponent;
import hec.gfx2d.G2dSpacer;
import hec.gfx2d.G2dTitle;
import hec.gfx2d.G2dToolbarListener;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.LegendPanel;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.LineProperties;
import hec.gfx2d.ObjectSelectionEvent;
import hec.gfx2d.ObjectSelectionListener;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.PlotProperties;
import hec.gfx2d.PopupPlotCreator;
import hec.gfx2d.PopupPlotMouseAdapter;
import hec.gfx2d.PrintProperties;
import hec.gfx2d.SimpleArray;
import hec.gfx2d.TSAxisTics;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.TimeWindowPlotData;
import hec.gfx2d.TitlePanel;
import hec.gfx2d.ToolbarButtonProp;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportLayer;
import hec.gfx2d.ViewportLayout;
import hec.gfx2d.ViewportLinkRecord;
import hec.gfx2d.ViewportToolbar;
import hec.gfx2d.ViewportToolbarProp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import rma.lang.RmaMath;
import rma.services.tz.TimeZoneComponent;
import rma.services.units.UnitsComponent;
import rma.swing.RmaJMenuLabel;

public class G2dPanel
extends JPanel
implements G2dPointerComponent,
G2dToolbarListener,
UnitsComponent,
TimeZoneComponent,
ObjectSelectionListener,
Printable {
    public static final int X1 = 0;
    public static final int X2 = 1;
    public static final int Y1 = 2;
    public static final int Y2 = 3;
    protected static final int MAX_COMPONENT_ROW = 250;
    protected static final int MAX_COMPONENT_COLUMN = 250;
    protected static final GridBagConstraints LEGEND_CONTAINER_GRIDBAGCONSTRAINTS = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
    protected JPanel VERTICAL_LEGEND_CONTAINER = new JPanel(new GridBagLayout()){

        @Override
        public void remove(Component c2) {
            super.remove(c2);
        }

        @Override
        public void removeAll() {
            super.removeAll();
        }
    };
    protected JPanel HORIZONTAL_LEGEND_CONTAINER = new JPanel(new GridBagLayout()){
        private static final int IS_DOUBLE_BUFFERED = 0;
        private static final int ANCESTOR_USING_BUFFER = 1;
        private static final int IS_PAINTING_TILE = 2;
        private static final int IS_OPAQUE = 3;
        private static final int KEY_EVENTS_ENABLED = 4;
        private static final int FOCUS_INPUTMAP_CREATED = 5;
        private static final int ANCESTOR_INPUTMAP_CREATED = 6;
        private static final int WIF_INPUTMAP_CREATED = 7;
        private static final int ACTIONMAP_CREATED = 8;
        private static final int CREATED_DOUBLE_BUFFER = 9;

        @Override
        public void remove(Component c2) {
            super.remove(c2);
        }

        @Override
        public void removeAll() {
            super.removeAll();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }
    };
    protected G2dComponent ACCESSORY_PANEL_CONTAINER = new G2dComponent();
    JMenu _editMenu = null;
    TimeWindowPlotData _timeWindowData;
    Hashtable _viewportLinkTable = new Hashtable();
    List<G2dSpacer> _horizontalSpacerTable = new Vector<G2dSpacer>();
    List<G2dSpacer> _spacerList = new ArrayList<G2dSpacer>();
    Hashtable _xAxisTable = new Hashtable();
    Hashtable _yAxisTable = new Hashtable();
    Hashtable _scaleTable = new Hashtable();
    Vector _viewportVector = new Vector();
    Dimension _referenceSize = null;
    double _fontZoom = 1.0;
    boolean _paintEnabled = true;
    AxisLabel _x1label;
    AxisLabel _x2label;
    AxisLabel _y1label;
    AxisLabel _y2label;
    AxisTics _x1tics;
    AxisTics _x2tics;
    AxisTics _y1tics;
    AxisTics _y2tics;
    G2dTitle _title = null;
    Color _ticBottom = new Color(0, 0, 0);
    Color _ticTextBottom = new Color(0, 0, 0);
    Color _ticLeft = new Color(0, 0, 0);
    Color _ticTextLeft = new Color(0, 0, 0);
    Color _gridX = Color.lightGray;
    Color _gridY = Color.lightGray;
    Color _plotDialog = new Color(174, 174, 174);
    Color _plotBackground = new Color(255, 255, 255);
    protected TransferHandler _transferHandler = null;
    G2dMouseAdapter _mouseAdapter = null;
    ViewportToolbar _toolbar = null;
    int _displayUnitSystem = -1;
    String _propertiesFactoryName = null;
    private boolean _showStats = true;
    protected static PopupPlotCreator m_popupPlotCreator = new DefaultPopupPlotCreator();
    private boolean m_ignorePopupPlotEvents = false;
    static Color[] _lineColor = new Color[]{Color.blue, Color.red, Color.green.darker(), Color.darkGray, Color.magenta, Color.orange, Color.black};
    static Color[] _fillColor = new Color[]{Color.blue, Color.red, Color.green.darker(), Color.darkGray, Color.magenta, Color.orange, Color.cyan, Color.magenta, Color.gray, Color.yellow, Color.pink, Color.black, Color.white};
    LegendPanel _legend = null;
    JPanel _legendContainer = new JPanel(new BorderLayout());
    List _components = null;
    G2dPanelProp _panelProperties = new G2dPanelProp();
    private MouseInputHandler _mouseListener;
    private Vector _focusListenerList = new Vector();
    private WindowClosingListener m_windowClosingListener = new WindowClosingListener();
    private Vector m_openPopupWindows = new Vector();
    private int m_deviceResolution = GraphicsEnvironment.isHeadless() ? 96 : Toolkit.getDefaultToolkit().getScreenResolution();
    JFrame LEGEND_FRAME;
    Container LEGEND_CONTAINER;
    PlotLayout _plotLayout = null;

    public G2dPanel() {
        this.setBackground(this._panelProperties.backgroundColor);
        this.VERTICAL_LEGEND_CONTAINER.setBackground(null);
        this.HORIZONTAL_LEGEND_CONTAINER.setBackground(null);
        this.registerKeyboardAction(e -> PlotProperties.dumpDefaults(), KeyStroke.getKeyStroke(68, 2, true), 1);
        this.addMouseListener(new PopupPlotMouseAdapter(this, this));
    }

    public static void registerPopupPlotCreator(PopupPlotCreator creator) {
        if (creator == null) {
            return;
        }
        m_popupPlotCreator = creator;
    }

    public void setPropertiesFactoryName(String name) {
        this._propertiesFactoryName = name;
    }

    public static PopupPlotCreator getPopupPlotCreator() {
        return m_popupPlotCreator;
    }

    public void setDirty() {
        Viewport[] viewports = this.getViewports();
        if (viewports == null) {
            return;
        }
        for (int i = 0; i < viewports.length; ++i) {
            Viewport v = viewports[i];
            v.setDirty();
        }
    }

    public JComponent getAccessoryPanel() {
        Component[] comps = this.ACCESSORY_PANEL_CONTAINER.getComponents();
        if (comps == null || comps.length == 0) {
            return null;
        }
        return (JComponent)comps[0];
    }

    public void setDeviceResolution(int dpi) {
        this.m_deviceResolution = dpi;
        Gfx2dDrawUtil.DEVICE_RESOLUTION = dpi;
    }

    public int getDeviceResoultion() {
        return this.m_deviceResolution;
    }

    protected G2dDialog createPopupPlot() {
        G2dDialog dialog = m_popupPlotCreator.createPopupPlot(this);
        this.addPopupWindow(dialog);
        return dialog;
    }

    protected void addPopupWindow(G2dDialog dialog) {
        if (dialog == null) {
            return;
        }
        dialog.addWindowListener(this.m_windowClosingListener);
        this.m_openPopupWindows.add(dialog);
    }

    public void removeGlyph(G2dGlyph g) {
        Viewport v;
        int i;
        ArrayList<Viewport> emptyViewports = new ArrayList<Viewport>();
        Viewport[] viewports = this.getViewports();
        if (viewports == null) {
            return;
        }
        for (i = 0; i < viewports.length; ++i) {
            v = viewports[i];
            if (v.getGlyphVector() == null || v.getGlyphVector().isEmpty()) continue;
            v.removeGlyph(g);
            if (v.getGlyphVector() != null && !v.getGlyphVector().isEmpty()) continue;
            emptyViewports.add(v);
        }
        if (viewports.length > 1 && !emptyViewports.isEmpty()) {
            boolean removeEmptyViewports = false;
            String msg = "Remove the empty viewport from the plot window?";
            Object[] options = new Object[]{"Yes", "No"};
            int opt = JOptionPane.showOptionDialog(this, msg, "Remove Empty Viewport", 0, 3, null, options, options[0]);
            if (opt == 0) {
                removeEmptyViewports = true;
            }
            for (int i2 = 0; removeEmptyViewports && i2 < emptyViewports.size(); ++i2) {
                this.setVisible(false);
                Viewport v2 = (Viewport)emptyViewports.get(i2);
                GridBagConstraints viewportConstraints = ((GridBagLayout)this.getLayout()).getConstraints(v2);
                int gy = viewportConstraints.gridy;
                int gx = viewportConstraints.gridx;
                for (int j = 0; j < this._spacerList.size(); ++j) {
                    G2dSpacer spacer = this._spacerList.get(j);
                    viewportConstraints = ((GridBagLayout)this.getLayout()).getConstraints(spacer);
                    boolean xfound = false;
                    boolean yfound = false;
                    int sy = viewportConstraints.gridy;
                    int sx = viewportConstraints.gridx;
                    if (!(gx == sx && gy == sy - 1 || gx - 1 == sx && gy + 1 == sy || gx - 1 == sx && gy == sy || gx + 2 == sx && gy - 1 == sy) && (gx + 1 != sx || gy - 1 != sy)) continue;
                    this.remove(spacer);
                    this._spacerList.remove(spacer);
                    this._horizontalSpacerTable.remove(spacer);
                    --j;
                }
                AxisTics y1 = this.getViewportAxisTics(v2, 2);
                AxisTics y2 = this.getViewportAxisTics(v2, 3);
                AxisTics x1 = this.getViewportAxisTics(v2, 0);
                AxisTics x2 = this.getViewportAxisTics(v2, 1);
                AxisLabel y1Label = this.getViewportAxisLabel(v2, 2);
                AxisLabel y2Label = this.getViewportAxisLabel(v2, 3);
                AxisLabel x1Label = this.getViewportAxisLabel(v2, 0);
                AxisLabel x2Label = this.getViewportAxisLabel(v2, 1);
                GridBagConstraints axisTicsGbc = null;
                if (x1 != null) {
                    axisTicsGbc = ((GridBagLayout)this.getLayout()).getConstraints(x1);
                }
                if (y1 != null) {
                    this.remove(y1);
                }
                if (y2 != null) {
                    this.remove(y2);
                }
                if (x1 != null) {
                    this.remove(x1);
                }
                if (x2 != null) {
                    this.remove(x2);
                }
                Component[] components = this.getComponents();
                if (y1Label != null) {
                    for (Component component : components) {
                        if (!(component instanceof AxisLabel) || !((AxisLabel)component).getText().equals(y1Label.getText())) continue;
                        this.remove(component);
                    }
                }
                if (y2Label != null) {
                    for (Component component : components) {
                        if (!(component instanceof AxisLabel) || !((AxisLabel)component).getText().equals(y2Label.getText())) continue;
                        this.remove(component);
                    }
                }
                if (x1Label != null) {
                    for (Component component : components) {
                        if (!(component instanceof AxisLabel) || !((AxisLabel)component).getText().equals(x1Label.getText())) continue;
                        this.remove(component);
                    }
                }
                if (x2Label != null) {
                    for (Component component : components) {
                        if (!(component instanceof AxisLabel) || !((AxisLabel)component).getText().equals(x2Label.getText())) continue;
                        this.remove(component);
                    }
                }
                this.remove(v2);
                if (x1 instanceof TSAxisTics && axisTicsGbc != null) {
                    int sy = this.convertGridBagToRowCol(axisTicsGbc.gridy);
                    axisTicsGbc.gridy = this.convertPropertyRowColToGridBag(--sy);
                    ++axisTicsGbc.gridy;
                    this.add((Component)x1, axisTicsGbc.clone());
                }
                this.getViewportVector().remove(v2);
            }
            this.setVisible(true);
        }
        viewports = this.getViewports();
        for (i = 0; i < viewports.length; ++i) {
            v = viewports[i];
            v.resetAllDataLimits(viewports.length != 1);
        }
        if (this._legend != null) {
            this._legend.rebuildall();
            for (Viewport viewport : viewports) {
                this._legend.addViewport(viewport);
            }
            this._legend.invalidate();
            this._legend.repaint();
        }
        this.repaint();
    }

    public void showThumbnailPopupMenu(Component parent, int x, int y) {
        if (this.ignorePopupPlotEvent() || this._toolbar != null && this._toolbar.getSelectedButton() <= 1) {
            return;
        }
        JPopupMenu pMenu = this.createThumbnailPopupMenu();
        pMenu.show(parent, x, y);
    }

    protected JPopupMenu createThumbnailPopupMenu() {
        JPopupMenu pMenu = new JPopupMenu();
        pMenu.add(new RmaJMenuLabel("Thumbnail Plot"));
        pMenu.addSeparator();
        this.addThumbnailMenuItems(pMenu);
        return pMenu;
    }

    protected void addThumbnailMenuItems(Container c2) {
        JMenuItem popupAction = new JMenuItem("Show Popup");
        popupAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                G2dPanel.this.showPopupPlot();
            }
        });
        c2.add(popupAction);
    }

    public void showPopupPlot() {
        if (this.ignorePopupPlotEvent()) {
            return;
        }
        G2dDialog dialog = this.createPopupPlot();
        if (dialog == null) {
            return;
        }
        ((Window)dialog).setVisible(true);
    }

    public void setIgnorePopupPlotEvents(boolean b) {
        this.m_ignorePopupPlotEvents = b;
    }

    public boolean ignorePopupPlotEvent() {
        Window w = SwingUtilities.windowForComponent(this);
        if (w instanceof G2dDialog) {
            return true;
        }
        if (w instanceof Dialog && ((Dialog)w).isModal()) {
            return true;
        }
        return this.m_ignorePopupPlotEvents;
    }

    public Viewport[] getViewports() {
        Object[] viewportArray = new Viewport[this._viewportVector.size()];
        this._viewportVector.copyInto(viewportArray);
        return viewportArray;
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        this._transferHandler = transferHandler;
        super.setTransferHandler(this._transferHandler);
        for (int i = 0; i < this._viewportVector.size(); ++i) {
            ((Viewport)this._viewportVector.elementAt(i)).setTransferHandler(this._transferHandler);
        }
    }

    public ViewportToolbar getViewportToolbar() {
        return this._toolbar;
    }

    public boolean isPaintEnabled() {
        return this._paintEnabled;
    }

    public void setPaintEnabled(boolean b) {
        this._paintEnabled = b;
    }

    protected void addLegendToPosition(LegendPanel legend, int position) {
        if (position == 0) {
            this.HORIZONTAL_LEGEND_CONTAINER.add((Component)legend, LEGEND_CONTAINER_GRIDBAGCONSTRAINTS);
            this.LEGEND_CONTAINER = this.HORIZONTAL_LEGEND_CONTAINER;
        } else if (position == 1) {
            this.VERTICAL_LEGEND_CONTAINER.add((Component)legend, LEGEND_CONTAINER_GRIDBAGCONSTRAINTS);
            this.LEGEND_CONTAINER = this.VERTICAL_LEGEND_CONTAINER;
        }
    }

    public void moveLegendToPosition(int position) {
        if (this._legend == null) {
            return;
        }
        if (this.LEGEND_CONTAINER == null) {
            this.LEGEND_CONTAINER = this.findLegend();
        }
        Viewport[] viewports = this.getViewports();
        for (int i = 0; i < viewports.length; ++i) {
            viewports[i].setDrawViewportLegend(false);
            viewports[i].setDirty();
        }
        if (this.LEGEND_FRAME != null && this.LEGEND_FRAME.isVisible() && position != 5) {
            this.LEGEND_FRAME.setVisible(false);
            this.LEGEND_FRAME = null;
        }
        if (this.LEGEND_CONTAINER != null) {
            this.LEGEND_CONTAINER.remove(this._legend);
            this.LEGEND_CONTAINER.setPreferredSize(null);
        }
        if (position == 0) {
            int legendLayout = 0;
            if (this.LEGEND_CONTAINER instanceof JFrame) {
                ((JFrame)this.LEGEND_CONTAINER).setVisible(false);
                this.LEGEND_CONTAINER = ((JFrame)this.LEGEND_CONTAINER).getContentPane();
            }
            this._legend.setLegendPosistion(legendLayout);
            this._legend.setLayout(legendLayout);
            this._legend.rebuildall();
            this._legend.fillGlyphVector();
            this.HORIZONTAL_LEGEND_CONTAINER.add((Component)this._legend, LEGEND_CONTAINER_GRIDBAGCONSTRAINTS);
            this.LEGEND_CONTAINER = this.HORIZONTAL_LEGEND_CONTAINER;
            this._legend.revalidate();
            this._legend.setSize(this._legend.getPreferredSize());
            this.HORIZONTAL_LEGEND_CONTAINER.revalidate();
            this.HORIZONTAL_LEGEND_CONTAINER.doLayout();
            this.revalidate();
            this.LEGEND_CONTAINER.repaint();
            this._legend.repaint();
        } else if (position == 1) {
            int legendLayout = 1;
            if (this.LEGEND_CONTAINER instanceof JFrame) {
                ((JFrame)this.LEGEND_CONTAINER).setVisible(false);
                this.LEGEND_CONTAINER = ((JFrame)this.LEGEND_CONTAINER).getContentPane();
            }
            this._legend.setLegendPosistion(legendLayout);
            this._legend.setLayout(legendLayout);
            this._legend.rebuildall();
            this._legend.fillGlyphVector();
            this.VERTICAL_LEGEND_CONTAINER.add((Component)this._legend, LEGEND_CONTAINER_GRIDBAGCONSTRAINTS);
            this.LEGEND_CONTAINER = this.VERTICAL_LEGEND_CONTAINER;
            this.revalidate();
            this.LEGEND_CONTAINER.repaint();
            this._legend.repaint();
        } else if (position == 5) {
            boolean created = false;
            this.LEGEND_FRAME = new JFrame();
            this.LEGEND_FRAME.addWindowListener(new LegendWindowListener());
            this.LEGEND_FRAME.getContentPane().addMouseListener(new G2dPointerAdapter(new G2dPointerComponent(){

                @Override
                public boolean objectPopupMenu(LocalPt pt, int modifiers) {
                    return G2dPanel.this._legend.objectPopupMenu(pt, modifiers);
                }

                @Override
                public void pointerOver(LocalPt pt) {
                    G2dPanel.this._legend.pointerOver(pt);
                }

                @Override
                public boolean objectSelect(LocalPt pt, int modifiers) {
                    return G2dPanel.this._legend.objectSelect(pt, modifiers);
                }
            }, this._legendContainer));
            this.LEGEND_FRAME.setTitle("Legend");
            created = true;
            int legendLayout = 5;
            this._legend.setLegendPosistion(5);
            this._legend.rebuildall();
            this._legend.fillGlyphVector();
            Dimension d = this._legend.getPreferredSize();
            this.LEGEND_FRAME.getContentPane().setLayout(new BorderLayout());
            this.LEGEND_FRAME.getContentPane().add((Component)this._legend, "Center");
            if (created) {
                Point pt = new Point();
                pt.x = this.getSize().width / 2 + this.getLocation().x;
                pt.y = this.getSize().height / 2 + this.getLocation().y;
                pt.x -= this.LEGEND_FRAME.getSize().width / 2;
                pt.y -= this.LEGEND_FRAME.getSize().height / 2;
                this.LEGEND_FRAME.setLocation(pt);
            }
            this.LEGEND_FRAME.getContentPane().setPreferredSize(d);
            this.LEGEND_FRAME.pack();
            this.LEGEND_FRAME.setVisible(true);
            this.LEGEND_CONTAINER = this.LEGEND_FRAME;
        } else if (position == 6 || position == 7) {
            if (this.LEGEND_CONTAINER instanceof JFrame) {
                ((JFrame)this.LEGEND_CONTAINER).setVisible(false);
                this.LEGEND_CONTAINER = ((JFrame)this.LEGEND_CONTAINER).getContentPane();
            }
            if (this.LEGEND_CONTAINER != null) {
                this.LEGEND_CONTAINER.remove(this._legend);
            }
            this._legend.setLegendPosistion(position);
            for (Viewport viewport : viewports = this.getViewports()) {
                String align = 6 == position ? "Left" : "Right";
                viewport.setLegendAlignment(align);
                viewport.setDrawViewportLegend(true);
                viewport.setDirty();
            }
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private Container findLegend() {
        if (this.VERTICAL_LEGEND_CONTAINER.getComponents().length > 0) {
            return this.VERTICAL_LEGEND_CONTAINER;
        }
        if (this.HORIZONTAL_LEGEND_CONTAINER.getComponents().length > 0) {
            return this.HORIZONTAL_LEGEND_CONTAINER;
        }
        if (this.LEGEND_FRAME != null && this.LEGEND_FRAME.getContentPane().getComponents().length > 0) {
            return this.LEGEND_FRAME;
        }
        return null;
    }

    public void paintGfx() {
        if (!this._paintEnabled) {
            return;
        }
        Dimension dim = this.getSize();
        this.paintImmediately(0, 0, dim.width, dim.height);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return this.print(g, pageFormat, pageIndex, true, new PrintProperties());
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex, boolean useLocalPageFormat, PrintProperties printProperties) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        double imageableX = pageFormat.getImageableX();
        double imageableY = pageFormat.getImageableY();
        double pageWidth = pageFormat.getImageableWidth();
        double pageHeight = pageFormat.getImageableHeight();
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        Font origFont = g2.getFont();
        double scaleX = 1.0;
        double scaleY = 1.0;
        double plotWidth = this.getWidth();
        double plotHeight = this.getHeight();
        if (plotWidth > pageWidth) {
            scaleX = pageWidth / plotWidth;
        }
        double plotWidthOnPage = plotWidth * scaleX;
        double pageHeightForPlot = plotHeight * scaleY;
        g2.translate(imageableX, imageableY);
        if (useLocalPageFormat && printProperties.usePlotFrame()) {
            Color oldColor = g.getColor();
            g.setColor(Color.black);
            g.drawRect(0, 0, (int)pageWidth, (int)pageHeight);
            g.setColor(oldColor);
        }
        String printDateStr = new Date().toString().substring(4);
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDesent = g2.getFontMetrics().getDescent();
        int footerHeight = 0;
        boolean headerHeight = false;
        if (useLocalPageFormat && printProperties.usePageNumber()) {
            String pageStr = "Page: " + (pageIndex + 1);
            int pageStrLen = g.getFontMetrics().stringWidth(pageStr);
            g2.drawString(printDateStr, 2, (int)(pageHeight - (double)fontDesent));
            g2.drawString("Page: " + (pageIndex + 1), (int)(plotWidthOnPage / 2.0 - (double)(pageStrLen / 2)), (int)(pageHeight - (double)fontDesent));
            footerHeight = 2 * fontHeight;
        }
        if (plotHeight > pageHeight - (double)footerHeight - (double)headerHeight) {
            scaleY = (pageHeight - (double)footerHeight - (double)headerHeight) / plotHeight;
        }
        if (pageIndex == 0) {
            g2.translate(0.0, (double)headerHeight);
        }
        double scale = scaleX < scaleY ? scaleX : scaleY;
        g2.scale(scale, scale);
        Color oldbackgroundColor = this.getBackground();
        this.setBackground(new Color(0, 0, 0, 0));
        this.paintGfx(g);
        this.setBackground(oldbackgroundColor);
        g2.scale(1.0 / scaleX, 1.0 / scaleY);
        if (pageIndex == 0) {
            g2.translate(0.0, (double)(-fontHeight));
        }
        g2.translate(-imageableX, -imageableY);
        g2.setFont(origFont);
        return 0;
    }

    public double getFontScl() {
        return this._fontZoom;
    }

    public void resetFontScl() {
        this._referenceSize = this.getSize();
        this._fontZoom = 1.0;
    }

    @Override
    public void setBounds(Rectangle rc) {
        super.setBounds(rc);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (w == 0 || h == 0) {
            this._fontZoom = 0.0;
            return;
        }
        if (this._referenceSize == null) {
            this._referenceSize = new Dimension(w, h);
        }
        if (this.isVisible()) {
            double xscl = (double)w / (double)this._referenceSize.width;
            double yscl = (double)h / (double)this._referenceSize.height;
            this._fontZoom = Math.min(xscl, yscl);
        }
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
    }

    public void printStatus(String txt) {
    }

    public void clearPanel() {
        MouseMotionListener[] mouseMotionListeners;
        MouseListener[] mouseListeners;
        this.removeAll();
        for (MouseListener mouseListener : mouseListeners = this.getMouseListeners()) {
            if (!(mouseListener instanceof G2dMouseAdapter)) continue;
            this.removeMouseListener(mouseListener);
        }
        for (MouseMotionListener mouseMotionListener : mouseMotionListeners = this.getMouseMotionListeners()) {
            if (!(mouseMotionListener instanceof G2dMouseAdapter)) continue;
            this.removeMouseMotionListener(mouseMotionListener);
        }
        this.HORIZONTAL_LEGEND_CONTAINER.removeAll();
        this.VERTICAL_LEGEND_CONTAINER.removeAll();
        this.ACCESSORY_PANEL_CONTAINER.removeAll();
        this._scaleTable.clear();
        this._xAxisTable.clear();
        this._yAxisTable.clear();
        this._viewportVector.removeAllElements();
        this._viewportLinkTable.clear();
        this._legend = null;
        this._spacerList.clear();
        this.clearFocusListeners();
    }

    void clearPlot() {
        this.clearPlot(true);
    }

    void clearPlot(boolean reval) {
        Enumeration ev = this._viewportVector.elements();
        while (ev.hasMoreElements()) {
            Viewport v = (Viewport)ev.nextElement();
            v.clearPlot(false);
        }
        if (reval) {
            this.revalidate();
        }
    }

    public void addScaleToTable(String key, Scale scl) {
        if (key == null || scl == null) {
            return;
        }
        this._scaleTable.put(key, scl);
    }

    public PlotLayout getPlotLayout() {
        return this._plotLayout;
    }

    public void buildComponents(PlotLayout plotLayout) {
        Viewport v;
        int j;
        ViewportLayout viewLayout;
        int i;
        if (plotLayout == null) {
            return;
        }
        this.clearPanel();
        this._plotLayout = plotLayout;
        G2dPanelProp panelProperties = new G2dPanelProp();
        panelProperties.hasLegend = plotLayout.hasLegend();
        panelProperties.hasToolbar = plotLayout.hasToolbar();
        int numViewports = plotLayout.getViewportCount();
        ViewportToolbarProp toolbarProperties = plotLayout.getToolbarProperties();
        panelProperties.toolbarProp = toolbarProperties != null ? toolbarProperties : G2dPanel.createDefaultToolbarProperties();
        String title = plotLayout.getTitle();
        if (title != null && title.length() > 0) {
            panelProperties.titleProp.text = plotLayout.getTitle();
            panelProperties.titleProp.drawTitle = true;
            panelProperties.hasTitle = true;
        }
        ArrayList dataList = new ArrayList();
        List<ViewportLayout> viewportLayoutList = plotLayout.getViewports();
        double[] viewportRowWeights = plotLayout.getViewportWeights();
        RmaMath.normalize(viewportRowWeights, 1.0);
        ArrayList drawingPropertiesList = new ArrayList();
        HashMap dataObjToScaleName = new HashMap();
        HashMap<String, ViewportLayout> x1AxisTicsVisible = new HashMap<String, ViewportLayout>();
        for (i = numViewports - 1; i >= 0; --i) {
            viewLayout = viewportLayoutList.get(i);
            String name = viewLayout.getAxisName("X1");
            if (name == null || x1AxisTicsVisible.get(name) != null) continue;
            x1AxisTicsVisible.put(name, viewLayout);
        }
        for (i = 0; i < numViewports; ++i) {
            int zzz;
            String label;
            String type;
            G2dObject dataObj;
            boolean hasxX1Y2Data;
            DataType dataType;
            boolean hasX1Y1Data;
            viewLayout = viewportLayoutList.get(i);
            G2dPlotProp plotProperties = new G2dPlotProp();
            panelProperties.addPlotProp(plotProperties);
            plotProperties.col = 0;
            plotProperties.row = i;
            plotProperties.rowweight = viewportRowWeights[i];
            plotProperties.hasX1Label = false;
            plotProperties.hasX1Tics = false;
            plotProperties.hasX1Axis = false;
            plotProperties.hasXScroll = i == numViewports - 1;
            plotProperties.hasY1Axis = hasX1Y1Data = viewLayout.hasY1Data("X1");
            plotProperties.hasY1Tics = hasX1Y1Data;
            plotProperties.hasY1Label = hasX1Y1Data;
            plotProperties.viewportDrawProp.drawViewportLegend(viewLayout.isViewportLegendVisible());
            plotProperties.x1AxisProp.isReversed = viewLayout.isAxisReversed("X1");
            plotProperties.x2AxisProp.isReversed = viewLayout.isAxisReversed("X2");
            plotProperties.y1AxisProp.isReversed = viewLayout.isAxisReversed("Y1");
            plotProperties.y2AxisProp.isReversed = viewLayout.isAxisReversed("Y2");
            String axisName = viewLayout.getAxisName("X2");
            if (axisName != null) {
                plotProperties.x2AxisProp.name = axisName;
                plotProperties.x2AxisProp.label = axisName;
            }
            String y1AxisLabel = null;
            if (hasX1Y1Data) {
                String label2;
                String name = viewLayout.getAxisName("X1");
                plotProperties.hasX1Tics = x1AxisTicsVisible.get(name) != null || i == numViewports - 1;
                plotProperties.hasX1Axis = true;
                List y1Data = viewLayout.getY1Data("X1");
                List y1DataDrawProp = viewLayout.getY1DataProperties("X1");
                G2dObject dataObj2 = (G2dObject)y1Data.get(0);
                dataType = DataTypeFactory.getFactory().getDataType(dataObj2);
                dataList.addAll(y1Data);
                drawingPropertiesList.addAll(y1DataDrawProp);
                axisName = viewLayout.getAxisName("Y1");
                if (axisName == null) {
                    axisName = this.getYName(dataObj2, dataType);
                }
                plotProperties.y1AxisProp.name = axisName;
                plotProperties.y1AxisProp.label = this.getYName(dataObj2, dataType);
                plotProperties.y1AxisProp.type = dataObj2.getYAxisType();
                String type2 = viewLayout.getAxisType("Y1");
                if (type2 != null) {
                    plotProperties.y1AxisProp.type = viewLayout.convertAxisType(type2);
                }
                if (plotProperties.y1AxisProp.isReversed && dataType != null) {
                    boolean bl = plotProperties.y1AxisProp.isReversed = !dataType.isYAxisReversed();
                }
                if ((axisName = viewLayout.getAxisName("X1")) == null) {
                    axisName = dataObj2.getXAxisName().trim();
                }
                plotProperties.x1AxisProp.name = axisName;
                plotProperties.x1AxisProp.label = dataObj2.getXAxisName().trim();
                type2 = viewLayout.getAxisType("X1");
                plotProperties.x1AxisProp.type = dataObj2.getXAxisType();
                if (type2 != null) {
                    plotProperties.x1AxisProp.type = viewLayout.convertAxisType(type2);
                }
                if ((label2 = viewLayout.getAxisLabel("X1")) != null) {
                    plotProperties.x1AxisProp.label = label2;
                }
                if ((label2 = viewLayout.getAxisLabel("X2")) != null) {
                    plotProperties.x2AxisProp.label = label2;
                }
                if ((label2 = viewLayout.getAxisLabel("Y1")) != null) {
                    plotProperties.y1AxisProp.label = label2;
                }
                if (y1AxisLabel == null) {
                    y1AxisLabel = plotProperties.y1AxisProp.name;
                }
                String[] args = new String[]{y1AxisLabel, plotProperties.x1AxisProp.name};
                String scaleName = Scale.SCALE_NAME_FORMAT.format(args);
                for (int zzz2 = 0; zzz2 < y1Data.size(); ++zzz2) {
                    dataObjToScaleName.put(y1Data.get(zzz2), scaleName);
                }
            }
            plotProperties.hasY2Axis = hasxX1Y2Data = viewLayout.hasY2Data("X1");
            plotProperties.hasY2Tics = hasxX1Y2Data;
            plotProperties.hasY2Label = hasxX1Y2Data;
            if (hasxX1Y2Data) {
                String name = viewLayout.getAxisName("X1");
                plotProperties.hasX1Tics = x1AxisTicsVisible.get(name) != null || i == numViewports - 1;
                plotProperties.hasX1Axis = true;
                List y2Data = viewLayout.getY2Data("X1");
                List y2DataDrawProp = viewLayout.getY2DataProperties("X1");
                G2dObject dataObj3 = (G2dObject)y2Data.get(0);
                dataList.addAll(y2Data);
                drawingPropertiesList.addAll(y2DataDrawProp);
                dataType = DataTypeFactory.getFactory().getDataType(dataObj3);
                axisName = viewLayout.getAxisName("Y2");
                if (axisName == null) {
                    axisName = this.getYName(dataObj3, dataType);
                }
                plotProperties.y2AxisProp.name = axisName;
                plotProperties.y2AxisProp.label = this.getYName(dataObj3, dataType);
                plotProperties.y2AxisProp.type = dataObj3.getYAxisType();
                String type3 = viewLayout.getAxisType("Y2");
                if (type3 != null) {
                    plotProperties.y2AxisProp.type = viewLayout.convertAxisType(type3);
                }
                if (plotProperties.y2AxisProp.isReversed && dataType != null) {
                    boolean bl = plotProperties.y2AxisProp.isReversed = !dataType.isYAxisReversed();
                }
                if ((axisName = viewLayout.getAxisName("X1")) == null) {
                    axisName = dataObj3.getXAxisName().trim();
                }
                plotProperties.x1AxisProp.name = axisName;
                plotProperties.x1AxisProp.label = dataObj3.getXAxisName().trim();
                plotProperties.x1AxisProp.type = dataObj3.getXAxisType();
                type3 = viewLayout.getAxisType("X1");
                if (type3 != null) {
                    plotProperties.x1AxisProp.type = viewLayout.convertAxisType(type3);
                }
                plotProperties.y2AxisProp.rateData = viewLayout.hasAutoRatedAxis();
                plotProperties.y2AxisProp.ratingFunction = viewLayout.getRatingFunction();
                String label3 = viewLayout.getAxisLabel("X1");
                if (label3 != null) {
                    plotProperties.x1AxisProp.label = label3;
                }
                if ((label3 = viewLayout.getAxisLabel("Y2")) != null) {
                    plotProperties.y2AxisProp.label = label3;
                }
                String[] args = new String[]{plotProperties.y2AxisProp.name, plotProperties.x1AxisProp.name};
                String scaleName = Scale.SCALE_NAME_FORMAT.format(args);
                for (int zzz3 = 0; zzz3 < y2Data.size(); ++zzz3) {
                    dataObjToScaleName.put(y2Data.get(zzz3), scaleName);
                }
            }
            plotProperties.hasX2Label = false;
            boolean hasX2Y1Data = viewLayout.hasY1Data("X2");
            boolean hasX2Y2Data = viewLayout.hasY2Data("X2");
            plotProperties.hasX2Axis = hasX2Y1Data || hasX2Y2Data;
            plotProperties.hasX2Tics = hasX2Y1Data || hasX2Y2Data;
            plotProperties.hasX2Label = hasX2Y1Data || hasX2Y2Data;
            plotProperties.hasY1Axis |= hasX2Y1Data;
            plotProperties.hasY1Tics |= hasX2Y1Data;
            plotProperties.hasY1Label |= hasX2Y1Data;
            plotProperties.viewportDrawProp.drawViewportLegend(viewLayout.isViewportLegendVisible());
            axisName = viewLayout.getAxisName("X2");
            if (axisName != null) {
                plotProperties.x2AxisProp.name = axisName;
                plotProperties.x2AxisProp.label = axisName;
            }
            if (hasX2Y1Data) {
                List y1Data = viewLayout.getY1Data("X2");
                List y1DataDrawProp = viewLayout.getY1DataProperties("X2");
                dataObj = (G2dObject)y1Data.get(0);
                dataType = DataTypeFactory.getFactory().getDataType(dataObj);
                dataList.addAll(y1Data);
                drawingPropertiesList.addAll(y1DataDrawProp);
                axisName = viewLayout.getAxisName("Y1");
                if (axisName == null) {
                    axisName = this.getYName(dataObj, dataType);
                }
                if (plotProperties.y1AxisProp.name == null || plotProperties.y1AxisProp.name.length() == 0) {
                    plotProperties.y1AxisProp.name = axisName;
                    plotProperties.y1AxisProp.label = this.getYName(dataObj, dataType);
                    plotProperties.y1AxisProp.type = dataObj.getYAxisType();
                }
                plotProperties.y1AxisProp.type = dataObj.getYAxisType();
                type = viewLayout.getAxisType("Y1");
                if (type != null) {
                    plotProperties.y1AxisProp.type = viewLayout.convertAxisType(type);
                }
                if (plotProperties.y1AxisProp.isReversed && dataType != null) {
                    boolean bl = plotProperties.y1AxisProp.isReversed = !dataType.isYAxisReversed();
                }
                if ((axisName = viewLayout.getAxisName("X2")) == null) {
                    axisName = dataObj.getXAxisName().trim();
                }
                plotProperties.x2AxisProp.name = axisName;
                plotProperties.x2AxisProp.label = dataObj.getXAxisName().trim();
                type = viewLayout.getAxisType("X2");
                plotProperties.x2AxisProp.type = dataObj.getXAxisType();
                if (type != null) {
                    plotProperties.x2AxisProp.type = viewLayout.convertAxisType(type);
                }
                if ((label = viewLayout.getAxisLabel("X2")) != null) {
                    plotProperties.x2AxisProp.label = label;
                }
                if ((label = viewLayout.getAxisLabel("Y1")) != null) {
                    plotProperties.y1AxisProp.label = label;
                }
                if (y1AxisLabel == null) {
                    y1AxisLabel = plotProperties.y1AxisProp.name;
                }
                String[] args = new String[]{y1AxisLabel, plotProperties.x2AxisProp.name};
                String scaleName = Scale.SCALE_NAME_FORMAT.format(args);
                for (zzz = 0; zzz < y1Data.size(); ++zzz) {
                    dataObjToScaleName.put(y1Data.get(zzz), scaleName);
                }
            }
            plotProperties.hasY2Axis |= hasX2Y2Data;
            plotProperties.hasY2Tics |= hasX2Y2Data;
            plotProperties.hasY2Label |= hasX2Y2Data;
            if (hasX2Y2Data) {
                List y2Data = viewLayout.getY2Data("X2");
                List y2DataDrawProp = viewLayout.getY2DataProperties("X2");
                dataObj = (G2dObject)y2Data.get(0);
                dataList.addAll(y2Data);
                drawingPropertiesList.addAll(y2DataDrawProp);
                dataType = DataTypeFactory.getFactory().getDataType(dataObj);
                axisName = viewLayout.getAxisName("Y2");
                if (axisName == null) {
                    axisName = this.getYName(dataObj, dataType);
                }
                plotProperties.y2AxisProp.name = axisName;
                plotProperties.y2AxisProp.label = this.getYName(dataObj, dataType);
                plotProperties.y2AxisProp.type = dataObj.getYAxisType();
                type = viewLayout.getAxisType("Y2");
                if (type != null) {
                    plotProperties.y2AxisProp.type = viewLayout.convertAxisType(type);
                }
                if (plotProperties.y2AxisProp.isReversed && dataType != null) {
                    boolean bl = plotProperties.y2AxisProp.isReversed = !dataType.isYAxisReversed();
                }
                if ((axisName = viewLayout.getAxisName("X2")) == null) {
                    axisName = dataObj.getXAxisName().trim();
                }
                plotProperties.x2AxisProp.name = axisName;
                plotProperties.x2AxisProp.label = dataObj.getXAxisName().trim();
                plotProperties.x2AxisProp.type = dataObj.getXAxisType();
                type = viewLayout.getAxisType("X2");
                if (type != null) {
                    plotProperties.x2AxisProp.type = viewLayout.convertAxisType(type);
                }
                plotProperties.y2AxisProp.rateData = viewLayout.hasAutoRatedAxis();
                plotProperties.y2AxisProp.ratingFunction = viewLayout.getRatingFunction();
                label = viewLayout.getAxisLabel("X2");
                if (label != null) {
                    plotProperties.x2AxisProp.label = label;
                }
                if ((label = viewLayout.getAxisLabel("Y2")) != null) {
                    plotProperties.y2AxisProp.label = label;
                }
                String[] args = new String[]{plotProperties.y2AxisProp.name, plotProperties.x1AxisProp.name};
                String scaleName = Scale.SCALE_NAME_FORMAT.format(args);
                for (zzz = 0; zzz < y2Data.size(); ++zzz) {
                    dataObjToScaleName.put(y2Data.get(zzz), scaleName);
                }
            }
            plotProperties.hasX1Label = i == numViewports - 1 && plotProperties.x1AxisProp.type != 1;
        }
        this.configurePanel(panelProperties);
        DataTypeFactory.getFactory().reset();
        List<LineProperties> dataLineSytles = DataTypeFactory.getFactory().getLineProperties(dataList, true);
        int propCntr = 0;
        for (j = 0; j < viewportLayoutList.size(); ++j) {
            ViewportLayout viewLayout2 = viewportLayoutList.get(j);
            if (j >= this._viewportVector.size()) continue;
            v = (Viewport)this._viewportVector.get(j);
            List<ViewportLayer> viewportLayers = viewLayout2.getViewportLayers();
            viewportLayers.forEach(viewportLayer -> v.addComponentLayer((ViewportLayer<?>)viewportLayer));
            List dataObjects = viewLayout2.getY1Data("X1");
            List tempList = viewLayout2.getY2Data("X1");
            if (tempList != null) {
                dataObjects.addAll(tempList);
            }
            if ((tempList = viewLayout2.getY1Data("X2")) != null) {
                dataObjects.addAll(tempList);
            }
            if ((tempList = viewLayout2.getY2Data("X2")) != null) {
                dataObjects.addAll(tempList);
            }
            G2dLineProperties[] lineProperties = null;
            for (int z = 0; z < dataObjects.size(); ++z) {
                G2dObject g2dObj = (G2dObject)dataObjects.get(z);
                if (g2dObj == null) continue;
                lineProperties = new G2dLineProperties[g2dObj.getCurveCount()];
                for (int yy = 0; yy < g2dObj.getCurveCount(); ++yy) {
                    lineProperties[yy] = (G2dLineProperties)drawingPropertiesList.get(propCntr);
                    if (lineProperties[yy] == null && propCntr < dataLineSytles.size()) {
                        lineProperties[yy] = (G2dLineProperties)dataLineSytles.get(propCntr);
                    }
                    ++propCntr;
                }
                String scaleName = (String)dataObjToScaleName.get(g2dObj);
                Scale s = v.getScale(scaleName);
                v.addG2dObject(g2dObj, lineProperties, s);
            }
            v.updateRatingAxisValues();
        }
        for (j = 0; j < viewportLayoutList.size(); ++j) {
            ViewportLayout viewLayout3 = viewportLayoutList.get(j);
            if (j >= this._viewportVector.size()) continue;
            v = (Viewport)this._viewportVector.get(j);
            List y1Markerlines = viewLayout3.getY1MarkerLines();
            List y1MarkerlineProps = viewLayout3.getY1MarklineProps();
            for (int k = 0; k < y1Markerlines.size(); ++k) {
                G2dMarkerProperties props = (G2dMarkerProperties)y1MarkerlineProps.get(k);
                props = props == null ? new G2dMarkerProperties() : props.clone();
                props.markerValue = (Double)y1Markerlines.get(k);
                props.setDrawOnAxis(1);
                v.addAxisMarker(props);
            }
        }
        for (j = 0; j < viewportLayoutList.size(); ++j) {
            ViewportLayout viewLayout4 = viewportLayoutList.get(j);
            if (j >= this._viewportVector.size()) continue;
            v = (Viewport)this._viewportVector.get(j);
            List x1Markerlines = viewLayout4.getX1MarkerLines();
            List x1MarkerlineProps = viewLayout4.getX1MarklineProps();
            for (int k = 0; k < x1Markerlines.size(); ++k) {
                G2dMarkerProperties props = (G2dMarkerProperties)x1MarkerlineProps.get(k);
                props = props == null ? new G2dMarkerProperties() : props.clone();
                props.markerValue = (Double)x1Markerlines.get(k);
                props.setDrawOnAxis(0);
                v.addAxisMarker(props);
            }
            List<G2dMarkerPointProperties> markerPointProps = viewLayout4.getMarkerPoints();
            if (markerPointProps == null) continue;
            for (int i2 = 0; i2 < markerPointProps.size(); ++i2) {
                G2dMarkerPointProperties pointProps = markerPointProps.get(i2);
                if (pointProps == null) continue;
                v.addAxisPointMarker(pointProps);
            }
        }
        if (this._legend != null) {
            this._legend.fillGlyphVector();
        }
        for (int i3 = 0; i3 < this._viewportVector.size(); ++i3) {
            ((Viewport)this._viewportVector.get(i3)).updateRatingAxisValues();
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    protected Scale createScale(String scaleName) {
        return new Scale(scaleName);
    }

    public void buildDefaultComponents() {
        this.clearPanel();
        Axis x = new Axis("X Axis");
        this._xAxisTable.put(x.getName(), x);
        Axis y = new Axis("Y Axis");
        y.setReversed(true);
        this._yAxisTable.put(y.getName(), y);
        Axis y2 = new Axis("Y2 Axis");
        y2.setReversed(true);
        this._yAxisTable.put(y2.getName(), y2);
        Hashtable<Integer, Axis> masterAxisTable = new Hashtable<Integer, Axis>();
        masterAxisTable.put(new Integer(1), y);
        masterAxisTable.put(new Integer(0), x);
        Scale scl = this.createScale("scale1");
        scl.setAxis(x, 0);
        scl.setAxis(y, 1);
        Scale scl2 = this.createScale("scale2");
        scl2.setAxis(x, 0);
        scl2.setAxis(y2, 1);
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        Insets insets = new Insets(3, 3, 3, 3);
        Axis[] ax = new Axis[1];
        Axis[] ay = new Axis[1];
        Scale[] vs = new Scale[1];
        boolean[] showXtics = new boolean[1];
        boolean[] showXlabel = new boolean[1];
        boolean[] showYtics = new boolean[1];
        boolean[] showYlabel = new boolean[1];
        ax[0] = x;
        ay[0] = y;
        vs[0] = scl;
        showXtics[0] = false;
        showXlabel[0] = false;
        boolean showXscroll = false;
        showYtics[0] = true;
        showYlabel[0] = true;
        boolean showYscroll = true;
        Viewport v1 = this.buildPlotComponents(0, 0, 1.0, 0.3, 1, 1, ax, ay, vs, showXtics, showXlabel, showXscroll, showYtics, showYlabel, showYscroll);
        v1.setMasterAxisTable(masterAxisTable);
        v1.addG2dObject(new SimpleArray());
        ax[0] = x;
        ay[0] = y2;
        vs[0] = scl2;
        showXtics[0] = true;
        showXlabel[0] = true;
        showXscroll = true;
        showYtics[0] = true;
        showYlabel[0] = true;
        showYscroll = true;
        masterAxisTable.clear();
        masterAxisTable.put(new Integer(1), y2);
        masterAxisTable.put(new Integer(0), x);
        Viewport v2 = this.buildPlotComponents(0, 1, 1.0, 1.0, 1, 1, ax, ay, vs, showXtics, showXlabel, showXscroll, showYtics, showYlabel, showYscroll);
        v2.setMasterAxisTable(masterAxisTable);
        v2.addG2dObject(new SimpleArray());
        TitlePanel title = new TitlePanel(this, "Sample Plot");
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 3;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.insets = insets;
        gridbag.setConstraints(title, gc);
        this.add(title);
        ViewportToolbar tools = new ViewportToolbar(this);
        this.createDefaultMapTools(tools);
        tools.addViewport(v1);
        tools.addViewport(v2);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 0;
        gc.fill = 3;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.insets = new Insets(0, 0, 0, 0);
        gridbag.setConstraints(tools, gc);
        this.add(tools);
        this._toolbar = tools;
        tools.addToolbarListener(this);
        Component[] comps = this.getComponents();
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof G2dToolbarListener)) continue;
            tools.addToolbarListener((G2dComponent)comps[i]);
        }
        tools.forceSelectButton(1);
    }

    public void addLegendContainers() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 250;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.fill = 3;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.gridheight = 0;
        gc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.VERTICAL_LEGEND_CONTAINER, gc);
        gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.gridy = 250;
        gc.gridwidth = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.HORIZONTAL_LEGEND_CONTAINER, gc);
    }

    public G2dComponent[] getComponents(Predicate<G2dComponent> p) {
        Component[] components = this.getComponents();
        ArrayList<Component> startingList = new ArrayList<Component>();
        startingList.addAll(Arrays.asList(components));
        ArrayList<G2dComponent> results = new ArrayList<G2dComponent>();
        for (int i = 0; i < startingList.size(); ++i) {
            Component component = (Component)startingList.get(i);
            if (component instanceof Container) {
                Component[] components1 = ((Container)component).getComponents();
                startingList.addAll(Arrays.asList(components1));
            }
            if (!(component instanceof G2dComponent) || !p.test((G2dComponent)component)) continue;
            results.add((G2dComponent)component);
        }
        return results.toArray(new G2dComponent[results.size()]);
    }

    public void applyToAll(Consumer<G2dComponent> c2) {
        Component[] components = this.getComponents();
        ArrayList<Component> startingList = new ArrayList<Component>();
        startingList.addAll(Arrays.asList(components));
        for (int i = 0; i < startingList.size(); ++i) {
            Component component = (Component)startingList.get(i);
            if (component instanceof Container) {
                Component[] components1 = ((Container)component).getComponents();
                startingList.addAll(Arrays.asList(components1));
            }
            if (!(component instanceof G2dComponent)) continue;
            c2.accept((G2dComponent)component);
        }
    }

    public void buildComponents(List objvec) {
        this.buildComponents(objvec, true, true);
    }

    public void buildComponents(List objvec, boolean addToolbar, boolean addLegend) {
        if (objvec == null || objvec.size() < 1) {
            this.buildDefaultComponents();
        }
        Vector<Color> colorvec = new Vector<Color>();
        for (int i = 0; i < objvec.size(); ++i) {
            colorvec.addElement(_lineColor[i % _lineColor.length]);
        }
        this.buildComponents(objvec, colorvec, addToolbar, addLegend);
    }

    public void buildComponents(List objvec, List colorvec) {
        this.buildComponents(objvec, colorvec, true, true);
    }

    public void buildComponents(List objvec, List colorvec, boolean addToolbar, boolean addLegend) {
        Enumeration ev;
        int i;
        if (objvec == null || objvec.size() < 1) {
            this.buildDefaultComponents();
            return;
        }
        if (colorvec == null) {
            colorvec = new Vector<Object>();
        }
        ArrayList<G2dObject> curveList = new ArrayList<G2dObject>();
        int numCurves = 0;
        for (int i2 = 0; i2 < objvec.size(); ++i2) {
            for (int iCurve = 0; iCurve < ((G2dObject)objvec.get(i2)).getCurveCount(); ++iCurve) {
                curveList.add((G2dObject)objvec.get(i2));
            }
            numCurves += ((G2dObject)objvec.get(i2)).getCurveCount();
        }
        if (colorvec.size() < numCurves) {
            List<LineProperties> newColors;
            for (int istart = colorvec.size(); istart < numCurves; istart += newColors.size()) {
                Vector<G2dObject> dssVec = new Vector<G2dObject>();
                dssVec.add((G2dObject)curveList.get(istart));
                newColors = DataTypeFactory.getFactory().getLineProperties(dssVec);
                if (newColors.size() == 0) {
                    colorvec.add(_lineColor[istart % _lineColor.length]);
                    ++istart;
                }
                colorvec.addAll(newColors);
            }
        }
        this._components = objvec;
        this.clearPanel();
        double rowWeight = 1.0;
        ArrayList<Scale> scaleList = new ArrayList<Scale>();
        for (i = 0; i < objvec.size(); ++i) {
            String sclname;
            Scale scl;
            Object o = objvec.get(i);
            if (!(o instanceof G2dObject)) continue;
            G2dObject go = (G2dObject)o;
            DataType dataType = DataTypeFactory.getFactory().getDataType(go);
            String xname = go.getXAxisName();
            Axis xa = (Axis)this._xAxisTable.get(xname.toLowerCase());
            if (xa == null) {
                xa = this.createAxis(go.getXAxisType(), xname);
                xa.setTicColor(this._ticBottom);
                xa.setTicTextColor(this._ticTextBottom);
                this._xAxisTable.put(xname.toLowerCase(), xa);
            }
            if (go instanceof G2dData) {
                String xUnit = ((G2dData)go).xunits;
                xa.setUnit(xUnit);
            }
            String yname = this.getYName(go, dataType);
            rowWeight = dataType != null && dataType != DataTypeFactory.UNDEFINED_DATA_TYPE ? (dataType.hasViewportWeight() ? dataType.getViewportWeight() : 1.0) : 1.0;
            Axis ya = (Axis)this._yAxisTable.get(yname.toLowerCase());
            if (ya == null) {
                ya = this.createAxis(go.getYAxisType(), yname);
                if (dataType != null) {
                    ya.setReversed(!dataType.isYAxisReversed());
                    ya.setParameterId(dataType.getParameterId());
                    if (dataType.hasDefaultMaxAxisValue()) {
                        go.setDefaultMaxYValue(dataType.getDefaultMaxAxisValue());
                    }
                    if (dataType.hasDefaultMinAxisValue()) {
                        go.setDefaultMinYValue(dataType.getDefaultMinAxisValue());
                    }
                } else {
                    ya.setReversed(true);
                }
                ya.setTicColor(this._ticLeft);
                ya.setTicTextColor(this._ticTextLeft);
                this._yAxisTable.put(yname.toLowerCase(), ya);
            }
            if (go instanceof G2dData) {
                String yUnit = ((G2dData)go).yunits;
                ya.setUnit(yUnit);
            }
            if ((scl = (Scale)this._scaleTable.get(sclname = yname.toLowerCase() + " vs " + xname.toLowerCase())) == null) {
                scl = this.createScale(sclname);
                scl.setRowWeight(rowWeight);
                scl.setAxis(xa, 0);
                scl.setAxis(ya, 1);
                this.addScaleToTable(sclname, scl);
                scaleList.add(scl);
                continue;
            }
            scl.setRowWeight(rowWeight);
        }
        int icnt = 0;
        int nscl = this._scaleTable.size();
        int ncol = this._xAxisTable.size();
        int maxrow = this._yAxisTable.size();
        Axis[] xaOrder = new Axis[ncol];
        icnt = 0;
        Enumeration e = this._xAxisTable.elements();
        while (e.hasMoreElements()) {
            xaOrder[icnt] = (Axis)e.nextElement();
            ++icnt;
        }
        Axis[][] yaOrder = new Axis[ncol][maxrow];
        int[] nrow = new int[ncol];
        for (i = 0; i < ncol; ++i) {
            nrow[i] = 0;
        }
        int irow = 0;
        int icol = 0;
        int iscl = 0;
        int[][] sclcolrow = new int[2][this._scaleTable.size()];
        HashMap<Integer, Map> furthestAxisInRow = new HashMap<Integer, Map>();
        for (int zz = 0; zz < scaleList.size(); ++zz) {
            Map axisIntegerMap;
            Integer greatestRightMostPosition;
            Scale scl = (Scale)scaleList.get(zz);
            Axis xscl = scl.getAxis(0);
            Axis yscl = scl.getAxis(1);
            icol = -1;
            for (i = 0; i < ncol; ++i) {
                if (xscl != xaOrder[i]) continue;
                icol = i;
                break;
            }
            if (icol < 0) {
                ++iscl;
                continue;
            }
            irow = -1;
            for (i = 0; i < nrow[icol]; ++i) {
                if (yscl != yaOrder[icol][i]) continue;
                irow = i;
                break;
            }
            if (irow < 0) {
                irow = nrow[icol];
                yaOrder[icol][irow] = yscl;
                int n = icol;
                nrow[n] = nrow[n] + 1;
            }
            if (icol > (greatestRightMostPosition = (axisIntegerMap = furthestAxisInRow.computeIfAbsent(irow, k -> new HashMap())).getOrDefault(yscl, -1))) {
                axisIntegerMap.put(yscl, icol);
            }
            sclcolrow[0][iscl] = icol;
            sclcolrow[1][iscl] = irow;
            ++iscl;
        }
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        Insets insets = new Insets(3, 3, 3, 3);
        Axis[] ax = new Axis[1];
        Axis[] ay = new Axis[1];
        Scale[] vs = new Scale[1];
        boolean[] showXtics = new boolean[1];
        boolean[] showXlabel = new boolean[1];
        boolean[] showYtics = new boolean[1];
        boolean[] showYlabel = new boolean[1];
        iscl = 0;
        for (int zz = 0; zz < scaleList.size(); ++zz) {
            boolean showXscroll;
            Scale scl;
            vs[0] = scl = (Scale)scaleList.get(zz);
            ax[0] = vs[0].getAxis(0);
            ay[0] = vs[0].getAxis(1);
            irow = sclcolrow[1][iscl];
            icol = sclcolrow[0][iscl];
            if (irow == nrow[icol] - 1) {
                showXtics[0] = true;
                showXlabel[0] = !(ax[0] instanceof TSAxis);
                showXscroll = true;
            } else {
                showXtics[0] = false;
                showXlabel[0] = false;
                showXscroll = false;
            }
            showYtics[0] = true;
            showYlabel[0] = true;
            Map axisIntegerMap = furthestAxisInRow.getOrDefault(irow, new HashMap());
            boolean showYscroll = Objects.equals(icol, axisIntegerMap.get(ay[0]));
            Viewport v1 = this.buildPlotComponents(icol, irow, 1.0, scl.getRowWeight(), 1, 1, ax, ay, vs, showXtics, showXlabel, showXscroll, showYtics, showYlabel, showYscroll);
            v1.addObjectSelectionListener(this);
            TransferHandler transferHandler = this.getTransferHandler();
            if (transferHandler != null) {
                v1.setTransferHandler(transferHandler);
            }
            this._viewportVector.addElement(v1);
            ++iscl;
        }
        int curvecnt = 0;
        int objcnt = 0;
        block10: for (int z = 0; z < objvec.size(); ++z) {
            G2dObject go = (G2dObject)objvec.get(z);
            DataType dataType = DataTypeFactory.getFactory().getDataType(go);
            String yname = this.getYName(go, dataType);
            String sclname = yname.toLowerCase() + " vs " + go.getXAxisName().toLowerCase();
            Scale scl = (Scale)this._scaleTable.get(sclname);
            ev = this._viewportVector.elements();
            while (ev.hasMoreElements()) {
                Viewport v = (Viewport)ev.nextElement();
                if (v.getScale() == scl && scl != null) {
                    G2dLineProperties[] lineProp = new G2dLineProperties[go.getCurveCount()];
                    for (int zz = 0; zz < go.getCurveCount(); ++zz) {
                        Object colorObj = colorvec.get(curvecnt);
                        if (colorObj instanceof G2dLineProperties) {
                            lineProp[zz] = (G2dLineProperties)colorObj;
                        } else if (colorObj instanceof Color) {
                            lineProp[zz] = new G2dLineProperties();
                            lineProp[zz].setLineColor((Color)colorvec.get(curvecnt));
                            lineProp[zz].setFillColor(_fillColor[objcnt % _fillColor.length]);
                            if (go instanceof TimeSeriesDataSet) {
                                TimeSeriesDataSet tsdt = (TimeSeriesDataSet)go;
                                if (tsdt._timeSeries != null && tsdt._timeSeries.type != null && tsdt._timeSeries.type.toUpperCase().startsWith("PER")) {
                                    lineProp[zz].setLineStepStyle(1);
                                }
                            }
                        }
                        ++curvecnt;
                    }
                    v.addG2dObject(go, lineProp);
                    continue block10;
                }
                ++objcnt;
            }
        }
        this._title = new G2dTitle(this);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 0;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._title, gc);
        this._legend = new LegendPanel(this, 0);
        this.addLegendContainers();
        LegendPanelProp legendProp = this._panelProperties.legendProp;
        this.addLegendToPosition(this._legend, 0);
        this._legend.setLegendPosistion(0);
        this.HORIZONTAL_LEGEND_CONTAINER.add((Component)this._legend, LEGEND_CONTAINER_GRIDBAGCONSTRAINTS);
        this.LEGEND_CONTAINER = this.HORIZONTAL_LEGEND_CONTAINER;
        this._legend.setBorder(BorderFactory.createLoweredBevelBorder());
        ev = this._viewportVector.elements();
        while (ev.hasMoreElements()) {
            this._legend.addViewport((Viewport)ev.nextElement());
        }
        this.moveLegendToPosition(legendProp.layoutPosition);
        this.setLegendVisible(legendProp.legendVisible);
        if (addLegend) {
            this.setLegendVisible(true);
        } else {
            this.setLegendVisible(false);
        }
        if (addToolbar) {
            ViewportToolbar tools;
            this._toolbar = tools = new ViewportToolbar(this);
            this.createDefaultMapTools(tools);
            Enumeration ev2 = this._viewportVector.elements();
            while (ev2.hasMoreElements()) {
                tools.addViewport((Viewport)ev2.nextElement());
            }
            gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridheight = 0;
            gc.fill = 3;
            gc.weightx = 0.0;
            gc.weighty = 1.0;
            gc.insets = insets;
            gridbag.setConstraints(tools, gc);
            this.add(tools);
            tools.addToolbarListener(this);
            Component[] comps = this.getComponents();
            if (comps == null) {
                return;
            }
            for (int z = 0; z < comps.length; ++z) {
                if (!(comps[z] instanceof G2dToolbarListener)) continue;
                tools.addToolbarListener((G2dComponent)comps[z]);
            }
            tools.forceSelectButton(1);
        }
    }

    protected Axis createAxis(int type, String name) {
        return AxisFactory.createAxis(type, name);
    }

    public Vector getPlotObjects() {
        Vector viewports = this.getViewportVector();
        Vector<G2dObject> objects = new Vector<G2dObject>();
        if (viewports == null) {
            return objects;
        }
        for (int i = 0; i < viewports.size(); ++i) {
            Vector glyphs = ((Viewport)viewports.elementAt(i)).getGlyphVector();
            if (glyphs == null) continue;
            for (int j = 0; j < glyphs.size(); ++j) {
                G2dObject gobj = ((G2dGlyph)glyphs.elementAt(j)).getG2dObject();
                if (gobj == null) continue;
                objects.addElement(gobj);
            }
        }
        return objects;
    }

    public Vector getLinePropertyObjects() {
        Vector viewports = this.getViewportVector();
        Vector<G2dLineProperties> linePropsList = new Vector<G2dLineProperties>();
        if (viewports == null) {
            return linePropsList;
        }
        for (int i = 0; i < viewports.size(); ++i) {
            Vector glyphs = ((Viewport)viewports.get(i)).getGlyphVector();
            if (glyphs == null) continue;
            for (int j = 0; j < glyphs.size(); ++j) {
                G2dLine line = ((G2dGlyph)glyphs.get(j)).getLine();
                if (line == null) continue;
                linePropsList.add(line.getProperties().clone());
            }
        }
        return linePropsList;
    }

    public Vector getAllLinePropertyObjects() {
        Vector viewports = this.getViewportVector();
        Vector<G2dLineProperties> linePropsList = new Vector<G2dLineProperties>();
        if (viewports == null) {
            return linePropsList;
        }
        for (int i = 0; i < viewports.size(); ++i) {
            Vector glyphs = ((Viewport)viewports.get(i)).getGlyphVector();
            if (glyphs == null) continue;
            for (int j = 0; j < glyphs.size(); ++j) {
                for (G2dLine iLine : ((G2dGlyph)glyphs.get((int)j))._lineArray) {
                    if (iLine == null) continue;
                    linePropsList.add(iLine.getProperties().clone());
                }
            }
        }
        return linePropsList;
    }

    public G2dPanelProp getProperties() {
        Vector plotPropVec = new Vector();
        this._panelProperties.plotPropVector.clear();
        for (int i = 0; i < this._viewportVector.size(); ++i) {
            G2dPlotProp plotProp;
            if (i >= this._panelProperties.plotPropVector.size()) {
                plotProp = new G2dPlotProp();
                this._panelProperties.plotPropVector.addElement(plotProp);
            } else {
                plotProp = (G2dPlotProp)this._panelProperties.plotPropVector.elementAt(i);
            }
            Viewport view = (Viewport)this._viewportVector.elementAt(i);
            ViewportLinkRecord vlr = (ViewportLinkRecord)this._viewportLinkTable.get(view);
            plotProp.hasY1Tics = this.determineAxisTicProperties(vlr.y1axistics, plotProp.y1TicsProp);
            plotProp.hasY2Tics = this.determineAxisTicProperties(vlr.y2axistics, plotProp.y2TicsProp);
            plotProp.hasX1Tics = this.determineAxisTicProperties(vlr.x1axistics, plotProp.x1TicsProp);
            plotProp.hasX2Tics = this.determineAxisTicProperties(vlr.x2axistics, plotProp.x2TicsProp);
            plotProp.hasY1Label = this.determineLabelProperties(vlr.y1label, plotProp.y1LabelProp);
            plotProp.hasY2Label = this.determineLabelProperties(vlr.y2label, plotProp.y2LabelProp);
            plotProp.hasX1Label = this.determineLabelProperties(vlr.x1label, plotProp.x1LabelProp);
            plotProp.hasX2Label = this.determineLabelProperties(vlr.x2label, plotProp.x2LabelProp);
            plotProp.hasX1Axis = this.determineAxisProperties(vlr.x1axis, plotProp.x1AxisProp);
            plotProp.hasX2Axis = this.determineAxisProperties(vlr.x2axis, plotProp.x2AxisProp);
            plotProp.hasY1Axis = this.determineAxisProperties(vlr.y1axis, plotProp.y1AxisProp);
            plotProp.hasY2Axis = this.determineAxisProperties(vlr.y2axis, plotProp.y2AxisProp);
            plotProp.hasXScroll = vlr.hasXScroll;
            plotProp.hasYScroll = vlr.hasYScroll;
            plotProp.viewportDrawProp = view.getProperties();
            GridBagConstraints gbc = ((GridBagLayout)this.getLayout()).getConstraints(view);
            plotProp.row = this.convertGridBagToRowCol(gbc.gridy);
            plotProp.col = this.convertGridBagToRowCol(gbc.gridx);
            plotProp.rowweight = gbc.weighty;
            plotProp.colweight = gbc.weightx;
        }
        if (this._toolbar != null) {
            this._panelProperties.toolbarProp = this._toolbar.getProperties();
        }
        if (this._legend != null) {
            this._panelProperties.legendProp = this._legend.getProperties();
        }
        if (this._title != null) {
            this._panelProperties.titleProp = this._title.getTitleProperties();
        }
        return this._panelProperties;
    }

    public int getLegendLocation() {
        return this.VERTICAL_LEGEND_CONTAINER.getComponentCount() > 0 ? G2dPanelProp.RIGHT : G2dPanelProp.BOTTOM;
    }

    private boolean determineAxisProperties(Axis axis, AxisProp prop) {
        if (axis != null) {
            prop.set(axis.getAxisProp());
            return true;
        }
        return false;
    }

    private boolean determineLabelProperties(G2dLabel label, G2dLabelDrawProp prop) {
        if (label != null) {
            prop.set(label.getProperties());
            return true;
        }
        return false;
    }

    private boolean determineAxisTicProperties(AxisTics tics, AxisTicsDrawProp prop) {
        if (tics != null) {
            prop.set(tics.getProperties());
            return true;
        }
        return false;
    }

    public void resetProperties(G2dPanelProp panelProperties) {
        int i;
        if (panelProperties == null) {
            return;
        }
        Vector plotObjects = this.getPlotObjects();
        this.clearPanel();
        Vector<G2dObject> droppedDataObject = new Vector<G2dObject>();
        Vector<G2dGlyphDrawProp> newGlyphProperties = new Vector<G2dGlyphDrawProp>();
        Vector<G2dPlotProp> droppedPanelProperties = new Vector<G2dPlotProp>();
        int row = -1;
        for (int i2 = 0; i2 < panelProperties.plotPropVector.size(); ++i2) {
            G2dPlotProp prop = (G2dPlotProp)panelProperties.plotPropVector.elementAt(i2);
            if (prop == null || prop.row <= row) continue;
            row = prop.row;
        }
        ++row;
        Hashtable<G2dPlotProp, Integer> glyphCounter = new Hashtable<G2dPlotProp, Integer>();
        for (i = 0; plotObjects != null && i < plotObjects.size(); ++i) {
            G2dObject go = (G2dObject)plotObjects.elementAt(i);
            if (go instanceof TimeWindowPlotData) continue;
            DataType dataType = DataTypeFactory.getFactory().getDataType(go);
            String yname = this.getYName(go, dataType).trim();
            String[] args = new String[]{yname.toLowerCase(), go.getXAxisName().toLowerCase()};
            String sclname = Scale.SCALE_NAME_FORMAT.format(args);
            boolean found = false;
            for (int j = 0; j < panelProperties.plotPropVector.size(); ++j) {
                G2dGlyphDrawProp glyphProp;
                int intCount;
                G2dPlotProp plotProp = (G2dPlotProp)panelProperties.plotPropVector.elementAt(j);
                String[] args1 = new String[]{plotProp.y1AxisProp.name.toLowerCase(), plotProp.x1AxisProp.name.toLowerCase()};
                String[] args2 = new String[]{plotProp.y2AxisProp.name.toLowerCase(), plotProp.x1AxisProp.name.toLowerCase()};
                if (!sclname.equals(Scale.SCALE_NAME_FORMAT.format(args1)) && !sclname.equals(Scale.SCALE_NAME_FORMAT.format(args2))) continue;
                found = true;
                Integer count = (Integer)glyphCounter.get(plotProp);
                if (count == null) {
                    count = new Integer(1);
                }
                if ((intCount = count.intValue()) > plotProp.viewportDrawProp.glyphProperties.size()) {
                    glyphProp = new G2dGlyphDrawProp();
                    plotProp.viewportDrawProp.addGlyphProperties(glyphProp);
                    droppedDataObject.addElement(go);
                    newGlyphProperties.addElement(glyphProp);
                } else {
                    glyphProp = (G2dGlyphDrawProp)plotProp.viewportDrawProp.glyphProperties.elementAt(intCount - 1);
                    if (glyphProp.lineProperties == null || glyphProp.lineProperties.size() > 0 && ((G2dLineProperties)glyphProp.lineProperties.get(0)).useDefaultLineStyles()) {
                        droppedDataObject.addElement(go);
                        newGlyphProperties.addElement(glyphProp);
                    }
                }
                glyphCounter.put(plotProp, new Integer(count + 1));
                break;
            }
            if (found) continue;
            G2dPlotProp tempPlotProp = null;
            for (int z = 0; z < droppedPanelProperties.size(); ++z) {
                G2dPlotProp plotProp = (G2dPlotProp)droppedPanelProperties.elementAt(z);
                String[] args1 = new String[]{plotProp.y1AxisProp.name.toLowerCase(), plotProp.x1AxisProp.name.toLowerCase()};
                String[] args2 = new String[]{plotProp.y2AxisProp.name.toLowerCase(), plotProp.x1AxisProp.name.toLowerCase()};
                if (!sclname.equals(Scale.SCALE_NAME_FORMAT.format(args1)) && !sclname.equals(Scale.SCALE_NAME_FORMAT.format(args2))) continue;
                tempPlotProp = plotProp;
                break;
            }
            if (tempPlotProp == null) {
                tempPlotProp = new G2dPlotProp();
                tempPlotProp.x1AxisProp.name = go.getXAxisName();
                tempPlotProp.y1AxisProp.name = yname;
                tempPlotProp.hasX1Label = go.getXAxisType() != 1;
                tempPlotProp.col = 0;
                tempPlotProp.row = row++;
                if (dataType != null) {
                    boolean bl = dataType != null && !dataType.isYAxisReversed() ? true : (tempPlotProp.y1AxisProp.isReversed = false);
                    if (dataType.hasDefaultMaxAxisValue()) {
                        go.setDefaultMaxYValue(dataType.getDefaultMaxAxisValue());
                    }
                    if (dataType.hasDefaultMinAxisValue()) {
                        go.setDefaultMinYValue(dataType.getDefaultMinAxisValue());
                    }
                }
                droppedPanelProperties.addElement(tempPlotProp);
            }
            G2dGlyphDrawProp glyphProp = new G2dGlyphDrawProp();
            tempPlotProp.viewportDrawProp.addGlyphProperties(glyphProp);
            newGlyphProperties.addElement(glyphProp);
            droppedDataObject.addElement(go);
        }
        for (i = 0; i < droppedPanelProperties.size(); ++i) {
            panelProperties.addPlotProp((G2dPlotProp)droppedPanelProperties.elementAt(i));
        }
        DataTypeFactory.getFactory().reset();
        List<LineProperties> lineProperties = DataTypeFactory.getFactory().getLineProperties(droppedDataObject, true);
        for (int z = 0; z < newGlyphProperties.size(); ++z) {
            ((G2dGlyphDrawProp)newGlyphProperties.elementAt((int)z)).lineProperties.add(lineProperties.get(z));
        }
        this.configurePanel(panelProperties);
        Vector<Object> lProperties = new Vector<Object>();
        for (int i3 = 0; i3 < plotObjects.size(); ++i3) {
            G2dObject go = (G2dObject)plotObjects.get(i3);
            int curveCount = go.getCurveCount();
            for (int z = 0; z < curveCount; ++z) {
                lProperties.addElement(null);
            }
        }
        if (plotObjects.size() > 0) {
            this.setPlotObjects(plotObjects, lProperties);
        }
        for (int j = 0; j < panelProperties.plotPropVector.size(); ++j) {
            G2dPlotProp plotProp = (G2dPlotProp)panelProperties.plotPropVector.elementAt(j);
            Axis axis = (Axis)this._xAxisTable.get(plotProp.x1AxisProp.name.toLowerCase());
            if (axis != null) {
                axis.setAxisProp(plotProp.x1AxisProp);
            }
            if ((axis = (Axis)this._xAxisTable.get(plotProp.x2AxisProp.name.toLowerCase())) != null) {
                axis.setAxisProp(plotProp.x2AxisProp);
            }
            if ((axis = (Axis)this._yAxisTable.get(plotProp.y1AxisProp.name.toLowerCase())) != null) {
                axis.setAxisProp(plotProp.y1AxisProp);
            }
            if ((axis = (Axis)this._yAxisTable.get(plotProp.y2AxisProp.name.toLowerCase())) == null) continue;
            axis.setAxisProp(plotProp.y2AxisProp);
        }
        Viewport[] viewports = this.getViewports();
        if (viewports != null) {
            for (int i4 = 0; i4 < viewports.length; ++i4) {
                viewports[i4].updateRatingAxisValues();
            }
        }
        if (panelProperties.legendProp != null) {
            this.moveLegendToPosition(panelProperties.legendProp.legendPosition);
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void configurePanel(G2dPanelProp prop) {
        if (prop == null) {
            return;
        }
        int nplots = prop.getPlotCount();
        if (nplots < 1) {
            return;
        }
        this._panelProperties = prop;
        this.clearPanel();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.setBackground(this._panelProperties.backgroundColor);
        Axis[] xa = new Axis[2];
        Axis[] ya = new Axis[2];
        Scale[] scl = new Scale[4];
        boolean[] showXtics = new boolean[2];
        boolean[] showXlabel = new boolean[2];
        boolean[] showYtics = new boolean[2];
        boolean[] showYlabel = new boolean[2];
        int maxrow = 0;
        Hashtable<Integer, Axis> masterAxisTable = new Hashtable<Integer, Axis>();
        for (int cnt = 0; cnt < prop.plotPropVector.size(); ++cnt) {
            int i;
            masterAxisTable.clear();
            G2dPlotProp pp = (G2dPlotProp)prop.plotPropVector.elementAt(cnt);
            for (i = 0; i < 2; ++i) {
                xa[i] = null;
            }
            for (i = 0; i < 2; ++i) {
                ya[i] = null;
            }
            for (i = 0; i < 4; ++i) {
                scl[i] = null;
            }
            if (pp.hasX1Axis) {
                xa[0] = (Axis)this._xAxisTable.get(pp.x1AxisProp.name.toLowerCase());
                if (xa[0] == null) {
                    xa[0] = this.createAxis(pp.x1AxisProp.type, pp.x1AxisProp.name);
                    xa[0].setAxisProp(pp.x1AxisProp);
                    this._xAxisTable.put(pp.x1AxisProp.name.toLowerCase(), xa[0]);
                }
                showXtics[0] = pp.hasX1Tics;
                showXlabel[0] = pp.hasX1Label;
                masterAxisTable.put(new Integer(0), xa[0]);
            } else {
                showXtics[0] = false;
                showXlabel[0] = false;
            }
            if (pp.hasX2Axis) {
                xa[1] = (Axis)this._xAxisTable.get(pp.x2AxisProp.name.toLowerCase());
                if (xa[1] == null) {
                    xa[1] = this.createAxis(pp.x2AxisProp.type, pp.x2AxisProp.name);
                    xa[1].setAxisProp(pp.x2AxisProp);
                    this._xAxisTable.put(pp.x2AxisProp.name.toLowerCase(), xa[1]);
                }
                showXtics[1] = pp.hasX2Tics;
                showXlabel[1] = pp.hasX2Label;
                if (masterAxisTable.get(new Integer(0)) == null && xa[0] != null) {
                    masterAxisTable.put(new Integer(0), xa[0]);
                }
            } else {
                showXtics[1] = false;
                showXlabel[1] = false;
            }
            if (pp.hasY1Axis) {
                ya[0] = (Axis)this._yAxisTable.get(pp.y1AxisProp.name.toLowerCase());
                if (ya[0] == null) {
                    ya[0] = this.createAxis(pp.y1AxisProp.type, pp.y1AxisProp.name);
                    ya[0].setAxisProp(pp.y1AxisProp);
                    this._yAxisTable.put(pp.y1AxisProp.name.toLowerCase(), ya[0]);
                }
                showYtics[0] = pp.hasY1Tics;
                showYlabel[0] = pp.hasY1Label;
                masterAxisTable.put(new Integer(1), ya[0]);
            } else {
                showYtics[0] = false;
                showYlabel[0] = false;
            }
            if (pp.hasY2Axis) {
                ya[1] = (Axis)this._yAxisTable.get(pp.y2AxisProp.name.toLowerCase());
                if (ya[1] == null) {
                    ya[1] = this.createAxis(pp.y2AxisProp.type, pp.y2AxisProp.name);
                    ya[1].setAxisProp(pp.y2AxisProp);
                    this._yAxisTable.put(pp.y2AxisProp.name.toLowerCase(), ya[1]);
                }
                showYtics[1] = pp.hasY2Tics;
                showYlabel[1] = pp.hasY2Label;
                if (masterAxisTable.get(new Integer(1)) == null) {
                    masterAxisTable.put(new Integer(1), ya[1]);
                }
            } else {
                showYtics[1] = false;
                showYlabel[1] = false;
            }
            if (xa[0] == null && xa[1] == null || ya[0] == null && ya[1] == null) continue;
            if (maxrow < pp.row) {
                maxrow = pp.row;
            }
            for (i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (xa[i] == null || ya[j] == null) continue;
                    String sclname = ya[j].getName().toLowerCase() + " vs " + xa[i].getName().toLowerCase();
                    scl[i * 2 + j] = (Scale)this._scaleTable.get(sclname);
                    if (scl[i * 2 + j] != null) continue;
                    scl[i * 2 + j] = this.createScale(sclname);
                    scl[i * 2 + j].setAxis(xa[i], 0);
                    scl[i * 2 + j].setAxis(ya[j], 1);
                    this.addScaleToTable(sclname, scl[i * 2 + j]);
                }
            }
            Viewport v1 = this.buildPlotComponents(pp.col, pp.row, pp.colweight, pp.rowweight, pp.colwidth, pp.rowheight, xa, ya, scl, showXtics, showXlabel, pp.hasXScroll, showYtics, showYlabel, pp.hasYScroll);
            v1.setMasterAxisTable((Hashtable)masterAxisTable.clone());
            v1.setProperties(pp.viewportDrawProp);
            v1.addObjectSelectionListener(this);
            this._viewportVector.addElement(v1);
            if (this._x1tics != null) {
                this._x1tics.setProperties(pp.x1TicsProp);
            }
            if (this._x2tics != null) {
                this._x2tics.setProperties(pp.x2TicsProp);
            }
            if (this._y1tics != null) {
                this._y1tics.setProperties(pp.y1TicsProp);
            }
            if (this._y2tics != null) {
                this._y2tics.setProperties(pp.y2TicsProp);
            }
            if (this._x1label != null) {
                this._x1label.setProperties(pp.x1LabelProp);
            }
            if (this._x2label != null) {
                this._x2label.setProperties(pp.x2LabelProp);
            }
            if (this._y1label != null) {
                this._y1label.setProperties(pp.y1LabelProp);
            }
            if (this._y2label == null) continue;
            this._y2label.setProperties(pp.y2LabelProp);
        }
        this._title = new G2dTitle(this, prop.titleProp.align);
        this._title.setText(prop.hasTitle ? prop.titleProp.text : "");
        this._title.setProperties(prop.titleProp);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 0;
        gc.anchor = 10;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 0, 0, 0);
        gridbag.setConstraints(this._title, gc);
        this.add(this._title);
        this.addLegendContainers();
        this._legend = new LegendPanel(this, prop.legendProp, 0);
        this._legend.setBorder(BorderFactory.createLoweredBevelBorder());
        this._legend.setProperties(prop.legendProp);
        Enumeration ev = this._viewportVector.elements();
        while (ev.hasMoreElements()) {
            this._legend.addViewport((Viewport)ev.nextElement());
        }
        this.moveLegendToPosition(prop.legendProp.legendPosition);
        this.setLegendVisible(prop.hasLegend && prop.legendProp.legendVisible);
        if (prop.hasToolbar) {
            ViewportToolbar tools;
            this._toolbar = tools = new ViewportToolbar(this);
            tools.configureToolbar(prop.toolbarProp);
            Enumeration ev2 = this._viewportVector.elements();
            while (ev2.hasMoreElements()) {
                tools.addViewport((Viewport)ev2.nextElement());
            }
            gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridheight = 0;
            gc.fill = 3;
            gc.weightx = 0.0;
            gc.weighty = 1.0;
            gc.insets = prop.insets;
            gridbag.setConstraints(tools, gc);
            this.add(tools);
            tools.addToolbarListener(this);
            Component[] comps = this.getComponents();
            if (comps == null) {
                return;
            }
            for (int z = 0; z < comps.length; ++z) {
                if (!(comps[z] instanceof G2dToolbarListener)) continue;
                tools.addToolbarListener((G2dComponent)comps[z]);
            }
            tools.forceSelectButton(prop.toolbarProp.defaultButton);
        }
        gc.gridx = 249;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.fill = 3;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.gridheight = 0;
        gc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.ACCESSORY_PANEL_CONTAINER, gc);
        this.ACCESSORY_PANEL_CONTAINER.setLayout(new BorderLayout());
        if (prop.accessoryPanelClass != null) {
            try {
                Class<?> c2 = Class.forName(prop.accessoryPanelClass);
                JComponent obj = (JComponent)c2.newInstance();
                this.ACCESSORY_PANEL_CONTAINER.add((Component)obj, "Center");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public G2dTitle getTitlePanel() {
        return this._title;
    }

    public String getTitle() {
        if (this._title == null) {
            return "";
        }
        return this._title.getText();
    }

    public void setTitle(String title) {
        if (title == null || this._title == null) {
            return;
        }
        this._title.setText(title);
        this._title.setDrawTitleOn();
    }

    public void setPlotObjects(List plotvec) {
        int i;
        Vector<Color> colorvec = new Vector<Color>();
        int numCurves = 0;
        for (i = 0; i < plotvec.size(); ++i) {
            numCurves += ((G2dObject)plotvec.get(i)).getCurveCount();
        }
        if (numCurves < plotvec.size()) {
            numCurves = plotvec.size();
        }
        for (i = 0; i < numCurves; ++i) {
            colorvec.addElement(_lineColor[i % _lineColor.length]);
        }
        this.setPlotObjects(plotvec, colorvec);
    }

    public void setPlotObjects(List plotvec, List colorvec) {
        DataTypeFactory.getFactory().reset();
        this._components = plotvec;
        if (colorvec == null) {
            colorvec = new Vector<Color>();
        }
        int numCurves = 0;
        for (int i = 0; i < plotvec.size(); ++i) {
            numCurves += ((G2dObject)plotvec.get(i)).getCurveCount();
        }
        if (numCurves < plotvec.size()) {
            numCurves = plotvec.size();
        }
        if (colorvec.size() < numCurves) {
            int istart;
            for (int i = istart = colorvec.size(); i < numCurves; ++i) {
                colorvec.add(_lineColor[i % _lineColor.length]);
            }
        }
        this.clearPlot(false);
        int objcnt = 0;
        int curvecnt = 0;
        for (int z = 0; z < plotvec.size(); ++z) {
            G2dObject go = (G2dObject)plotvec.get(z);
            G2dLineProperties[] lineProp = new G2dLineProperties[go.getCurveCount()];
            for (int zz = 0; zz < go.getCurveCount(); ++zz) {
                Object colorObj = colorvec.get(curvecnt);
                if (colorObj instanceof G2dLineProperties) {
                    lineProp[zz] = (G2dLineProperties)colorObj;
                } else if (colorObj instanceof Color) {
                    lineProp[zz] = new G2dLineProperties();
                    lineProp[zz].setLineColor((Color)colorvec.get(curvecnt));
                    lineProp[zz].setFillColor(_fillColor[objcnt % _fillColor.length]);
                }
                ++curvecnt;
            }
            this.addPlotObject(go, lineProp, false);
            ++objcnt;
        }
        if (this._timeWindowData != null) {
            this.addPlotObject(this._timeWindowData, Color.black, Color.black, false);
        }
        if (this._legend != null) {
            this._legend.fillGlyphVector();
        }
        DataTypeFactory.getFactory().reset();
        for (int i = 0; i < this.m_openPopupWindows.size(); ++i) {
            G2dDialog dlg = (G2dDialog)this.m_openPopupWindows.elementAt(i);
            G2dPanel panel = dlg.getPlotpanel();
            panel.setPlotObjects(plotvec, DataTypeFactory.getFactory().getLineProperties(plotvec));
        }
    }

    public void addPlotObject(G2dObject obj) {
        if (obj == null) {
            return;
        }
        this.addPlotObject(obj, Color.blue, Color.blue, true);
    }

    private void addPlotObject(G2dObject go, Color lineColor, Color fillColor, boolean refreshComponents) {
        G2dLineProperties lineProp = new G2dLineProperties();
        lineProp.setLineColor(lineColor);
        lineProp.setFillColor(fillColor);
        this.addPlotObject(go, lineProp, refreshComponents);
    }

    public void addPlotObject(G2dObject go, G2dLineProperties lineProp, boolean refreshComponents) {
        this.addPlotObject(go, new G2dLineProperties[]{lineProp}, refreshComponents);
    }

    private void addPlotObject(G2dObject go, G2dLineProperties[] lineProp, boolean refreshComponents) {
        DataType dataType = DataTypeFactory.getFactory().getDataType(go);
        String yname = this.getYName(go, dataType).trim();
        String sclname = yname.toLowerCase() + " vs " + go.getXAxisName().toLowerCase();
        Scale scl = (Scale)this._scaleTable.get(sclname);
        boolean cnt = false;
        boolean found = false;
        Enumeration ev = this._viewportVector.elements();
        block0: while (ev.hasMoreElements() && !found) {
            Viewport v = (Viewport)ev.nextElement();
            for (int j = 0; j < v.numScaleElements(); ++j) {
                if (go instanceof TimeWindowPlotData) {
                    ViewportLinkRecord vlr = (ViewportLinkRecord)this._viewportLinkTable.get(v);
                    if (!(vlr.x1axis instanceof TSAxis) && !(vlr.x2axis instanceof TSAxis)) continue;
                    v.addG2dObject(go, lineProp, v.getScale());
                    continue;
                }
                if (v.getScale(j) != scl || scl == null) continue;
                v.addG2dObject(go, lineProp);
                found = true;
                continue block0;
            }
        }
        if (this._legend != null && refreshComponents) {
            this._legend.fillGlyphVector();
        }
    }

    public void plotTimeWindow(TimeWindowPlotData data) {
        this._timeWindowData = data;
        if (this._viewportVector.size() > 0 && this._timeWindowData != null) {
            this.addPlotObject(this._timeWindowData);
        }
    }

    public void zoomToAll() {
        this.setVisible(false);
        for (int i = 0; this._viewportVector != null && i < this._viewportVector.size(); ++i) {
            Viewport v = (Viewport)this._viewportVector.elementAt(i);
            for (int z = 0; z <= 3; ++z) {
                Axis a = this.getViewportAxis(v, z);
                if (a == null) continue;
                double min = a.getMin();
                double max = a.getMax();
                if (a instanceof ProbabilityAxis) {
                    min = ProbabilityAxis.getNormalDistribution(min);
                    max = ProbabilityAxis.getNormalDistribution(max);
                }
                a.zoomIn(min, max);
            }
        }
        this.setVisible(true);
    }

    private int convertPropertyRowColToGridBag(int row_col) {
        return row_col * 6 + 1 + 2;
    }

    private int convertGridBagToRowCol(int gridBag) {
        return (gridBag - 2 - 1) / 6;
    }

    public Viewport buildPlotComponents(int plotcol, int plotrow, double colwgt, double rowwgt, Axis[] x, Axis[] y, Scale[] vs, boolean[] showXtic, boolean[] showXlabel, boolean showXscroll, boolean[] showYtic, boolean[] showYlabel, boolean showYscroll) {
        return this.buildPlotComponents(plotcol, plotrow, colwgt, rowwgt, 1, 1, x, y, vs, showXtic, showXlabel, showXscroll, showYtic, showYlabel, showYscroll);
    }

    protected Viewport createViewport() {
        Viewport v = new Viewport(this);
        v.setTransferHandler(this.getTransferHandler());
        return v;
    }

    public Viewport buildPlotComponents(int plotcol, int plotrow, double colwgt, double rowwgt, int colwth, int rowht, Axis[] x, Axis[] y, Scale[] vs, boolean[] showXtic, boolean[] showXlabel, boolean showXscroll, boolean[] showYtic, boolean[] showYlabel, boolean showYscroll) {
        G2dSpacer spacer;
        GridBagLayout gridbag = (GridBagLayout)this.getLayout();
        ViewportLinkRecord vlr = new ViewportLinkRecord();
        if (x.length >= 1) {
            vlr.x1axis = x[0];
        }
        if (x.length >= 2) {
            vlr.x2axis = x[1];
        }
        if (y.length >= 1) {
            vlr.y1axis = y[0];
        }
        if (y.length >= 2) {
            vlr.y2axis = y[1];
        }
        boolean STACK = Boolean.getBoolean("STACK_VIEWPORTS");
        int gx = this.convertPropertyRowColToGridBag(plotcol);
        int gy = this.convertPropertyRowColToGridBag(plotrow);
        int gwth = this.convertPropertyRowColToGridBag(colwth);
        Viewport view = this.createViewport();
        for (int iscl = 0; iscl < vs.length; ++iscl) {
            view.addScale(vs[iscl]);
        }
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = gx;
        gc.gridy = gy;
        gc.fill = 1;
        gc.weightx = colwgt;
        gc.weighty = rowwgt;
        if (colwth > 1) {
            gc.gridwidth = gwth;
        }
        gridbag.setConstraints(view, gc);
        String name = "Viewport (" + (this._viewportLinkTable.size() + 1) + "," + (gx - 2) + ")";
        view.setName(name);
        this.add(view);
        if (showXlabel != null && showXlabel.length >= 1 && showXlabel[0]) {
            this._x1label = new AxisLabel(this, x[0], 2);
            gc = new GridBagConstraints();
            gc.gridx = gx - 1;
            gc.gridy = gy + 2;
            gc.gridwidth = colwth > 1 ? gwth + 1 : 3;
            gc.fill = 1;
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gridbag.setConstraints(this._x1label, gc);
            this.add(this._x1label);
            vlr.x1label = this._x1label;
        }
        if (showXtic != null && showXtic.length >= 1 && showXtic[0]) {
            this._x1tics = AxisTicFactory.createAxisTics(this, x[0], view, 2);
            if (this._x1tics != null) {
                gc = new GridBagConstraints();
                gc.gridx = gx - 1;
                gc.gridy = gy + 1;
                gc.gridwidth = colwth > 1 ? gwth + 1 : 3;
                gc.fill = 1;
                gc.weightx = 0.0;
                gc.weighty = 0.0;
                gridbag.setConstraints(this._x1tics, gc);
                this.add(this._x1tics);
                vlr.x1axistics = this._x1tics;
            } else {
                this._x1tics = null;
                spacer = new G2dSpacer(this, y[0], 2);
                gc = new GridBagConstraints();
                gc.gridx = gx - 1;
                gc.gridy = gy + 1;
                gc.gridwidth = 3;
                gc.fill = 2;
                gc.weightx = 0.0;
                gc.weighty = 0.0;
                gridbag.setConstraints(spacer, gc);
                this.add(spacer);
                if (plotrow >= 0) {
                    this._horizontalSpacerTable.add(spacer);
                    this._spacerList.add(spacer);
                    spacer.setPixelSpacing(this._panelProperties.viewportSpaceSize);
                }
            }
        } else {
            this._x1tics = null;
            vlr.x1axisticsSpacer = spacer = new G2dSpacer(this, y[0], 2);
            gc = new GridBagConstraints();
            gc.gridx = gx - 1;
            gc.gridy = gy + 1;
            gc.gridwidth = 3;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gridbag.setConstraints(spacer, gc);
            this.add(spacer);
            if (plotrow >= 0) {
                this._horizontalSpacerTable.add(spacer);
                this._spacerList.add(spacer);
                spacer.setPixelSpacing(this._panelProperties.viewportSpaceSize);
            }
        }
        if (showXlabel != null && showXlabel.length >= 2 && showXlabel[1]) {
            this._x2label = new AxisLabel(this, x[1], 3);
            gc = new GridBagConstraints();
            gc.gridx = gx - 1;
            gc.gridy = gy - 2;
            gc.gridwidth = colwth > 1 ? 6 * colwth + 1 : 3;
            gc.fill = 1;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gridbag.setConstraints(this._x2label, gc);
            this.add(this._x2label);
            vlr.x2label = this._x2label;
        }
        if (showXtic != null && showXtic.length >= 2 && showXtic[1]) {
            this._x2tics = AxisTicFactory.createAxisTics(this, x[1], view, 3);
            if (this._x2tics != null) {
                gc = new GridBagConstraints();
                gc.gridx = gx - 1;
                gc.gridy = gy - 1;
                gc.gridwidth = colwth > 1 ? 6 * colwth + 1 : 3;
                gc.fill = 1;
                gc.weightx = 0.0;
                gc.weighty = 0.0;
                gridbag.setConstraints(this._x2tics, gc);
                this.add(this._x2tics);
                vlr.x2axistics = this._x2tics;
            } else {
                spacer = new G2dSpacer(this, y[0], 3);
                gc = new GridBagConstraints();
                gc.gridx = gx;
                gc.gridy = gy - 1;
                gc.fill = 2;
                gc.weightx = 0.0;
                gc.weighty = 0.0;
                gc.gridwidth = colwth > 1 ? 6 * colwth + 1 : 3;
                gridbag.setConstraints(spacer, gc);
                this.add(spacer);
                if (plotrow > 0) {
                    this._horizontalSpacerTable.add(spacer);
                    this._spacerList.add(spacer);
                    spacer.setPixelSpacing(this._panelProperties.viewportSpaceSize);
                }
            }
        } else {
            vlr.x2axisticsSpacer = spacer = new G2dSpacer(this, y[0], 3);
            gc = new GridBagConstraints();
            gc.gridx = gx;
            gc.gridy = gy - 1;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.gridwidth = colwth > 1 ? 6 * colwth + 1 : 3;
            gridbag.setConstraints(spacer, gc);
            this.add(spacer);
            if (plotrow > 0) {
                this._horizontalSpacerTable.add(spacer);
                this._spacerList.add(spacer);
                spacer.setPixelSpacing(this._panelProperties.viewportSpaceSize);
            }
        }
        if (showXscroll) {
            AxisScrollbar xscroll = new AxisScrollbar(this, x, 0);
            xscroll.setBorder(BorderFactory.createLineBorder(Color.gray));
            xscroll.setVisible(false);
            gc = new GridBagConstraints();
            gc.gridx = gx;
            gc.gridy = gy + 3;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            if (colwth > 1) {
                gc.gridwidth = 6 * colwth;
            }
            gridbag.setConstraints(xscroll, gc);
            this.add(xscroll);
            vlr.hasXScroll = true;
        }
        if (showYlabel != null && showYlabel.length >= 1 && showYlabel[0]) {
            this._y1label = new AxisLabel(this, y[0], 0);
            gc = new GridBagConstraints();
            gc.gridx = gx - 2;
            gc.gridy = gy - 1;
            gc.gridheight = 3;
            gc.fill = 1;
            gc.weightx = 0.0;
            gc.weighty = rowwgt;
            gridbag.setConstraints(this._y1label, gc);
            this.add(this._y1label);
            vlr.y1label = this._y1label;
        }
        if (showYtic != null && showYtic.length >= 1 && showYtic[0]) {
            this._y1tics = AxisTicFactory.createAxisTics(this, y[0], view, 0);
            if (this._y1tics != null) {
                gc = new GridBagConstraints();
                gc.gridx = gx - 1;
                gc.gridy = gy - 1;
                gc.gridheight = 3;
                gc.fill = 1;
                gc.weightx = 0.0;
                gridbag.setConstraints(this._y1tics, gc);
                this.add(this._y1tics);
                vlr.y1axistics = this._y1tics;
            } else {
                spacer = new G2dSpacer(this, x[0], 0);
                gc = new GridBagConstraints();
                gc.gridx = gx - 1;
                gc.gridy = gy;
                gc.fill = 3;
                gc.weightx = 0.0;
                gc.weighty = 0.0;
                gridbag.setConstraints(spacer, gc);
                this.add(spacer);
                this._spacerList.add(spacer);
            }
        } else {
            vlr.y1axisticsSpacer = spacer = new G2dSpacer(this, x[0], 0);
            gc = new GridBagConstraints();
            gc.gridx = gx - 1;
            gc.gridy = gy;
            gc.fill = 3;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gridbag.setConstraints(spacer, gc);
            this.add(spacer);
            this._spacerList.add(spacer);
        }
        if (showYlabel != null && showYlabel.length >= 2 && showYlabel[1]) {
            this._y2label = new AxisLabel(this, y[1], 1);
            if (this._y2label != null) {
                gc = new GridBagConstraints();
                gc.gridx = gx + 2;
                gc.gridy = gy - 1;
                gc.gridheight = 3;
                gc.fill = 1;
                gc.weightx = 0.0;
                gc.weighty = rowwgt;
                gridbag.setConstraints(this._y2label, gc);
                this.add(this._y2label);
                vlr.y2label = this._y2label;
            } else {
                spacer = new G2dSpacer(this, null, 1);
                gc = new GridBagConstraints();
                gc.gridx = gx + 2;
                gc.gridy = gy - 1;
                gc.gridheight = 3;
                gc.fill = 3;
                gc.weightx = 0.0;
                gc.weighty = 0.0;
                gridbag.setConstraints(spacer, gc);
                this.add(spacer);
                this._spacerList.add(spacer);
            }
        } else {
            spacer = new G2dSpacer(this, null, 1);
            gc = new GridBagConstraints();
            vlr.y2axislabelSpacer = spacer;
            gc.gridx = gx + 2;
            gc.gridy = gy - 1;
            gc.gridheight = 3;
            gc.fill = 3;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gridbag.setConstraints(spacer, gc);
            this.add(spacer);
            this._spacerList.add(spacer);
        }
        if (showYtic != null && showYtic.length >= 2 && showYtic[1]) {
            this._y2tics = AxisTicFactory.createAxisTics(this, y[1], view, 1);
            if (this._y2tics != null) {
                gc = new GridBagConstraints();
                gc.gridx = gx + 1;
                gc.gridy = gy - 1;
                gc.gridheight = 3;
                gc.fill = 1;
                gc.weightx = 0.0;
                gc.weighty = 0.0;
                gridbag.setConstraints(this._y2tics, gc);
                this.add(this._y2tics);
                vlr.y2axistics = this._y2tics;
            } else {
                spacer = new G2dSpacer(this, x[0], 1);
                gc = new GridBagConstraints();
                gc.gridx = gx + 1;
                gc.gridy = gy - 1;
                gc.gridheight = 3;
                gc.fill = 3;
                gc.weightx = 0.0;
                gc.weighty = 0.0;
                gridbag.setConstraints(spacer, gc);
                this.add(spacer);
                this._spacerList.add(spacer);
            }
        } else {
            vlr.y2axisticsSpacer = spacer = new G2dSpacer(this, x[0], 1);
            gc = new GridBagConstraints();
            gc.gridx = gx + 1;
            gc.gridy = gy - 1;
            gc.gridheight = 3;
            gc.fill = 3;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gridbag.setConstraints(spacer, gc);
            this.add(spacer);
            this._spacerList.add(spacer);
        }
        if (showYscroll) {
            AxisScrollbar yscroll = new AxisScrollbar(this, y, 1);
            yscroll.setBorder(BorderFactory.createLineBorder(Color.gray));
            gc = new GridBagConstraints();
            gc.gridx = gx + 3;
            gc.gridy = gy;
            gc.fill = 3;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gridbag.setConstraints(yscroll, gc);
            this.add(yscroll);
            vlr.hasYScroll = true;
        }
        this._viewportLinkTable.put(view, vlr);
        return view;
    }

    public int getHorizontalViewportSpacing() {
        return this._panelProperties.viewportSpaceSize;
    }

    public void setHorizontalViewportSpacing(int pixelWidth) {
        for (int i = 0; i < this._horizontalSpacerTable.size(); ++i) {
            this._horizontalSpacerTable.get(i).setPixelSpacing(pixelWidth);
        }
        this._panelProperties.viewportSpaceSize = pixelWidth;
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void createDefaultMapTools(ViewportToolbar tools) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 11;
        gbc.fill = 0;
        JToggleButton button = new JToggleButton();
        ToolbarButtonProp bgstr = new ToolbarButtonProp();
        bgstr.up = "Images/Point.gif";
        bgstr.down = "Images/Point.gif";
        bgstr.over = "Images/Point.gif";
        bgstr.on = "Images/Point.gif";
        bgstr.adapter = "hec.gfx2d.G2dPointerAdapter";
        ++gbc.gridy;
        tools.addToolButton(button, bgstr, gbc);
        button = new JToggleButton();
        bgstr = new ToolbarButtonProp();
        bgstr.up = "Images/ZoomUp.gif";
        bgstr.down = "Images/ZoomDown.gif";
        bgstr.over = "Images/ZoomUp.gif";
        bgstr.on = "Images/ZoomDown.gif";
        bgstr.adapter = "hec.gfx2d.G2dZoomAdapter";
        gbc.weighty = 1.0;
        ++gbc.gridy;
        tools.addToolButton(button, bgstr, gbc);
    }

    public JToggleButton addTool(ToolbarButtonProp bprop) {
        if (this._toolbar == null) {
            return null;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 11;
        gbc.fill = 0;
        JToggleButton lastButton = (JToggleButton)this._toolbar._buttonVector.lastElement();
        GridBagLayout gridbag = (GridBagLayout)this._toolbar.getLayout();
        GridBagConstraints gc = gridbag.getConstraints(lastButton);
        gc.weighty = 0.0;
        gridbag.setConstraints(lastButton, gc);
        JToggleButton button = new JToggleButton();
        gbc.gridy = gc.gridy + 1;
        this._toolbar.addToolButton(button, bprop, gbc);
        return lastButton;
    }

    public void setViewportAxisLink(Viewport view, Axis axis, int axisId) {
        if (view == null) {
            return;
        }
        ViewportLinkRecord vlr = (ViewportLinkRecord)this._viewportLinkTable.get(view);
        if (vlr == null) {
            vlr = new ViewportLinkRecord();
            this._viewportLinkTable.put(view, vlr);
        }
        switch (axisId) {
            case 0: {
                vlr.x1axis = axis;
                break;
            }
            case 1: {
                vlr.x2axis = axis;
                break;
            }
            case 2: {
                vlr.y1axis = axis;
                break;
            }
            case 3: {
                vlr.y2axis = axis;
                break;
            }
            default: {
                System.out.println("getViewportAxis: invalid axis specified " + axis);
            }
        }
    }

    public Axis getViewportAxis(Viewport view, int axis) {
        if (view == null) {
            return null;
        }
        ViewportLinkRecord vlr = (ViewportLinkRecord)this._viewportLinkTable.get(view);
        if (vlr == null) {
            System.out.println("getViewportAxis: failed to find link record for " + view);
            return null;
        }
        switch (axis) {
            case 0: {
                return vlr.x1axis;
            }
            case 1: {
                return vlr.x2axis;
            }
            case 2: {
                return vlr.y1axis;
            }
            case 3: {
                return vlr.y2axis;
            }
        }
        System.out.println("getViewportAxis: invalid axis specified " + axis);
        return null;
    }

    public AxisLabel getViewportAxisLabel(Viewport view, int axisInt) {
        if (view == null) {
            return null;
        }
        ViewportLinkRecord vlr = (ViewportLinkRecord)this._viewportLinkTable.get(view);
        if (vlr == null) {
            System.out.println("getViewportAxisLabel: failed to find link record for " + view);
            return null;
        }
        Axis axis = null;
        int align = 0;
        String[] text = null;
        Icon icon = null;
        G2dLabelDrawProp prop = null;
        AxisLabel label = null;
        switch (axisInt) {
            case 0: {
                if (vlr.x1label == null) break;
                axis = vlr.x1axis;
                text = vlr.x1label._text;
                icon = vlr.x1label._icon;
                align = vlr.x1label._alignment;
                prop = vlr.x1label._drawProp;
                break;
            }
            case 1: {
                if (vlr.x2label == null) break;
                axis = vlr.x2axis;
                text = vlr.x2label._text;
                icon = vlr.x2label._icon;
                align = vlr.x2label._alignment;
                prop = vlr.x2label._drawProp;
                break;
            }
            case 2: {
                if (vlr.y1label == null) break;
                axis = vlr.y1axis;
                text = vlr.y1label._text;
                icon = vlr.y1label._icon;
                align = vlr.y1label._alignment;
                prop = vlr.y1label._drawProp;
                break;
            }
            case 3: {
                if (vlr.y2label == null) break;
                axis = vlr.y2axis;
                text = vlr.y2label._text;
                icon = vlr.y2label._icon;
                align = vlr.y2label._alignment;
                prop = vlr.y2label._drawProp;
                break;
            }
            default: {
                System.out.println("getViewportAxisLabel: invalid axis specified " + axisInt);
            }
        }
        if (axis != null) {
            label = new AxisLabel(this, axis, align);
            label._text = text;
            label._icon = icon;
            label._drawProp = prop;
        }
        return label;
    }

    public G2dSpacer getViewportAxisLabelSpacer(Viewport view, int axis) {
        if (view == null) {
            return null;
        }
        ViewportLinkRecord vlr = (ViewportLinkRecord)this._viewportLinkTable.get(view);
        if (vlr == null) {
            System.out.println("getViewportAxisLabelSpacer: failed to find link record for " + view);
            return null;
        }
        switch (axis) {
            case 0: {
                return vlr.x1axislabelSpacer;
            }
            case 1: {
                return vlr.x2axislabelSpacer;
            }
            case 2: {
                return vlr.y1axislabelSpacer;
            }
            case 3: {
                return vlr.y2axislabelSpacer;
            }
        }
        System.out.println("getViewportAxisLabelSpacer: invalid axis specified " + axis);
        return null;
    }

    public G2dSpacer getViewportAxisTicsSpacer(Viewport view, int axis) {
        if (view == null) {
            return null;
        }
        ViewportLinkRecord vlr = (ViewportLinkRecord)this._viewportLinkTable.get(view);
        if (vlr == null) {
            System.out.println("getViewportAxisTicsSpacer: failed to find link record for " + view);
            return null;
        }
        switch (axis) {
            case 0: {
                return vlr.x1axisticsSpacer;
            }
            case 1: {
                return vlr.x2axisticsSpacer;
            }
            case 2: {
                return vlr.y1axisticsSpacer;
            }
            case 3: {
                return vlr.y2axisticsSpacer;
            }
        }
        System.out.println("getViewportAxisTicsSpacer: invalid axis specified " + axis);
        return null;
    }

    public AxisTics getViewportAxisTics(Viewport view, int axis) {
        if (view == null) {
            return null;
        }
        ViewportLinkRecord vlr = (ViewportLinkRecord)this._viewportLinkTable.get(view);
        if (vlr == null) {
            System.out.println("getViewportAxisTics: failed to find link record for " + view);
            return null;
        }
        switch (axis) {
            case 0: {
                return vlr.x1axistics;
            }
            case 1: {
                return vlr.x2axistics;
            }
            case 2: {
                return vlr.y1axistics;
            }
            case 3: {
                return vlr.y2axistics;
            }
        }
        System.out.println("getViewportAxisTics: invalid axis specified " + axis);
        return null;
    }

    public AxisLabel getAxisLabel(int axis) {
        switch (axis) {
            case 0: {
                return this._x1label;
            }
            case 1: {
                return this._x2label;
            }
            case 2: {
                return this._y1label;
            }
            case 3: {
                return this._y2label;
            }
        }
        return null;
    }

    public AxisTics getAxisTics(int axis) {
        switch (axis) {
            case 0: {
                return this._x1tics;
            }
            case 1: {
                return this._x2tics;
            }
            case 2: {
                return this._y1tics;
            }
            case 3: {
                return this._y2tics;
            }
        }
        return null;
    }

    public void setLabelFontSizes(int sz, int tiny, int min, int max) {
        Component[] comps = this.getComponents();
        this.setLabelFontSizes(comps, sz, tiny, min, max);
    }

    private void setLabelFontSizes(Component[] components, int sz, int tiny, int min, int max) {
        if (components == null) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof AxisLabel) {
                ((AxisLabel)components[i]).setFontSizes(sz, tiny, min, max);
                continue;
            }
            if (!(components[i] instanceof Container)) continue;
            Component[] temp = ((Container)components[i]).getComponents();
            this.setLabelFontSizes(temp, sz, tiny, min, max);
        }
    }

    public void setTicFontSizes(int sz, int tiny, int min, int max) {
        this.setTicFontSizes(this.getComponents(), sz, tiny, min, max);
    }

    private void setTicFontSizes(Component[] components, int sz, int tiny, int min, int max) {
        if (components == null) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof AxisTics) {
                ((AxisTics)components[i]).setFontSizes(sz, tiny, min, max);
                continue;
            }
            if (!(components[i] instanceof Container)) continue;
            Component[] temp = ((Container)components[i]).getComponents();
            this.setLabelFontSizes(temp, sz, tiny, min, max);
        }
    }

    public void resetAllDataLimits() {
        Enumeration e = this._scaleTable.elements();
        while (e.hasMoreElements()) {
            Scale scl = (Scale)e.nextElement();
            scl.invalidateRegionExtents();
        }
        for (int i = 0; i < this._viewportVector.size(); ++i) {
            Viewport vp = (Viewport)this._viewportVector.elementAt(i);
            vp.resetAllDataLimits();
            vp.zoomByFactor(10000.0);
        }
    }

    public void paintGfx(Graphics g) {
        if (this._panelProperties.backgroundColor != null) {
            Dimension size = this.getSize();
            g.setColor(this._panelProperties.backgroundColor);
            g.fillRect(0, 0, size.width - 1, size.height - 1);
        }
        g = g.create();
        if (this._toolbar != null && this._toolbar.isVisible()) {
            int v = (int)Math.ceil((this._toolbar.getBounds().x + this._toolbar.getBounds().width) / 2);
            g.setClip(v, 0, this.getWidth() - v + 1, this.getHeight());
            g.translate(-1 * v, 0);
        }
        this.printAll(g);
        g.dispose();
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        Component x = this.getComponentAt(pt.x, pt.y);
        if (x instanceof G2dComponent) {
            ((G2dComponent)x).objectPopupMenu(pt, modifiers);
        }
        if (x == this.VERTICAL_LEGEND_CONTAINER || x == this.HORIZONTAL_LEGEND_CONTAINER) {
            Rectangle rect = x.getBounds();
            pt.init(pt.x - rect.x, pt.y - rect.y);
            this._legend.objectPopupMenu(pt, modifiers);
        }
        return true;
    }

    @Override
    public void pointerOver(LocalPt pt) {
    }

    public boolean mouseDragged(LocalPt pt) {
        return false;
    }

    @Override
    public boolean objectSelect(LocalPt pt, int modifiers) {
        Component x = this.getComponentAt(pt.x, pt.y);
        if (x == this.VERTICAL_LEGEND_CONTAINER || x == this.HORIZONTAL_LEGEND_CONTAINER) {
            Rectangle rect = x.getBounds();
            pt.init(pt.x - rect.x, pt.y - rect.y);
            this._legend.objectSelect(pt, modifiers);
        }
        return false;
    }

    @Override
    public void objectSelectionChanged(ObjectSelectionEvent e) {
        this.fireObjectSelectionChanged(e);
    }

    public void addObjectSelectionListener(ObjectSelectionListener l) {
        this.listenerList.add(ObjectSelectionListener.class, l);
    }

    public void removeObjectSelectionListener(ObjectSelectionListener l) {
        this.listenerList.remove(ObjectSelectionListener.class, l);
    }

    protected void fireObjectSelectionChanged(ObjectSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        Object e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ObjectSelectionListener.class) continue;
            ((ObjectSelectionListener)listeners[i + 1]).objectSelectionChanged(event);
        }
    }

    @Override
    public G2dMouseAdapter getMouseAdapter() {
        return this._mouseAdapter;
    }

    @Override
    public void setMouseAdapter(String className) {
        if (className == null) {
            this.setMouseAdapter((G2dMouseAdapter)null);
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        G2dMouseAdapter adapter = null;
        try {
            Class<?> adapterClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            Constructor<?> constructor = null;
            Constructor<?>[] cparamConstructor = adapterClass.getDeclaredConstructors();
            boolean tf = true;
            for (int i = 0; cparamConstructor != null && i < cparamConstructor.length; ++i) {
                constructor = cparamConstructor[i];
                Class<?>[] cparamClasses = cparamConstructor[i].getParameterTypes();
                for (int j = 0; cparamClasses != null && j < cparamClasses.length; ++j) {
                    if (cparamClasses[j].isAssignableFrom(this.getClass())) continue;
                    tf = false;
                    break;
                }
                if (tf) break;
            }
            if (!tf) {
                this.setMouseAdapter(this.createDefaultMouseAdapter());
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            Object[] cparam = new Object[]{this, this};
            if (constructor != null) {
                adapter = (G2dMouseAdapter)constructor.newInstance(cparam);
            }
        }
        catch (Exception e) {
            Logger.getLogger(G2dComponent.class.getName()).log(Level.SEVERE, "Unable to load Mouse Adapter: " + className, e);
        }
        if (adapter != null) {
            this.setMouseAdapter(adapter);
        }
    }

    protected G2dMouseAdapter createDefaultMouseAdapter() {
        return new G2dPointerAdapter(this, this);
    }

    @Override
    public G2dMouseAdapter setMouseAdapter(G2dMouseAdapter adapter) {
        if (this._mouseAdapter != null) {
            this._mouseAdapter.abort();
            this.removeMouseListener(this._mouseAdapter);
            this.removeMouseMotionListener(this._mouseAdapter);
        }
        if (adapter != null) {
            adapter.init();
            this.addMouseListener(adapter);
            this.addMouseMotionListener(adapter);
        }
        G2dMouseAdapter oldadapter = this._mouseAdapter;
        this._mouseAdapter = adapter;
        return oldadapter;
    }

    @Override
    public void setDisplayUnitsSystem(int units) {
        boolean[] axisAutoMaxMin;
        Axis axis;
        WorldRect rect;
        Scale scl;
        if (!Units.isValidUnitsSystem(units)) {
            throw new IllegalArgumentException("ERROR <G2dPanel.setDisplayUnitsSystem()> : Invalid Unit System Id " + units);
        }
        boolean isVisible = this.isVisible();
        this.setVisible(false);
        this._displayUnitSystem = units;
        this.updateUnitSystem(this);
        Enumeration e = this._scaleTable.elements();
        HashMap<Scale, WorldRect> viewMap = new HashMap<Scale, WorldRect>();
        HashMap<Axis, boolean[]> axisMap = new HashMap<Axis, boolean[]>();
        while (e.hasMoreElements()) {
            scl = (Scale)e.nextElement();
            rect = new WorldRect();
            axis = scl.getAxis(0);
            axisAutoMaxMin = new boolean[2];
            rect.w = axis.getActMin();
            rect.e = axis.getActMax();
            axisAutoMaxMin[0] = axis.isUsingAutomaticViewMinimum();
            axisAutoMaxMin[1] = axis.isUsingAutomaticViewMaximum();
            axisMap.put(axis, axisAutoMaxMin);
            axisAutoMaxMin = new boolean[2];
            axis = scl.getAxis(1);
            rect.n = axis.getActMax();
            rect.s = axis.getActMin();
            axisAutoMaxMin[0] = axis.isUsingAutomaticViewMinimum();
            axisAutoMaxMin[1] = axis.isUsingAutomaticViewMaximum();
            axisMap.put(axis, axisAutoMaxMin);
            viewMap.put(scl, rect);
            scl.setDisplayUnitSystem(units);
        }
        this.resetAllDataLimits();
        e = this._scaleTable.elements();
        while (e.hasMoreElements()) {
            scl = (Scale)e.nextElement();
            rect = (WorldRect)viewMap.get(scl);
            if (rect == null) continue;
            axis = scl.getAxis(0);
            axisAutoMaxMin = (boolean[])axisMap.get(axis);
            rect.w = !axisAutoMaxMin[0] ? scl.covertUnitSystems(axis.getOldDisplayUnitSystem(), axis.getDisplayUnitSystem(), axis.getParameterId(), rect.w) : axis.getMin();
            rect.e = !axisAutoMaxMin[1] ? scl.covertUnitSystems(axis.getOldDisplayUnitSystem(), axis.getDisplayUnitSystem(), axis.getParameterId(), rect.e) : axis.getMax();
            axis.zoomIn(rect.w, rect.e);
            axis = scl.getAxis(1);
            axisAutoMaxMin = (boolean[])axisMap.get(axis);
            rect.s = !axisAutoMaxMin[0] ? scl.covertUnitSystems(axis.getOldDisplayUnitSystem(), axis.getDisplayUnitSystem(), axis.getParameterId(), rect.s) : axis.getMin();
            rect.n = !axisAutoMaxMin[1] ? scl.covertUnitSystems(axis.getOldDisplayUnitSystem(), axis.getDisplayUnitSystem(), axis.getParameterId(), rect.n) : axis.getMax();
            axis.zoomIn(rect.s, rect.n);
        }
        if (isVisible) {
            this.setVisible(true);
        }
        this.repaint();
    }

    private boolean updateUnitSystem(Container c2) {
        Component[] comps = null;
        if (c2 == null) {
            return false;
        }
        comps = c2.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof UnitsComponent) {
                ((UnitsComponent)((Object)comps[i])).setDisplayUnitsSystem(this._displayUnitSystem);
                continue;
            }
            if (!(comps[i] instanceof Container) || this.updateUnitSystem((Container)comps[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
        Enumeration e = this._scaleTable.elements();
        while (e.hasMoreElements()) {
            Scale scl = (Scale)e.nextElement();
            scl.setDisplayScaleFactor(paramId, scaleFactor);
        }
        this.resetAllDataLimits();
        this.repaint();
    }

    @Override
    public String getDisplayUnitsString(int v) {
        return "";
    }

    @Override
    public void setTimeZone(TimeZone tz) {
        Enumeration e = this._scaleTable.elements();
        while (e.hasMoreElements()) {
            Scale scl = (Scale)e.nextElement();
            scl.setDisplayTimeZone(tz);
        }
        this.resetAllDataLimits();
        this.repaint();
    }

    @Override
    public TimeZone getTimeZone() {
        return null;
    }

    public int getSelectedToolbarButton() {
        if (this._toolbar == null) {
            return -1;
        }
        return this._toolbar.getSelectedButton();
    }

    public void setSelectedToolbarButton(int selected) {
        if (this._toolbar == null) {
            return;
        }
        this._toolbar.forceSelectButton(selected);
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        super.addFocusListener(fl);
        if (this._focusListenerList == null) {
            return;
        }
        if (fl != null && !this._focusListenerList.contains(fl)) {
            this._focusListenerList.add(fl);
        }
        if (this._mouseListener == null) {
            this._mouseListener = new MouseInputHandler();
            this.addMouseListener(this._mouseListener);
        }
        if (this._viewportVector == null) {
            return;
        }
        for (int i = 0; i < this._viewportVector.size(); ++i) {
            ((Component)this._viewportVector.get(i)).addFocusListener(fl);
        }
    }

    @Override
    public void removeFocusListener(FocusListener fl) {
        super.removeFocusListener(fl);
        if (this._focusListenerList == null) {
            return;
        }
        if (fl != null) {
            this._focusListenerList.remove(fl);
        }
        if (this._viewportVector == null) {
            return;
        }
        for (int i = 0; i < this._viewportVector.size(); ++i) {
            ((Component)this._viewportVector.get(i)).removeFocusListener(fl);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    private void clearFocusListeners() {
        while (this._focusListenerList.size() > 0) {
            FocusListener fl = (FocusListener)this._focusListenerList.lastElement();
            this.removeFocusListener(fl);
        }
    }

    public void useLineStyles(boolean useStyles) {
        G2dGlyph glyph;
        Vector<G2dObject> g2dObjList = new Vector<G2dObject>();
        Vector<G2dGlyph> g2dGlyphList = new Vector<G2dGlyph>();
        for (int i = 0; i < this._viewportVector.size(); ++i) {
            Viewport v = (Viewport)this._viewportVector.get(i);
            Vector glyphVector = v.getGlyphVector();
            for (int g = 0; g < glyphVector.size(); ++g) {
                glyph = (G2dGlyph)glyphVector.get(g);
                g2dObjList.add(glyph.getG2dObject());
                g2dGlyphList.add(glyph);
            }
            v.setDirty();
        }
        DataTypeFactory.getFactory().reset();
        List<LineProperties> lineProps = DataTypeFactory.getFactory().getLineProperties(g2dObjList, useStyles);
        if (lineProps == null) {
            return;
        }
        int colorIndex = 0;
        for (int j = 0; j < g2dGlyphList.size(); ++j) {
            glyph = (G2dGlyph)g2dGlyphList.elementAt(j);
            for (int i = 0; i < glyph.getCurveCount() && colorIndex < lineProps.size(); ++colorIndex, ++i) {
                G2dLineProperties prop = (G2dLineProperties)lineProps.get(colorIndex);
                glyph.getLine(i).setProperties(prop);
            }
        }
        this.paintGfx();
    }

    /*
     * Enabled aggressive block sorting
     */
    String getYName(G2dObject go, DataType dataType) {
        String yname = "Y Axis";
        if (go == null) {
            return yname;
        }
        if (dataType != null) {
            DataTypeFactory.getFactory();
            if (dataType != DataTypeFactory.UNDEFINED_DATA_TYPE) {
                if (Units.isValidUnitsSystem(this._displayUnitSystem)) {
                    yname = dataType.getYAxisName();
                    return yname.trim();
                }
                yname = go.getYAxisName();
                return yname.trim();
            }
        }
        yname = go.getYAxisName();
        return yname.trim();
    }

    public Scale[] getScales() {
        Scale[] scaleList = new Scale[this._scaleTable.size()];
        Enumeration enumeration = this._scaleTable.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            scaleList[i++] = (Scale)enumeration.nextElement();
        }
        return scaleList;
    }

    public Vector getViewportVector() {
        return this._viewportVector;
    }

    public static Color[] getLineColors() {
        return _lineColor;
    }

    public static Color[] getFillColors() {
        return _fillColor;
    }

    public LegendPanel getLegendPanel() {
        return this._legend;
    }

    public void setLegendVisible(boolean b) {
        if (this._legend.getLegendPosition() == 0 || this._legend.getLegendPosition() == 1) {
            this._legend.setVisible(b);
        }
        if (this._legend.getLegendPosition() == 6 || this._legend.getLegendPosition() == 7) {
            this._legend.setVisible(false);
            for (int i = 0; i < this._viewportVector.size(); ++i) {
                Viewport v = (Viewport)this._viewportVector.get(i);
                v.setDrawViewportLegend(b);
                v.setDirty();
                v.repaint();
            }
        }
        if (this._legend.getLegendPosition() == 5) {
            if (this.LEGEND_FRAME != null) {
                this.LEGEND_FRAME.setVisible(b);
            }
            this._legend.setVisible(b);
        }
        LegendPanelProp properties = this._legend.getProperties();
        properties.setLegenedVisible(b);
        this._legend.setProperties(properties);
    }

    public boolean isLegendVisible() {
        boolean viewportLegendVisible = false;
        for (int i = 0; i < this._viewportVector.size(); ++i) {
            Viewport v = (Viewport)this._viewportVector.get(i);
            viewportLegendVisible |= v.getDrawViewportLegend();
        }
        return this._legend != null && this._legend.isVisible() || viewportLegendVisible || this.LEGEND_FRAME != null && this.LEGEND_FRAME.isVisible();
    }

    public void setLegendPanel(LegendPanel panel) {
        this._legend = panel;
    }

    public static ViewportToolbarProp createDefaultToolbarProperties() {
        ViewportToolbarProp properties = new ViewportToolbarProp();
        ToolbarButtonProp buttonProp = new ToolbarButtonProp();
        buttonProp.up = "Images/Point.gif";
        buttonProp.down = "Images/Point.gif";
        buttonProp.over = "Images/Point.gif";
        buttonProp.on = "Images/Point.gif";
        buttonProp.adapter = "hec.gfx2d.G2dPointerAdapter";
        properties.addButtonProp(buttonProp);
        buttonProp = new ToolbarButtonProp();
        buttonProp.up = "Images/ZoomUp.gif";
        buttonProp.down = "Images/ZoomDown.gif";
        buttonProp.over = "Images/ZoomUp.gif";
        buttonProp.on = "Images/ZoomDown.gif";
        buttonProp.adapter = "hec.gfx2d.G2dZoomAdapter";
        properties.addButtonProp(buttonProp);
        return properties;
    }

    public void showStatistics(boolean stats) {
        this._showStats = stats;
        Viewport[] viewports = this.getViewports();
        for (int viewportIndex = 0; viewportIndex < viewports.length; ++viewportIndex) {
            Viewport viewport = viewports[viewportIndex];
            viewport.setShowStatistics(stats);
        }
    }

    public boolean isShowingStatistics() {
        return this._showStats;
    }

    public boolean hasStatistics() {
        Viewport[] viewports = this.getViewports();
        for (int viewportIndex = 0; viewportIndex < viewports.length; ++viewportIndex) {
            Viewport viewport = viewports[viewportIndex];
            if (!viewport.containsStatistics()) continue;
            return true;
        }
        return false;
    }

    private class WindowClosingListener
    extends WindowAdapter {
        private WindowClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Object src = e.getSource();
            G2dPanel.this.m_openPopupWindows.removeElement(src);
            ((Window)src).removeWindowListener(this);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            Object src = e.getSource();
            G2dPanel.this.m_openPopupWindows.removeElement(src);
            ((Window)src).removeWindowListener(this);
        }
    }

    private class LegendWindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent e) {
            G2dPanel.this.moveLegendToPosition(0);
            G2dPanel.this._legend.fillGlyphVector();
            G2dPanel.this.HORIZONTAL_LEGEND_CONTAINER.invalidate();
            G2dPanel.this.HORIZONTAL_LEGEND_CONTAINER.validate();
            G2dPanel.this.invalidate();
            G2dPanel.this.validate();
            G2dPanel.this.repaint();
        }
    }

    private class MouseInputHandler
    extends MouseAdapter {
        MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            G2dPanel.this.requestFocus();
        }
    }
}

