/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.PlotProperties;
import hec.gfx2d.PropertiesSerializer;
import hec.gfx2d.TitleDrawProp;
import hec.gfx2d.ViewportToolbarProp;
import hec.io.AsciiSerializable;
import java.awt.Color;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Vector;
import rma.swing.RmaColor;
import rma.util.RMAIO;

public class G2dPanelProp
extends PlotProperties
implements AsciiSerializable {
    public static int TOP = 0;
    public static int BOTTOM = 1;
    public static int LEFT = 2;
    public static int RIGHT = 3;
    public static final String PANEL_BEGIN = "Panel Begin";
    public static final String PANEL_END = "Panel End";
    public static final String TOOLBAR_BEGIN = "Toolbar Begin";
    public static final String TOOLBAR_END = "Toolbar End";
    public static final String TITLE_BEGIN = "Title Begin";
    public static final String TITLE_END = "Title End";
    public static final String LEGEND_PANEL_BEGIN = "Legend Panel Begin";
    public static final String LEGEND_PANEL_END = "Legend Panel End";
    public static final String PLOT_BEGIN = "Plot Begin";
    public static final String PLOT_END = "Plot End";
    private static final String HAS_TOOLBAR = "hasToolbar";
    private static final String TOOLBAR_POSITION = "toolbarPosition";
    private static final String HAS_TITLE = "hasTitle";
    private static final String HAS_LEGEND = "hasLegend";
    private static final String INSETS = "insets";
    private static final String BACKGROUND_COLOR = "backgroundColor";
    private static final String VIEWPORT_SPACE_SIZE = "viewportSpaceSize";
    private static final String ACCESSORY_PANEL_CLASS = "accessoryPanelClass";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_HEIGH = "dialogHeight";
    private static final String CLS_NAME = "G2dPanel_";
    private static final String[] POSITION_LABELS = new String[]{"top", "bottom", "left", "right"};
    public boolean hasToolbar;
    public int toolbarPosition;
    public boolean hasTitle;
    public boolean hasLegend;
    public Insets insets;
    public Color backgroundColor;
    public int viewportSpaceSize;
    public int dialogWidth = Integer.MIN_VALUE;
    public int dialogHeight = Integer.MIN_VALUE;
    public Vector plotPropVector = new Vector();
    public ViewportToolbarProp toolbarProp = new ViewportToolbarProp();
    public TitleDrawProp titleProp = new TitleDrawProp();
    public LegendPanelProp legendProp = new LegendPanelProp();
    public String accessoryPanelClass = null;

    public static void init() {
        G2dPanelProp.init(CLS_NAME);
    }

    static void init(String cls) {
        G2dPanelProp.setDefault(cls + HAS_TOOLBAR, true);
        G2dPanelProp.setDefault(cls + TOOLBAR_POSITION, LEFT);
        G2dPanelProp.setDefault(cls + HAS_TITLE, true);
        G2dPanelProp.setDefault(cls + HAS_LEGEND, true);
        G2dPanelProp.setDefault(cls + INSETS, new Insets(3, 3, 3, 3));
        G2dPanelProp.setDefault(cls + BACKGROUND_COLOR, (Color)null);
        G2dPanelProp.setDefault(cls + VIEWPORT_SPACE_SIZE, 5);
        G2dPanelProp.setDefault(cls + DIALOG_HEIGH, Integer.MIN_VALUE);
        G2dPanelProp.setDefault(cls + DIALOG_WIDTH, Integer.MIN_VALUE);
    }

    public G2dPanelProp() {
        this(CLS_NAME);
    }

    public G2dPanelProp(G2dPanelProp dp) {
        this.set(dp);
    }

    protected G2dPanelProp(String cls) {
        this.hasToolbar = G2dPanelProp.getDefaultBoolean(cls + HAS_TOOLBAR);
        this.toolbarPosition = G2dPanelProp.getDefaultInt(cls + TOOLBAR_POSITION);
        this.hasTitle = G2dPanelProp.getDefaultBoolean(cls + HAS_TITLE);
        this.hasLegend = G2dPanelProp.getDefaultBoolean(cls + HAS_LEGEND);
        this.insets = G2dPanelProp.getDefaultInsets(cls + INSETS);
        this.backgroundColor = G2dPanelProp.getDefaultColor(cls + BACKGROUND_COLOR);
        this.viewportSpaceSize = G2dPanelProp.getDefaultInt(cls + VIEWPORT_SPACE_SIZE);
        this.dialogHeight = G2dPanelProp.getDefaultInt(cls + DIALOG_HEIGH);
        this.dialogWidth = G2dPanelProp.getDefaultInt(cls + DIALOG_WIDTH);
    }

    public void sethasToolbar(boolean b) {
        this.hasToolbar = b;
    }

    public void setToolbarPosition(int i) {
        this.toolbarPosition = i;
    }

    public void setHasTitle(boolean b) {
        this.hasTitle = b;
    }

    public void sethasLegend(boolean b) {
        this.hasLegend = b;
    }

    public void setInsets(Insets in) {
        this.insets = in;
    }

    public void setBackgroundColor(Color c2) {
        this.backgroundColor = c2;
    }

    public void setViewportSpaceSize(int i) {
        this.viewportSpaceSize = i;
    }

    public boolean gethasToolbar() {
        return this.hasToolbar;
    }

    public int getToolbarPosition() {
        return this.toolbarPosition;
    }

    public boolean getHasTitle() {
        return this.hasTitle;
    }

    public boolean gethasLegend() {
        return this.hasLegend;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getViewportSpaceSize() {
        return this.viewportSpaceSize;
    }

    public void writeProperties(BufferedWriter writer) {
        if (writer == null) {
            return;
        }
        String indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + PANEL_BEGIN);
        PropertiesSerializer.incrementRecursion();
        indent = PropertiesSerializer.getIndent();
        if (!G2dPanelProp.isDefault(BACKGROUND_COLOR, this.backgroundColor)) {
            RMAIO.fout(writer, indent + "backgroundColor=" + RmaColor.color2String(this.backgroundColor));
        }
        if (!G2dPanelProp.isDefault(VIEWPORT_SPACE_SIZE, this.viewportSpaceSize)) {
            RMAIO.fout(writer, indent + "viewportSpaceSize=" + this.viewportSpaceSize);
        }
        if (!G2dPanelProp.isDefault(HAS_TOOLBAR, this.hasToolbar)) {
            RMAIO.fout(writer, indent + "hasToolbar=" + this.hasToolbar);
        }
        if (!G2dPanelProp.isDefault(TOOLBAR_POSITION, this.toolbarPosition)) {
            RMAIO.fout(writer, indent + "toolbarPosition=" + this.toolbarPosition);
        }
        if (!G2dPanelProp.isDefault(DIALOG_HEIGH, this.dialogHeight)) {
            RMAIO.fout(writer, indent + "dialogHeight=" + this.dialogHeight);
        }
        if (!G2dPanelProp.isDefault(DIALOG_WIDTH, this.dialogWidth)) {
            RMAIO.fout(writer, indent + "dialogWidth=" + this.dialogWidth);
        }
        RMAIO.fout(writer, indent + TOOLBAR_BEGIN);
        this.toolbarProp.writeProperties(writer, TOOLBAR_END);
        if (!G2dPanelProp.isDefault(HAS_TITLE, this.hasTitle)) {
            RMAIO.fout(writer, indent + "hasTitle=" + this.hasTitle);
        }
        RMAIO.fout(writer, indent + TITLE_BEGIN);
        this.titleProp.writeProperties(writer, TITLE_END);
        if (!G2dPanelProp.isDefault(HAS_LEGEND, this.hasLegend)) {
            RMAIO.fout(writer, indent + "hasLegend=" + this.hasLegend);
        }
        RMAIO.fout(writer, indent + LEGEND_PANEL_BEGIN);
        this.legendProp.writeProperties(writer, LEGEND_PANEL_END);
        for (int i = 0; i < this.plotPropVector.size(); ++i) {
            RMAIO.fout(writer, indent + PLOT_BEGIN);
            ((G2dPlotProp)this.plotPropVector.elementAt(i)).writeProperties(writer, PLOT_END);
        }
        if (this.accessoryPanelClass != null) {
            RMAIO.fout(writer, indent + "accessoryPanelClass=" + this.accessoryPanelClass);
        }
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + PANEL_END);
    }

    public static boolean writeDefaults() {
        BufferedWriter writer = PlotDefaultsManager.getDefaults().getBufferedWriter(G2dPanelProp.class);
        boolean b = G2dPanelProp.writeDefaults(writer);
        try {
            writer.close();
        }
        catch (IOException ioe) {
            System.out.println("");
        }
        return b;
    }

    public static boolean writeDefaults(BufferedWriter writer) {
        return G2dPanelProp.writeDefaults(CLS_NAME, writer);
    }

    protected static boolean writeDefaults(String cls, BufferedWriter writer) {
        if (writer == null) {
            return false;
        }
        RMAIO.fout(writer, PANEL_BEGIN);
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + "backgroundColor=" + RmaColor.color2String(G2dPanelProp.getDefaultColor(cls + BACKGROUND_COLOR)));
        RMAIO.fout(writer, indent + "viewportSpaceSize=" + G2dPanelProp.getDefaultInt(cls + VIEWPORT_SPACE_SIZE));
        RMAIO.fout(writer, indent + "hasToolbar=" + G2dPanelProp.getDefaultBoolean(cls + HAS_TOOLBAR));
        RMAIO.fout(writer, indent + "toolbarPosition=" + G2dPanelProp.getDefaultInt(cls + TOOLBAR_POSITION));
        RMAIO.fout(writer, indent + "hasTitle=" + G2dPanelProp.getDefaultBoolean(cls + HAS_TITLE));
        RMAIO.fout(writer, indent + "hasLegend=" + G2dPanelProp.getDefaultBoolean(cls + HAS_LEGEND));
        RMAIO.fout(writer, indent + "dialogHeight=" + G2dPanelProp.getDefaultInt(cls + DIALOG_HEIGH));
        RMAIO.fout(writer, indent + "dialogWidth=" + G2dPanelProp.getDefaultInt(cls + DIALOG_WIDTH));
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + PANEL_END);
        return true;
    }

    public static void setDefaults(G2dPanelProp defaultProps) {
        G2dPanelProp.setDefaults(defaultProps, CLS_NAME);
    }

    protected static void setDefaults(G2dPanelProp defaultProps, String cls) {
        if (defaultProps == null) {
            return;
        }
        if (cls == null) {
            cls = "";
        }
        G2dPanelProp.setDefault(cls + HAS_TOOLBAR, defaultProps.hasToolbar);
        G2dPanelProp.setDefault(cls + TOOLBAR_POSITION, defaultProps.toolbarPosition);
        G2dPanelProp.setDefault(cls + HAS_TITLE, defaultProps.hasTitle);
        G2dPanelProp.setDefault(cls + HAS_LEGEND, defaultProps.hasLegend);
        G2dPanelProp.setDefault(cls + INSETS, defaultProps.insets);
        G2dPanelProp.setDefault(cls + BACKGROUND_COLOR, defaultProps.backgroundColor);
        G2dPanelProp.setDefault(cls + VIEWPORT_SPACE_SIZE, defaultProps.viewportSpaceSize);
        G2dPanelProp.setDefault(cls + DIALOG_HEIGH, defaultProps.dialogHeight);
        G2dPanelProp.setDefault(cls + DIALOG_WIDTH, defaultProps.dialogWidth);
    }

    public void readProperties(BufferedReader in) {
        if (in == null) {
            return;
        }
        String line = "";
        String param = "";
        String type = "";
        try {
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(PANEL_END)) {
                    if (type.equalsIgnoreCase(BACKGROUND_COLOR)) {
                        this.backgroundColor = RmaColor.parseColorString(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(VIEWPORT_SPACE_SIZE)) {
                        this.viewportSpaceSize = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(HAS_TOOLBAR)) {
                        this.hasToolbar = "true".equalsIgnoreCase(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(TOOLBAR_POSITION)) {
                        this.toolbarPosition = Integer.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(TOOLBAR_BEGIN)) {
                        this.toolbarProp.readProperties(in, TOOLBAR_END);
                        continue;
                    }
                    if (type.equalsIgnoreCase(HAS_TITLE)) {
                        this.hasTitle = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(TITLE_BEGIN)) {
                        this.titleProp.readProperties(in, TITLE_END);
                        continue;
                    }
                    if (type.equalsIgnoreCase(HAS_LEGEND)) {
                        this.hasLegend = Boolean.valueOf(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DIALOG_HEIGH)) {
                        this.dialogHeight = RMAIO.parseInt(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(DIALOG_WIDTH)) {
                        this.dialogWidth = RMAIO.parseInt(param);
                        continue;
                    }
                    if (type.equalsIgnoreCase(LEGEND_PANEL_BEGIN)) {
                        this.legendProp.readProperties(in, LEGEND_PANEL_END);
                        continue;
                    }
                    if (type.equalsIgnoreCase(ACCESSORY_PANEL_CLASS)) {
                        this.accessoryPanelClass = param.trim();
                        continue;
                    }
                    if (!type.equalsIgnoreCase(PLOT_BEGIN)) continue;
                    G2dPlotProp pp = new G2dPlotProp();
                    pp.readProperties(in, PLOT_END);
                    this.plotPropVector.addElement(pp);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readProperties(BufferedReader)");
            return;
        }
    }

    public Object getClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException e) {
            return new G2dPanelProp(this);
        }
    }

    public void set(G2dPanelProp dp) {
        if (dp.plotPropVector != null) {
            Enumeration e = dp.plotPropVector.elements();
            while (e.hasMoreElements()) {
                G2dPlotProp p = (G2dPlotProp)e.nextElement();
                this.plotPropVector.addElement(p.getClone());
            }
        }
        this.hasToolbar = dp.hasToolbar;
        this.toolbarPosition = dp.toolbarPosition;
        if (dp.toolbarProp != null) {
            this.toolbarProp = (ViewportToolbarProp)dp.toolbarProp.getClone();
        }
        this.hasTitle = dp.hasTitle;
        if (dp.titleProp != null) {
            this.titleProp = (TitleDrawProp)dp.titleProp.getClone();
        }
        this.hasLegend = dp.hasLegend;
        if (dp.legendProp != null) {
            this.legendProp = (LegendPanelProp)dp.legendProp.getClone();
        }
        this.insets = (Insets)dp.insets.clone();
        this.dialogHeight = dp.dialogHeight;
        this.dialogWidth = dp.dialogWidth;
    }

    public void addPlotProp(G2dPlotProp p) {
        this.plotPropVector.addElement(p);
    }

    public void clearPlotProp() {
        this.plotPropVector.clear();
    }

    public int getPlotCount() {
        return this.plotPropVector.size();
    }

    public Enumeration plotElements() {
        return this.plotPropVector.elements();
    }

    public static String getFileName() {
        return "panelDefaults";
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean loadDefaults(BufferedReader in) {
        return G2dPanelProp.loadDefaults(in, PANEL_END, CLS_NAME);
    }

    private static boolean loadDefaults(BufferedReader in, String endTag, String cls) {
        if (in == null) {
            return false;
        }
        String line = "";
        String param = "";
        String type = "";
        try {
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    if (type.equalsIgnoreCase(BACKGROUND_COLOR)) {
                        G2dPanelProp.setDefault(cls + BACKGROUND_COLOR, RmaColor.parseColorString(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(VIEWPORT_SPACE_SIZE)) {
                        G2dPanelProp.setDefault(cls + VIEWPORT_SPACE_SIZE, Integer.parseInt(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(HAS_TOOLBAR)) {
                        G2dPanelProp.setDefault(cls + HAS_TOOLBAR, "true".equalsIgnoreCase(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(TOOLBAR_POSITION)) {
                        G2dPanelProp.setDefault(cls + TOOLBAR_POSITION, Integer.parseInt(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(HAS_TITLE)) {
                        G2dPanelProp.setDefault(cls + HAS_TITLE, "true".equalsIgnoreCase(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(HAS_LEGEND)) {
                        G2dPanelProp.setDefault(cls + HAS_LEGEND, "true".equalsIgnoreCase(param));
                        continue;
                    }
                    if (type.equalsIgnoreCase(DIALOG_WIDTH)) {
                        G2dPanelProp.setDefault(cls + DIALOG_WIDTH, RMAIO.parseInt(param));
                        continue;
                    }
                    if (!type.equalsIgnoreCase(DIALOG_HEIGH)) continue;
                    G2dPanelProp.setDefault(cls + DIALOG_HEIGH, RMAIO.parseInt(param));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in loadDefaults(BufferedReader, endTag)");
            return false;
        }
        return true;
    }

    public static int getPositionFromString(String pos) {
        for (int i = 0; i < POSITION_LABELS.length; ++i) {
            if (!POSITION_LABELS[i].equalsIgnoreCase(pos)) continue;
            return i;
        }
        return BOTTOM;
    }

    public static String getStringFromPosition(int pos) {
        if (pos < 0 || pos > RIGHT) {
            return POSITION_LABELS[BOTTOM];
        }
        return POSITION_LABELS[pos];
    }

    static {
        G2dPanelProp.init();
    }
}

