/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dPatternPropertiesPanel;
import hec.gfx2d.G2dPolygonProperties;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.Gfx2dDrawUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;

public class G2dPolygon
extends Polygon
implements ActionListener {
    protected G2dPolygonProperties _properties = null;
    JPopupMenu _popupMenu = null;
    G2dGlyph _glyph = null;
    Scale _scale = null;
    protected static final String EDIT_PROPERTIES = "EDIT_PROPERTIES";

    public G2dPolygon() {
        this._properties = new G2dPolygonProperties();
        this.createPopupMenu();
    }

    public G2dPolygon(G2dPolygonProperties prop) {
        this._properties = prop;
        this.createPopupMenu();
    }

    public G2dPolygon(int[] xpoints, int[] ypoints, int npoints) {
        super(xpoints, ypoints, npoints);
        if (npoints > 0 && (xpoints[0] != xpoints[npoints - 1] || ypoints[0] != ypoints[npoints - 1])) {
            this.addPoint(xpoints[0], ypoints[0]);
        }
        this.createPopupMenu();
    }

    public void setScale(Scale s) {
        this._scale = s;
    }

    public void setGlyph(G2dGlyph g) {
        this._glyph = g;
    }

    public void showPopup(Component c2, int x, int y) {
        this._popupMenu.show(c2, x, y);
    }

    private void createMenuComponents(Container c2) {
        JMenuItem menuItem = new JMenuItem("Edit Properties");
        menuItem.setName(EDIT_PROPERTIES);
        menuItem.addActionListener(this);
        c2.add(menuItem);
    }

    protected void createPopupMenu() {
        this._popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("G2dPolygon");
        menuItem.setEnabled(false);
        this._popupMenu.add(menuItem);
        this._popupMenu.addSeparator();
        this.createMenuComponents(this._popupMenu);
    }

    public JMenu createEditMenu() {
        JMenu menu = new JMenu("Polygon");
        this.createMenuComponents(menu);
        return menu;
    }

    public G2dPolygonProperties getProperties() {
        return this._properties;
    }

    public void setProperties(G2dPolygonProperties propValue) {
        this._properties = propValue;
    }

    public void setPolygonData(int[] xdata, int[] ydata, int npts) {
        this.npoints = npts;
        this.xpoints = new int[npts];
        this.ypoints = new int[npts];
        System.arraycopy(xdata, 0, this.xpoints, 0, this.npoints);
        System.arraycopy(ydata, 0, this.ypoints, 0, this.npoints);
        if (npts > 0 && (this.xpoints[0] != this.xpoints[npts - 1] || this.ypoints[0] != this.ypoints[npts - 1])) {
            this.addPoint(this.xpoints[0], this.ypoints[0]);
        }
    }

    public boolean contains(LocalPt pt) {
        if (pt == null) {
            return false;
        }
        return super.contains(pt.x, pt.y);
    }

    public void drawPolygon(Graphics g, Rectangle clipRect) {
        Color oldColor = g.getColor();
        if (this._properties.drawBackground) {
            g.setColor(this._properties.fillColor);
            Gfx2dDrawUtil.fillPolygonClipped(g, clipRect, this.xpoints, this.ypoints, this.npoints, this._properties.fillPattern);
        }
        if (this._properties.drawBorder) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke oldStroke = g2d.getStroke();
            g2d.setColor(this._properties.borderColor);
            BasicStroke bs = new BasicStroke(this._properties.borderWeight, 0, 0, 10.0f, this._properties.borderStyle, 0.0f);
            g2d.setStroke(bs);
            Gfx2dDrawUtil.plotPolyLineClipped(g2d, clipRect, this.xpoints, this.ypoints, this.npoints);
            g2d.setStroke(oldStroke);
        }
        g.setColor(oldColor);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JMenuItem menuItem;
        Object obj = event.getSource();
        if (obj instanceof JMenuItem && (menuItem = (JMenuItem)obj).getName().equals(EDIT_PROPERTIES)) {
            this.editProperties();
        }
    }

    public void editProperties() {
        G2dPatternPropertiesPanel panel = new G2dPatternPropertiesPanel();
        panel.setData(this._properties);
        Window w = null;
        if (this._glyph.getViewport() != null) {
            w = SwingUtilities.windowForComponent(this._glyph.getViewport());
        }
        PropertiesOKListener listener = new PropertiesOKListener();
        G2dPropertiesDlg dialog = null;
        dialog = w instanceof Frame ? new G2dPropertiesDlg((Frame)w, false, "Edit Polygon Properties", new DefaultJPanel[]{panel}) : new G2dPropertiesDlg((Dialog)w, false, "Edit Polygon Properties", new DefaultJPanel[]{panel});
        dialog.addOKListener(listener);
        dialog.setVisible(true);
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window w;
            if (G2dPolygon.this._glyph != null && (w = SwingUtilities.windowForComponent(G2dPolygon.this._glyph.getViewport())) != null) {
                w.repaint();
            }
        }
    }
}

