/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.PatternProperties;
import hec.gfx2d.PropertiesSerializer;
import hec.io.AsciiSerializable;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import rma.util.RMAIO;
import rma.util.RmaDrawConst;

public class G2dPolygonProperties
implements PatternProperties,
AsciiSerializable {
    private static final Color DEFAULT_FILL_COLOR = Color.blue;
    private static final int DEFAULT_FILL_PATTERN = 0;
    private static final boolean DEFAULT_DRAW_BORDER = false;
    private static final boolean DEFAULT_DRAW_BACKGROUND = true;
    private static final Color DEFAULT_BORDER_COLOR = Color.blue;
    private static final float[] DEFAULT_BORDER_STYLE = G2dLineProperties.SOLID_STYLE_PATTERN;
    private static final float DEFAULT_BORDER_WEIGHT = 1.0f;
    private static final float DEFAULT_ALPHA_COMPOSITE = 1.0f;
    public Color fillColor = DEFAULT_FILL_COLOR;
    public int fillPattern = 0;
    public boolean drawBorder = false;
    public boolean drawBackground = true;
    public Color borderColor = DEFAULT_BORDER_COLOR;
    public float[] borderStyle = DEFAULT_BORDER_STYLE;
    public float borderWeight = 1.0f;
    public float alphaComposite = 1.0f;

    @Override
    public void setDrawLine(boolean b) {
        this.drawBorder = b;
    }

    @Override
    public void setDrawBackground(boolean b) {
        this.drawBackground = b;
    }

    @Override
    public void setLineColor(Color c2) {
        this.borderColor = c2;
    }

    @Override
    public void setLineStyle(float[] s) {
        this.borderStyle = s;
    }

    @Override
    public void setLineWeight(float f) {
        this.borderWeight = f;
    }

    @Override
    public void setBackgroundColor(Color c2) {
        this.fillColor = c2;
    }

    @Override
    public void setBackgroundFill(int i) {
        this.fillPattern = i;
    }

    @Override
    public void setAlphaComposite(float flt) {
        this.alphaComposite = flt;
    }

    @Override
    public Color getLineColor() {
        return this.borderColor;
    }

    @Override
    public float[] getLineStyle() {
        return this.borderStyle;
    }

    @Override
    public float getLineWeight() {
        return this.borderWeight;
    }

    @Override
    public Color getBackgroundColor() {
        return this.fillColor;
    }

    @Override
    public boolean getDrawLine() {
        return this.drawBorder;
    }

    @Override
    public boolean getDrawBackground() {
        return this.drawBackground;
    }

    @Override
    public int getBackgroundFill() {
        return this.fillPattern;
    }

    @Override
    public float getAlphaComposite() {
        return this.alphaComposite;
    }

    public void writeProperties(BufferedWriter writer, String endTag) {
        if (writer == null) {
            return;
        }
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        if (!this.fillColor.equals(DEFAULT_FILL_COLOR)) {
            RMAIO.fout(writer, indent + "fillColor=" + RMAIO.getRGBString(this.fillColor));
        }
        if (!this.borderColor.equals(DEFAULT_BORDER_COLOR)) {
            RMAIO.fout(writer, indent + "borderColor" + RMAIO.getRGBString(this.borderColor));
        }
        if (this.fillPattern != 0) {
            RMAIO.fout(writer, indent + "fillPattern=" + RmaDrawConst.lookupFillPatternName(this.fillPattern));
        }
        if (this.drawBorder) {
            RMAIO.fout(writer, indent + "drawBorder=" + this.drawBorder);
        }
        if (!this.drawBackground) {
            RMAIO.fout(writer, indent + "drawBackground=" + this.drawBackground);
        }
        if (!Arrays.equals(this.borderStyle, DEFAULT_BORDER_STYLE)) {
            RMAIO.fout(writer, indent + "borderStyle=" + G2dLineProperties.lookupStyleName(this.borderStyle));
        }
        if (this.borderWeight != 1.0f) {
            RMAIO.fout(writer, indent + "borderWeight=" + this.borderWeight);
        }
        if (this.alphaComposite != 1.0f) {
            RMAIO.fout(writer, indent + "alphaComposite=" + Float.toString(this.alphaComposite));
        }
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + endTag);
    }

    public void readProperties(BufferedReader in, String endTag) {
        if (in == null) {
            return;
        }
        String line = "";
        String param = "";
        String type = "";
        try {
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    if (type.equalsIgnoreCase("fillColor")) {
                        this.fillColor = RMAIO.parseRGBString(param);
                    }
                    if (type.equalsIgnoreCase("borderColor")) {
                        this.borderColor = RMAIO.parseRGBString(param);
                    }
                    if (type.equalsIgnoreCase("fillPattern")) {
                        this.fillPattern = RmaDrawConst.lookupFillPattern(param);
                    }
                    if (type.equalsIgnoreCase("drawBorder")) {
                        this.drawBorder = Boolean.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("drawBackground")) {
                        this.drawBackground = Boolean.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("borderStyle")) {
                        this.borderStyle = G2dLineProperties.lookupStyle(param);
                    }
                    if (type.equalsIgnoreCase("borderWeight")) {
                        this.borderWeight = Float.valueOf(param).floatValue();
                    }
                    if (!type.equalsIgnoreCase("alphaComposite")) continue;
                    this.alphaComposite = RMAIO.parseFloat(param, 1.0f);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readProperties(BufferedReader)");
            return;
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

