/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dGridPropertiesPanel;
import hec.gfx2d.G2dLinePropertiesPanel;
import hec.gfx2d.G2dPatternPropertiesPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJDialog;
import rma.util.RMAIO;

public class G2dPropertiesDlg
extends RmaJDialog
implements ButtonCmdPanelListener {
    public static int OK_BUTTON_ACTION = 0;
    public static int APPLY_BUTTON_ACTION = 1;
    private DefaultJPanel[] _panels = null;
    private boolean _canceled = false;
    EventListenerList listenerList = new EventListenerList();
    private JTabbedPane _tabPane;
    boolean fComponentsAdjusted = false;

    public G2dPropertiesDlg(Frame parent, boolean model, DefaultJPanel[] panels) {
        super(parent, model);
        this.createComponents(panels);
    }

    public G2dPropertiesDlg(Frame parent, boolean model, String title, DefaultJPanel[] panels) {
        this(parent, model, panels);
        this.setTitle(title);
    }

    public G2dPropertiesDlg(Dialog parent, boolean model, DefaultJPanel[] panels) {
        super(parent, model);
        this.createComponents(panels);
    }

    public G2dPropertiesDlg(Dialog parent, boolean model, String title, DefaultJPanel[] panels) {
        this(parent, model, panels);
        this.setTitle(title);
    }

    private void createComponents(DefaultJPanel[] panels) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(410, 395);
        if (panels != null && panels.length > 0) {
            int i;
            if (panels.length == 1) {
                this.getContentPane().add((Component)panels[0], new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this._tabPane = new JTabbedPane();
                this.getContentPane().add((Component)this._tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
                for (i = 0; i < panels.length; ++i) {
                    this._tabPane.addTab(panels[i].getName(), panels[i]);
                }
            }
            this._panels = panels;
            for (i = 0; i < panels.length; ++i) {
                panels[i].fillPanel();
            }
        } else {
            RMAIO.postWarning(this, "There are no panels to display");
            System.out.println("There are no panels to display");
        }
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(14);
        this.getContentPane().add((Component)cmdPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 5, 5), 0, 0));
        cmdPanel.setApplyEnabled(true);
        cmdPanel.addCmdPanelListener(this);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.setModified(false);
        Dimension d = this.getPreferredSize();
        this.setSize(d.width, d.height);
        this.setDefaultSize(d.width, d.height);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public G2dPropertiesDlg(String title) {
        this();
        this.setTitle(title);
    }

    public G2dPropertiesDlg() {
        this((Frame)null, false, new DefaultJPanel[]{new G2dLinePropertiesPanel()});
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        G2dPatternPropertiesPanel panel = new G2dPatternPropertiesPanel();
        G2dGridPropertiesPanel panel2 = new G2dGridPropertiesPanel();
        new G2dPropertiesDlg((Frame)null, true, "Test Properties Dialog", new DefaultJPanel[]{panel, panel2}).setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.getParent());
        } else {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.listenerList.remove((Class)listeners[i], (ActionListener)listeners[i + 1]);
            }
        }
        super.setVisible(b);
    }

    void G2dPropertiesDlg_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    @Override
    public void buttonCmdActionPerformed(ActionEvent event) {
        if (event.getID() == 8) {
            this.buttonOkActionPerformed();
        } else if (event.getID() == 4) {
            this.buttonCancelActionPerformed();
        } else if (event.getID() == 2) {
            this.buttonApplyActionPerformed();
        }
    }

    private void buttonApplyActionPerformed() {
        if (this._panels == null) {
            return;
        }
        boolean success = true;
        for (int i = 0; i < this._panels.length; ++i) {
            success &= this._panels[i].savePanel();
        }
        if (!success) {
            return;
        }
        this.setModified(false);
        this.fireActionPerformed(APPLY_BUTTON_ACTION);
    }

    private void buttonOkActionPerformed() {
        if (this._panels == null) {
            return;
        }
        boolean success = true;
        for (int i = 0; i < this._panels.length; ++i) {
            success &= this._panels[i].savePanel();
        }
        if (!success) {
            return;
        }
        this._canceled = false;
        this.fireActionPerformed(OK_BUTTON_ACTION);
        this.setVisible(false);
        this.dispose();
    }

    private void buttonCancelActionPerformed() {
        this._canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public synchronized void addOKListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeOKListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(int actionId) {
        Object[] listeners = this.listenerList.getListenerList();
        Object e = null;
        ActionEvent event = new ActionEvent(this, actionId, "Button OK/Apply Pressed");
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public void setSelectedTabIndex(int idx) {
        if (idx < 0 || this._tabPane == null) {
            return;
        }
        if (idx >= this._tabPane.getTabCount()) {
            return;
        }
        this._tabPane.setSelectedIndex(idx);
    }

    public void setTabEnabled(int tabindex, boolean enabled) {
        this._tabPane.setEnabledAt(tabindex, enabled);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == G2dPropertiesDlg.this) {
                G2dPropertiesDlg.this.G2dPropertiesDlg_WindowClosing(event);
            }
        }
    }
}

