/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.ScaleProperties;
import hec.gfx2d.G2dAxisPropertiesPanel;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.ScalePropertiesPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class G2dScalePropertiesPanel
extends DefaultJPanel
implements ScalePropertiesPanel {
    protected ScaleProperties _properties = null;
    RmaJDecimalField minorUnitIntervalTxt = new RmaJDecimalField();
    RmaJDecimalField majorUnitIntervalTxt = new RmaJDecimalField();
    RmaJDecimalField maxAxisValueTxt = new RmaJDecimalField();
    RmaJDecimalField minAxisValueTxt = new RmaJDecimalField();
    RmaJDecimalField minViewValueTxt = new RmaJDecimalField();
    RmaJDecimalField maxViewValueTxt = new RmaJDecimalField();
    RmaJCheckBox jAutoMaxAxisValueCheck = new RmaJCheckBox("Maximum:");
    RmaJCheckBox jAutoMinAxisValueCheck = new RmaJCheckBox("Minimum:");
    RmaJCheckBox jAutoMajorTicCheckBox = new RmaJCheckBox("Major Tic Interval:");
    RmaJCheckBox jAutoMinorTicCheckBox = new RmaJCheckBox("Minor Tic Interval:");
    RmaJCheckBox jAutoMaxViewCheck = new RmaJCheckBox("View Maximum:");
    RmaJCheckBox jAutoMinViewCheck = new RmaJCheckBox("View Minimum:");
    RmaJCheckBox jReverseAxisCheck = new RmaJCheckBox("Reverse (Invert) Axis");
    RmaJCheckBox jSwitchAxisCheck = new RmaJCheckBox("Switch X and Y Axis");
    JLabel jAutoLabel = new JLabel("Auto");

    public G2dScalePropertiesPanel() {
        this.setLayout(new GridBagLayout());
        Insets ins = this.getInsets();
        this.setName("Scale");
        JPanel backPanel = new JPanel(new GridBagLayout());
        this.add((Component)backPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.insets(0, 0, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoMaxAxisValueCheck, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoMinAxisValueCheck, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoMaxViewCheck, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoMinViewCheck, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoMajorTicCheckBox, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 0, 0), 0, 0));
        backPanel.add((Component)this.jAutoMinorTicCheckBox, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 5, 0), 0, 0));
        backPanel.add((Component)this.jReverseAxisCheck, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 18, 0, RmaInsets.insets(5, 5, 5, 0), 0, 0));
        backPanel.add((Component)this.jSwitchAxisCheck, new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 18, 0, RmaInsets.insets(5, 5, 5, 0), 0, 0));
        backPanel.add((Component)this.maxAxisValueTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        backPanel.add((Component)this.minAxisValueTxt, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        backPanel.add((Component)this.maxViewValueTxt, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        backPanel.add((Component)this.minViewValueTxt, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        backPanel.add((Component)this.majorUnitIntervalTxt, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 0, 5), 0, 0));
        backPanel.add((Component)this.minorUnitIntervalTxt, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(5, 5, 5, 5), 0, 0));
        this.jAutoMaxAxisValueCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jAutoMinAxisValueCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jAutoMajorTicCheckBox.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jAutoMinorTicCheckBox.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jAutoMaxViewCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jAutoMinViewCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jReverseAxisCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jSwitchAxisCheck.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this.jAutoMaxAxisValueCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMaxAxisValueCheck, this.maxAxisValueTxt));
        this.jAutoMinAxisValueCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMinAxisValueCheck, this.minAxisValueTxt));
        this.jAutoMajorTicCheckBox.addActionListener(new TextFieldStateUpdater(this.jAutoMajorTicCheckBox, this.majorUnitIntervalTxt));
        this.jAutoMinorTicCheckBox.addActionListener(new TextFieldStateUpdater(this.jAutoMinorTicCheckBox, this.minorUnitIntervalTxt));
        this.jAutoMaxViewCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMaxViewCheck, this.maxViewValueTxt));
        this.jAutoMinViewCheck.addActionListener(new TextFieldStateUpdater(this.jAutoMinViewCheck, this.minViewValueTxt));
        Dimension d = this.getPreferredSize();
        this.setSize(d);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            this.clearPanel();
            return;
        }
        this.majorUnitIntervalTxt.setValue(this._properties.getMajorTicInterval());
        this.minorUnitIntervalTxt.setValue(this._properties.getMinorTicInterval());
        this.maxAxisValueTxt.setValue(this._properties.getMaxScaleValue());
        this.minAxisValueTxt.setValue(this._properties.getMinScaleValue());
        this.maxViewValueTxt.setValue(this._properties.getActualMaxScaleValue());
        this.minViewValueTxt.setValue(this._properties.getActualMinScaleValue());
        this.jAutoMaxAxisValueCheck.setSelected(this._properties.isAutomaticMax());
        this.jAutoMinAxisValueCheck.setSelected(this._properties.isAutomaticMin());
        this.jAutoMinViewCheck.setSelected(this._properties.isAutomaticViewMin());
        this.jAutoMaxViewCheck.setSelected(this._properties.isAutomaticViewMax());
        this.jAutoMinorTicCheckBox.setSelected(this._properties.isAutoComputeMinorTics());
        this.jAutoMajorTicCheckBox.setSelected(this._properties.isAutoComputeMajorTics());
        this.maxAxisValueTxt.setEditable(!this._properties.isAutomaticMax());
        this.minAxisValueTxt.setEditable(!this._properties.isAutomaticMin());
        this.majorUnitIntervalTxt.setEditable(!this._properties.isAutoComputeMajorTics());
        this.minorUnitIntervalTxt.setEditable(!this._properties.isAutoComputeMinorTics());
        this.maxViewValueTxt.setEditable(!this._properties.isAutomaticViewMax());
        this.minViewValueTxt.setEditable(!this._properties.isAutomaticViewMin());
        this.jReverseAxisCheck.setSelected(this._properties.isReversed());
        this.jSwitchAxisCheck.setEnabled(this._properties.canSwapXYAxis());
        this.jSwitchAxisCheck.setSelected(this._properties.swapXYAxis());
    }

    @Override
    public void refresh() {
        this.fillPanel();
    }

    public boolean validatePanel() {
        if (this.majorUnitIntervalTxt.getValue() == 0.0) {
            RMAIO.postError(this, "The major tic interval must be defined and greater than zero.");
            return false;
        }
        if (this.minorUnitIntervalTxt.getValue() > this.majorUnitIntervalTxt.getValue()) {
            RMAIO.postError(this, "The Minor Tic interval cannot be greater than the Major Tic interval.");
            return false;
        }
        if (this.minAxisValueTxt.getValue() > this.maxAxisValueTxt.getValue()) {
            // empty if block
        }
        if (this.maxViewValueTxt.getValue() < this.minViewValueTxt.getValue()) {
            // empty if block
        }
        return true;
    }

    @Override
    public boolean savePanel() {
        double temp;
        if (this._properties == null) {
            return true;
        }
        if (!this.validatePanel()) {
            return false;
        }
        this._properties.setAutomaticMax(this.jAutoMaxAxisValueCheck.isSelected());
        this._properties.setAutomaticMin(this.jAutoMinAxisValueCheck.isSelected());
        this._properties.setAutomaticViewMax(this.jAutoMaxViewCheck.isSelected());
        this._properties.setAutomaticViewMin(this.jAutoMinViewCheck.isSelected());
        this._properties.setAutoComputeMajorTics(this.jAutoMajorTicCheckBox.isSelected());
        this._properties.setAutoComputeMinorTics(this.jAutoMinorTicCheckBox.isSelected());
        double max = this.maxAxisValueTxt.getValue();
        double min = this.minAxisValueTxt.getValue();
        if (min > max) {
            temp = max;
            max = min;
            min = temp;
        }
        this._properties.setMaxScaleValue(max);
        this._properties.setMinScaleValue(min);
        max = this.maxViewValueTxt.getValue();
        min = this.minViewValueTxt.getValue();
        if (min > max) {
            temp = max;
            max = min;
            min = temp;
        }
        this._properties.setActualMaxScaleValue(max);
        this._properties.setActualMinScaleValue(min);
        this._properties.setMinorTicInterval(this.minorUnitIntervalTxt.getValue());
        this._properties.setMajorTicInterval(this.majorUnitIntervalTxt.getValue());
        this._properties.setMajorTicInterval(this.majorUnitIntervalTxt.getValue());
        this._properties.setMinorTicInterval(this.minorUnitIntervalTxt.getValue());
        this._properties.setReversed(this.jReverseAxisCheck.isSelected());
        this._properties.setSwapXYAxis(this.jSwitchAxisCheck.isSelected());
        return true;
    }

    @Override
    public void setData(ScaleProperties scale) {
        this._properties = scale;
    }

    @Override
    public ScaleProperties getData() {
        return this._properties;
    }

    public static void main(String[] args) {
        G2dPropertiesDlg dialog = new G2dPropertiesDlg((Frame)null, false, "", new DefaultJPanel[]{new G2dAxisPropertiesPanel(), new G2dScalePropertiesPanel()});
        dialog.setVisible(true);
    }

    public void clearPanel() {
        this.minorUnitIntervalTxt.clearPerformed();
        this.majorUnitIntervalTxt.clearPerformed();
        this.maxAxisValueTxt.clearPerformed();
        this.minAxisValueTxt.clearPerformed();
        this.minViewValueTxt.clearPerformed();
        this.maxViewValueTxt.clearPerformed();
    }

    private class TextFieldStateUpdater
    implements ActionListener {
        RmaJTextField m_textField = null;
        RmaJCheckBox m_checkBox = null;

        public TextFieldStateUpdater(RmaJCheckBox checkBox, RmaJTextField tf) {
            this.m_checkBox = checkBox;
            this.m_textField = tf;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_textField.setEditable(!this.m_checkBox.isSelected());
        }
    }
}

