/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Axis;
import hec.geometry.LocalPt;
import hec.gfx2d.AxisTics;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dFont;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPointerComponent;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.G2dResolutionConst;
import hec.gfx2d.G2dSpacerPropertiesPanel;
import hec.gfx2d.PreferredSizeProvider;
import hec.gfx2d.TSAxisTics;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJMenuLabel;

public class G2dSpacer
extends G2dComponent
implements G2dPointerComponent {
    Axis _axis = null;
    int m_pixelSpacing = -1;
    private static final String PROPERTIES_DLG_TITLE = "Edit Spacer Properties";

    public G2dSpacer(G2dPanel p, Axis ax, int align) {
        this._parent = p;
        this._axis = ax;
        this._alignment = align;
        this.setOpaque(false);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (Boolean.getBoolean("DEBUG_PLOT_BOUNDS")) {
            Color c2 = g.getColor();
            g.setColor(Color.red);
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
            g.setColor(c2);
        }
    }

    public int getPixelSpacing() {
        if (this.m_pixelSpacing < 0) {
            Dimension d = this.getPreferredSize();
            if (this._alignment == 0 || this._alignment == 1) {
                return d.width;
            }
            return d.height;
        }
        return this.m_pixelSpacing;
    }

    public void setPixelSpacing(int spacing) {
        this.m_pixelSpacing = spacing;
        this._preferredSizeProvider = new PixelSizePrefferedSizeProvider(this.m_pixelSpacing);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setPreferredSizeProvider(PreferredSizeProvider provider) {
        this._preferredSizeProvider = provider != null ? provider : new G2dComponent.DefaultPreferredSizeProvider();
    }

    @Override
    public Dimension getPreferredSizeLocal() {
        int g2dResolution;
        double scl;
        Dimension defaultDim = super.getPreferredSizeLocal();
        Dimension dim = new Dimension(defaultDim);
        Graphics g = this.getGraphics();
        if (g == null) {
            return dim;
        }
        Font font = g.getFont();
        int sz = (int)(11.0 * this._parent.getFontScl() + 0.5);
        if ((double)sz < 9.0 * (scl = (double)((g2dResolution = this._parent.getDeviceResoultion()) / G2dResolutionConst.PRINTER_SCALE))) {
            sz = (int)(9.0 * scl);
        }
        if ((double)sz > 16.0 * scl) {
            sz = (int)(16.0 * scl);
        }
        String name = font.getName();
        String fn = name + "-PLAIN-" + Integer.toString(sz);
        font = G2dFont.newFont(name, 0, sz);
        if (font != null) {
            g.setFont(font);
        }
        int space = 2;
        FontMetrics metrics = g.getFontMetrics();
        DecimalFormat df = new DecimalFormat();
        if (this._axis != null) {
            df.setMaximumFractionDigits(this._axis.getSigFig());
            df.setMinimumFractionDigits(this._axis.getSigFig());
        }
        if (this._alignment == 0 || this._alignment == 1) {
            dim.height = 25;
            AxisTics tics = this._parent.getAxisTics(0);
            if (tics instanceof TSAxisTics) {
                dim.width = 10;
            } else if (tics != null && tics.isVisible() && tics.getProperties().showTicLabels()) {
                if (this._axis != null) {
                    String xtxt = df.format(this._axis.getActMax());
                    dim.width = metrics.stringWidth(xtxt) * 2 / 3;
                } else {
                    dim.width = 0;
                }
            }
        } else {
            dim.width = 25;
            dim.height = metrics.getHeight() * 2 / 3;
        }
        return dim;
    }

    @Override
    public void createPopupMenu() {
        this._popupMenu = new JPopupMenu();
        RmaJMenuLabel label = new RmaJMenuLabel("Spacer");
        Font f = label.getFont();
        f = new Font(f.getName(), 2, f.getSize());
        label.setFont(f);
        this._popupMenu.add(label);
        this._popupMenu.addSeparator();
        JMenuItem menuItem = new JMenuItem("Edit Properties");
        this._popupMenu.add(menuItem);
        menuItem.addActionListener(new G2dComponent.EditPropertyListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editProperties() {
        Window w = SwingUtilities.windowForComponent(this);
        Cursor oldCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            G2dPropertiesDlg dlg = null;
            G2dSpacerPropertiesPanel panel1 = new G2dSpacerPropertiesPanel();
            panel1.setData(this);
            dlg = w instanceof Dialog ? new G2dPropertiesDlg((Dialog)w, false, PROPERTIES_DLG_TITLE, new DefaultJPanel[]{panel1}) : new G2dPropertiesDlg((Frame)w, false, PROPERTIES_DLG_TITLE, new DefaultJPanel[]{panel1});
            if (dlg == null) {
                return;
            }
            dlg.setTitle(PROPERTIES_DLG_TITLE);
            dlg.addOKListener(new PropertiesOKListener());
            dlg.setVisible(true);
        }
        finally {
            this.setCursor(oldCursor);
        }
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        Rectangle rect = this.getBounds();
        if (!rect.contains(new Point(pt.x, pt.y))) {
            return false;
        }
        this._popupMenu.show(this, pt.x - rect.x, pt.y - rect.y);
        return true;
    }

    @Override
    public void pointerOver(LocalPt pt) {
    }

    @Override
    public boolean objectSelect(LocalPt pt, int modifiers) {
        return false;
    }

    private class PixelSizePrefferedSizeProvider
    implements PreferredSizeProvider {
        int pixelSpacing = -1;

        public PixelSizePrefferedSizeProvider(int pixelSpacing) {
            this.pixelSpacing = pixelSpacing;
        }

        @Override
        public Dimension getPreferredSize() {
            LayoutManager layout = G2dSpacer.this.getLayout();
            Dimension defaultDim = layout != null ? layout.preferredLayoutSize(G2dSpacer.this) : new Dimension(0, 0);
            Dimension dim = new Dimension(defaultDim);
            if (G2dSpacer.this._alignment == 0 || G2dSpacer.this._alignment == 1) {
                dim.width = this.pixelSpacing;
            } else {
                dim.height = this.pixelSpacing;
            }
            return dim;
        }
    }

    class PropertiesOKListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Container c2 = G2dSpacer.this.getParent();
            c2.invalidate();
            c2.validate();
            c2.repaint();
        }
    }
}

