/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.tx.QualityTx;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.Gfx2dDrawUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.Vector;
import rma.swing.DefaultJPanel;
import rma.util.RMAConst;

public class G2dTimeSeriesLine
extends G2dLine {
    private Vector m_placeHolderDataPoints = new Vector();
    private Vector m_missingDataPoints = new Vector();
    private Vector m_rejectedDataPoints = new Vector();
    private Vector m_questionableDataPoints = new Vector();
    long[] m_baseXData = null;
    double[] m_baseYData = null;
    int[] m_baseQuality = null;
    boolean m_interpolate = false;

    public G2dTimeSeriesLine() {
        this._properties._enableQualityDataPts = true;
        this._clipToBounds = true;
    }

    @Override
    protected void createPopupMenu() {
        super.createPopupMenu();
    }

    public void setInterpolateMissing(boolean interpolate) {
        this._properties._interpolateMissing = interpolate;
    }

    @Override
    public void setProperties(G2dLineProperties prop) {
        super.setProperties(prop);
        if (prop != null) {
            this._properties._enableQualityDataPts = true;
        }
    }

    public void setRawTimeSeriesData(int[] xdata, double[] ydata, int[] qualityFlags) {
        long[] lxdata = new long[xdata.length];
        for (int i = 0; i < lxdata.length; ++i) {
            lxdata[i] = xdata[i];
        }
        this.setRawTimeSeriesData(lxdata, ydata, qualityFlags);
    }

    public void setRawTimeSeriesData(long[] xdata, double[] ydata, int[] qualityFlags) {
        long t1 = System.currentTimeMillis();
        if (xdata == null || ydata == null) {
            return;
        }
        if (xdata.length != ydata.length) {
            throw new IllegalArgumentException("X/Y Data Arrays are not the same length");
        }
        if (Boolean.getBoolean("DEBUG") && (qualityFlags == null || qualityFlags.length < 1)) {
            System.out.println("=================================================================");
            System.out.println(" Quality Flags passed to setRawTimeSeriesData() is null or empty ");
            System.out.println("=================================================================");
        }
        this.m_baseXData = xdata;
        this.m_baseYData = ydata;
        this.m_baseQuality = qualityFlags;
        this.m_interpolate = this._properties._interpolateMissing;
        this.clearLineData();
        int ilen = xdata.length;
        int istart = 0;
        int number = 0;
        double[] xarray = new double[10000];
        double[] yarray = new double[10000];
        byte[] byteValue = new byte[4];
        int pValidIndex = -1;
        int nValidIndex = -1;
        boolean missingDataSegemnt = false;
        for (int i = istart; i < ilen; ++i) {
            double dx = xdata[i];
            double dy = ydata[i];
            if (i < pValidIndex || i >= nValidIndex) {
                pValidIndex = -1;
                nValidIndex = -1;
            }
            if (!(RMAConst.isValidValue(dy) || qualityFlags != null && i < qualityFlags.length && qualityFlags[i] != 0)) {
                if (number > 0 && !this._properties.getInterpolateMissing()) {
                    if (missingDataSegemnt) {
                        super.addLineSegment(xarray, yarray, number);
                    } else {
                        super.addLineData(xarray, yarray, number);
                    }
                    missingDataSegemnt = true;
                    number = 0;
                }
                if (number >= xarray.length) {
                    super.addLineData(xarray, yarray, number);
                    number = 0;
                }
                if (pValidIndex == -1 || nValidIndex == -1) {
                    pValidIndex = this.findPreviousValidIndex(ydata, i - 1);
                    nValidIndex = this.findNextValidIndex(ydata, i + 1);
                }
                dy = this.findInterpolatedPoint(xdata, ydata, i, pValidIndex, nValidIndex);
                if (RMAConst.isValidValue(dx) && RMAConst.isValidValue(dy)) {
                    this.m_placeHolderDataPoints.add(new WorldPt(dx, dy));
                }
            } else {
                if (!RMAConst.isValidValue(dy)) {
                    if (pValidIndex == -1 || nValidIndex == -1) {
                        pValidIndex = this.findPreviousValidIndex(ydata, i - 1);
                        nValidIndex = this.findNextValidIndex(ydata, i + 1);
                    }
                    if (!RMAConst.isValidValue(dy = this.findInterpolatedPoint(xdata, ydata, i, pValidIndex, nValidIndex))) continue;
                    if (number > 0 && !this._properties.getInterpolateMissing()) {
                        if (missingDataSegemnt) {
                            super.addLineSegment(xarray, yarray, number);
                        } else {
                            super.addLineData(xarray, yarray, number);
                        }
                        missingDataSegemnt = true;
                        number = 0;
                    }
                } else {
                    xarray[number] = dx;
                    yarray[number] = dy;
                    ++number;
                }
                if (qualityFlags != null && qualityFlags.length > i) {
                    try {
                        QualityTx.getBytes(qualityFlags[i], byteValue);
                        if (QualityTx.isMissing(byteValue)) {
                            this.m_missingDataPoints.add(new WorldPt(dx, dy));
                        } else if (QualityTx.isReject(byteValue)) {
                            this.m_rejectedDataPoints.add(new WorldPt(dx, dy));
                        } else if (QualityTx.isQuestion(byteValue)) {
                            this.m_questionableDataPoints.add(new WorldPt(dx, dy));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (number < 10000) continue;
            if (missingDataSegemnt) {
                this.addLineSegment(xarray, yarray, number);
                missingDataSegemnt = true;
            } else {
                this.addLineData(xarray, yarray, number);
            }
            number = 0;
        }
        if (number > 0) {
            if (missingDataSegemnt) {
                this.addLineSegment(xarray, yarray, number);
            } else {
                this.addLineData(xarray, yarray, number);
            }
        }
    }

    private double findInterpolatedPoint(long[] xdata, double[] ydata, int i) {
        int pvalidIndex = this.findPreviousValidIndex(ydata, i - 1);
        int nvalidIndex = this.findNextValidIndex(ydata, i + 1);
        return this.findInterpolatedPoint(xdata, ydata, i, pvalidIndex, nvalidIndex);
    }

    private double findInterpolatedPoint(long[] xdata, double[] ydata, int currentIndex, int prevGoodIndex, int nextGoodIndex) {
        double y2;
        double dx = xdata[currentIndex];
        double dy = -3.4028234663852886E38;
        double y1 = prevGoodIndex > -1 && prevGoodIndex < ydata.length ? ydata[prevGoodIndex] : -3.4028234663852886E38;
        double x1 = prevGoodIndex > -1 && prevGoodIndex < xdata.length ? (double)xdata[prevGoodIndex] : -3.4028234663852886E38;
        double x2 = nextGoodIndex > -1 && nextGoodIndex < xdata.length ? (double)xdata[nextGoodIndex] : -3.4028234663852886E38;
        double d = y2 = nextGoodIndex > -1 && nextGoodIndex < ydata.length ? ydata[nextGoodIndex] : -3.4028234663852886E38;
        if (RMAConst.isValidValue(y2) && RMAConst.isValidValue(x2) && RMAConst.isValidValue(y1) && RMAConst.isValidValue(x1)) {
            dy = this.interpolate(x1, x2, y1, y2, dx);
        }
        return dy;
    }

    @Override
    public void clearLineData() {
        super.clearLineData();
        this.m_placeHolderDataPoints.removeAllElements();
        this.m_rejectedDataPoints.removeAllElements();
        this.m_questionableDataPoints.removeAllElements();
        this.m_missingDataPoints.removeAllElements();
    }

    private double interpolate(double x1, double x2, double y1, double y2, double dx) {
        return y1 + (y2 - y1) * ((dx - x1) / (x2 - x1));
    }

    private int findNextValidIndex(double[] values, int start) {
        if (values == null || start < 0) {
            return -1;
        }
        for (int i = start; i < values.length; ++i) {
            if (!RMAConst.isValidValue(values[i])) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private int findPreviousValidIndex(double[] values, int start) {
        if (values == null || start >= values.length) {
            return -1;
        }
        for (int i = start; i >= 0; --i) {
            if (!RMAConst.isValidValue(values[i])) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void drawLine(Graphics g, Rectangle clipRect) {
        Color lineColor;
        Color fillColor;
        float symbolSize;
        int symbolType;
        if (this.m_interpolate != this._properties.getInterpolateMissing()) {
            this.setRawTimeSeriesData(this.m_baseXData, this.m_baseYData, this.m_baseQuality);
        }
        super.drawLine(g, clipRect);
        if (this._properties._drawMissingData) {
            symbolType = this._properties._placeholderSymbolType;
            symbolSize = this._properties._placeholderSymbolSize;
            fillColor = this._properties._placeholderPointFillColor;
            lineColor = this._properties._placeholderPointLineColor;
            this.drawPoints(g, clipRect, this.m_placeHolderDataPoints, symbolType, symbolSize, fillColor, lineColor);
        }
        if (this._properties._drawQualityData) {
            symbolType = this._properties._missingSymbolType;
            symbolSize = this._properties._missingSymbolSize;
            fillColor = this._properties._missingPointFillColor;
            lineColor = this._properties._missingPointLineColor;
            this.drawPoints(g, clipRect, this.m_missingDataPoints, symbolType, symbolSize, fillColor, lineColor);
            symbolType = this._properties._questionableSymbolType;
            symbolSize = this._properties._questionableSymbolSize;
            fillColor = this._properties._questionablePointFillColor;
            lineColor = this._properties._questionablePointLineColor;
            this.drawPoints(g, clipRect, this.m_questionableDataPoints, symbolType, symbolSize, fillColor, lineColor);
            symbolType = this._properties._rejectedSymbolType;
            symbolSize = this._properties._rejectedSymbolSize;
            fillColor = this._properties._rejectedPointFillColor;
            lineColor = this._properties._rejectedPointLineColor;
            this.drawPoints(g, clipRect, this.m_rejectedDataPoints, symbolType, symbolSize, fillColor, lineColor);
        }
    }

    private void drawPoints(Graphics g, Rectangle clipRect, Vector points, int symbolType, float symbolSize, Color fillColor, Color lineColor) {
        int missingSize = points.size();
        if (missingSize < 1) {
            return;
        }
        int[] localX = new int[missingSize];
        int[] localY = new int[missingSize];
        Shape oldClip = g.getClip();
        g.setClip(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        boolean[] clipped = new boolean[missingSize];
        Arrays.fill(clipped, false);
        for (int i = 0; i < missingSize; ++i) {
            WorldPt wpt = (WorldPt)points.elementAt(i);
            localX[i] = this._scale.e2x(wpt.e);
            localY[i] = this._scale.n2y(wpt.n);
            clipped[i] = clipRect.contains(localX[i], localY[i]);
        }
        Gfx2dDrawUtil.drawPoints(g, localX, localY, missingSize, clipped, symbolType, lineColor, fillColor, symbolSize, this.getProperties().getAutoSkipPoints(), 0, 0);
        g.setClip(oldClip);
    }

    @Override
    protected DefaultJPanel[] buildPropertiesPanel() {
        DefaultJPanel[] panels = super.buildPropertiesPanel();
        return panels;
    }

    public static void main(String[] args) {
        int i1 = -1;
        int i2 = i1 >> 8;
        int i3 = i1 >>> 8;
        int i4 = i1 >>> 16;
        int i5 = i1 >>> 24;
        int i6 = i1 >>> 31;
        int i7 = i1 >>> 32;
        System.out.println("DONE");
    }
}

