/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dLabel;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.G2dTitlePropertiesPanel;
import hec.gfx2d.TitleDrawProp;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observer;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJMenuLabel;

public class G2dTitle
extends G2dLabel
implements Observer {
    protected TitleDrawProp _drawProp = new TitleDrawProp();

    public G2dTitle(G2dPanel p) {
        super(p, 1, 0);
        this.setProperties(this._drawProp);
        this.setText(this._drawProp.text);
    }

    public G2dTitle(G2dPanel p, int align) {
        this(p);
        this._drawProp.align = align;
    }

    public G2dTitle(G2dPanel p, int align, int rot) {
        this(p, align);
        this._drawProp.rotation = rot;
    }

    @Override
    public Dimension getPreferredSizeLocal() {
        Dimension d = super.getPreferredSizeLocal();
        if (!this.isTitleDrawn() || this.getText() == null || this.getText().equals("")) {
            d.height = 10;
        }
        return d;
    }

    @Override
    public void createPopupMenu() {
        this._popupMenu = new JPopupMenu("Label Properties");
        RmaJMenuLabel label = new RmaJMenuLabel("Title");
        this._popupMenu.add(label);
        this._popupMenu.addSeparator();
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.setName("EDIT_PROPERTIES");
        jm.addActionListener(new G2dComponent.EditPropertyListener());
        this._popupMenu.add(jm);
        this._popupMenu.add(jm);
    }

    @Override
    public void editProperties() {
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        G2dTitlePropertiesPanel titlePanel = new G2dTitlePropertiesPanel();
        this._drawProp.text = this.getText();
        titlePanel.setData(this._drawProp);
        G2dPropertiesDlg dlg = null;
        PropertiesOKListener listener = new PropertiesOKListener();
        Window w = SwingUtilities.windowForComponent(this);
        dlg = w instanceof Dialog ? new G2dPropertiesDlg((Dialog)w, false, "Edit Title Properties", new DefaultJPanel[]{titlePanel}) : new G2dPropertiesDlg((Frame)w, false, "Edit Title Properties", new DefaultJPanel[]{titlePanel});
        if (dlg == null) {
            return;
        }
        dlg.addOKListener(listener);
        this.setCursor(oldCursor);
        dlg.setVisible(true);
    }

    public void setProperties(TitleDrawProp prop) {
        if (prop == null) {
            return;
        }
        this._drawProp = prop;
        super.setProperties(prop);
        this.setText(prop.text, "\n");
    }

    public TitleDrawProp getTitleProperties() {
        return this._drawProp;
    }

    @Override
    Dimension getTextSize(Graphics g) {
        int numLines;
        FontMetrics metrics = g.getFontMetrics();
        Dimension linedim = this.getMaxTextLineSize(metrics);
        Dimension dim = new Dimension();
        int n = numLines = this._text == null || this._text.length == 0 || !this._drawProp.drawTitle ? 1 : this._text.length;
        if (this._drawProp.rotation == 90 || this._drawProp.rotation == 270) {
            dim.width = numLines * linedim.width + 2 * this._drawProp.space;
            dim.height = linedim.height + 2 * this._drawProp.space;
        } else {
            dim.width = linedim.width + 2 * this._drawProp.space;
            dim.height = numLines * linedim.height + 2 * this._drawProp.space;
        }
        return dim;
    }

    public void setDrawTitleOn() {
        this._drawProp.setDrawTitle(true);
    }

    public void setDrawTitleOff() {
        this._drawProp.setDrawTitle(false);
    }

    public boolean isTitleDrawn() {
        return this._drawProp.getDrawTitle();
    }

    @Override
    public void paintGfx(Graphics g) {
        if (this._drawProp.getDrawTitle()) {
            super.paintGfx(g);
        }
        if (Boolean.getBoolean("DEBUG_PLOT_BOUNDS")) {
            Color c2 = g.getColor();
            g.setColor(Color.orange);
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
            g.setColor(c2);
        }
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (G2dTitle.this._drawProp.drawTitle) {
                G2dTitle.this.setText(G2dTitle.this._drawProp.text);
            }
            G2dTitle.this.revalidate();
            G2dTitle.this.repaint();
            G2dTitle.this._parent.revalidate();
            G2dTitle.this._parent.repaint();
        }
    }
}

