/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.LabelLayoutConstants;
import hec.gfx2d.LabelPropertiesPanel;
import hec.gfx2d.TitleDrawProp;
import hec.gfx2d.components.CheckBoxPanel;
import hec.gfx2d.components.ComponentPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;

public class G2dTitlePropertiesPanel
extends LabelPropertiesPanel
implements LabelLayoutConstants,
ComponentPanel {
    private CheckBoxPanel _showLabelPanel;
    private JSeparator _topSep;
    private TitleDrawProp _titleProperties;
    private JPanel _alignPanel;
    private RmaJComboBox _alignCombo;

    public G2dTitlePropertiesPanel() {
        this.addListeners();
    }

    @Override
    protected void buildControls() {
        super.buildControls();
        this.setName("Title");
        this._showLabelPanel = new CheckBoxPanel("Show Plot Title");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._showLabelPanel, gbc);
        this._topSep = new JSeparator();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._topSep, gbc);
        this._alignPanel = new EnabledJPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._alignPanel, gbc);
        JLabel label = new JLabel("Alignment:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._alignPanel.add((Component)label, gbc);
        this._alignCombo = new RmaJComboBox<String>(LabelLayoutConstants.LABEL_ALIGN_NAMES);
        this._alignCombo.setModifiable(true);
        label.setLabelFor(this._alignCombo);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._alignPanel.add((Component)this._alignCombo, gbc);
        this.setAllLabelsCheckVisible(false);
    }

    @Override
    protected void addListeners() {
        this._showLabelPanel.addComponentPanel(this);
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        super.setComponentsEnabled(enabled);
        this._alignPanel.setEnabled(enabled);
    }

    public void setData(TitleDrawProp props) {
        super.setData(props);
        this._titleProperties = props;
    }

    @Override
    public void fillPanel() {
        if (this._titleProperties == null) {
            return;
        }
        super.fillPanel();
        this._showLabelPanel.setSelected(this._titleProperties.getDrawTitle());
        int alignment = this._titleProperties.getLabelAlignment();
        if (alignment == 1) {
            this._alignCombo.setSelectedItem("Center");
        } else if (alignment == 2) {
            this._alignCombo.setSelectedItem("Right");
        } else if (alignment == 0) {
            this._alignCombo.setSelectedItem("Left");
        }
    }

    @Override
    public boolean savePanel() {
        super.savePanel();
        this._titleProperties.setDrawTitle(this._showLabelPanel.isSelected());
        int alignment = 1;
        Object value = this._alignCombo.getSelectedItem();
        if (value != null) {
            String str = value.toString();
            if ("Center".equalsIgnoreCase(str)) {
                alignment = 1;
            } else if ("Right".equalsIgnoreCase(str)) {
                alignment = 2;
            } else if ("Left".equalsIgnoreCase(str)) {
                alignment = 0;
            }
        }
        this._titleProperties.setLabelAlignment(alignment);
        return true;
    }

    @Override
    public TitleDrawProp getProperties() {
        return this._titleProperties;
    }
}

