/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dPolygonProperties;
import hec.gfx2d.PropertiesSerializer;
import hec.io.AsciiSerializable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.util.Vector;
import rma.util.RMAIO;

public class G2dVerifyGlyphDrawProp
implements AsciiSerializable {
    private static final int DEFAULT_FONT_SIZE = 10;
    private static final int DEFAULT_TINY_FONT_SIZE = 6;
    private static final int DEFAULT_MIN_FONT_SIZE = 8;
    private static final int DEFAULT_MAX_FONT_SIZE = 16;
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final int DEFAULT_SPACE = 2;
    private static final String DEFAULT_FFAMILY_STYLE = null;
    public int fontSize = 10;
    public int tinyFontSize = 6;
    public int minFontSize = 8;
    public int maxFontSize = 16;
    public int fontStyle = 0;
    public String fontFamily = DEFAULT_FFAMILY_STYLE;
    public int space = 2;
    public G2dLineProperties lineProperties = new G2dLineProperties();
    public G2dPolygonProperties polygonProperties = new G2dPolygonProperties();
    public Vector lineMarkerProperties = new Vector();

    public G2dVerifyGlyphDrawProp() {
    }

    public G2dVerifyGlyphDrawProp(G2dVerifyGlyphDrawProp dp) {
        this.set(dp);
    }

    public void writeProperties(BufferedWriter writer, String endTag) {
        if (writer == null) {
            return;
        }
        PropertiesSerializer.incrementRecursion();
        String indent = PropertiesSerializer.getIndent();
        if (this.fontSize != 10) {
            RMAIO.fout(writer, indent + "fontSize=" + this.fontSize);
        }
        if (this.tinyFontSize != 6) {
            RMAIO.fout(writer, indent + "tinyFontSize=" + this.tinyFontSize);
        }
        if (this.minFontSize != 8) {
            RMAIO.fout(writer, indent + "minFontSize=" + this.minFontSize);
        }
        if (this.maxFontSize != 16) {
            RMAIO.fout(writer, indent + "maxFontSize=" + this.maxFontSize);
        }
        if (this.fontStyle != 0) {
            RMAIO.fout(writer, indent + "fontStyle=" + this.fontStyle);
        }
        if (this.fontFamily != DEFAULT_FFAMILY_STYLE) {
            RMAIO.fout(writer, indent + "fontFamily=" + this.fontFamily);
        }
        if (this.space != 2) {
            RMAIO.fout(writer, indent + "space=" + this.space);
        }
        RMAIO.fout(writer, indent + "Line Begin");
        this.lineProperties.writeProperties(writer, "Line End");
        RMAIO.fout(writer, indent + "Polygon Begin");
        this.polygonProperties.writeProperties(writer, "Polygon End");
        for (int i = 0; i < this.lineMarkerProperties.size(); ++i) {
            RMAIO.fout(writer, indent + "Marker Begin");
            ((G2dMarkerProperties)this.lineMarkerProperties.elementAt(i)).writeProperties(writer, "Marker End");
        }
        PropertiesSerializer.decrementRecursion();
        indent = PropertiesSerializer.getIndent();
        RMAIO.fout(writer, indent + endTag);
    }

    public void readProperties(BufferedReader in, String endTag) {
        if (in == null) {
            return;
        }
        String line = "";
        String param = "";
        String type = "";
        try {
            while ((line = in.readLine()) != null) {
                line.trim();
                param = RMAIO.getParam(line, "=");
                type = RMAIO.getType(line, "=");
                if (!type.equalsIgnoreCase(endTag)) {
                    if (type.equalsIgnoreCase("fontSize")) {
                        this.fontSize = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("tinyFontSize")) {
                        this.tinyFontSize = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("minFontSize")) {
                        this.minFontSize = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("maxFontSize")) {
                        this.maxFontSize = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("fontStyle")) {
                        this.fontStyle = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("fontFamily")) {
                        this.fontFamily = param;
                    }
                    if (type.equalsIgnoreCase("space")) {
                        this.space = Integer.valueOf(param);
                    }
                    if (type.equalsIgnoreCase("Line Begin")) {
                        this.lineProperties.readProperties(in, "Line End");
                    }
                    if (type.equalsIgnoreCase("Polygon Begin")) {
                        this.polygonProperties.readProperties(in, "Polygon End");
                    }
                    if (!type.equalsIgnoreCase("Marker Begin")) continue;
                    G2dMarkerProperties mp = new G2dMarkerProperties();
                    mp.readProperties(in, "Marker End");
                    this.lineMarkerProperties.addElement(mp);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error in readProperties(BufferedReader)");
            return;
        }
    }

    public Object clone() {
        return new G2dVerifyGlyphDrawProp(this);
    }

    public void set(G2dVerifyGlyphDrawProp dp) {
        this.fontSize = dp.fontSize;
        this.tinyFontSize = dp.tinyFontSize;
        this.minFontSize = dp.minFontSize;
        this.maxFontSize = dp.maxFontSize;
        this.fontStyle = dp.fontStyle;
        this.fontFamily = dp.fontFamily;
        this.space = dp.space;
        this.polygonProperties = dp.polygonProperties;
        this.lineProperties = dp.lineProperties;
        this.lineMarkerProperties = (Vector)dp.lineMarkerProperties.clone();
    }

    public void addLineMarkerProperties(G2dMarkerProperties prop) {
        if (prop == null) {
            return;
        }
        this.lineMarkerProperties.addElement(prop);
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

