/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.ViewportLayer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;

public class G2dViewportLayerLocationPanel
extends DefaultJPanel {
    private static final long serialVersionUID = 8867544948078792456L;
    private ViewportLayer.Location _originalLocation;
    private ViewportLayer.Location _location;
    private JLabel _label;
    private JComboBox<ViewportLayer.Location> _comboBox;

    public G2dViewportLayerLocationPanel() {
        this.setName("Location");
        this.buildComponents();
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        this._label = new JLabel("Pick Location:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._label, gbc);
        this._comboBox = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add(this._comboBox, gbc);
        for (ViewportLayer.Location location : ViewportLayer.Location.values()) {
            this._comboBox.addItem(location);
        }
        this._comboBox.addItemListener(e -> this.setModified(true));
    }

    @Override
    public void fillPanel() {
        if (this._location != null) {
            this._comboBox.setSelectedItem((Object)this._location);
        }
    }

    @Override
    public void undoEdits() {
        this._location = this._originalLocation;
        this.fillPanel();
    }

    public void setViewportLocation(ViewportLayer.Location location) {
        this._originalLocation = location;
        this._location = location;
        this.fillPanel();
    }

    public ViewportLayer.Location getViewportLocation() {
        this._location = (ViewportLayer.Location)((Object)this._comboBox.getSelectedItem());
        return this._location;
    }
}

