/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dBackgroundPropertiesPanel;
import hec.gfx2d.G2dGridPropertiesPanel;
import hec.gfx2d.SimpleLinePropertiesPanel;
import hec.gfx2d.ViewportDrawProp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;

public class G2dViewportPropertiesPanel
extends DefaultJPanel {
    private G2dGridPropertiesPanel _gridPanel;
    private SimpleLinePropertiesPanel _borderPanel;
    private G2dBackgroundPropertiesPanel _backgroundPanel;
    private ViewportDrawProp _properties;

    public G2dViewportPropertiesPanel() {
        super(new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this._gridPanel = new G2dGridPropertiesPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._gridPanel, gbc);
        this._borderPanel = new SimpleLinePropertiesPanel();
        this._borderPanel.setBorder(BorderFactory.createTitledBorder("Border"));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._borderPanel, gbc);
        this._backgroundPanel = new G2dBackgroundPropertiesPanel();
        this._backgroundPanel.setBorder(BorderFactory.createTitledBorder("Background"));
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._backgroundPanel, gbc);
    }

    protected void addListeners() {
    }

    public void setData(ViewportDrawProp vdp) {
        this._properties = vdp;
        this._gridPanel.setData(this._properties);
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        this._borderPanel.setCustomEnabled(this._properties.getDrawLine());
        this._borderPanel.setLineStyle(this._properties.getLineStyle());
        this._borderPanel.setLineWidth(this._properties.getLineWeight());
        this._borderPanel.setLineColor(this._properties.getLineColor());
        this._backgroundPanel.setBackgroundColor(this._properties.getBackgroundColor());
        this._backgroundPanel.setBackgroundFill(this._properties.getBackgroundFill());
        this._backgroundPanel.setCustomEnabled(this._properties.getDrawBackground());
        this._backgroundPanel.setAlpha(this._properties.getAlphaComposite());
        this._gridPanel.fillPanel();
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        this._properties.setDrawBackground(this._backgroundPanel.isCustomEnabled());
        this._properties.setBackgroundColor(this._backgroundPanel.getBackgroundColor());
        this._properties.setBackgroundFill(this._backgroundPanel.getBackgroundFill());
        this._properties.setLineColor(this._borderPanel.getLineColor());
        this._properties.setLineStyle(this._borderPanel.getLineStyle());
        this._properties.setLineWeight(this._borderPanel.getLineWidth());
        this._properties.setDrawLine(this._borderPanel.isCustomEnabled());
        this._properties.setAlphaComposite(this._backgroundPanel.getAlpha());
        return this._gridPanel.savePanel();
    }
}

