/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dBasicStroke;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dResolutionConst;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Stroke;
import rma.util.wmf.WMF;
import rma.util.wmf.WMFGraphics2D;

public class G2dWMFGraphics2D
extends WMFGraphics2D {
    private G2dPanel _gfxPanel;

    public G2dWMFGraphics2D(G2dPanel panel, WMF wmf, int width, int height) {
        this(panel, wmf, width, height, Color.black, Color.white);
    }

    public G2dWMFGraphics2D(G2dPanel panel, WMF wmf, int width, int height, Color fore, Color back) {
        super(wmf, width, height, fore, back);
        this._gfxPanel = panel;
    }

    protected G2dWMFGraphics2D(G2dWMFGraphics2D g) {
        super(g);
        this._gfxPanel = g._gfxPanel;
    }

    @Override
    public void setStroke(Stroke s) {
        if (s instanceof BasicStroke) {
            if (s instanceof G2dBasicStroke) {
                super.setStroke(s);
            } else {
                float[] dashArray = ((BasicStroke)s).getDashArray();
                int i = 0;
                while (dashArray != null && i < dashArray.length) {
                    int n = i++;
                    dashArray[n] = dashArray[n] * (float)(this._gfxPanel.getDeviceResoultion() / G2dResolutionConst.PRINTER_SCALE);
                }
                super.setStroke(new G2dBasicStroke(this._gfxPanel, (BasicStroke)s, dashArray));
            }
        } else {
            super.setStroke(s);
        }
    }

    @Override
    public Graphics create() {
        G2dWMFGraphics2D g = new G2dWMFGraphics2D(this);
        return g;
    }
}

