/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.geometry.LocalRect;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dMouseAdapter;
import hec.gfx2d.G2dZoomComponent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import rma.swing.RmaImage;

public class G2dZoomAdapter
extends G2dMouseAdapter {
    public static final String ZOOM_CURSOR = "ZoomCursor";
    boolean _zoomIn = false;
    boolean _drawDragRect = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalRect _dragRect = new LocalRect();
    LocalRect _oldDragRect = new LocalRect();
    protected Cursor _zoomCursor = null;
    WorldPt _wpt = new WorldPt();
    protected G2dZoomComponent zComp = null;

    public G2dZoomAdapter(G2dZoomComponent c2, JPanel canvas) {
        this.zComp = c2;
        Image zoomCursor = RmaImage.loadURLImage("Images/ZoomCursor.gif");
        if (zoomCursor != null) {
            this._zoomCursor = Toolkit.getDefaultToolkit().createCustomCursor(zoomCursor, new Point(5, 5), ZOOM_CURSOR);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._zoomIn) {
            this._endPt.init(e.getX(), e.getY());
            this._dragRect.init(this._beginPt, this._endPt);
            this._zoomIn = false;
            if (this._dragRect.width() < 3 || this._dragRect.height() < 3) {
                Graphics g = this.zComp.getGraphics();
                g.setXORMode(new Color(255, 255, 255));
                g.drawRect(this._oldDragRect.l, this._oldDragRect.t, this._oldDragRect.width(), this._oldDragRect.height());
                g.setPaintMode();
                g.dispose();
            } else if (this.zComp != null) {
                this.zComp.zoomIn(this._dragRect);
            }
        } else if (G2dZoomAdapter.pressedButton3(e)) {
            this._zoomIn = false;
            if (this.zComp != null) {
                this.zComp.zoomByFactor(2.0);
            }
        }
        this._drawDragRect = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (G2dZoomAdapter.pressedButton1(e)) {
            this._beginPt.init(e.getX(), e.getY());
            this._oldDragRect.initToPoint(this._beginPt);
            this._drawDragRect = true;
            this._zoomIn = true;
        } else if (G2dZoomAdapter.pressedButton3(e)) {
            this._zoomIn = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.zComp != null && this._zoomIn) {
            Graphics g = this.zComp.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            this._endPt.init(e.getX(), e.getY());
            this._dragRect.init(this._beginPt, this._endPt);
            g.drawRect(this._oldDragRect.l, this._oldDragRect.t, this._oldDragRect.width(), this._oldDragRect.height());
            g.drawRect(this._dragRect.l, this._dragRect.t, this._dragRect.width(), this._dragRect.height());
            g.setPaintMode();
            g.dispose();
            this._oldDragRect.init(this._dragRect);
        }
    }

    public void setCursorImage(Image zoomCursor) {
        if (zoomCursor != null) {
            this._zoomCursor = Toolkit.getDefaultToolkit().createCustomCursor(zoomCursor, new Point(5, 5), ZOOM_CURSOR);
        }
    }

    @Override
    public Cursor getCursor() {
        if (this._zoomCursor == null) {
            return super.getCursor();
        }
        return this._zoomCursor;
    }
}

