/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dFont;
import hec.gfx2d.G2dResolutionConst;
import hec.gfx2d.RotatedText;
import hec.gfx2d.Symbol;
import hec.heclib.util.intContainer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import rma.lang.RmaMath;
import rma.util.FillPatternFactory;

public class Gfx2dDrawUtil {
    private static final Color _defaultPointFillColor = Color.blue;
    private static final Color _defaultPointLineColor = Color.blue;
    private static final Color _defaultLineColor = Color.blue;
    private static final int _defaultSymbolType = 0;
    static final int MAX_JAVA_DRAW_SIZE = 750;
    public static int DEVICE_RESOLUTION = G2dResolutionConst.PRINTER_SCALE;
    static int[] JAVA_DRAW_XARRAY = new int[750];
    static int[] JAVA_DRAW_YARRAY = new int[750];

    public static void plotClippedLine(Graphics g, Rectangle rect, int x1, int y1, int x2, int y2) {
        intContainer x1temp = new intContainer(x1);
        intContainer y1temp = new intContainer(y1);
        intContainer x2temp = new intContainer(x2);
        intContainer y2temp = new intContainer(y2);
        boolean[] pt1Changed = new boolean[]{false};
        boolean[] pt2Changed = new boolean[]{false};
        boolean[] isVisible = new boolean[]{false};
        Gfx2dDrawUtil.plotClippedLine(rect, x1temp, y1temp, x2temp, y2temp, pt1Changed, pt2Changed, isVisible);
        if (isVisible[0]) {
            g.drawLine(x1temp.value, y1temp.value, x2temp.value, y2temp.value);
        }
    }

    private static void plotClippedLine(Rectangle rect, intContainer x1, intContainer y1, intContainer x2, intContainer y2, boolean[] pt1Changed, boolean[] pt2Changed, boolean[] lineVisible) {
        double deltay;
        double deltax = (double)x2.value - (double)x1.value;
        double[] t0 = new double[]{0.0};
        double[] t1 = new double[]{1.0};
        if (Gfx2dDrawUtil.plotClippedLine2(-deltax, (double)x1.value - (double)rect.x, t0, t1) && Gfx2dDrawUtil.plotClippedLine2(deltax, (double)(rect.x + rect.width) - (double)x1.value, t0, t1) && Gfx2dDrawUtil.plotClippedLine2(-(deltay = (double)(y2.value - y1.value)), (double)y1.value - (double)rect.y, t0, t1) && Gfx2dDrawUtil.plotClippedLine2(deltay, (double)(rect.y + rect.height) - (double)y1.value, t0, t1)) {
            if (t1[0] < 1.0) {
                x2.value = (int)((double)x1.value + t1[0] * deltax);
                y2.value = (int)((double)y1.value + t1[0] * deltay);
                pt2Changed[0] = true;
            }
            if (t0[0] > 0.0) {
                x1.value = (int)((double)x1.value + t0[0] * deltax);
                y1.value = (int)((double)y1.value + t0[0] * deltay);
                pt1Changed[0] = true;
            }
            lineVisible[0] = true;
        }
    }

    private static boolean plotClippedLine2(double p, double q, double[] t0, double[] t1) {
        boolean accept = true;
        double r = 0.0;
        if (p < 0.0) {
            r = q / p;
            if (r > t1[0]) {
                accept = false;
            } else if (r > t0[0]) {
                t0[0] = r;
            }
        } else if (p > 0.0) {
            r = q / p;
            if (r < t0[0]) {
                accept = false;
            } else if (r < t1[0]) {
                t1[0] = r;
            }
        } else if (q < 0.0) {
            accept = false;
        }
        return accept;
    }

    public static void plotPolyLineClipped(Graphics g, Rectangle rect, int[] xpoints, int[] ypoints, int numPts) {
        Gfx2dDrawUtil.plotPolyLineClipped(g, rect, xpoints, ypoints, numPts, true, false);
    }

    public static void plotPolyLineClipped(Graphics g, Rectangle rect, int[] xpoints, int[] ypoints, int numPts, boolean showPts) {
        Gfx2dDrawUtil.plotPolyLineClipped(g, rect, xpoints, ypoints, numPts, true, g.getColor(), 1.0f, showPts, 0, 7.0f, _defaultPointFillColor, _defaultPointLineColor);
    }

    public static void plotPolyLineClipped(Graphics g, Rectangle rect, int[] xpoints, int[] ypoints, int numPts, boolean showLine, boolean showPts) {
        Gfx2dDrawUtil.plotPolyLineClipped(g, rect, xpoints, ypoints, numPts, showLine, g.getColor(), 1.0f, showPts, 0, 7.0f, _defaultPointFillColor, _defaultPointLineColor);
    }

    public static void plotPolyLineClipped(Graphics g, Rectangle rect, int[] xpoints, int[] ypoints, int numPts, boolean showLine, Color lineColor, float lineWidth, boolean showPts, int symbolType, float symbolSize, Color sFillColor, Color sLineColor) {
        Gfx2dDrawUtil.plotPolyLineClipped(g, rect, xpoints, ypoints, numPts, showLine, lineColor, lineWidth, showPts, symbolType, symbolSize, sFillColor, sLineColor, 0, 0);
    }

    public static void plotPolyLineClipped(Graphics g, Rectangle rect, int[] xpoints, int[] ypoints, int numPts, boolean showLine, Color lineColor, float lineWidth, boolean showPts, int symbolType, float symbolSize, Color sFillColor, Color sLineColor, int offset, int skip) {
        Gfx2dDrawUtil.plotPolyLineClipped(g, rect, xpoints, ypoints, numPts, showLine, lineColor, lineWidth, showPts, symbolType, symbolSize, sFillColor, sLineColor, false, 0, 0, false, "", 1, 0, G2dFont.newFont("Dialog", 0, 10), Color.black);
    }

    public static void plotPolyLineClipped(Graphics g, Rectangle rect, int[] xpoints, int[] ypoints, int numPts, boolean showLine, Color lineColor, float lineWidth, boolean showPts, int symbolType, float symbolSize, Color sFillColor, Color sLineColor, boolean autoSkip, int offset, int skip, boolean drawLabel, String label, int labelAlign, int labelPosition, Font labelFont, Color labelColor) {
        intContainer x1 = new intContainer();
        intContainer x2 = new intContainer();
        intContainer y1 = new intContainer();
        intContainer y2 = new intContainer();
        boolean[] showXYSymbol = null;
        boolean[] visibleSymbols = null;
        if (showPts) {
            showXYSymbol = new boolean[numPts];
            visibleSymbols = new boolean[numPts];
            Gfx2dDrawUtil.computeVisibleSymbols(xpoints, ypoints, numPts, autoSkip, offset, skip, symbolSize, showXYSymbol);
        }
        int[] visibleXPoints = new int[numPts];
        int[] visibleYPoints = new int[numPts];
        int[] labelXPoints = null;
        int[] labelYPoints = null;
        int numLabelPoints = 0;
        boolean[] clippedPoint = new boolean[numPts];
        Arrays.fill(clippedPoint, false);
        int numVisiblePts = 0;
        int index = 0;
        boolean[] pt1Changed = new boolean[]{false};
        boolean[] pt2Changed = new boolean[]{false};
        boolean[] isVisible = new boolean[]{false};
        Color oldColor = g.getColor();
        Color sfColor = sFillColor == null ? _defaultPointFillColor : sFillColor;
        Color slColor = sLineColor == null ? _defaultPointLineColor : sLineColor;
        Color lColor = lineColor == null ? _defaultLineColor : lineColor;
        for (int i = 0; i < numPts - 1; ++i) {
            x1.value = xpoints[i];
            x2.value = xpoints[i + 1];
            y1.value = ypoints[i];
            y2.value = ypoints[i + 1];
            pt1Changed[0] = false;
            pt2Changed[0] = false;
            isVisible[0] = false;
            Gfx2dDrawUtil.plotClippedLine(rect, x1, y1, x2, y2, pt1Changed, pt2Changed, isVisible);
            if (isVisible[0]) {
                numVisiblePts += numVisiblePts == 0 ? 2 : 1;
                if (pt1Changed[0]) {
                    visibleXPoints[index] = x1.value;
                    visibleYPoints[index] = y1.value;
                    if (showPts) {
                        visibleSymbols[index] = false;
                    }
                } else {
                    visibleXPoints[index] = xpoints[i];
                    visibleYPoints[index] = ypoints[i];
                    if (showPts) {
                        visibleSymbols[index] = showXYSymbol[i];
                    }
                }
                if (pt2Changed[0]) {
                    visibleXPoints[index + 1] = x2.value;
                    visibleYPoints[index + 1] = y2.value;
                    if (showPts) {
                        visibleSymbols[index + 1] = false;
                    }
                } else {
                    visibleXPoints[index + 1] = xpoints[i + 1];
                    visibleYPoints[index + 1] = ypoints[i + 1];
                    if (showPts) {
                        visibleSymbols[index + 1] = showXYSymbol[i + 1];
                    }
                }
                ++index;
            }
            if (!pt1Changed[0] && !pt2Changed[0]) continue;
            if (showLine) {
                g.setColor(lColor);
                Gfx2dDrawUtil.efficientJavaPolylineDraw(g, visibleXPoints, visibleYPoints, numVisiblePts);
            }
            if (showPts) {
                Gfx2dDrawUtil.drawPoints(g, visibleXPoints, visibleYPoints, numVisiblePts, visibleSymbols, symbolType, slColor, sfColor, symbolSize, autoSkip, offset, skip);
            }
            if (drawLabel && labelAlign == 1) {
                labelXPoints = visibleXPoints;
                labelYPoints = visibleYPoints;
                numLabelPoints = numVisiblePts;
            } else if (drawLabel && labelAlign == 0 || labelAlign == 2) {
                int startIndex = labelXPoints == null ? 0 : 1;
                numVisiblePts = labelXPoints == null ? numVisiblePts : numVisiblePts - 1;
                labelXPoints = Gfx2dDrawUtil.appendArray(labelXPoints, visibleXPoints, startIndex, numVisiblePts);
                labelYPoints = Gfx2dDrawUtil.appendArray(labelYPoints, visibleYPoints, startIndex, numVisiblePts);
                numLabelPoints = labelXPoints.length;
            }
            numVisiblePts = 0;
            index = 0;
        }
        if (numPts == 1 && rect.contains(xpoints[0], ypoints[0])) {
            if (showLine) {
                g.setColor(lColor);
                float tempLineWidth = lineWidth <= 1.0f ? 2.0f : lineWidth;
                int width = (int)tempLineWidth / 2;
                g.fillRect(xpoints[0] - 1, ypoints[0] - width, 2, (int)tempLineWidth);
            }
            if (showPts) {
                Gfx2dDrawUtil.drawPoints(g, xpoints, ypoints, 1, new boolean[]{true}, symbolType, slColor, sfColor, symbolSize, false, 0, skip);
            }
        }
        if (numVisiblePts > 0) {
            if (showLine) {
                g.setColor(lColor);
                Gfx2dDrawUtil.efficientJavaPolylineDraw(g, visibleXPoints, visibleYPoints, numVisiblePts);
            }
            if (showPts) {
                Gfx2dDrawUtil.drawPoints(g, visibleXPoints, visibleYPoints, numVisiblePts, visibleSymbols, symbolType, slColor, sfColor, symbolSize, autoSkip, offset, skip);
            }
            if (labelAlign == 1 || labelXPoints == null && (labelAlign == 0 || labelAlign == 2)) {
                labelXPoints = visibleXPoints;
                labelYPoints = visibleYPoints;
                numLabelPoints = numVisiblePts;
            }
        }
        if (drawLabel && labelXPoints != null && labelYPoints != null) {
            Font oldFont = g.getFont();
            if (labelFont != null) {
                g.setFont(labelFont);
            }
            Gfx2dDrawUtil.drawConformingString(g, labelXPoints, labelYPoints, numLabelPoints, label, labelAlign, labelPosition, 5.0, 5, g.getFont(), labelColor, 1, 1.0f);
            if (oldFont != null) {
                g.setFont(oldFont);
            }
        }
    }

    private static int[] appendArray(int[] appendToArray, int[] appendFromArray, int startIndex, int numPointsToAppend) {
        if (appendToArray == null) {
            appendToArray = new int[]{};
        }
        int[] oldArray = appendToArray;
        appendToArray = new int[oldArray.length + numPointsToAppend];
        System.arraycopy(oldArray, 0, appendToArray, 0, oldArray.length);
        System.arraycopy(appendFromArray, startIndex, appendToArray, oldArray.length, numPointsToAppend);
        return appendToArray;
    }

    public static void drawPoints(Graphics g, int[] xpoints, int[] ypoints, int numPts, boolean[] showPoints, int symbolType, Color sLineColor, Color sFillColor, float sSize, boolean autoSkip, int offset, int skip) {
        Gfx2dDrawUtil.drawPoints(g, xpoints, ypoints, numPts, showPoints, symbolType, sLineColor, sFillColor, sSize, autoSkip, offset, skip, 1);
    }

    public static void drawPoints(Graphics g, int[] xpoints, int[] ypoints, int numPts, boolean[] showPoints, int symbolType, Color sLineColor, Color sFillColor, float sSize, boolean autoSkip, int offset, int skip, int symbolThickness) {
        int start;
        Stroke oldStroke = null;
        if (g instanceof Graphics2D) {
            oldStroke = ((Graphics2D)g).getStroke();
            ((Graphics2D)g).setStroke(new BasicStroke());
        }
        for (int i = start = 0; i < numPts; ++i) {
            if (!showPoints[i]) continue;
            Symbol.draw2(g, xpoints[i], ypoints[i], symbolType, sLineColor, sFillColor, sSize, DEVICE_RESOLUTION, symbolThickness);
        }
        if (g instanceof Graphics2D && oldStroke != null) {
            ((Graphics2D)g).setStroke(oldStroke);
        }
    }

    public static void fillPolygonClipped(Graphics g, Rectangle rect, int[] xpoints, int[] ypoints, int numPts) {
        Gfx2dDrawUtil.fillPolygonClipped(g, rect, xpoints, ypoints, numPts, 0);
    }

    public static void fillPolygonClipped(Graphics g, Rectangle rect, int[] xpoints, int[] ypoints, int numPts, int fillType) {
        Paint p = null;
        if (fillType == 0) {
            p = g.getColor();
        } else {
            Color c2 = g.getColor();
            Paint tp = FillPatternFactory.createFillPattern(fillType, c2);
            p = tp;
        }
        Gfx2dDrawUtil.fillPolygonClipped(g, rect, xpoints, ypoints, numPts, p);
    }

    public static void fillPolygonClipped(Graphics g, Rectangle rect, int[] xpoints, int[] ypoints, int numPts, Paint fillPaint) {
        int numCPoints = 0;
        int[] xCPoints = new int[numPts * 2];
        int[] yCPoints = new int[numPts * 2];
        for (int i = 0; i < numPts; ++i) {
            double tin2;
            double tin1;
            int yout;
            int yin;
            int xout;
            int xin;
            double deltay;
            double deltax;
            if (i < numPts - 1) {
                deltax = xpoints[i + 1] - xpoints[i];
                deltay = ypoints[i + 1] - ypoints[i];
            } else {
                deltax = xpoints[0] - xpoints[numPts - 1];
                deltay = ypoints[0] - ypoints[numPts - 1];
            }
            if (deltax > 0.0 || deltax == 0.0 && xpoints[i] > rect.x + rect.width) {
                xin = rect.x;
                xout = rect.x + rect.width;
            } else {
                xout = rect.x;
                xin = rect.x + rect.width;
            }
            if (deltay > 0.0 || deltay == 0.0 && ypoints[i] > rect.y + rect.height) {
                yin = rect.y;
                yout = rect.y + rect.height;
            } else {
                yout = rect.y;
                yin = rect.y + rect.height;
            }
            double tinx = deltax != 0.0 ? (double)(xin - xpoints[i]) / deltax : Double.NEGATIVE_INFINITY;
            double tiny = deltay != 0.0 ? (double)(yin - ypoints[i]) / deltay : Double.NEGATIVE_INFINITY;
            if (tinx < tiny) {
                tin1 = tinx;
                tin2 = tiny;
            } else {
                tin1 = tiny;
                tin2 = tinx;
            }
            if (!(1.0 >= tin1)) continue;
            if (0.0 < tin1) {
                xCPoints[++numCPoints - 1] = xin;
                yCPoints[numCPoints - 1] = yin;
            }
            if (!(1.0 >= tin2)) continue;
            double toutx = deltax != 0.0 ? (double)(xout - xpoints[i]) / deltax : (xpoints[i] >= rect.x && xpoints[i] <= rect.x + rect.width ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
            double touty = deltay != 0.0 ? (double)(yout - ypoints[i]) / deltay : (ypoints[i] >= rect.y && ypoints[i] <= rect.y + rect.height ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
            double tout1 = toutx < touty ? toutx : touty;
            if (!(0.0 < tin2) && !(0.0 < tout1)) continue;
            if (tin2 <= tout1) {
                if (0.0 < tin2) {
                    if (tinx > tiny) {
                        xCPoints[++numCPoints - 1] = xin;
                        yCPoints[numCPoints - 1] = (int)((double)ypoints[i] + tinx * deltay);
                    } else {
                        xCPoints[++numCPoints - 1] = (int)((double)xpoints[i] + tiny * deltax);
                        yCPoints[numCPoints - 1] = yin;
                    }
                }
                if (1.0 > tout1) {
                    if (toutx < touty) {
                        xCPoints[++numCPoints - 1] = xout;
                        yCPoints[numCPoints - 1] = (int)((double)ypoints[i] + toutx * deltay);
                        continue;
                    }
                    xCPoints[++numCPoints - 1] = (int)((double)xpoints[i] + touty * deltax);
                    yCPoints[numCPoints - 1] = yout;
                    continue;
                }
                ++numCPoints;
                if (i < numPts - 1) {
                    xCPoints[numCPoints - 1] = xpoints[i + 1];
                    yCPoints[numCPoints - 1] = ypoints[i + 1];
                    continue;
                }
                xCPoints[numCPoints - 1] = xpoints[0];
                yCPoints[numCPoints - 1] = ypoints[0];
                continue;
            }
            if (tinx > tiny) {
                xCPoints[++numCPoints - 1] = xin;
                yCPoints[numCPoints - 1] = yout;
                continue;
            }
            xCPoints[++numCPoints - 1] = xout;
            yCPoints[numCPoints - 1] = yin;
        }
        if (numCPoints < 1) {
            return;
        }
        if (fillPaint != null) {
            Paint op = ((Graphics2D)g).getPaint();
            ((Graphics2D)g).setPaint(fillPaint);
            g.fillPolygon(xCPoints, yCPoints, numCPoints);
            ((Graphics2D)g).setPaint(op);
        }
    }

    public static void drawConformingString(Graphics g, int[] xarray, int[] yarray, int numPoints, String str, int labelAlign, int labelPosition, double coord, int baseoffset, Font font, Color color, int bank, float priority) {
        int[] ya;
        int[] xa;
        double fac;
        double len2;
        int i;
        Font f;
        if (str == null || str.equals("")) {
            return;
        }
        if (bank != 1 && bank != -1) {
            bank = 1;
        }
        if ((f = g.getFont()) != font) {
            g.setFont(font);
        }
        FontMetrics metrics = g.getFontMetrics();
        int strwidth = metrics.stringWidth(str);
        int h = metrics.getHeight();
        int ascent = metrics.getAscent();
        int descent = metrics.getDescent();
        int hoff = (int)((double)h / 2.0 + 0.5) - ascent;
        int w = metrics.getMaxAdvance();
        int numchar = str.length();
        double len = 0.0;
        int istart = 0;
        int iend = numPoints - 1;
        int PIXEL_BUF = 10;
        if (labelAlign == 1) {
            for (i = iend; i >= 0; --i) {
                len2 = Math.sqrt((xarray[numPoints - 1] - xarray[i]) * (xarray[numPoints - 1] - xarray[i]) + (yarray[numPoints - 1] - yarray[i]) * (yarray[numPoints - 1] - yarray[i]));
                if (len2 >= (double)strwidth) {
                    fac = ((double)(strwidth / 2 + PIXEL_BUF) - len) / (len2 - len);
                    xarray[i] = xarray[i + 1] + (int)((double)(xarray[i] - xarray[i + 1]) * fac);
                    yarray[i] = yarray[i + 1] + (int)((double)(yarray[i] - yarray[i + 1]) * fac);
                    len = strwidth;
                    istart = i;
                    break;
                }
                len = len2;
            }
            if (len < (double)strwidth && istart == 0) {
                return;
            }
        } else if (labelAlign == 0) {
            for (i = istart; i < iend; ++i) {
                len2 = Math.sqrt((xarray[0] - xarray[i + 1]) * (xarray[0] - xarray[i + 1]) + (yarray[0] - yarray[i + 1]) * (yarray[0] - yarray[i + 1]));
                if (len2 >= (double)strwidth) {
                    fac = ((double)(strwidth / 2 + PIXEL_BUF) - len) / (len2 - len);
                    xarray[i + 1] = xarray[i] + (int)((double)(xarray[i + 1] - xarray[i]) * fac);
                    yarray[i + 1] = yarray[i] + (int)((double)(yarray[i + 1] - yarray[i]) * fac);
                    len = strwidth;
                    iend = i + 1;
                    break;
                }
                len = len2;
            }
            if (len < (double)strwidth && iend == numPoints - 1) {
                return;
            }
        } else if (labelAlign == 2) {
            int totalLength = 0;
            int centerIndex = 0;
            double halfLength = 0.0;
            for (i = 0; i < numPoints - 1; ++i) {
                totalLength = (int)((double)totalLength + Math.sqrt((xarray[i] - xarray[i + 1]) * (xarray[i] - xarray[i + 1]) + (yarray[i] - yarray[i + 1]) * (yarray[i] - yarray[i + 1])));
            }
            halfLength = totalLength / 2;
            int tempTotalLength = 0;
            double segmentLength = 0.0;
            for (i = 0; i < numPoints - 1; ++i) {
                segmentLength = Math.sqrt((xarray[i] - xarray[i + 1]) * (xarray[i] - xarray[i + 1]) + (yarray[i] - yarray[i + 1]) * (yarray[i] - yarray[i + 1]));
                if ((double)tempTotalLength + segmentLength >= halfLength) {
                    centerIndex = i;
                    break;
                }
                tempTotalLength = (int)((double)tempTotalLength + segmentLength);
            }
            fac = (halfLength - (double)tempTotalLength) / segmentLength;
            xarray[i + 1] = xarray[i] + (int)((double)(xarray[i + 1] - xarray[i]) * fac);
            yarray[i + 1] = yarray[i] + (int)((double)(yarray[i + 1] - yarray[i]) * fac);
            iend = i + 1;
        }
        int xmin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymin = Integer.MAX_VALUE;
        int ymax = Integer.MIN_VALUE;
        for (i = istart; i <= iend; ++i) {
            if (xmin > xarray[i]) {
                xmin = xarray[i];
            }
            if (xmax < xarray[i]) {
                xmax = xarray[i];
            }
            if (ymin > yarray[i]) {
                ymin = yarray[i];
            }
            if (ymax >= yarray[i]) continue;
            ymax = yarray[i];
        }
        if (xmax - xmin >= ymax - ymin) {
            xa = xarray;
            ya = yarray;
        } else {
            ya = xarray;
            xa = yarray;
        }
        double[] mb = RmaMath.bestFitLinear(xa, ya, iend - istart + 1, istart);
        double ang = 1.5707963267948966;
        if (xmax - xmin < ymax - ymin) {
            ang = 0.0;
        }
        if (mb[0] != Double.NEGATIVE_INFINITY) {
            ang = xmax - xmin >= ymax - ymin ? Math.atan(mb[0]) : (mb[0] != 0.0 ? Math.atan(1.0 / mb[0]) : 1.5707963267948966);
        }
        double ca = Math.cos(-ang);
        double sa = Math.sin(-ang);
        double ytmax = -999999.0;
        double ytmin = 999999.0;
        for (i = istart; i <= iend; ++i) {
            double yt = sa * (double)(xarray[i] - xarray[istart + 1]) + ca * (double)(yarray[i] - yarray[istart + 1]);
            if (ytmax < yt) {
                ytmax = yt;
            }
            if (!(ytmin > yt)) continue;
            ytmin = yt;
        }
        double xt0 = ca * (double)(xarray[istart] - xarray[istart + 1]) - sa * (double)(yarray[istart] - yarray[istart + 1]);
        if (xt0 > 0.0) {
            bank *= -1;
        }
        int ioff = labelPosition == 0 ? (bank <= 0 ? (int)ytmax + ascent : (int)ytmin - descent) : (labelPosition == 1 ? (bank > 0 ? ascent + (int)ytmax : (int)ytmin - descent) : (bank <= 0 ? (int)ytmax - descent / 2 : (int)ytmin + ascent / 2));
        int startPos = labelAlign != 1 ? iend : istart;
        RotatedText mapText = new RotatedText(str, xarray[startPos], yarray[startPos], ang, ioff, priority, font, color, null, g);
        Graphics g2 = g.create();
        mapText.draw(g2);
        g2.dispose();
        if (f != font) {
            g.setFont(f);
        }
    }

    public static void computeVisibleSymbols(int[] xpoints, int[] ypoints, int numPts, boolean autoSkip, int offset, int skip, float sSize, boolean[] visibleSymbols) {
        float askipSize = sSize * 1.5f * (float)DEVICE_RESOLUTION / (float)G2dResolutionConst.PRINTER_SCALE;
        int halfSizeWidth = (int)Math.ceil(askipSize / 2.0f);
        Rectangle r1 = new Rectangle();
        Rectangle r2 = new Rectangle();
        int lastDrawnIndex = 0;
        int start = 0 + offset;
        for (int j = 0; j < numPts; ++j) {
            visibleSymbols[j] = false;
        }
        for (int i = start; i < numPts; i += skip + 1) {
            if (autoSkip) {
                if (i == start) continue;
                r1.setRect(xpoints[lastDrawnIndex] - halfSizeWidth, ypoints[lastDrawnIndex] + halfSizeWidth, askipSize, askipSize);
                r2.setRect(xpoints[i] - halfSizeWidth, ypoints[i] + halfSizeWidth, askipSize, askipSize);
                if (r1.intersects(r2)) {
                    visibleSymbols[i] = false;
                    continue;
                }
                visibleSymbols[i] = true;
                lastDrawnIndex = i;
                continue;
            }
            visibleSymbols[i] = i % (skip + 1) == 0 + offset % (skip + 1);
        }
    }

    private static void efficientJavaPolylineDraw(Graphics g, int[] xdata, int[] ydata, int numPoints) {
        if (numPoints <= 750) {
            g.drawPolyline(xdata, ydata, numPoints);
            return;
        }
        int i = 0;
        i = 0;
        while (i + 750 < numPoints) {
            System.arraycopy(xdata, i, JAVA_DRAW_XARRAY, 0, 750);
            System.arraycopy(ydata, i, JAVA_DRAW_YARRAY, 0, 750);
            g.drawPolyline(JAVA_DRAW_XARRAY, JAVA_DRAW_YARRAY, 750);
            i += 749;
        }
        System.arraycopy(xdata, i, JAVA_DRAW_XARRAY, 0, numPoints - i);
        System.arraycopy(ydata, i, JAVA_DRAW_YARRAY, 0, numPoints - i);
        g.drawPolyline(JAVA_DRAW_XARRAY, JAVA_DRAW_YARRAY, numPoints - i);
    }

    public static void drawString(JComponent c2, Graphics g, String text, int x, int y) {
        JLabel paintLabel = new JLabel();
        paintLabel.setText(text);
        paintLabel.setFont(g.getFont());
        paintLabel.setForeground(g.getColor());
        FontMetrics fontMetrics = paintLabel.getFontMetrics(g.getFont());
        int width = fontMetrics.stringWidth(text);
        Rectangle2D bounds = fontMetrics.getStringBounds(text, g);
        paintLabel.setBounds((int)((double)x + bounds.getX()), (int)((double)y + bounds.getY()), width, (int)bounds.getHeight());
        Graphics2D g2d = (Graphics2D)g.create((int)((double)x + bounds.getX()), (int)((double)y + bounds.getY()), width, (int)bounds.getHeight());
        paintLabel.paint(g2d);
        g2d.dispose();
    }

    public static void drawString(JComponent c2, Graphics g, String text, int x, int y, int rotate) {
        Dimension dim = c2.getSize();
        JLabel paintLabel = new JLabel();
        paintLabel.setText(text);
        paintLabel.setFont(g.getFont());
        paintLabel.setForeground(g.getColor());
        FontMetrics fontMetrics = paintLabel.getFontMetrics(g.getFont());
        int width = fontMetrics.stringWidth(text);
        Rectangle2D bounds = fontMetrics.getStringBounds(text, g);
        paintLabel.setBounds((int)((double)x + bounds.getX()), (int)((double)y + bounds.getY()), width, (int)bounds.getHeight());
        Graphics2D g2d = (Graphics2D)g.create((int)((double)x + bounds.getX()), (int)((double)y + bounds.getY()), width, (int)bounds.getHeight());
        double factor = Math.abs(Math.sin(Math.toRadians(rotate)));
        g2d.translate((double)(-x) * factor, (double)(-y) * factor);
        g2d.rotate(Math.toRadians(-rotate), 0.0, 0.0);
        g2d.translate((double)(-dim.height + x - fontMetrics.getHeight()) * factor, (double)(y - fontMetrics.getHeight()) * factor);
        g2d.setClip(0, 0, width, fontMetrics.getHeight());
        paintLabel.paint(g2d);
        g2d.dispose();
    }
}

