/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalRect;
import hec.gfx2d.GfxTextObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class GfxLabelItem
extends GfxTextObject {
    public static final int EAST = 0;
    public static final int NORTHEAST = 1;
    public static final int NORTH = 2;
    public static final int NORTHWEST = 3;
    public static final int WEST = 4;
    public static final int SOUTHWEST = 5;
    public static final int SOUTH = 6;
    public static final int SOUTHEAST = 7;
    private static final double[] _angle = new double[]{0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, Math.PI, 3.9269908169872414, 4.71238898038469, 5.497787143782138, Math.PI};
    public static final String[] POSITION_STRINGS = new String[]{"EAST", "NORTHEAST", "NORTH", "NORTHWEST", "WEST", "SOUTHWEST", "SOUTH", "SOUTHEAST"};
    int _x;
    int _y;
    int _iconHeight;
    int _iconWidth;
    int _position = 0;
    boolean _drawBorder = false;

    public GfxLabelItem(String txt, int x, int y, int pos, int iconWidth, int iconHeight, float priority, Font font, Color fg, Color bg, boolean drawBorder, Graphics g) {
        super(txt, priority, font, fg, bg, g);
        this._x = x;
        this._y = y;
        this._iconWidth = iconWidth;
        this._iconHeight = iconHeight;
        this._position = pos;
        if (this._position < 0 || this._position > 7) {
            this._position = 0;
        }
        this._drawBorder = drawBorder;
    }

    public GfxLabelItem(String txt, int x, int y, int pos, int size, float priority, Font font, Color fg, Color bg, Graphics g) {
        super(txt, priority, font, fg, bg, g);
        this._x = x;
        this._y = y;
        this._iconHeight = size * 2;
        this._iconWidth = size * 2;
        this._position = pos;
        if (this._position < 0 || this._position > 7) {
            this._position = 0;
        }
    }

    public GfxLabelItem(String txt, int x, int y, float priority, Font font, Color fg, Color bg, Graphics g) {
        super(txt, priority, font, fg, bg, g);
        this._x = x;
        this._y = y;
        this._position = 0;
        this._iconHeight = 0;
        this._iconWidth = 0;
    }

    public GfxLabelItem(String txt, int x, int y, int pos, int offset, float priority, Font font, Color fg, Color bg, boolean drawBorder, Graphics g) {
        this(txt, x, y, pos, offset * 2, offset * 2, priority, font, fg, bg, false, g);
        this._drawBorder = drawBorder;
    }

    @Override
    public boolean intersects(GfxTextObject obj) {
        if (obj == null) {
            return false;
        }
        if (this._bounds == null) {
            this.getBounds();
        }
        if (obj instanceof GfxLabelItem) {
            return this._bounds.intersects(obj.getBounds());
        }
        return obj.intersects(this);
    }

    @Override
    public LocalRect getBounds() {
        if (this._bounds == null) {
            double ca = Math.cos(_angle[this._position]);
            int yoff = this._position == 0 || this._position == 4 ? (int)(0.5 - (double)(this._h / 2)) : (this._position == 1 || this._position == 3 || this._position == 2 ? -this._iconHeight / 2 - this._h - 1 : this._iconHeight / 2 + 2);
            int xoff = this._position == 0 || this._position == 1 || this._position == 7 ? 0 : (this._position == 2 || this._position == 6 ? -this._w / 2 : -this._w);
            int l = (int)((double)this._x + (double)(this._iconWidth / 2 + 3) * ca + (double)xoff);
            int r = l + this._w;
            int t = this._y + yoff;
            int b = t + this._h;
            this._bounds = new LocalRect(l, t, r, b);
        }
        return this._bounds;
    }

    public LocalRect getLocalRect() {
        return this.getBounds();
    }

    public LocalRect getLocalRect(LocalRect rc) {
        LocalRect rcb = this.getBounds();
        rc.init(rcb.l, rcb.t, rcb.r, rcb.b);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            Font f = g2d.getFont();
            g2d.setFont(this._font);
            LocalRect rcb = this.getBounds();
            if (this._bgcolor != null) {
                FontMetrics metrics = g2d.getFontMetrics();
                g2d.setColor(this._bgcolor);
                g2d.fillRect(rcb.l - 1, rcb.t, rcb.width() + 2, rcb.height());
            } else {
                g2d.setColor(this._fgcolor);
            }
            if (this._drawBorder) {
                g2d.setColor(this._fgcolor);
                g2d.drawRect(rcb.l - 1, rcb.t, rcb.width() + 2, rcb.height());
            } else {
                g2d.setColor(this._fgcolor);
            }
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            g2d.drawString(this._text, rcb.l, rcb.t + this._a);
            g2d.setFont(f);
        }
        finally {
            g2d.dispose();
        }
    }

    public String getText() {
        return this._text;
    }
}

