/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.AbstractPlotDefaults;
import hec.gfx2d.DefaultPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.action.ImportPlotDefaults;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAIO;

public class HotPlotDefaults
extends AbstractPlotDefaults {
    private static final Logger LOGGER = Logger.getLogger(HotPlotDefaults.class.getName());
    static final Map STATIC_HP_DEFAULTS;

    public HotPlotDefaults() {
        this.m_plotDefaultsTable = STATIC_HP_DEFAULTS;
    }

    @Override
    public BufferedWriter getBufferedWriter(Class plotCompClass) {
        return new BufferedWriter(new StringWriter());
    }

    @Override
    public boolean loadPlotComponentDefaults(Class plotCompClass) {
        return true;
    }

    private static String copyFileFromResourcesToTemp() {
        try {
            String resource = "hec/gfx2d/HotPlotDefaults.zip";
            String tempDirectory = System.getProperty("java.io.tmpdir");
            String DEST_FILE = RMAIO.getFileFromPath(resource);
            String projectName = RMAIO.getFileNameNoExtension(DEST_FILE);
            String separator = tempDirectory.endsWith(File.separator) ? "" : File.separator;
            String DEST_DIR = tempDirectory + separator + projectName;
            File f = new File(DEST_DIR + File.separator);
            if (!f.exists()) {
                f.mkdirs();
            }
            String DEST = DEST_DIR + File.separator + DEST_FILE;
            try (InputStream iStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                 BufferedInputStream bufIn = new BufferedInputStream(iStream);
                 FileOutputStream fStream = new FileOutputStream(DEST);
                 BufferedOutputStream bufOut = new BufferedOutputStream(fStream);){
                byte[] byteArray = new byte[100];
                int numBytesRead = bufIn.read(byteArray);
                while (numBytesRead != -1) {
                    bufOut.write(byteArray, 0, numBytesRead);
                    numBytesRead = bufIn.read(byteArray);
                }
                bufOut.flush();
            }
            return DEST;
        }
        catch (IOException | RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Error copying HotPlotDefaults.zip to temp directory", e);
            return null;
        }
    }

    public static void main(String[] args) {
        new HotPlotDefaults();
    }

    static {
        PlotDefaults oldDefaults = PlotDefaultsManager.getDefaults();
        DefaultPlotDefaults hpdefaults = new DefaultPlotDefaults();
        PlotDefaultsManager.setDefaults(hpdefaults);
        String filePath = HotPlotDefaults.copyFileFromResourcesToTemp();
        if (filePath != null) {
            File f = new File(filePath);
            try {
                new ImportPlotDefaults().run(f);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error static initializing import plot defaults", e);
            }
        }
        STATIC_HP_DEFAULTS = PlotDefaultsManager.getDefaults().getDefaultsTable();
        PlotDefaultsManager.setDefaults(oldDefaults);
    }
}

