/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class IntegerTextField
extends TextField
implements KeyListener,
TextListener {
    private String lastValue;
    private int lastCaretPosition;

    public IntegerTextField() {
        this.addTextListener(this);
        this.addKeyListener(this);
    }

    public IntegerTextField(String s) {
        super(s);
        this.addKeyListener(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        if (!('0' <= ch && ch <= '9' || Character.isISOControl(ch))) {
            e.consume();
        } else {
            this.lastCaretPosition = this.getCaretPosition();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void textValueChanged(TextEvent evt) {
        this.checkValue();
    }

    public void checkValue() {
        try {
            int i = Integer.parseInt(this.getText().trim());
            if (i > 72) {
                this.lastValue = "72";
                this.setText(this.lastValue);
                this.selectAll();
            } else {
                this.lastValue = this.getText();
            }
        }
        catch (NumberFormatException e) {
            if (this.getText().equals("")) {
                this.setText("12");
                this.lastValue = "12";
                this.selectAll();
            }
            this.setText(this.lastValue);
        }
    }

    public int getValue() {
        this.checkValue();
        try {
            return Integer.parseInt(this.getText().trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

