/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.G2dBackgroundPropertiesPanel;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.SamplePanel;
import hec.gfx2d.SimpleLinePropertiesPanel;
import hec.gfx2d.components.ComponentPanel;
import hec.gfx2d.components.FontPanel;
import hec.gfx2d.components.TextPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;

public class LabelPropertiesPanel
extends DefaultJPanel
implements ComponentPanel {
    private TextPanel _textPanel;
    private FontPanel _fontPanel;
    private SamplePanel _samplePanel;
    private SimpleLinePropertiesPanel _borderPanel;
    private G2dBackgroundPropertiesPanel _backgroundPanel;
    private RmaJCheckBox _allLegendsSameFontCheck;
    protected G2dLabelDrawProp _properties;
    private JSeparator _bottomSep;

    public LabelPropertiesPanel() {
        super(new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this._textPanel = new TextPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._textPanel, gbc);
        this._fontPanel = new FontPanel(null);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._fontPanel, gbc);
        this._samplePanel = new SamplePanel();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._samplePanel, gbc);
        JPanel rightPanel = new JPanel(new GridBagLayout());
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this.add((Component)rightPanel, gbc);
        this._borderPanel = new SimpleLinePropertiesPanel("Draw Border");
        this._borderPanel.setBorder(BorderFactory.createTitledBorder("Border"));
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        rightPanel.add((Component)this._borderPanel, gbc);
        this._backgroundPanel = new G2dBackgroundPropertiesPanel();
        this._backgroundPanel.setBorder(BorderFactory.createTitledBorder("Background"));
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        rightPanel.add((Component)this._backgroundPanel, gbc);
        this._bottomSep = new JSeparator();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._bottomSep, gbc);
        this._allLegendsSameFontCheck = new RmaJCheckBox("All Legend Items use the same font");
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._allLegendsSameFontCheck, gbc);
        this._textPanel.setSamplePanel(this._samplePanel);
        this._fontPanel.setSamplePanel(this._samplePanel);
        this._backgroundPanel.setSamplePanel(this._samplePanel);
        this._borderPanel.setSamplePanel(this._samplePanel);
        this._samplePanel.setBackgroundPropPanel(this._backgroundPanel);
        this._samplePanel.setBorderPropPanel(this._borderPanel);
    }

    public G2dLabelDrawProp getProperties() {
        return this._properties;
    }

    protected void addListeners() {
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        this._properties.font = this._fontPanel.getSelectedFont();
        if (this._properties.font != null) {
            this._properties.fontFamily = this._properties.font.getFamily();
            this._properties.fontSize = this._properties.font.getSize();
            this._properties.fontStyle = this._properties.font.getStyle();
        }
        this._properties.textColor = this._fontPanel.getFontColor();
        this._properties.useFontScaling = this._fontPanel.useFontScaling();
        this._properties.maxFontSize = this._fontPanel.getMaxScalingSize();
        this._properties.minFontSize = this._fontPanel.getMinScalingSize();
        this._properties.setBackgroundFill(this._backgroundPanel.getBackgroundFill());
        this._properties.setBackgroundColor(this._backgroundPanel.getBackgroundColor());
        this._properties.setAlphaComposite(this._backgroundPanel.getAlpha());
        this._properties.drawBackground = this._backgroundPanel.isCustomEnabled();
        this._properties.drawBorder = this._borderPanel.isCustomEnabled();
        this._properties.setLineStyle(this._borderPanel.getLineStyle());
        this._properties.setLineWeight(this._borderPanel.getLineWidth());
        this._properties.setLineColor(this._borderPanel.getLineColor());
        this._properties.text = this._textPanel.getText();
        return true;
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        this._fontPanel.setSelectedFont(this._properties.getFont());
        this._fontPanel.setFontColor(this._properties.getTextColor());
        this._fontPanel.setUseFontScaling(this._properties.useFontScaling);
        this._fontPanel.setMinScalingSize(this._properties.minFontSize);
        this._fontPanel.setMaxScalingSize(this._properties.maxFontSize);
        this._backgroundPanel.setBackgroundFill(this._properties.getBackgroundFill());
        this._backgroundPanel.setBackgroundColor(this._properties.getBackgroundColor());
        this._backgroundPanel.setCustomEnabled(this._properties.drawBackground);
        this._backgroundPanel.setAlpha(this._properties.getAlphaComposite());
        this._borderPanel.setCustomEnabled(this._properties.drawBorder);
        this._borderPanel.setLineStyle(this._properties.getLineStyle());
        this._borderPanel.setLineWidth(this._properties.getLineWeight());
        this._borderPanel.setLineColor(this._properties.getLineColor());
        this._textPanel.setText(this._properties.text);
        if (this._properties.text == null || this._properties.text.length() == 0) {
            this.setSampleText("Sample Text");
        }
    }

    public void setData(G2dLabelDrawProp properties) {
        this._properties = properties;
    }

    public G2dLabelDrawProp getData() {
        return this._properties;
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        this._textPanel.setEnabled(enabled);
        this._fontPanel.setEnabled(enabled);
        this._samplePanel.setEnabled(enabled);
        this._borderPanel.setEnabled(enabled);
        this._backgroundPanel.setEnabled(enabled);
    }

    public boolean isAllLabelsCheckSelected() {
        return this._allLegendsSameFontCheck.isSelected();
    }

    public boolean isAllLabelsCheckVisible() {
        return this._allLegendsSameFontCheck.isVisible();
    }

    protected void setAllLabelsCheckVisible(boolean b) {
        this._bottomSep.setVisible(b);
        this._allLegendsSameFontCheck.setVisible(b);
    }

    public void setSampleText(String text) {
        this._samplePanel.setSampleText(text);
    }

    public void setText(String text) {
        this._textPanel.setText(text);
    }

    public String getText() {
        return this._textPanel.getText();
    }
}

