/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.data.Parameter;
import hec.data.Units;
import hec.geometry.Axis;
import hec.geometry.AxisFactory;
import hec.geometry.Scale;
import hec.gfx2d.AxisTics;
import hec.gfx2d.DataType;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.LegendPanel;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportToolbar;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.services.ServiceLookup;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.tree.PopupNodeListener;
import rma.swing.tree.PopupTreeNode;
import rma.util.DoubleVector;
import rma.util.IntVector;
import rma.util.RMAIO;

public class LayoutPlotDialog
extends RmaJDialog {
    private static String[] AXIS_LABELS = new String[]{"Left Y Axis", "Right Y Axis"};
    private JTree _plotTree;
    private JButton _spinUp;
    private JButton _spinDown;
    private JMenuItem _addAxisMenuItem;
    private JMenuItem _saveMenuItem;
    private ButtonCmdPanel _cmdPanel;
    private G2dDialog _parent;
    int[] intarray = new int[1];
    private boolean _canceled = false;
    Action _removeViewportAction;
    Action _removeAxisAction;
    JPopupMenu _viewportPopup;
    JPopupMenu _axisPopup;

    public LayoutPlotDialog(G2dDialog parent, boolean modal) {
        super((Frame)parent, modal);
        this._parent = parent;
        this.buildControls();
    }

    protected void buildControls() {
        this.setTitle("Configure Plot");
        this.getContentPane().setLayout(new GridBagLayout());
        this._removeViewportAction = new AbstractAction("Remove Viewport"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutPlotDialog.this.removeViewport();
            }
        };
        this._removeAxisAction = new AbstractAction("Remove Axis"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutPlotDialog.this.removeAxis();
            }
        };
        JLabel label = new JLabel("Selected Data Sets", 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)label, gbc);
        this._plotTree = new JTree(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.width = 400;
                d.height = 200;
                return d;
            }
        };
        this._plotTree.addMouseListener(new PopupNodeListener(this._plotTree));
        this._plotTree.getSelectionModel().setSelectionMode(1);
        this._plotTree.setCellRenderer(new PlotTreeCellRenderer());
        this._plotTree.setRootVisible(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)new JScrollPane(this._plotTree), gbc);
        JPanel spinPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)spinPanel, gbc);
        this._spinUp = new JButton(RmaImage.getImageIcon("Images/spinUp.gif"));
        this._spinUp.addActionListener(e -> this.spinUp());
        this._spinUp.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this._spinUp.setToolTipText("Move Up");
        this._spinUp.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        spinPanel.add((Component)this._spinUp, gbc);
        this._spinDown = new JButton(RmaImage.getImageIcon("Images/spinDown.gif"));
        this._spinDown.addActionListener(e -> this.spinDown());
        this._spinDown.setMargin(RmaInsets.insets(0, 0, 0, 0));
        this._spinDown.setToolTipText("Move Down");
        this._spinDown.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        spinPanel.add((Component)this._spinDown, gbc);
        this._cmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        LayoutPlotDialog.this.saveForm();
                        LayoutPlotDialog.this._canceled = false;
                        LayoutPlotDialog.this.setVisible(false);
                        break;
                    }
                    case 2: {
                        LayoutPlotDialog.this.saveForm();
                        break;
                    }
                    case 4: {
                        LayoutPlotDialog.this._canceled = true;
                        LayoutPlotDialog.this.setVisible(false);
                    }
                }
            }
        });
        this.buildMenus();
        this.fillForm(this._parent);
        this.pack();
        this.setLocation();
        this._plotTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TreePath path = LayoutPlotDialog.this._plotTree.getSelectionPath();
                if (path == null) {
                    LayoutPlotDialog.this._spinUp.setEnabled(false);
                    LayoutPlotDialog.this._spinDown.setEnabled(false);
                    LayoutPlotDialog.this._removeViewportAction.setEnabled(false);
                    LayoutPlotDialog.this._addAxisMenuItem.setEnabled(false);
                    LayoutPlotDialog.this._removeAxisAction.setEnabled(false);
                    return;
                }
                Object node = path.getLastPathComponent();
                LayoutPlotDialog.this.nodeSelected(node);
            }
        });
    }

    protected void buildMenus() {
        JMenuBar mbar = new JMenuBar();
        JMenu menu = new JMenu("Plot");
        menu.setMnemonic('P');
        this._saveMenuItem = new JMenuItem("Save", 83);
        this._saveMenuItem.setEnabled(false);
        this._saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this._saveMenuItem.addActionListener(e -> this.saveForm());
        menu.add(this._saveMenuItem);
        menu.addSeparator();
        JMenuItem menuItem = new JMenuItem("Close", 67);
        menuItem.addActionListener(e -> this.closeForm());
        menu.add(menuItem);
        mbar.add(menu);
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        menuItem = new JMenuItem("Add Viewport", 86);
        menuItem.addActionListener(e -> this.addViewport());
        menu.add(menuItem);
        menuItem = menu.add(this._removeViewportAction);
        menuItem.setMnemonic('R');
        this._removeViewportAction.setEnabled(false);
        menu.addSeparator();
        this._addAxisMenuItem = new JMenuItem("Add Axis", 65);
        this._addAxisMenuItem.setEnabled(false);
        this._addAxisMenuItem.addActionListener(e -> this.addAxis());
        menu.add(this._addAxisMenuItem);
        menuItem = menu.add(this._removeAxisAction);
        menuItem.setMnemonic('x');
        menu.addSeparator();
        menuItem = new JMenuItem("Set Viewport Weights...", 83);
        menuItem.addActionListener(e -> this.setViewportWeights());
        menu.add(menuItem);
        mbar.add(menu);
        this.setJMenuBar(mbar);
    }

    public void fillForm(G2dDialog parent) {
        int i;
        DefaultTreeModel model = (DefaultTreeModel)this._plotTree.getModel();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        if (parent == null) {
            model.setRoot(root);
            model.reload();
            return;
        }
        Viewport[] viewports = parent._gfxPanel.getViewports();
        GridBagLayout gbl = (GridBagLayout)parent._gfxPanel.getLayout();
        double[] weights = new double[viewports.length];
        double[] weightPercents = new double[viewports.length];
        double sum = 0.0;
        for (i = 0; i < viewports.length; ++i) {
            GridBagConstraints gbc = gbl.getConstraints(viewports[i]);
            weights[i] = gbc.weighty;
            sum += weights[i];
        }
        i = 0;
        while (i < weights.length) {
            weightPercents[i] = weights[i] / sum;
            int n = i++;
            weightPercents[n] = weightPercents[n] * 100.0;
        }
        for (int i2 = 0; i2 < viewports.length; ++i2) {
            Viewport v = viewports[i2];
            ViewportNode vn = new ViewportNode(v);
            vn.setWeight(weights[i2]);
            vn.setWeightPercent(weightPercents[i2]);
            root.add(vn);
            Vector glyphVector = v.getGlyphVector();
            block3: for (int g = 0; g < glyphVector.size(); ++g) {
                G2dGlyph glyph = (G2dGlyph)glyphVector.get(g);
                Axis axis = glyph.getScale().getAxis(1);
                G2dObject g2dObj = glyph.getG2dObject();
                G2dLineProperties lineProps = glyph.getLine().getProperties();
                if (axis == null || g2dObj == null) continue;
                for (int a = 0; a < vn.getChildCount(); ++a) {
                    AxisNode an = (AxisNode)vn.getChildAt(a);
                    if (an.getAxis() != axis) continue;
                    an.add(new G2dObjectNode(g2dObj, lineProps));
                    continue block3;
                }
            }
        }
        model.setRoot(root);
        model.reload();
        this._plotTree.getSelectionModel().setSelectionMode(0);
        this._plotTree.setRootVisible(false);
        this.expandAllTreeNodes(this._plotTree);
    }

    public void expandAllTreeNodes(JTree tree) {
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
    }

    protected void nodeSelected(Object node) {
        if (node instanceof ViewportNode) {
            this.viewportNodeSelected((ViewportNode)node);
        } else if (node instanceof AxisNode) {
            this.axisNodeSelected((AxisNode)node);
        } else if (node instanceof G2dObjectNode) {
            this.g2dObjectNodeSelected((G2dObjectNode)node);
        }
    }

    protected void g2dObjectNodeSelected(G2dObjectNode node) {
        this._spinUp.setEnabled(false);
        this._spinDown.setEnabled(false);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._plotTree.getModel().getRoot();
        this._removeAxisAction.setEnabled(false);
        this._addAxisMenuItem.setEnabled(false);
        this._removeViewportAction.setEnabled(false);
        AxisNode an = (AxisNode)node.getParent();
        String currentUnits = an.getUnits();
        ViewportNode vpn = (ViewportNode)an.getParent();
        AxisNode an2 = this.getNextAxisForObj(node);
        if (an2 != null) {
            this._spinDown.setEnabled(true);
        }
        if ((an2 = this.getPreviousAxisForObj(node)) != null) {
            this._spinUp.setEnabled(true);
        }
    }

    protected void axisNodeSelected(AxisNode an) {
        DefaultMutableTreeNode sibling;
        this._spinDown.setEnabled(false);
        this._spinUp.setEnabled(false);
        this._addAxisMenuItem.setEnabled(false);
        this._removeAxisAction.setEnabled(an.getChildCount() == 0);
        ViewportNode parent = (ViewportNode)an.getParent();
        int idx = parent.getIndex(an);
        if (idx == 0 && parent.getChildCount() == 2) {
            this._spinDown.setEnabled(true);
        } else if (idx == 1) {
            this._spinUp.setEnabled(true);
        }
        for (sibling = parent.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getChildCount() >= 2) continue;
            this._spinUp.setEnabled(true);
            break;
        }
        for (sibling = parent.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getChildCount() >= 2) continue;
            this._spinDown.setEnabled(true);
            break;
        }
    }

    protected void viewportNodeSelected(ViewportNode vpn) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._plotTree.getModel().getRoot();
        this._removeAxisAction.setEnabled(false);
        this._addAxisMenuItem.setEnabled(true);
        if (vpn.getChildCount() == 0) {
            this._removeViewportAction.setEnabled(true);
        } else {
            boolean removable = this.isViewportNodeRemovable(vpn);
            this._removeViewportAction.setEnabled(removable);
        }
        if (root.getChildCount() > 1) {
            if (root.getIndex(vpn) > 0) {
                this._spinUp.setEnabled(true);
            } else {
                this._spinUp.setEnabled(false);
            }
            if (root.getIndex(vpn) != root.getChildCount() - 1) {
                this._spinDown.setEnabled(true);
            } else {
                this._spinDown.setEnabled(false);
            }
        } else {
            this._spinUp.setEnabled(false);
            this._spinDown.setEnabled(false);
        }
    }

    private AxisNode getPreviousAxisForObj(G2dObjectNode node) {
        String units;
        AxisNode an2;
        AxisNode an = (AxisNode)node.getParent();
        String currentUnits = an.getUnits();
        ViewportNode vpn = (ViewportNode)an.getParent();
        if (vpn.getChildCount() == 2) {
            Enumeration<TreeNode> e = vpn.children();
            for (int i = 0; i < 2; ++i) {
                an2 = (AxisNode)e.nextElement();
                if (an2 == an) continue;
                units = an2.getUnits();
                if (units != null && !units.isEmpty() && currentUnits != null && !currentUnits.isEmpty() && !currentUnits.equals(units) || i != 0) break;
                return an2;
            }
        }
        if (vpn.getSiblingCount() > 0) {
            for (DefaultMutableTreeNode sibling = vpn.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
                if (sibling.getChildCount() <= 0) continue;
                Enumeration<TreeNode> e = sibling.children();
                while (e.hasMoreElements()) {
                    an2 = (AxisNode)e.nextElement();
                    units = an2.getUnits();
                    if (units != null && !units.isEmpty() && currentUnits != null && !currentUnits.isEmpty() && !currentUnits.equals(units)) continue;
                    return an2;
                }
            }
        }
        return null;
    }

    private AxisNode getNextAxisForObj(G2dObjectNode node) {
        String units;
        AxisNode an2;
        AxisNode an = (AxisNode)node.getParent();
        String currentUnits = an.getUnits();
        ViewportNode vpn = (ViewportNode)an.getParent();
        if (vpn.getChildCount() == 2) {
            Enumeration<TreeNode> e = vpn.children();
            for (int i = 0; i < 2; ++i) {
                an2 = (AxisNode)e.nextElement();
                if (an2 == an || (units = an2.getUnits()) != null && !units.isEmpty() && currentUnits != null && !currentUnits.isEmpty() && !currentUnits.equals(units) || i != 1) continue;
                return an2;
            }
        }
        if (vpn.getSiblingCount() > 0) {
            for (DefaultMutableTreeNode sibling = vpn.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getChildCount() <= 0) continue;
                Enumeration<TreeNode> e = sibling.children();
                while (e.hasMoreElements()) {
                    an2 = (AxisNode)e.nextElement();
                    units = an2.getUnits();
                    if (units != null && !units.isEmpty() && currentUnits != null && !currentUnits.isEmpty() && !currentUnits.equals(units)) continue;
                    return an2;
                }
            }
        }
        return null;
    }

    protected void addViewport() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._plotTree.getModel().getRoot();
        ViewportNode lastChild = (ViewportNode)root.getLastChild();
        Viewport v = new Viewport();
        v.setName(this.getNextViewportName(lastChild));
        ViewportNode vpn = new ViewportNode(v);
        root.add(vpn);
        int idx = root.getIndex(vpn);
        if (idx != -1) {
            this.intarray[0] = idx;
            ((DefaultTreeModel)this._plotTree.getModel()).nodesWereInserted(root, this.intarray);
            this._plotTree.expandPath(new TreePath(vpn.getPath()));
        }
        this.calculateViewportWeights();
        this.setModified(true);
    }

    protected void removeViewport() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._plotTree.getModel().getRoot();
        TreePath path = this._plotTree.getSelectionPath();
        if (path == null) {
            System.out.println("removeViewport: no path selected");
            return;
        }
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node == null) {
            System.out.println("removeViewport: no last Path component found");
            return;
        }
        if (!(node instanceof ViewportNode)) {
            System.out.println("removeViewport: selected node is not a Viewport");
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this._plotTree.getModel();
        ViewportNode vpn = (ViewportNode)node;
        boolean removable = this.isViewportNodeRemovable(vpn);
        if (!removable) {
            System.out.println("removeViewport: viewport not removable");
            return;
        }
        int idx = root.getIndex(vpn);
        root.remove(vpn);
        if (idx != -1) {
            this.intarray[0] = idx;
            model.nodesWereRemoved(root, this.intarray, new Object[]{vpn});
        }
        this.calculateViewportWeights();
        this.setModified(true);
    }

    private void calculateViewportWeights() {
        ViewportNode vpn;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._plotTree.getModel().getRoot();
        DefaultTreeModel model = (DefaultTreeModel)this._plotTree.getModel();
        double sum = 0.0;
        double[] weights = new double[root.getChildCount()];
        double[] weightPercents = new double[weights.length];
        Enumeration<TreeNode> e = root.children();
        int i = 0;
        while (e.hasMoreElements()) {
            vpn = (ViewportNode)e.nextElement();
            weights[i] = vpn.getWeight();
            sum += weights[i];
            ++i;
        }
        e = root.children();
        i = 0;
        while (e.hasMoreElements()) {
            vpn = (ViewportNode)e.nextElement();
            weightPercents[i] = weights[i] / sum;
            int n = i;
            weightPercents[n] = weightPercents[n] * 100.0;
            vpn.setWeightPercent(weightPercents[i++]);
            model.nodeChanged(vpn);
        }
    }

    protected String getNextViewportName(ViewportNode lastChild) {
        String name = lastChild.toString();
        int idx = name.indexOf(40);
        int idx2 = name.indexOf(44, idx);
        String row = name.substring(idx + 1, idx2);
        int nextRow = RMAIO.parseInt(row);
        return "Viewport (" + ++nextRow + ",1)";
    }

    public void reverseAxis() {
        AxisNode an;
        TreePath path = this._plotTree.getSelectionPath();
        if (path == null) {
            System.out.println("reverseAxis: no path selected");
            return;
        }
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node == null) {
            System.out.println("reverseAxis: no last Path component found");
            return;
        }
        if (!(node instanceof AxisNode)) {
            System.out.println("reverseAxis: selected node is not an Axis");
            return;
        }
        an.setReversed(!(an = (AxisNode)node).isReversed());
        this.setModified(true);
    }

    protected void removeAxis() {
        int idx;
        TreePath path = this._plotTree.getSelectionPath();
        if (path == null) {
            System.out.println("removeAxis: no path selected");
            return;
        }
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node == null) {
            System.out.println("removeAxis: no last Path component found");
            return;
        }
        if (!(node instanceof AxisNode)) {
            System.out.println("removeAxis: selected node is not an Axis");
            return;
        }
        AxisNode an = (AxisNode)node;
        if (an.getChildCount() > 0) {
            JOptionPane.showMessageDialog(this, "Cannot remove an Axis that still has Curves", "Remove Axis Error", 0);
            return;
        }
        MutableTreeNode parent = (MutableTreeNode)an.getParent();
        this.intarray[0] = idx = parent.getIndex((AxisNode)node);
        parent.remove((AxisNode)node);
        ((DefaultTreeModel)this._plotTree.getModel()).nodesWereRemoved(parent, this.intarray, new Object[]{node});
        this.setModified(true);
    }

    protected void addAxis() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._plotTree.getModel().getRoot();
        TreePath path = this._plotTree.getSelectionPath();
        if (path == null) {
            System.out.println("addAxis: no path selected");
            return;
        }
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node == null) {
            System.out.println("addAxis: no last Path component found");
            return;
        }
        ViewportNode vpn = null;
        if (node instanceof ViewportNode) {
            vpn = (ViewportNode)node;
        } else if (node instanceof AxisNode) {
            vpn = (ViewportNode)node.getParent();
        } else if (node instanceof G2dObjectNode) {
            vpn = (ViewportNode)node.getParent().getParent();
        }
        if (vpn == null) {
            System.out.println("Can't find ViewportNode to add Axis to");
            return;
        }
        if (vpn.getChildCount() == 2) {
            JOptionPane.showMessageDialog(this, "Viewports can have a maximum of 2 Axis.", "Add Axis Error", 2);
            return;
        }
        Axis axis = AxisFactory.createAxis(0, "");
        axis.setReversed(true);
        AxisNode an = new AxisNode(axis);
        vpn.add(an);
        int idx = vpn.getIndex(an);
        if (idx != -1) {
            this.intarray[0] = idx;
            ((DefaultTreeModel)this._plotTree.getModel()).nodesWereInserted(vpn, this.intarray);
        }
        this.setModified(true);
    }

    protected boolean isViewportNodeRemovable(ViewportNode vpn) {
        for (int i = 0; i < vpn.getChildCount(); ++i) {
            AxisNode an = (AxisNode)vpn.getChildAt(i);
            Enumeration<TreeNode> e = an.children();
            if (!e.hasMoreElements()) continue;
            return false;
        }
        return true;
    }

    protected boolean saveForm() {
        if (this._parent == null) {
            System.out.println("saveForm() WARNING: Calling dialog not a G2dDialog");
            return false;
        }
        if (!this.isModified()) {
            return true;
        }
        this.setModified(false);
        return this.buildPlot(this._parent, (DefaultMutableTreeNode)this._plotTree.getModel().getRoot());
    }

    boolean buildPlot(G2dDialog g2dDialog, DefaultMutableTreeNode selectedRoot) {
        Viewport[] viewports;
        ViewportNode vpnode;
        int i;
        for (i = 0; i < selectedRoot.getChildCount(); ++i) {
            vpnode = (ViewportNode)selectedRoot.getChildAt(i);
            boolean foundData = false;
            for (int zz = 0; zz < vpnode.getChildCount(); ++zz) {
                AxisNode axisNode = (AxisNode)vpnode.getChildAt(zz);
                if (axisNode.getChildCount() <= 0) continue;
                foundData = true;
            }
            if (foundData) continue;
            selectedRoot.remove(vpnode);
            --i;
        }
        int size = selectedRoot.getChildCount();
        G2dPanel panel = g2dDialog._gfxPanel;
        LegendPanel lPanel = panel.getLegendPanel();
        LegendPanelProp lProperties = null;
        if (lPanel != null) {
            lProperties = lPanel.getProperties();
        }
        panel.clearPanel();
        boolean[] showxtics = new boolean[]{false, false};
        boolean[] showxscroll = new boolean[]{false, false};
        boolean[] showxlabel = new boolean[]{false, false};
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        ViewportToolbar tb = new ViewportToolbar(panel);
        panel.createDefaultMapTools(tb);
        tb.addToolbarListener(panel);
        if (lPanel != null) {
            panel._legend = new LegendPanel(panel, lProperties);
            panel._legend.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        Vector<G2dObject> g2dObjects = new Vector<G2dObject>();
        Vector<G2dLineProperties> lineProps = new Vector<G2dLineProperties>();
        Vector colorvec = new Vector();
        double defWeight = 100.0 / (double)size;
        int prevObjSize = 0;
        String yname = null;
        Axis[] xaxis = new Axis[2];
        xaxis[0] = AxisFactory.createAxis(1, "minutes");
        for (i = 0; i < size; ++i) {
            boolean addViewport = false;
            vpnode = (ViewportNode)selectedRoot.getChildAt(i);
            if (vpnode.getChildCount() == 0) continue;
            if (i == size - 1) {
                showxtics[0] = true;
                showxscroll[0] = true;
            }
            for (int v = 0; v < vpnode.getChildCount(); ++v) {
                if (vpnode.getChildAt(v).getChildCount() <= 0) continue;
                addViewport = true;
                break;
            }
            if (!addViewport) continue;
            Hashtable<Integer, Axis> masterAxisTable = new Hashtable<Integer, Axis>();
            Viewport viewport = vpnode.getViewport();
            viewport._scaleVector.clear();
            int axisCnt = vpnode.getChildCount();
            Axis[] yaxis = new Axis[axisCnt];
            Scale[] scale = new Scale[axisCnt];
            boolean[] showytics = new boolean[axisCnt];
            boolean[] showylabel = new boolean[axisCnt];
            g2dObjects.clear();
            lineProps.clear();
            Hashtable scaleToG2dObject = new Hashtable();
            Hashtable scaleToLineProps = new Hashtable();
            for (int j = 0; j < axisCnt; ++j) {
                boolean reversed = true;
                Vector yObjs = new Vector();
                AxisNode anode = (AxisNode)vpnode.getChildAt(j);
                int paramId = anode.getParamId();
                Vector<G2dObject> g2dObjects2 = new Vector<G2dObject>();
                Vector<G2dLineProperties> lineProps2 = new Vector<G2dLineProperties>();
                if (anode.getChildCount() == 0) {
                    yname = "";
                } else {
                    int k;
                    for (k = 0; k < anode.getChildCount(); ++k) {
                        g2dObjects2.addElement(null);
                        lineProps2.addElement(null);
                    }
                    for (k = anode.getChildCount() - 1; k >= 0; --k) {
                        G2dObjectNode objNode = (G2dObjectNode)anode.getChildAt(k);
                        G2dObject go = objNode.getG2dObject();
                        G2dLineProperties props = objNode.getProperties();
                        g2dObjects.add(go);
                        g2dObjects2.setElementAt(go, k);
                        lineProps2.setElementAt(props, k);
                        lineProps.add(props);
                        DataType dataType = DataTypeFactory.getFactory().getDataType(go);
                        yname = panel.getYName(go, dataType);
                    }
                }
                showytics[j] = true;
                showylabel[j] = true;
                Axis axis = anode.getAxis();
                axis.invalidateWorldExtents();
                if (j == 0) {
                    masterAxisTable.put(new Integer(1), axis);
                }
                String paramString = Parameter.getParamString(anode.getParamId());
                axis.setName(yname);
                axis.setParameterId(paramId);
                if (g2dObjects.size() == 0) {
                    showytics[j] = false;
                    showylabel[j] = false;
                }
                yaxis[j] = axis;
                scale[j] = new Scale(yname.concat(" vs minutes"));
                scaleToG2dObject.put(scale[j], g2dObjects2);
                scaleToLineProps.put(scale[j], lineProps2);
                scale[j].setAxis(xaxis[0], 0);
                scale[j].setAxis(yaxis[j], 1);
            }
            Viewport vp = panel.buildPlotComponents(0, i, 1.0, vpnode.getWeight(), xaxis, yaxis, scale, showxtics, showxlabel, showxscroll[0], showytics, showylabel, true);
            vp.setProperties(viewport.getProperties());
            vp.setMasterAxisTable(masterAxisTable);
            for (int k = 0; k < scale.length; ++k) {
                Vector objects = (Vector)scaleToG2dObject.get(scale[k]);
                Vector lprops = (Vector)scaleToLineProps.get(scale[k]);
                for (int zz = 0; objects != null && zz < objects.size(); ++zz) {
                    vp.addG2dObject((G2dObject)objects.get(zz), (G2dLineProperties)lprops.get(zz), scale[k]);
                }
            }
            prevObjSize += g2dObjects.size();
            tb.addViewport(vp);
            tb.addToolbarListener(vp);
            panel._legend.addViewport(vp);
            vp.addObjectSelectionListener(panel);
            panel._viewportVector.add(vp);
        }
        Insets insets = new Insets(3, 3, 3, 3);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 0;
        gc.fill = 3;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.insets = insets;
        gridbag.setConstraints(tb, gc);
        panel.add(tb);
        panel.addLegendContainers();
        if (lProperties != null) {
            panel.moveLegendToPosition(lProperties.legendPosition);
        }
        Component[] comps = panel.getComponents();
        for (i = 0; comps != null && i < comps.length; ++i) {
            if (!(comps[i] instanceof AxisTics)) continue;
            tb.addToolbarListener((G2dComponent)comps[i]);
        }
        gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 0;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 0, 0, 0);
        for (Viewport viewport1 : viewports = panel.getViewports()) {
            Vector scaleList = viewport1.getScaleVector();
            for (Object scale1 : scaleList) {
                panel.addScaleToTable(((Scale)scale1).getName(), (Scale)scale1);
            }
        }
        panel.add((Component)panel._title, gc);
        g2dDialog.updateUnitSystem(panel);
        panel.setTimeZone(ServiceLookup.getTimeZoneDisplayService().getTimeZone());
        panel.revalidate();
        panel.paintGfx();
        return true;
    }

    protected void closeForm() {
        if (this.isModified()) {
            int opt = JOptionPane.showConfirmDialog(this, "Save Changes to Plot Layout?", "Save Changes?", 1);
            if (opt == 0) {
                this.saveForm();
            } else if (opt == 2) {
                return;
            }
        }
        this.setVisible(false);
    }

    void spinUp() {
        TreePath path = this._plotTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(this, "Please select a Viewport, Axis or Data Set to move");
            return;
        }
        Object node = path.getLastPathComponent();
        if (node instanceof ViewportNode) {
            this.spinUp((ViewportNode)node, path);
        } else if (node instanceof AxisNode) {
            this.spinUp((AxisNode)node, path);
        } else if (node instanceof G2dObjectNode) {
            this.spinUp((G2dObjectNode)node, path);
        }
    }

    void spinUp(G2dObjectNode node, TreePath path) {
        AxisNode dest = this.getPreviousAxisForObj(node);
        if (dest == null) {
            System.out.println("spinDown: no Axis found to move " + node + " to.");
            return;
        }
        AxisNode parent = (AxisNode)node.getParent();
        int idx = parent.getIndex(node);
        parent.remove(node);
        this.intarray[0] = idx;
        ((DefaultTreeModel)this._plotTree.getModel()).nodesWereRemoved(parent, this.intarray, new Object[]{node});
        if (dest == parent) {
            parent.insert(node, 0);
        } else {
            dest.add(node);
        }
        this.intarray[0] = idx = dest.getIndex(node);
        ((DefaultTreeModel)this._plotTree.getModel()).nodesWereInserted(dest, this.intarray);
        boolean expanded = this._plotTree.isExpanded(path);
        path = new TreePath(node.getPath());
        this._plotTree.expandRow(this._plotTree.getRowForPath(path));
        this._plotTree.setSelectionPath(path);
        this.setModified(true);
    }

    void spinUp(AxisNode anode, TreePath path) {
        int cnt;
        DefaultMutableTreeNode parent;
        DefaultTreeModel model = (DefaultTreeModel)this._plotTree.getModel();
        DefaultMutableTreeNode dest = parent = (DefaultMutableTreeNode)anode.getParent();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._plotTree.getModel().getRoot();
        int idx = parent.getIndex(anode);
        if (idx == 0) {
            DefaultMutableTreeNode sibling;
            for (sibling = parent.getPreviousSibling(); sibling != null && sibling.getChildCount() == 2; sibling = sibling.getPreviousSibling()) {
            }
            if (sibling == null) {
                System.out.println("No Viewport Sibling found to move Axis to");
                return;
            }
            dest = sibling;
        }
        if ((cnt = this._plotTree.getModel().getChildCount(root)) == 1) {
            return;
        }
        boolean expanded = this._plotTree.isExpanded(path);
        parent.remove(anode);
        this.intarray[0] = idx;
        model.nodesWereRemoved(parent, this.intarray, new Object[]{anode});
        if (dest == parent) {
            dest.insert(anode, idx - 1);
        } else {
            dest.add(anode);
        }
        this.intarray[0] = idx = dest.getIndex(anode);
        model.nodesWereInserted(dest, this.intarray);
        if (expanded) {
            path = new TreePath(anode.getPath());
            this._plotTree.expandPath(path);
        }
        this._plotTree.setSelectionPath(path);
        Enumeration<TreeNode> e = dest.children();
        while (e.hasMoreElements()) {
            anode = (AxisNode)e.nextElement();
            model.nodeChanged(anode);
        }
        this.setModified(true);
    }

    void spinUp(ViewportNode vnode, TreePath path) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)vnode.getParent();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._plotTree.getModel().getRoot();
        int idx = parent.getIndex(vnode);
        if (idx == 0) {
            return;
        }
        int cnt = this._plotTree.getModel().getChildCount(root);
        if (cnt == 1) {
            return;
        }
        boolean expanded = this._plotTree.isExpanded(path);
        parent.remove(vnode);
        this.intarray[0] = idx;
        ((DefaultTreeModel)this._plotTree.getModel()).nodesWereRemoved(parent, this.intarray, new Object[]{vnode});
        parent.insert(vnode, idx - 1);
        this.intarray[0] = idx - 1;
        ((DefaultTreeModel)this._plotTree.getModel()).nodesWereInserted(parent, this.intarray);
        if (expanded) {
            path = new TreePath(vnode.getPath());
            this._plotTree.expandPath(path);
        }
        this._plotTree.setSelectionPath(path);
        this.setModified(true);
    }

    void spinDown() {
        TreePath path = this._plotTree.getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(this, "Please select a Viewport, Axis or Data Set to move");
            return;
        }
        Object node = path.getLastPathComponent();
        DefaultMutableTreeNode vnode = (DefaultMutableTreeNode)node;
        if (node instanceof ViewportNode) {
            this.spinDown((ViewportNode)node, path);
        } else if (node instanceof AxisNode) {
            this.spinDown((AxisNode)node, path);
        } else if (node instanceof G2dObjectNode) {
            this.spinDown((G2dObjectNode)node, path);
        }
    }

    void spinDown(G2dObjectNode node, TreePath path) {
        AxisNode dest = this.getNextAxisForObj(node);
        if (dest == null) {
            System.out.println("spinDown: no Axis found to move " + node + " to.");
            return;
        }
        AxisNode parent = (AxisNode)node.getParent();
        int idx = parent.getIndex(node);
        parent.remove(node);
        this.intarray[0] = idx;
        ((DefaultTreeModel)this._plotTree.getModel()).nodesWereRemoved(parent, this.intarray, new Object[]{node});
        dest.add(node);
        this.intarray[0] = idx = dest.getIndex(node);
        ((DefaultTreeModel)this._plotTree.getModel()).nodesWereInserted(dest, this.intarray);
        boolean expanded = this._plotTree.isExpanded(path);
        path = new TreePath(node.getPath());
        this._plotTree.expandRow(this._plotTree.getRowForPath(path));
        this._plotTree.setSelectionPath(path);
        this.setModified(true);
    }

    void spinDown(AxisNode anode, TreePath path) {
        int cnt;
        DefaultMutableTreeNode parent;
        DefaultTreeModel model = (DefaultTreeModel)this._plotTree.getModel();
        DefaultMutableTreeNode dest = parent = (DefaultMutableTreeNode)anode.getParent();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._plotTree.getModel().getRoot();
        int idx = parent.getIndex(anode);
        if (idx == 1 || parent.getChildCount() == 1) {
            DefaultMutableTreeNode sibling;
            for (sibling = parent.getNextSibling(); sibling != null && sibling.getChildCount() == 2; sibling = sibling.getNextSibling()) {
            }
            if (sibling == null) {
                System.out.println("No Viewport Sibling found to move Axis to");
                return;
            }
            dest = sibling;
        }
        if ((cnt = this._plotTree.getModel().getChildCount(root)) == 1) {
            return;
        }
        boolean expanded = this._plotTree.isExpanded(path);
        parent.remove(anode);
        this.intarray[0] = idx;
        model.nodesWereRemoved(parent, this.intarray, new Object[]{anode});
        if (dest == parent) {
            dest.add(anode);
        } else {
            dest.insert(anode, 0);
        }
        this.intarray[0] = idx = dest.getIndex(anode);
        model.nodesWereInserted(dest, this.intarray);
        if (expanded) {
            path = new TreePath(anode.getPath());
            this._plotTree.expandPath(path);
        }
        this._plotTree.setSelectionPath(path);
        Enumeration<TreeNode> e = dest.children();
        while (e.hasMoreElements()) {
            anode = (AxisNode)e.nextElement();
            model.nodeChanged(anode);
        }
        this.setModified(true);
    }

    void spinDown(ViewportNode vnode, TreePath path) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)vnode.getParent();
        int idx = parent.getIndex(vnode);
        int cnt = this._plotTree.getModel().getChildCount(parent);
        if (cnt == 1) {
            return;
        }
        if (idx + 1 == cnt) {
            return;
        }
        boolean expanded = this._plotTree.isExpanded(path);
        parent.remove(vnode);
        this.intarray[0] = idx;
        ((DefaultTreeModel)this._plotTree.getModel()).nodesWereRemoved(parent, this.intarray, new Object[]{vnode});
        parent.insert(vnode, idx + 1);
        this.intarray[0] = idx + 1;
        ((DefaultTreeModel)this._plotTree.getModel()).nodesWereInserted(parent, this.intarray);
        if (expanded) {
            path = new TreePath(vnode.getPath());
            this._plotTree.expandPath(path);
        }
        this._plotTree.setSelectionPath(path);
        this.setModified(true);
    }

    @Override
    public void setModified(boolean b) {
        super.setModified(b);
        this._saveMenuItem.setEnabled(b);
    }

    void setViewportWeights() {
        ViewportWeightsDialog dialog = new ViewportWeightsDialog(this, true);
        dialog.fillForm((DefaultMutableTreeNode)this._plotTree.getModel().getRoot());
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        LayoutPlotDialog d = new LayoutPlotDialog(new G2dDialog(), false);
        d.setVisible(true);
    }

    public class PlotTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private HashMap _iconMap = new HashMap();
        private Icon _viewportIcon = RmaImage.getImageIcon("Images/Viewport.gif");
        private Icon _axisIcon;
        private Icon _axisIconNormal;
        private Icon _axisIconReversed;
        private Icon _lineIcon;

        public PlotTreeCellRenderer() {
            if (this._viewportIcon != null) {
                this._iconMap.put(ViewportNode.class, this._viewportIcon);
            }
            this._axisIcon = RmaImage.getImageIcon("Images/YAxis.gif");
            if (this._axisIcon != null) {
                this._iconMap.put(AxisNode.class, this._axisIcon);
            }
            this._axisIconReversed = RmaImage.getImageIcon("Images/YAxisReversed.gif");
            this._axisIconNormal = RmaImage.getImageIcon("Images/YAxisNormal.gif");
            this._lineIcon = RmaImage.getImageIcon("Images/Line.gif");
            if (this._lineIcon != null) {
                this._iconMap.put(G2dObjectNode.class, this._lineIcon);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
            this.hasFocus = hasFocus;
            this.setText(stringValue);
            if (sel) {
                this.setForeground(this.getTextSelectionColor());
            } else {
                this.setForeground(this.getTextNonSelectionColor());
            }
            if (!tree.isEnabled()) {
                this.setEnabled(false);
                if (leaf) {
                    this.setDisabledIcon(this.getLeafIcon(value, row));
                } else if (expanded) {
                    this.setDisabledIcon(this.getOpenIcon(value, row));
                } else {
                    this.setDisabledIcon(this.getClosedIcon(value, row));
                }
            } else {
                this.setEnabled(true);
                if (leaf) {
                    this.setIcon(this.getLeafIcon(value, row));
                } else if (expanded) {
                    this.setIcon(this.getOpenIcon(value, row));
                } else {
                    this.setIcon(this.getClosedIcon(value, row));
                }
            }
            this.setComponentOrientation(tree.getComponentOrientation());
            this.selected = sel;
            return this;
        }

        Icon getLeafIcon(Object value, int row) {
            if (value == null) {
                return super.getLeafIcon();
            }
            Icon icon = this.getIcon(value, row);
            if (icon == null) {
                return super.getLeafIcon();
            }
            return icon;
        }

        Icon getOpenIcon(Object value, int row) {
            if (value == null) {
                return super.getOpenIcon();
            }
            Icon icon = this.getIcon(value, row);
            if (icon == null) {
                return super.getOpenIcon();
            }
            return icon;
        }

        Icon getClosedIcon(Object value, int row) {
            if (value == null) {
                return super.getClosedIcon();
            }
            Icon icon = this.getIcon(value, row);
            if (icon == null) {
                return super.getClosedIcon();
            }
            return icon;
        }

        Icon getIcon(Object value, int row) {
            AxisNode an;
            Class<?> cls = value.getClass();
            Icon icon = null;
            if (value instanceof AxisNode && (an = (AxisNode)value).getChildCount() != 0) {
                if (!an.isReversed()) {
                    return this._axisIconReversed;
                }
                return this._axisIconNormal;
            }
            icon = (Icon)this._iconMap.get(cls);
            return icon;
        }
    }

    private class ViewportNode
    extends DefaultMutableTreeNode
    implements PopupTreeNode {
        private double _weight;
        private double _weightPercent;

        ViewportNode(Viewport v) {
            super(v, true);
            this._weight = 1.0;
            this._weightPercent = 0.0;
            if (v != null) {
                if (v._scaleVector.size() == 0) {
                    Axis axis = AxisFactory.createAxis(0, "");
                    axis.setReversed(true);
                    AxisNode an = new AxisNode(axis);
                    this.add(an);
                } else {
                    for (int i = 0; i < v._scaleVector.size(); ++i) {
                        AxisNode an;
                        Scale scale = (Scale)v._scaleVector.get(i);
                        Axis axis = scale.getAxis(1);
                        if (axis != null) {
                            int paramId = axis.getParameterId();
                            an = new AxisNode(axis);
                            an.setParamId(paramId);
                        } else {
                            an = new AxisNode(AxisFactory.createAxis(0, ""));
                        }
                        this.add(an);
                    }
                }
            } else {
                Axis axis = AxisFactory.createAxis(0, "");
                axis.setReversed(true);
                AxisNode an = new AxisNode(axis);
                this.add(an);
            }
        }

        public void setWeight(double weight) {
            this._weight = weight;
        }

        public double getWeight() {
            return this._weight;
        }

        public void setWeightPercent(double weightPercent) {
            this._weightPercent = weightPercent;
        }

        public double getWeightPercent() {
            return this._weightPercent;
        }

        @Override
        public String toString() {
            Viewport vp = this.getViewport();
            return vp.toString() + " (" + (int)this.getWeightPercent() + "%)";
        }

        public Viewport getViewport() {
            return (Viewport)this.getUserObject();
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (LayoutPlotDialog.this._viewportPopup == null) {
                LayoutPlotDialog.this._viewportPopup = new JPopupMenu();
                LayoutPlotDialog.this._viewportPopup.add(new JLabel("      " + this.toString()));
                LayoutPlotDialog.this._viewportPopup.addSeparator();
                JMenuItem menuItem = new JMenuItem("Add Axis");
                menuItem.addActionListener(e -> LayoutPlotDialog.this.addAxis());
                LayoutPlotDialog.this._viewportPopup.add(menuItem);
                LayoutPlotDialog.this._viewportPopup.addSeparator();
                menuItem = new JMenuItem("Move Up");
                menuItem.addActionListener(e -> LayoutPlotDialog.this.spinUp());
                LayoutPlotDialog.this._viewportPopup.add(menuItem);
                menuItem = new JMenuItem("Move Down");
                menuItem.addActionListener(e -> LayoutPlotDialog.this.spinDown());
                LayoutPlotDialog.this._viewportPopup.add(menuItem);
                LayoutPlotDialog.this._viewportPopup.addSeparator();
                menuItem = LayoutPlotDialog.this._viewportPopup.add(LayoutPlotDialog.this._removeViewportAction);
                menuItem.setLabel("Remove");
            } else {
                JLabel label = (JLabel)LayoutPlotDialog.this._viewportPopup.getComponent(0);
                label.setText("      " + this.toString());
            }
            return LayoutPlotDialog.this._viewportPopup;
        }
    }

    private class AxisNode
    extends DefaultMutableTreeNode
    implements PopupTreeNode {
        private String _name;
        private String _units;

        AxisNode(Axis a) {
            super(a);
            this._units = "";
        }

        public Axis getAxis() {
            return (Axis)this.getUserObject();
        }

        public String getUnits() {
            AxisNode axisNode = this;
            int unitSysId = axisNode.LayoutPlotDialog.this.getUnitSystem();
            String units = this.getAxis().getDisplayUnitsString(unitSysId);
            if (units == null || units.isEmpty() || "undef".equals(units)) {
                G2dObjectNode oNode;
                G2dObject obj;
                if (this.getChildCount() > 0 && (obj = (oNode = (G2dObjectNode)this.getChildAt(0)).getG2dObject()) instanceof G2dData) {
                    G2dData data = (G2dData)obj;
                    return data.yunits;
                }
                return null;
            }
            return units;
        }

        void setUnitsString(int paramId) {
            AxisNode axisNode = this;
            int unitSysId = axisNode.LayoutPlotDialog.this.getUnitSystem();
            if (!Units.isValidUnitsSystem(unitSysId)) {
                return;
            }
            String unitsString = Parameter.getUnitsStringForSystem(paramId, unitSysId);
            if (unitsString != null) {
                int idx = this.getParent().getIndex(this);
                this._name = AXIS_LABELS[idx].concat("(").concat(unitsString).concat(")");
            }
        }

        public int getParamId() {
            return this.getAxis().getParameterId();
        }

        public void setParamId(int paramId) {
            if (paramId != -1) {
                this.getAxis().setParameterId(paramId);
            }
            this._name = null;
        }

        @Override
        public String toString() {
            int idx = this.getParent().getIndex(this);
            if (this.getChildCount() > 0) {
                if (this.getParamId() == -1 || this._name == null) {
                    G2dObjectNode oNode = (G2dObjectNode)this.getChildAt(0);
                    G2dObject obj = oNode.getG2dObject();
                    AxisNode axisNode = this;
                    int unitSysId = axisNode.LayoutPlotDialog.this.getUnitSystem();
                    int paramId = obj.getYParameterId();
                    this.setParamId(paramId);
                    String unitsString = this.getUnits();
                    if (unitsString != null) {
                        this._name = AXIS_LABELS[idx] + " (".concat(unitsString).concat(")");
                    } else if (obj instanceof G2dData) {
                        G2dData data = (G2dData)obj;
                        this._name = AXIS_LABELS[idx] + " (".concat(data.yunits).concat(")");
                    }
                    return this._name;
                }
                if (this.getParamId() != -1) {
                    this.setUnitsString(this.getParamId());
                }
            }
            if (this._name != null) {
                return this._name;
            }
            return AXIS_LABELS[idx];
        }

        @Override
        public void remove(MutableTreeNode node) {
            super.remove(node);
            if (this.getChildCount() == 0) {
                this.getAxis().setParameterId(-1);
                this._name = null;
            }
        }

        @Override
        public void remove(int i) {
            super.remove(i);
            if (this.getChildCount() == 0) {
                this.getAxis().setParameterId(-1);
                this._name = null;
            }
        }

        @Override
        public void removeAllChildren() {
            super.removeAllChildren();
            this.getAxis().setParameterId(-1);
            this._name = null;
        }

        public boolean isReversed() {
            return this.getAxis().getReversed();
        }

        public void setReversed(boolean b) {
            this.getAxis().setReversed(b);
            ((DefaultTreeModel)LayoutPlotDialog.this._plotTree.getModel()).nodeChanged(this);
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (LayoutPlotDialog.this._axisPopup == null) {
                LayoutPlotDialog.this._axisPopup = new JPopupMenu();
                LayoutPlotDialog.this._axisPopup.add(new JLabel("      " + this.toString()));
                LayoutPlotDialog.this._axisPopup.addSeparator();
                JMenuItem menuItem = new JMenuItem("Reverse");
                menuItem.addActionListener(e -> LayoutPlotDialog.this.reverseAxis());
                LayoutPlotDialog.this._axisPopup.add(menuItem);
                menuItem = new JMenuItem("Move Up");
                menuItem.addActionListener(e -> LayoutPlotDialog.this.spinUp());
                LayoutPlotDialog.this._axisPopup.add(menuItem);
                menuItem = new JMenuItem("Move Down");
                menuItem.addActionListener(e -> LayoutPlotDialog.this.spinDown());
                LayoutPlotDialog.this._axisPopup.add(menuItem);
                LayoutPlotDialog.this._axisPopup.addSeparator();
                menuItem = LayoutPlotDialog.this._axisPopup.add(LayoutPlotDialog.this._removeAxisAction);
                menuItem.setLabel("Remove");
            } else {
                JLabel label = (JLabel)LayoutPlotDialog.this._axisPopup.getComponent(0);
                label.setText("      " + this.toString());
            }
            return LayoutPlotDialog.this._axisPopup;
        }
    }

    class G2dObjectNode
    extends DefaultMutableTreeNode {
        private G2dLineProperties _props;

        G2dObjectNode(G2dObject obj, G2dLineProperties props) {
            super(obj);
            this._props = props;
        }

        public G2dObject getG2dObject() {
            return (G2dObject)this.getUserObject();
        }

        public G2dLineProperties getProperties() {
            return this._props;
        }
    }

    class ViewportWeightsDialog
    extends RmaJDialog {
        private RmaJTable _weightsTable;
        private ButtonCmdPanel _cmdPanel;
        private DefaultMutableTreeNode _root;

        ViewportWeightsDialog(Dialog owner, boolean modal) {
            super(owner, modal);
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Set Plot Viewport Weights");
            this._weightsTable = new RmaJTable(this, new String[]{"Viewport", "Weight(%)"}){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 100;
                    d.width = 200;
                    return d;
                }
            };
            this._weightsTable.setColumnEnabled(false, 0);
            RmaJDecimalField field = this._weightsTable.setDoubleCellEditor(1);
            field.setMinValue(0.0);
            field.setMaxValue(100.0);
            this._weightsTable.setColumnWidths(150, 50);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 2.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)this._weightsTable.getScrollPane(), gbc);
            this._cmdPanel = new ButtonCmdPanel(14);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 16;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            this.getContentPane().add((Component)this._cmdPanel, gbc);
            this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

                @Override
                public void buttonCmdActionPerformed(ActionEvent e) {
                    switch (e.getID()) {
                        case 8: {
                            if (!ViewportWeightsDialog.this.saveForm()) break;
                            ViewportWeightsDialog.this.setModified(false);
                            LayoutPlotDialog.this.setModified(true);
                            ViewportWeightsDialog.this.setVisible(false);
                            break;
                        }
                        case 2: {
                            if (!ViewportWeightsDialog.this.saveForm()) break;
                            ViewportWeightsDialog.this.setModified(false);
                            LayoutPlotDialog.this.setModified(true);
                            break;
                        }
                        case 4: {
                            ViewportWeightsDialog.this.setVisible(false);
                        }
                    }
                }
            });
            this.pack();
            this.setLocation();
        }

        public void fillForm(DefaultMutableTreeNode root) {
            this._root = root;
            this._weightsTable.deleteCells();
            if (root == null) {
                return;
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                TreeNode node = root.getChildAt(i);
                if (!(node instanceof ViewportNode)) continue;
                ViewportNode vpnode = (ViewportNode)node;
                Vector<Object> row = new Vector<Object>(1);
                row.add(node);
                if (vpnode.getWeight() > 0.0) {
                    row.add(new Double(vpnode.getWeightPercent()));
                }
                this._weightsTable.appendRow(row);
            }
            int rowCnt = this._weightsTable.getRowCount();
            double total = 100.0;
            IntVector iv = new IntVector(rowCnt);
            for (int i = 0; i < rowCnt; ++i) {
                Object obj = this._weightsTable.getCell(i, 1);
                if (obj == null || obj.toString().length() == 0) {
                    iv.add(i);
                    continue;
                }
                String s = obj.toString();
                total = RMAIO.parseDouble(s, 0.0);
            }
            int size = iv.size();
            if (size > 0) {
                if (total > 100.0) {
                    total = 100 - size;
                }
                int each = (int)total / size;
                for (int i = 0; i < size; ++i) {
                    this._weightsTable.setCell(new Double(each), iv.get(i), 1);
                }
            }
            this.setModified(false);
        }

        public boolean saveForm() {
            ViewportNode node;
            this._weightsTable.commitEdit(true);
            this._weightsTable.commitEdit(true);
            int rowCnt = this._weightsTable.getRowCount();
            DoubleVector iv = new DoubleVector(rowCnt);
            for (int i = 0; i < rowCnt; ++i) {
                node = (ViewportNode)this._weightsTable.getCell(i, 0);
                Object obj = this._weightsTable.getCell(i, 1);
                if (obj == null || obj.toString().length() == 0) {
                    JOptionPane.showMessageDialog(this, "Please enter a weight for the Plot Region " + node);
                    return false;
                }
                iv.add(RMAIO.parseDouble(obj.toString()));
            }
            int total = (int)iv.elementTotal();
            if (total > 100 || (double)total < 99.9) {
                JOptionPane.showMessageDialog(this, "Viewport Weights must add up to 100");
                return false;
            }
            double max = iv.getMax();
            for (int i = 0; i < rowCnt; ++i) {
                node = (ViewportNode)this._weightsTable.getCell(i, 0);
                node.setWeightPercent(iv.get(i));
                node.setWeight(iv.get(i) / max);
            }
            this.fillForm(this._root);
            return true;
        }
    }
}

