/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.LabelLayoutConstants;
import hec.gfx2d.LabelPropertiesPanel;
import hec.gfx2d.components.CheckBoxPanel;
import hec.gfx2d.components.IconPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;

class LegendBlockPropertiesPanel
extends LabelPropertiesPanel {
    private CheckBoxPanel _showLabelPanel;
    private JSeparator _topSep;
    private boolean _showIconPanel;
    private IconPanel _selectIconPanel;
    private EnabledJPanel _alignPanel;
    private RmaJComboBox _alignCombo;

    public LegendBlockPropertiesPanel(String checkBoxText, boolean showIconPanel) {
        this._showIconPanel = showIconPanel;
        this._showLabelPanel.setText(checkBoxText);
        if (!this._showIconPanel) {
            this._selectIconPanel.setVisible(false);
        }
    }

    @Override
    protected void buildControls() {
        super.buildControls();
        this.setName("Title");
        this._showLabelPanel = new CheckBoxPanel("Draw Legend Title");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._showLabelPanel, gbc);
        this._topSep = new JSeparator();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._topSep, gbc);
        this._selectIconPanel = new IconPanel();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._selectIconPanel, gbc);
        this._alignPanel = new EnabledJPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._alignPanel, gbc);
        JLabel label = new JLabel("Alignment:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._alignPanel.add((Component)label, gbc);
        this._alignCombo = new RmaJComboBox<String>(LabelLayoutConstants.LABEL_ALIGN_NAMES);
        this._alignCombo.setModifiable(true);
        label.setLabelFor(this._alignCombo);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._alignPanel.add((Component)this._alignCombo, gbc);
        this.setAllLabelsCheckVisible(false);
        this.setComponentsEnabled(this._showLabelPanel.isSelected());
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this._showLabelPanel.addComponentPanel(this);
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        super.setComponentsEnabled(enabled);
        this._selectIconPanel.setEnabled(enabled);
        this._alignPanel.setEnabled(enabled);
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        super.savePanel();
        this._properties.iconPath = this._selectIconPanel.getPath();
        Object selectedItem = this._alignCombo.getSelectedItem();
        if ("Center".equals(selectedItem)) {
            this._properties.setAlign(1);
        } else if ("Right".equals(selectedItem)) {
            this._properties.setAlign(2);
        } else if ("Left".equals(selectedItem)) {
            this._properties.setAlign(0);
        }
        return true;
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        super.fillPanel();
        this._selectIconPanel.setPath(this._properties.iconPath);
        if (this._properties.align == 1) {
            this._alignCombo.setSelectedItem("Center");
        } else if (this._properties.align == 0) {
            this._alignCombo.setSelectedItem("Left");
        } else if (this._properties.align == 2) {
            this._alignCombo.setSelectedItem("Right");
        }
    }

    public boolean isSelected() {
        return this._showLabelPanel.isSelected();
    }

    public void setSelected(boolean selected) {
        this._showLabelPanel.setSelected(selected);
    }
}

