/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLabel;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.LegendPict;
import hec.gfx2d.text.TextSubstitutionManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;
import rma.swing.RmaJMenuLabel;

public class LegendItem
extends G2dComponent {
    public G2dLabel label;
    public LegendPict pict;
    public int m_curveIndex = 0;
    public G2dGlyph m_glyph = null;

    public LegendItem(G2dPanel p, G2dGlyph g, int curveIndex) {
        this._parent = p;
        this.m_glyph = g;
        this.m_curveIndex = curveIndex;
        this.buildDefaultComponents();
    }

    public G2dGlyph getGlyph() {
        return this.m_glyph;
    }

    void buildDefaultComponents() {
        this.pict = new LegendPict(this._parent, this.m_glyph, this.m_curveIndex);
        this.label = new LegendLabel(this.m_glyph, this.m_curveIndex, this._parent, 0);
        this.label.addPropertiesOKListener(new PropertiesOKListener());
    }

    @Override
    public void paintGfx(Graphics g) {
    }

    public void setProperties(G2dLabelDrawProp prop) {
        if (prop != null) {
            this.label.setProperties(prop);
        }
    }

    public G2dLabelDrawProp getProperties() {
        return this.label.getProperties();
    }

    class LegendLabel
    extends G2dLabel {
        G2dGlyph mGlyph;
        Object[] mTextSubObject;

        public LegendLabel(G2dGlyph glyph, int curveIndex, G2dPanel p, int align) {
            super(p, align);
            this.mGlyph = null;
            this.mTextSubObject = null;
            this.mGlyph = glyph;
            this.setText(glyph.getCurveName(curveIndex));
            G2dLabelDrawProp properties = new G2dLabelDrawProp(LegendPanelProp.getDefaultLegendLabelProperties());
            if (properties.text == null || properties.text.length() == 0) {
                properties.text = glyph.getCurveName(curveIndex);
            }
            properties.align = align;
            this.setProperties(properties);
        }

        public LegendLabel(G2dPanel p, int align, int rot) {
            super(p, align, rot);
            this.mGlyph = null;
            this.mTextSubObject = null;
            this.initProperties();
        }

        @Override
        public void setText(String text) {
            super.setText(text);
        }

        @Override
        public void setProperties(G2dLabelDrawProp prop) {
            super.setProperties(prop);
        }

        @Override
        public void setText(String txt, String delim) {
            super.setText(txt, delim);
        }

        @Override
        public void setSize(Dimension d) {
            super.setSize(d);
        }

        @Override
        public void setSize(int width, int height) {
            super.setSize(width, height);
        }

        @Override
        public Object[] getTextSubstitutionObjects() {
            if (this.mTextSubObject == null) {
                this.mTextSubObject = new Object[]{this.mGlyph.getG2dObject()};
            }
            return this.mTextSubObject;
        }

        @Override
        public void createPopupMenu() {
            super.createPopupMenu();
            JPopupMenu popup = this._popupMenu;
            Component comp0 = popup.getComponent(0);
            if (comp0 instanceof RmaJMenuLabel) {
                Font f = comp0.getFont();
                f = new Font(f.getName(), 2, f.getSize());
                comp0.setFont(f);
            }
            LegendItem.this.pict.createPopupMenu();
            this._popupMenu = LegendItem.this.pict._popupMenu;
            this._popupMenu.remove(2);
            this._popupMenu.insert(popup.getComponent(2), 2);
        }

        protected void initProperties() {
        }

        @Override
        public boolean objectPopupMenu(LocalPt pt, int modifiers) {
            this.createPopupMenu();
            Component comp0 = this._popupMenu.getComponent(0);
            if (comp0 instanceof RmaJMenuLabel) {
                RmaJMenuLabel label = (RmaJMenuLabel)comp0;
                String strlabel = TextSubstitutionManager.getTextSubstitutionManager().replaceTokens(this.getText(), this.getTextSubstitutionObjects());
                label.setText(strlabel);
            }
            Rectangle boundingRect = this.getBounds();
            Dimension prefSize = this.getPreferredSize();
            boundingRect.width = prefSize.width;
            boundingRect.height = prefSize.height;
            if (!boundingRect.contains(new Point(pt.x, pt.y))) {
                return false;
            }
            this._popupMenu.show(this, pt.x - boundingRect.x, pt.y - boundingRect.y);
            return true;
        }

        @Override
        public void editProperties() {
            LegendItem.this.m_glyph.editLineProperties(LegendItem.this.m_curveIndex);
            if (LegendItem.this.m_glyph.m_linePropertiesPanel != null) {
                LegendItem.this.m_glyph.m_linePropertiesPanel.setSelectedTabIndex(1);
            }
        }
    }

    private class PropertiesOKListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            LegendItem.this.getG2dPanel().revalidate();
            LegendItem.this.getG2dPanel().getLegendPanel().revalidate();
            LegendItem.this.getG2dPanel().repaint();
            LegendItem.this.getG2dPanel().getLegendPanel().repaint();
        }
    }
}

