/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.LegendItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTextField;

public class LegendItemContainer
extends G2dComponent {
    Vector m_itemVector = new Vector();
    int m_layout = 0;
    boolean resetBounds = false;

    public LegendItemContainer(G2dPanel p, int layout) {
        super(p);
        this.setLayout(layout);
        this.setBackground(null);
    }

    public void setLayout(int layout) {
        if (layout != 0 && layout != 1) {
            return;
        }
        this.m_layout = layout;
    }

    public void addItem(LegendItem item) {
        this.m_itemVector.addElement(item);
        this.resetConstraints();
    }

    public void setItems(List<LegendItem> items) {
        this.m_itemVector.clear();
        this.m_itemVector.addAll(items);
        this.resetConstraints();
    }

    public void addItems(List<LegendItem> items) {
        this.m_itemVector.addAll(items);
        this.resetConstraints();
    }

    public void removeAllItems() {
        this.m_itemVector.removeAllElements();
        super.removeAll();
    }

    public int numLegendItems() {
        return this.m_itemVector.size();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.resetConstraints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        LegendItemContainer legendItemContainer = this;
        synchronized (legendItemContainer) {
            if (!this.resetBounds) {
                this.resetBounds = true;
                this.resetConstraints();
                this.resetBounds = false;
            }
        }
    }

    void resetConstraints() {
        this.removeAll();
        if (this.m_layout == 0) {
            this.layoutHorizontally();
        } else {
            this.layoutVertically();
        }
        if (this._parent != null) {
            this._parent.repaint();
        }
    }

    private void layoutHorizontally() {
        Dimension dim = this.getSize();
        int w = this.getMaxItemWidth();
        int ncol = dim.width / w;
        if (ncol < 1) {
            ncol = 1;
        }
        this.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        int icnt = 0;
        int x = 0;
        Enumeration e = this.m_itemVector.elements();
        while (e.hasMoreElements()) {
            LegendItem item = (LegendItem)e.nextElement();
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = icnt % ncol * 2;
            gc.gridy = icnt / ncol;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.anchor = 10;
            gc.fill = 0;
            gridbag.setConstraints(item.pict, gc);
            this.add(item.pict);
            ++x;
            gc = new GridBagConstraints();
            gc.gridx = icnt % ncol * 2 + 1;
            gc.gridy = icnt / ncol;
            if (icnt % ncol == 0) {
                gc.gridwidth = 1;
                gc.weightx = 1.0;
            } else {
                gc.weightx = 0.0;
                gc.insets = new Insets(0, 0, 0, 5);
            }
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.anchor = 17;
            gc.fill = 2;
            gridbag.setConstraints(item.label, gc);
            this.add(item.label);
            if (icnt == 1) {
                JTextField jtf = new JTextField();
                jtf.setBorder(BorderFactory.createLineBorder(Color.black));
                jtf.setText(item.label.getText());
                jtf.selectAll();
            }
            ++x;
            ++icnt;
        }
        if (this._parent != null) {
            this._parent.invalidate();
            this._parent.validate();
        }
    }

    private void layoutVertically() {
        this.setLayout(new GridBagLayout());
        Dimension dim = this.getSize();
        int icnt = 1;
        for (int i = 0; i < this.m_itemVector.size(); ++i) {
            LegendItem item = (LegendItem)this.m_itemVector.elementAt(i);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = i * 2;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.anchor = 11;
            this.add((Component)item.pict, gc);
            gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = i * 2 + 1;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            gc.weighty = i == this.m_itemVector.size() - 1 ? 1.0 : 0.0;
            gc.anchor = 11;
            this.add((Component)item.label, gc);
            ++icnt;
        }
        if (this._parent != null) {
            this._parent.invalidate();
            this._parent.validate();
        }
    }

    int getMaxItemWidth() {
        int w = 10;
        Graphics g = this.getGraphics();
        FontMetrics fm = null;
        if (g != null) {
            fm = g.getFontMetrics();
        }
        Toolkit tk = this.getToolkit();
        Enumeration e = this.m_itemVector.elements();
        while (e.hasMoreElements()) {
            LegendItem item = (LegendItem)e.nextElement();
            Dimension dimp = item.pict.getPreferredSize();
            if (fm == null) {
                fm = tk.getFontMetrics(item.label.getG2dFont());
            }
            Dimension diml = item.label.getPreferredSize();
            if (w >= dimp.width + diml.width) continue;
            w = dimp.width + diml.width;
        }
        return w;
    }

    public LegendItem getLegendItem(int index) {
        if (index < 0 || index >= this.m_itemVector.size()) {
            return null;
        }
        return (LegendItem)this.m_itemVector.elementAt(index);
    }

    void objectSelect(LocalPt newPt, int modifiers) {
        Point pt = new Point(newPt.x, newPt.y);
        Rectangle thisRect = this.getBounds();
        for (Object object : this.m_itemVector) {
            LegendItem li = (LegendItem)object;
            Rectangle labelRect = li.label.getBounds();
            Point labelPt = new Point(pt.x - labelRect.x, pt.y - labelRect.y);
            Rectangle pictRect = li.pict.getBounds();
            Point pictPt = new Point(pt.x - pictRect.x, pt.y - pictRect.y);
            if (!li.label.contains(labelPt) && !li.pict.contains(pictPt)) continue;
            li.pict.pingCurve();
            Dimension d = this.getSize();
            this.paintImmediately(new Rectangle(0, 0, d.width, d.height));
            Rectangle union = pictRect.union(labelRect);
            Graphics g = this.getGraphics();
            g.setColor(Color.red);
            g.drawRect(union.x, union.y, union.width - 1, union.height - 1);
            g.dispose();
        }
    }
}

