/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.IScale;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPaint;
import hec.gfx2d.Symbol;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashMap;
import rma.util.FillPatternFactory;

public class LegendItemDrawUtilities {
    public static void drawLegendPict(Graphics g, G2dLineProperties prop, Dimension dim, int deviceResolution) {
        Stroke oldStroke = null;
        if (prop.drawLine()) {
            if (g instanceof Graphics2D) {
                oldStroke = ((Graphics2D)g).getStroke();
                ((Graphics2D)g).setStroke(new BasicStroke(prop.getLineWidth(), prop._endStyle, 0, 10.0f, prop.getLinePattern(), 0.0f));
            }
            Color oldColor = g.getColor();
            Color lineColor = prop.getLineColor();
            int alpha = (int)(255.0 * (100.0 - (double)prop.getLineTransparency()) / 100.0);
            lineColor = new Color(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue(), alpha);
            g.setColor(lineColor);
            int width = dim.width - 2;
            g.drawLine(1, dim.height / 2, width, dim.height / 2);
            Rectangle r = null;
            if (prop.getFillType() == 1) {
                r = new Rectangle();
                r.x = 1;
                r.y = 1;
                r.height = dim.height / 2 - 1;
                r.width = width;
            } else if (prop.getFillType() == 2) {
                r = new Rectangle();
                r.x = 1;
                r.y = dim.height / 2 + 1;
                r.height = dim.height / 2 - 2;
                r.width = width;
            }
            Composite oldAc = null;
            Paint oldPaint = null;
            if (g instanceof Graphics2D) {
                oldPaint = ((Graphics2D)g).getPaint();
                oldAc = ((Graphics2D)g).getComposite();
            }
            if (r != null) {
                Paint tp;
                Paint fillPaint = prop.getFillPaint();
                if (fillPaint != null) {
                    tp = fillPaint;
                    if (tp instanceof G2dPaint) {
                        HashMap<String, Object> drawParameters = new HashMap<String, Object>();
                        Rectangle worldRegion = r;
                        drawParameters.put("WORLD_BOUNDS", worldRegion);
                        drawParameters.put("SCALE", new IdentityScale());
                        ((G2dPaint)tp).setPaintParameters(drawParameters);
                    }
                } else {
                    Color fillColor = prop.getFillColor();
                    alpha = (int)(255.0 * (100.0 - (double)prop.getFillTransparency()) / 100.0);
                    fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), alpha);
                    tp = FillPatternFactory.createFillPattern(prop.getFillPattern(), fillColor);
                }
                ((Graphics2D)g).setPaint(tp);
                g.fillRect(r.x, r.y, r.width, r.height);
            }
            if (g instanceof Graphics2D && oldStroke != null) {
                ((Graphics2D)g).setStroke(oldStroke);
                ((Graphics2D)g).setComposite(oldAc);
                ((Graphics2D)g).setPaint(oldPaint);
            }
            g.setColor(oldColor);
        }
        if (prop.drawPoints()) {
            int resolution = deviceResolution;
            Symbol.draw2(g, dim.width / 2, dim.height / 2, prop.getSymbolType(), prop.getPointLineColor(), prop.getPointFillColor(), prop.getSymbolSize(), resolution);
        }
    }

    private static class IdentityScale
    implements IScale {
        private IdentityScale() {
        }

        @Override
        public int e2x(double e) {
            return (int)e;
        }

        @Override
        public int n2y(double n) {
            return (int)n;
        }

        @Override
        public double x2e(int x) {
            return x;
        }

        @Override
        public double y2n(int y) {
            return y;
        }
    }
}

