/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLabel;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.LegendItem;
import hec.gfx2d.LegendItemContainer;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.LegendPropertiesPanel;
import hec.gfx2d.NoLegend;
import hec.gfx2d.Viewport;
import hec.gfx2d.border.EdgeBorder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJMenuLabel;

public class LegendPanel
extends G2dComponent {
    public static final int VERTICAL_LAYOUT = 1;
    public static final int HORIZONTAL_LAYOUT = 0;
    public static final int SEPARATE_WINDOW = 5;
    public static final int SEPERATE_WINDOW = 5;
    public static final int VIEWPORT_LEGEND_UPPER_LEFT = 6;
    public static final int VIEWPORT_LEGEND_UPPER_RIGHT = 7;
    G2dLabel _leftLabel = null;
    G2dLabel _rightLabel = null;
    LegendItemContainer _itemContainer = null;
    G2dLabel _legendTitle = null;
    Vector _viewportVector = new Vector();
    Vector _glyphVector = new Vector();
    String _title = "HEC\nDSSGUI";
    int _titleFontSize = 12;
    int _fontSize = 10;
    int _layoutConfiguration = 0;
    LegendPanelProp _properties = new LegendPanelProp();
    Map<G2dGlyph, G2dLabelDrawProp> _legendItemPropCache = new HashMap<G2dGlyph, G2dLabelDrawProp>();
    int _legendPosition = 0;

    public LegendPanel(G2dPanel p) {
        super(p);
        this.buildDefaultComponents(this._properties);
        this.setBackground(null);
    }

    public LegendPanel(G2dPanel p, LegendPanelProp prop) {
        this(p);
        this._properties = prop;
        this.buildDefaultComponents(this._properties);
        this.setBackground(null);
    }

    public LegendPanel(G2dPanel p, int layout) {
        this(p);
        this.setLayout(layout);
        this.buildDefaultComponents(this._properties);
        this.setBackground(null);
    }

    public LegendPanel(G2dPanel p, LegendPanelProp prop, int layout) {
        this(p);
        this._properties = prop;
        this.setLayout(layout);
        this.buildDefaultComponents(this._properties);
        this.setBackground(null);
    }

    public void setLayout(int layout) {
        if (layout != 1 && layout != 0) {
            return;
        }
        this._layoutConfiguration = layout;
        if (this._itemContainer != null) {
            this._itemContainer.setLayout(layout);
        }
    }

    public void setLegendPosition(int legendPosition) {
        this._legendPosition = legendPosition;
        this._properties.legendPosition = legendPosition;
    }

    @Deprecated
    public void setLegendPosistion(int legendPosition) {
        this.setLegendPosition(legendPosition);
    }

    public int getLegendPosition() {
        return this._legendPosition;
    }

    public G2dLabel getTitleLabel() {
        return this._legendTitle;
    }

    public G2dLabel getLeftLabel() {
        return this._leftLabel;
    }

    public G2dLabel getRightLabel() {
        return this._rightLabel;
    }

    public LegendItem getLegendItem(G2dObject g2dObject) {
        return this.getLegendItem(g2dObject, 0);
    }

    public LegendItem getLegendItem(G2dObject g2dObject, int curveNum) {
        if (g2dObject == null) {
            return null;
        }
        for (int i = 0; i < this._itemContainer.numLegendItems(); ++i) {
            G2dObject glyphObject;
            LegendItem item = this._itemContainer.getLegendItem(i);
            G2dGlyph g2dGlyph = item.getGlyph();
            if (g2dGlyph == null || (glyphObject = g2dGlyph.getG2dObject()) == null || !g2dObject.equals(glyphObject) || item.m_curveIndex != curveNum) continue;
            return item;
        }
        return null;
    }

    public void addViewport(Viewport view) {
        if (this._viewportVector.contains(view)) {
            return;
        }
        int oldSize = this._viewportVector.size();
        int totalCurveCount = 0;
        for (int i = 0; i < oldSize; ++i) {
            Viewport v = (Viewport)this._viewportVector.get(i);
            if (v == null) continue;
            Vector glyphVector = v.getGlyphVector();
            for (Object object : glyphVector) {
                totalCurveCount += ((G2dGlyph)object).getCurveCount();
            }
        }
        this._viewportVector.addElement(view);
        Vector gvec = view.getGlyphVector();
        ArrayList<LegendItem> legendItems = new ArrayList<LegendItem>();
        block2: for (int i = 0; i < gvec.size(); ++i) {
            G2dGlyph g = (G2dGlyph)gvec.elementAt(i);
            if (g instanceof NoLegend) continue;
            this._glyphVector.addElement(g);
            int curveCount = g.getCurveCount();
            for (int cIndex = 0; cIndex < curveCount; ++cIndex) {
                if (!g.isCurveDrawn(cIndex)) continue;
                LegendItem li = new LegendItem(this._parent, g, cIndex);
                G2dLabelDrawProp tempProp = this._legendItemPropCache.get(g);
                if (tempProp != null) {
                    li.setProperties(tempProp);
                } else if (totalCurveCount < this._properties.legendItemPropVec.size()) {
                    li.setProperties((G2dLabelDrawProp)this._properties.legendItemPropVec.elementAt(totalCurveCount));
                    this._legendItemPropCache.put(g, (G2dLabelDrawProp)this._properties.legendItemPropVec.elementAt(totalCurveCount));
                } else {
                    G2dLabelDrawProp dprop = new G2dLabelDrawProp(LegendPanelProp.getDefaultLegendLabelProperties());
                    li.setProperties(dprop);
                    this._properties.legendItemPropVec.add(dprop);
                    this._legendItemPropCache.put(g, dprop);
                }
                legendItems.add(li);
                ++totalCurveCount;
                if (!g.showAllCurvesOnLegend()) continue block2;
            }
        }
        this._itemContainer.addItems(legendItems);
    }

    public void refreshLegendItems() {
        this.fillGlyphVector();
    }

    public void fillGlyphVector() {
        Hashtable<G2dObject, G2dObject> table = new Hashtable<G2dObject, G2dObject>();
        this._glyphVector.removeAllElements();
        this._itemContainer.removeAllItems();
        int legendItemCnt = 0;
        Enumeration e = this._viewportVector.elements();
        while (e.hasMoreElements()) {
            Viewport vp = (Viewport)e.nextElement();
            Vector gvec = vp.getGlyphVector();
            block1: for (int i = 0; i < gvec.size(); ++i) {
                G2dObject go;
                G2dGlyph g = (G2dGlyph)gvec.elementAt(i);
                if (g instanceof NoLegend || table.get(go = g.getG2dObject()) != null) continue;
                table.put(go, go);
                this._glyphVector.addElement(g);
                if (g.isLegendItemsVisible()) {
                    int curveCount = g.getCurveCount();
                    for (int cIndex = 0; cIndex < curveCount; ++cIndex) {
                        if (!g.isCurveDrawn(cIndex)) continue;
                        LegendItem li = new LegendItem(this._parent, g, cIndex);
                        G2dLabelDrawProp tempProp = this._legendItemPropCache.get(g);
                        if (tempProp != null) {
                            li.setProperties(tempProp);
                        } else if (legendItemCnt < this._properties.legendItemPropVec.size()) {
                            tempProp = (G2dLabelDrawProp)this._properties.legendItemPropVec.elementAt(legendItemCnt);
                            li.setProperties(tempProp);
                            this._legendItemPropCache.put(g, tempProp);
                        } else {
                            G2dLabelDrawProp dprop = new G2dLabelDrawProp(LegendPanelProp.getDefaultLegendLabelProperties());
                            li.setProperties(dprop);
                            this._properties.legendItemPropVec.add(dprop);
                            this._legendItemPropCache.put(g, dprop);
                        }
                        this._itemContainer.addItem(li);
                        ++legendItemCnt;
                        if (!g.showAllCurvesOnLegend()) continue block1;
                    }
                    continue;
                }
                legendItemCnt += g.getCurveCount();
            }
        }
    }

    public void rebuildall() {
        this.removeAll();
        this.buildDefaultComponents(this._properties);
        this.refreshLegendItems();
    }

    public G2dLabel getLegendLabel(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this._itemContainer.numLegendItems(); ++i) {
            LegendItem item = this._itemContainer.getLegendItem(i);
            if (item == null || item.m_glyph == null || item.m_glyph.getName() == null || !item.m_glyph.getName().equals(name)) continue;
            return item.label;
        }
        return null;
    }

    public G2dLabel getLegendLabel(String name, int curveNumber) {
        if (name == null) {
            return null;
        }
        LegendItem item = this._itemContainer.getLegendItem(curveNumber);
        if (item != null && item.m_glyph != null && item.m_glyph.getName() != null && item.m_glyph.getName().equals(name)) {
            return item.label;
        }
        return null;
    }

    public int getLegendItemCount() {
        return this._itemContainer == null ? 0 : this._itemContainer.numLegendItems();
    }

    public G2dLabel getLegendLabel(int index) {
        if (this._itemContainer == null) {
            return null;
        }
        LegendItem item = this._itemContainer.getLegendItem(index);
        return item == null ? null : item.label;
    }

    void buildDefaultComponents(LegendPanelProp prop) {
        GridBagConstraints gc;
        G2dLabelDrawProp textprop;
        this.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        if (prop.hasLeftText) {
            textprop = prop.leftTextProp;
            this._leftLabel = new G2dLabel(this._parent, textprop.align){

                @Override
                public Dimension getPreferredSizeLocal() {
                    return super.getPreferredSizeLocal();
                }
            };
            this._leftLabel.setText(textprop.text);
            this._leftLabel.setIcon(textprop.iconPath);
            this._leftLabel.setFontSizes(textprop.fontSize, textprop.tinyFontSize, textprop.minFontSize, textprop.maxFontSize);
            this._leftLabel.setFontStyle(textprop.fontStyle);
            this._leftLabel.setProperties(this._properties.leftTextProp);
            gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.weightx = 0.0;
            gc.weighty = 1.0;
            gc.gridheight = 2;
            gc.anchor = 17;
            gc.fill = 1;
            gridbag.setConstraints(this._leftLabel, gc);
            this._leftLabel.setBorder(new EdgeBorder(61440));
            if (this._layoutConfiguration == 0) {
                this.add(this._leftLabel);
            }
        } else {
            this._leftLabel = null;
        }
        if (prop.hasTitleText) {
            this._legendTitle = new G2dLabel(this._parent, 1);
            this._properties.titleTextProp.align = 1;
            this._legendTitle.setProperties(this._properties.titleTextProp);
            this._legendTitle.setText(prop.titleTextProp.text);
            gc = new GridBagConstraints();
            if (this._layoutConfiguration == 0) {
                gc.gridx = 1;
                gc.gridy = 0;
                gc.fill = 2;
                gc.weightx = 1.0;
                gc.weighty = 0.0;
            } else {
                gc.gridy = 0;
                gc.gridx = 0;
                gc.fill = 2;
                gc.weightx = 1.0;
                gc.weighty = 0.0;
            }
            gridbag.setConstraints(this._legendTitle, gc);
            this._legendTitle.setBorder(new EdgeBorder(3840));
            this.add(this._legendTitle);
        } else {
            this._legendTitle = null;
        }
        this._itemContainer = new LegendItemContainer(this._parent, this._layoutConfiguration);
        gc = new GridBagConstraints();
        if (this._layoutConfiguration == 0) {
            gc.gridx = 1;
            gc.gridy = 1;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
        } else {
            gc.gridy = 1;
            gc.gridx = 0;
            gc.fill = 3;
            gc.weightx = 0.0;
            gc.weighty = 1.0;
        }
        gridbag.setConstraints(this._itemContainer, gc);
        this.add(this._itemContainer);
        textprop = prop.rightTextProp;
        final boolean hasLeftText = prop.hasLeftText;
        if (prop.hasRightText) {
            this._rightLabel = new G2dLabel(this._parent, 0, textprop.align){

                @Override
                public void setBounds(int x, int y, int w, int h) {
                    if (LegendPanel.this._layoutConfiguration == 0) {
                        Insets ins = LegendPanel.this.getInsets();
                        h = LegendPanel.this.getSize().height - ins.top - ins.bottom;
                        w = LegendPanel.this.getSize().width - ins.left - ins.right - LegendPanel.this._itemContainer.getSize().width - (hasLeftText && LegendPanel.this._leftLabel != null ? LegendPanel.this._leftLabel.getSize().width : 0);
                        x = LegendPanel.this.getSize().width - w - ins.right;
                    }
                    super.setBounds(x, y, w, h);
                }
            };
            this._rightLabel.setText(textprop.text);
            this._rightLabel.setIcon(textprop.iconPath);
            this._rightLabel.setFontSizes(textprop.fontSize, textprop.tinyFontSize, textprop.minFontSize, textprop.maxFontSize);
            this._rightLabel.setFontStyle(textprop.fontStyle);
            this._rightLabel.setProperties(this._properties.rightTextProp);
            gc = new GridBagConstraints();
            if (this._layoutConfiguration == 0) {
                this._rightLabel.setBorder(new EdgeBorder(240));
                gc.anchor = 13;
                gc.gridx = 2;
                gc.gridy = 0;
                gc.weightx = 0.0;
                gc.weighty = 1.0;
                gc.gridwidth = 1;
                gc.gridheight = 2;
            } else {
                this._rightLabel.setBorder(new EdgeBorder(15));
                gc.anchor = 15;
                gc.gridy = 2;
                gc.gridx = 0;
            }
            gc.fill = 1;
            gridbag.setConstraints(this._rightLabel, gc);
            this.add(this._rightLabel);
        } else {
            this._rightLabel = null;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public boolean objectSelect(LocalPt pt, int modifiers) {
        Rectangle rect = this.getBounds();
        if (!rect.contains(new Point(pt.x, pt.y))) {
            return false;
        }
        rect = this._itemContainer.getBounds();
        LocalPt newPt = new LocalPt(pt.x - rect.x, pt.y - rect.y);
        this._itemContainer.objectSelect(newPt, modifiers);
        return false;
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        Point p;
        Rectangle rect = this.getBounds();
        if (!rect.contains(p = new Point(pt.x, pt.y))) {
            return false;
        }
        String title = "Legend Panel";
        boolean inTitle = false;
        int titleLoc = 0;
        if (this._leftLabel != null && this._leftLabel.getBounds().contains(p)) {
            title = "Left Plot Title";
            inTitle = true;
            titleLoc = 1;
        } else if (this._rightLabel != null && this._rightLabel.getBounds().contains(p)) {
            title = "Right Plot Title";
            inTitle = true;
            titleLoc = 2;
        } else if (this._legendTitle != null && this._legendTitle.getBounds().contains(p)) {
            title = "Plot Title";
            inTitle = true;
            titleLoc = 0;
        }
        rect = this._itemContainer.getBounds();
        LocalPt newPt = new LocalPt(pt.x - rect.x, pt.y - rect.y);
        Component x = this._itemContainer.getComponentAt(newPt.x, newPt.y);
        if (x instanceof G2dComponent && x != this._itemContainer && ((G2dComponent)x).objectPopupMenu(newPt, modifiers)) {
            return true;
        }
        JPopupMenu pMenu = new JPopupMenu();
        RmaJMenuLabel label = new RmaJMenuLabel(title);
        Font f = label.getFont();
        f = new Font(f.getName(), 2, f.getSize());
        label.setFont(f);
        pMenu.add(label);
        pMenu.addSeparator();
        final int fTitleLoc = titleLoc;
        JMenuItem menuItem = new JMenuItem("Edit Properties");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegendPanel.this.editProperties(fTitleLoc);
            }
        });
        pMenu.add(menuItem);
        pMenu.addSeparator();
        if (inTitle) {
            menuItem = new JMenuItem("Hide Legend Title");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LegendPanel.this.setTitleVisible(fTitleLoc, false);
                }
            });
        } else {
            menuItem = new JMenuItem("Hide Legend");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LegendPanel.this.setVisible(false);
                }
            });
        }
        pMenu.add(menuItem);
        for (Container w = this; !(w instanceof Frame) && w != null; w = w.getParent()) {
        }
        pMenu.show(this, pt.x, pt.y);
        return true;
    }

    public void setTitle(String legendTitleText) {
        this._properties.titleTextProp.text = legendTitleText;
        this.setTitleVisible(0, true);
    }

    private void setTitleVisible(int titleLoc, boolean visible) {
        boolean changed = false;
        switch (titleLoc) {
            case 1: {
                if (this._properties.hasLeftText == visible) break;
                this._properties.hasLeftText = visible;
                changed = true;
                break;
            }
            case 2: {
                if (this._properties.hasRightText == visible) break;
                this._properties.hasRightText = visible;
                changed = true;
                break;
            }
            case 0: {
                if (this._properties.hasTitleText == visible) break;
                this._properties.hasTitleText = visible;
                changed = true;
            }
        }
        if (changed) {
            this.removeAll();
            this.buildDefaultComponents(this._properties);
            this.fillGlyphVector();
            this.invalidate();
            this._parent.invalidate();
            this._parent.validate();
            this._parent.repaint();
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return "Legend";
    }

    public void setProperties(LegendPanelProp prop) {
        if (prop == null) {
            return;
        }
        this._properties = prop;
        if (this._leftLabel != null) {
            this._leftLabel.setProperties(prop.leftTextProp);
        }
        if (this._rightLabel != null) {
            this._rightLabel.setProperties(prop.rightTextProp);
        }
        this.setLegendPosistion(this._properties.legendPosition);
        this._legendItemPropCache.clear();
        for (int i = 0; i < this._itemContainer.numLegendItems(); ++i) {
            LegendItem li = this._itemContainer.getLegendItem(i);
            if (li == null || i >= prop.legendItemPropVec.size()) continue;
            li.setProperties((G2dLabelDrawProp)prop.legendItemPropVec.elementAt(i));
        }
    }

    public LegendPanelProp getProperties() {
        LegendPanelProp lgp = new LegendPanelProp();
        if (this._leftLabel != null) {
            lgp.hasLeftText = true;
            lgp.leftTextProp = this._leftLabel.getProperties();
        } else {
            lgp.hasLeftText = false;
            lgp.leftTextProp = new G2dLabelDrawProp();
        }
        if (this._rightLabel != null) {
            lgp.hasRightText = true;
            lgp.rightTextProp = this._rightLabel.getProperties();
        } else {
            lgp.hasRightText = false;
            lgp.rightTextProp = new G2dLabelDrawProp();
        }
        if (this._legendTitle != null) {
            lgp.hasTitleText = true;
            lgp.titleTextProp = this._legendTitle.getProperties();
        } else {
            lgp.hasTitleText = false;
            lgp.titleTextProp = new G2dLabelDrawProp();
        }
        lgp.legendItemPropVec = new Vector();
        for (int i = 0; i < this._itemContainer.numLegendItems(); ++i) {
            lgp.legendItemPropVec.addElement(this._itemContainer.getLegendItem(i).getProperties());
        }
        lgp.layoutPosition = this._layoutConfiguration;
        lgp.legendPosition = this._legendPosition;
        return lgp;
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this._parent.revalidate();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this._parent.revalidate();
    }

    @Override
    public void editProperties() {
        this.editProperties(0);
    }

    public void editProperties(int tabIndex) {
        PropertiesOKListener listener = new PropertiesOKListener();
        G2dPropertiesDlg dialog = null;
        DefaultJPanel[] propertiesPanels = this.buildPropertiesPanel();
        Window w = SwingUtilities.windowForComponent(this);
        dialog = w instanceof Frame ? new G2dPropertiesDlg((Frame)w, false, "Edit Legend Properties", propertiesPanels) : new G2dPropertiesDlg((Dialog)w, false, "Edit Legend Properties", propertiesPanels);
        dialog.addOKListener(listener);
        if (propertiesPanels[0] instanceof LegendPropertiesPanel) {
            LegendPropertiesPanel lpp = (LegendPropertiesPanel)propertiesPanels[0];
            lpp.setSelectedTabIndex(tabIndex);
        } else {
            dialog.setSelectedTabIndex(tabIndex);
        }
        dialog.setVisible(true);
    }

    protected DefaultJPanel[] buildPropertiesPanel() {
        DefaultJPanel[] panels = new DefaultJPanel[]{new LegendPropertiesPanel()};
        ((LegendPropertiesPanel)panels[0]).setData(this._properties);
        return panels;
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LegendPanel.this._glyphVector.clear();
            LegendPanel.this._viewportVector.clear();
            LegendPanel.this._itemContainer.removeAllItems();
            Vector viewportVector = LegendPanel.this._parent._viewportVector;
            LegendPanel.this.removeAll();
            LegendPanel.this.buildDefaultComponents(LegendPanel.this.getProperties());
            Enumeration ev = viewportVector.elements();
            while (ev.hasMoreElements()) {
                LegendPanel.this.addViewport((Viewport)ev.nextElement());
            }
            LegendPanel.this._itemContainer.resetConstraints();
            int idx = LegendPanel.this._properties.legendPosition;
            switch (idx) {
                case 0: {
                    LegendPanel.this._parent.moveLegendToPosition(0);
                    break;
                }
                case 1: {
                    LegendPanel.this._parent.moveLegendToPosition(1);
                    break;
                }
                case 5: {
                    LegendPanel.this._parent.moveLegendToPosition(5);
                    break;
                }
                case 6: {
                    LegendPanel.this._parent.moveLegendToPosition(6);
                    break;
                }
                case 7: {
                    LegendPanel.this._parent.moveLegendToPosition(7);
                }
            }
            LegendPanel.this._parent.setLegendVisible(LegendPanel.this._properties.legendVisible);
            LegendPanel.this.refreshLegendItems();
            LegendPanel.this._parent.invalidate();
            LegendPanel.this._parent.validate();
            LegendPanel.this._parent.repaint();
        }
    }
}

