/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.LocalPt;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dResolutionConst;
import hec.gfx2d.Viewport;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import rma.swing.RmaJMenuLabel;
import rma.swing.RmaJPopupMenu;

public class LegendPict
extends G2dComponent
implements ActionListener {
    G2dGlyph _glyph = null;
    int _curveIndex = 0;

    public LegendPict(G2dPanel p, G2dGlyph g, int curveIndex) {
        super(p);
        this._glyph = g;
        this._curveIndex = curveIndex;
        this.setBackground(null);
    }

    public boolean pingCurve() {
        Viewport[] viewports = this._parent.getViewports();
        Graphics g = null;
        Rectangle bounds = null;
        for (int i = 0; i < viewports.length; ++i) {
            if (!viewports[i].hasG2dObject(this._glyph.getG2dObject())) continue;
            Dimension d = viewports[i].getSize();
            viewports[i].paintImmediately(new Rectangle(0, 0, d.width, d.height));
            g = viewports[i].getGraphics();
            bounds = viewports[i].getBounds();
            break;
        }
        if (g == null) {
            return false;
        }
        Rectangle clipBounds = bounds;
        G2dLine line = this._glyph.getLine(this._curveIndex);
        if (line != null) {
            G2dLineProperties properties = line.getProperties();
            G2dLineProperties original = properties.clone();
            properties._lineWidth += 4.0f;
            properties._symbolSize += 4.0f;
            line.setProperties(properties);
            Rectangle rect = new Rectangle(0, 0, clipBounds.width, clipBounds.height);
            line.drawLine(g, rect);
            line.setProperties(original);
        }
        return true;
    }

    @Override
    public void createPopupMenu() {
        if (this._glyph == null) {
            return;
        }
        this._popupMenu = new RmaJPopupMenu("Line Properties");
        final G2dLine line = this._glyph.getLine(this._curveIndex);
        if (line == null) {
            return;
        }
        RmaJMenuLabel rjm = new RmaJMenuLabel(line.toString());
        Font f = rjm.getFont();
        f = new Font(f.getName(), 2, f.getSize());
        rjm.setFont(f);
        this._popupMenu.add(rjm);
        this._popupMenu.addSeparator();
        JMenuItem jm = new JMenuItem("Edit Properties");
        jm.setName("EDIT_PROPERTIES");
        jm.addActionListener(this);
        this._popupMenu.add(jm);
        this._popupMenu.addSeparator();
        String text = this._glyph.isLineVisible() ? "Hide Curve" : "Show Curve";
        jm = new JMenuItem(text);
        jm.setName("HIDE_UNHIDE");
        jm.addActionListener(this);
        this._popupMenu.add(jm);
        jm = new JMenuItem("Remove Curve");
        jm.setName("REMOVE");
        jm.addActionListener(this);
        this._popupMenu.add(jm);
        this._popupMenu.addSeparator();
        jm = new JMenuItem("Hide Legend Item");
        jm.setName("HIDE_LEGEND_ITEM");
        jm.addActionListener(this);
        this._popupMenu.add(jm);
        if (line.m_calloutTable.size() > 0) {
            this._popupMenu.addSeparator();
            jm = new JMenuItem(line._drawCallouts ? "Hide Callouts" : "Show Callouts");
            jm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    line._drawCallouts = !line._drawCallouts;
                    LegendPict.this._glyph.getViewport().setDirty();
                    SwingUtilities.windowForComponent(LegendPict.this._glyph.getViewport()).repaint();
                }
            });
            this._popupMenu.add(jm);
            jm = new JMenuItem("Clear Callouts");
            jm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    line.m_calloutTable.clear();
                    LegendPict.this._glyph.getViewport().setDirty();
                    SwingUtilities.windowForComponent(LegendPict.this._glyph.getViewport()).repaint();
                }
            });
            this._popupMenu.add(jm);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSizeLocal() {
        Dimension dim = this._glyph.getLegendPictSize(this._curveIndex);
        int g2dResolution = this._parent.getDeviceResoultion();
        return new Dimension(dim.width * (g2dResolution / G2dResolutionConst.PRINTER_SCALE), dim.height * (g2dResolution / G2dResolutionConst.PRINTER_SCALE));
    }

    @Override
    public void paintGfx(Graphics g) {
        Dimension dim = this.getSize();
        this._glyph.drawLegendPict(g, this._curveIndex, dim);
    }

    public boolean objectSelect(LocalPt pt, int modifiers) {
        Rectangle rect = this.getBounds();
        if (!rect.contains(new Point(pt.x, pt.y))) {
            return false;
        }
        return this.pingCurve();
    }

    @Override
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        Rectangle rect = this.getBounds();
        if (!rect.contains(new Point(pt.x, pt.y))) {
            return false;
        }
        this.createPopupMenu();
        this._popupMenu.show(this, pt.x - rect.x, pt.y - rect.y);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)obj;
            if (menuItem.getName().equals("EDIT_PROPERTIES")) {
                this.editLineProperties();
            } else if (menuItem.getName().equalsIgnoreCase("HIDE_UNHIDE")) {
                this._glyph.setLineVisible(!this._glyph.isLineVisible());
                this._glyph.getViewport().setDirty();
                SwingUtilities.windowForComponent(this._glyph.getViewport()).repaint();
            } else if (menuItem.getName().equalsIgnoreCase("REMOVE")) {
                this.removeGlyph();
            } else if (menuItem.getName().equalsIgnoreCase("HIDE_LEGEND_ITEM")) {
                this._glyph.setLegendItemsVisible(false);
                this._parent.getLegendPanel().refreshLegendItems();
                this._parent.repaint();
            }
        }
    }

    private void removeGlyph() {
        this._parent.removeGlyph(this._glyph);
    }

    public void editLineProperties() {
        this._glyph.editLineProperties(this._curveIndex);
    }
}

