/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.gfx2d.LegendBlockPropertiesPanel;
import hec.gfx2d.LegendPanelProp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;

public class LegendPropertiesPanel
extends DefaultJPanel {
    private RmaJCheckBox _showLegend;
    private RmaJComboBox _legendPositionCombo;
    private JTabbedPane _tabbedPane;
    private LegendBlockPropertiesPanel _titlePanel;
    private LegendBlockPropertiesPanel _leftPanel;
    private LegendBlockPropertiesPanel _rightPanel;
    private LegendPanelProp _properties;

    public LegendPropertiesPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this.setName("Legend");
        this._showLegend = new RmaJCheckBox("Show Legend");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._showLegend, gbc);
        JLabel label = new JLabel("Legend Position:");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(7, 5, 0, 5);
        this.add((Component)label, gbc);
        String[] legendPositions = new String[]{"Bottom of Panel", "Right of Panel", "Separate Window", "Viewport Upper Left", "Viewport Upper Right"};
        this._legendPositionCombo = new RmaJComboBox<String>(legendPositions);
        this._legendPositionCombo.setModifiable(true);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._legendPositionCombo, gbc);
        this._tabbedPane = new JTabbedPane();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._tabbedPane, gbc);
        this._titlePanel = new LegendBlockPropertiesPanel("Draw Legend Title", false);
        this._leftPanel = new LegendBlockPropertiesPanel("Draw Left Legend Block", true);
        this._rightPanel = new LegendBlockPropertiesPanel("Draw Right Legend Block", true);
        this._tabbedPane.addTab("Legend Title", this._titlePanel);
        this._tabbedPane.addTab("Left Block", this._leftPanel);
        this._tabbedPane.addTab("Right Block", this._rightPanel);
    }

    public void setData(LegendPanelProp legendProperties) {
        this._properties = legendProperties;
        this._titlePanel.setData(legendProperties.titleTextProp);
        this._rightPanel.setData(legendProperties.rightTextProp);
        this._leftPanel.setData(legendProperties.leftTextProp);
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        this._titlePanel.savePanel();
        this._rightPanel.savePanel();
        this._leftPanel.savePanel();
        this._properties.hasTitleText = this._titlePanel.isSelected();
        this._properties.hasRightText = this._rightPanel.isSelected();
        this._properties.hasLeftText = this._leftPanel.isSelected();
        this._properties.legendVisible = this._showLegend.isSelected();
        int idx = this._legendPositionCombo.getSelectedIndex();
        switch (idx) {
            case 0: {
                this._properties.legendPosition = 0;
                break;
            }
            case 1: {
                this._properties.legendPosition = 1;
                break;
            }
            case 2: {
                this._properties.legendPosition = 5;
                break;
            }
            case 3: {
                this._properties.legendPosition = 6;
                break;
            }
            case 4: {
                this._properties.legendPosition = 7;
            }
        }
        return true;
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        this._titlePanel.fillPanel();
        this._rightPanel.fillPanel();
        this._leftPanel.fillPanel();
        this._titlePanel.setSelected(this._properties.hasTitleText);
        this._rightPanel.setSelected(this._properties.hasRightText);
        this._leftPanel.setSelected(this._properties.hasLeftText);
        this._showLegend.setSelected(this._properties.legendVisible);
        int loc = this._properties.legendPosition;
        int idx = 0;
        switch (loc) {
            case 0: {
                idx = 0;
                break;
            }
            case 1: {
                idx = 1;
                break;
            }
            case 5: {
                idx = 2;
                break;
            }
            case 6: {
                idx = 3;
                break;
            }
            case 7: {
                idx = 4;
            }
        }
        this._legendPositionCombo.setSelectedIndex(idx);
    }

    public LegendPanelProp getProperties() {
        return this._properties;
    }

    public void setSelectedTabIndex(int tabIndex) {
        if (tabIndex < 0 || this._tabbedPane == null) {
            return;
        }
        if (tabIndex >= this._tabbedPane.getTabCount()) {
            return;
        }
        this._tabbedPane.setSelectedIndex(tabIndex);
    }
}

