/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;

public class Log10Curve2D
implements Shape {
    private float _x1;
    private float _x2;
    private float _y1;
    private float _y2;
    private float _a;
    private float _b;

    public Log10Curve2D(float x1, float y1, float x2, float y2, float a, float b) {
        this._x1 = x1;
        this._x2 = x2;
        this._y1 = y1;
        this._y2 = y2;
        this._a = a;
        this._b = b;
    }

    public float solveEquation(float x) {
        return (float)Math.pow(10.0, (double)this._a * Math.log10(x) + (double)this._b);
    }

    public double solveEquation(double x) {
        return (float)Math.pow(10.0, (double)this._a * Math.log10(x) + (double)this._b);
    }

    @Override
    public Rectangle getBounds() {
        float left = Math.min(this._x1, this._x2);
        float top = Math.min(this._y1, this._y2);
        float right = Math.max(this._x1, this._x2);
        float bottom = Math.max(this._y1, this._y2);
        return new Rectangle2D.Float(left, top, right, bottom).getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        float left = Math.min(this._x1, this._x2);
        float top = Math.min(this._y1, this._y2);
        float right = Math.max(this._x1, this._x2);
        float bottom = Math.max(this._y1, this._y2);
        return new Rectangle2D.Float(left, top, right, bottom);
    }

    @Override
    public boolean contains(double x, double y) {
        if (x < (double)this._x1 && x < (double)this._x2 || x > (double)this._x1 && x > (double)this._x2) {
            return false;
        }
        double logY = this.solveEquation(x);
        double linY = this.solveConnector(x);
        return !(y < (double)this._y1 && y < (double)this._y2) && (!(y > (double)this._y1) || !(y > (double)this._y2));
    }

    private double solveConnector(double x) {
        return (double)((this._y2 - this._y1) / (this._x2 - this._x1)) * (x - (double)this._x1) + (double)this._y1;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        if ((x < (double)this._x1 || x < (double)this._x2) && (x + w > (double)this._x1 || x + w > (double)this._x2)) {
            double logY1 = this.solveEquation(x);
            double linY1 = this.solveConnector(x);
            double logY2 = this.solveEquation(x + w);
            double linY2 = this.solveConnector(x + w);
            if ((logY1 < y || logY1 < y + h) && (logY1 > y || logY1 > y + h) || (linY1 < y || linY1 < y + h) && (linY1 > y || linY1 > y + h) || (logY2 < y || logY2 < y + h) && (logY2 > y || logY2 > y + h) || (linY2 < y || linY2 < y + h) && (linY2 > y || linY2 > y + h)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x, y + h) && this.contains(x + w, y) && this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new LogarithmicIterator(this, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return null;
    }

    private double getX1() {
        return this._x1;
    }

    private double getX2() {
        return this._x2;
    }

    private double getY1() {
        return this._y1;
    }

    private double getY2() {
        return this._y2;
    }

    private class LogarithmicIterator
    implements PathIterator {
        Log10Curve2D line;
        AffineTransform affine;
        int index;

        LogarithmicIterator(Log10Curve2D l, AffineTransform at) {
            this.line = l;
            this.affine = at;
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.index > 1;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException("quad iterator iterator out of bounds");
            }
            if (this.index == 0) {
                coords[0] = (float)this.line.getX1();
                coords[1] = (float)this.line.getY1();
                type = 0;
            } else {
                coords[0] = (float)this.line.getX2();
                coords[1] = (float)this.line.getY2();
                type = 1;
            }
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 2);
            }
            return type;
        }

        @Override
        public int currentSegment(double[] coords) {
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException("quad iterator iterator out of bounds");
            }
            if (this.index == 0) {
                coords[0] = this.line.getX1();
                coords[1] = this.line.getY1();
                type = 0;
            } else {
                coords[0] = this.line.getX2();
                coords[1] = this.line.getY2();
                type = 1;
            }
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 2);
            }
            return type;
        }
    }
}

