/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d;

import hec.geometry.Axis;
import hec.geometry.AxisFactory;
import hec.geometry.AxisIterator;
import hec.geometry.LogAxis;
import hec.geometry.LogAxisIterator;
import hec.gfx2d.AxisTics;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.Gfx2dDrawUtil;
import hec.gfx2d.Viewport;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import rma.util.RMAIO;

public class LogAxisTics
extends AxisTics {
    LogAxis _logAxis = null;

    public LogAxisTics(G2dPanel p, LogAxis ax, Viewport vp, int align) {
        super(p, ax, vp, align);
        this._logAxis = ax;
    }

    @Override
    protected void drawTicsRight(Graphics g) {
        AxisIterator iter;
        Rectangle rc = this.getBounds();
        Rectangle vprc = this._viewport.getBounds();
        int space = 2;
        FontMetrics metrics = g.getFontMetrics();
        int ioff = vprc.y - rc.y;
        double majorTic = this._axis.getMajorTic();
        if (this._drawProp.drawMajorTics) {
            g.setColor(this._drawProp.axisTicColor);
            Axis ma = this._viewport.getMasterAxis(1);
            if (ma == null) {
                ma = this._axis;
            }
            iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic());
            while (iter.next()) {
                int ix = ioff + iter.getLocalValue();
                g.drawLine(0, ix, this._drawProp.majorTicLength, ix);
            }
        }
        if (this._drawProp.drawMajorTics && this._drawProp.drawMajorTicLabels) {
            g.setColor(this._drawProp.axisTicColor);
            int dely = Math.abs(this._axis.w2l(majorTic) - this._axis.w2l(1.0));
            int iskip = dely != 0 ? metrics.getHeight() / dely + 1 : metrics.getHeight() + 1;
            Axis ma = this._viewport.getMasterAxis(1);
            if (ma == null) {
                ma = this._axis;
            }
            AxisIterator iter2 = ma instanceof LogAxis ? AxisFactory.createAxisIterator(ma, ma.getMajorTic()) : AxisFactory.createAxisIterator(ma, ma.getMajorTic() * (double)iskip);
            double lastLocal = 0.0;
            while (iter2.next()) {
                double maLocalValue = ma.w2lE(iter2.getValue());
                int iy = ioff + (int)maLocalValue;
                String txt = RMAIO.setPrecision(this._axis.l2wE(maLocalValue) / this._axis.getThousScale(), this._axis.getSigFig());
                int ix = this._drawProp.majorTicLength + space;
                Gfx2dDrawUtil.drawString(this, g, txt, ix, iy + metrics.getMaxAscent() / 2);
            }
        }
        if (this._drawProp.drawMinorTics) {
            g.setColor(this._drawProp.axisTicColor);
            Axis ma = this._viewport.getMasterAxis(1);
            if (ma == null) {
                ma = this._axis;
            }
            iter = AxisFactory.createAxisIterator(ma, ma.getMinorTic());
            iter.iterateMinorScale();
            while (iter.next()) {
                double minorTicWorld = iter.getValue();
                double minorTicPos = iter.getLocalValue();
                int ix = ioff + (int)minorTicPos;
                if (ix > vprc.height + ioff) continue;
                g.drawLine(0, ix, this._drawProp.minorTicLength, ix);
            }
        }
    }

    @Override
    protected void drawTicsLeft(Graphics g) {
        AxisIterator iter;
        Rectangle rc = this.getBounds();
        Rectangle vprc = this._viewport.getBounds();
        int space = 2;
        FontMetrics metrics = g.getFontMetrics();
        int ioff = vprc.y - rc.y;
        double majorTic = this._axis.getMajorTic();
        if (this._drawProp.drawMajorTics) {
            g.setColor(this._drawProp.axisTicColor);
            Axis ma = this._viewport.getMasterAxis(1);
            if (ma == null) {
                ma = this._axis;
            }
            iter = AxisFactory.createAxisIterator(ma, ma.getMajorTic());
            while (iter.next()) {
                int ix = ioff + iter.getLocalValue();
                g.drawLine(rc.width, ix, rc.width - this._drawProp.majorTicLength, ix);
            }
        }
        if (this._drawProp.drawMajorTics && this._drawProp.drawMajorTicLabels) {
            g.setColor(this._drawProp.axisTicColor);
            int dely = Math.abs(this._axis.w2l(majorTic) - this._axis.w2l(1.0));
            int iskip = dely != 0 ? metrics.getHeight() / dely + 1 : metrics.getHeight() + 1;
            Axis ma = this._viewport.getMasterAxis(1);
            if (ma == null) {
                ma = this._axis;
            }
            AxisIterator iter2 = ma instanceof LogAxis ? AxisFactory.createAxisIterator(ma, ma.getMajorTic()) : AxisFactory.createAxisIterator(ma, ma.getMajorTic());
            double lastLocal = 0.0;
            while (iter2.next()) {
                double maLocalValue = ma.w2lE(iter2.getValue());
                int iy = ioff + (int)maLocalValue;
                if (iy > vprc.height + ioff || iy < ioff) continue;
                String txt = RMAIO.setPrecision2(this._axis.l2wE(maLocalValue) / this._axis.getThousScale(), iter2.getSigFig());
                int ix = rc.width - this._drawProp.majorTicLength - space - metrics.stringWidth(txt);
                Gfx2dDrawUtil.drawString(this, g, txt, ix, iy + metrics.getMaxAscent() / 2);
            }
        }
        if (this._drawProp.drawMinorTics) {
            g.setColor(this._drawProp.axisTicColor);
            Axis ma = this._viewport.getMasterAxis(1);
            if (ma == null) {
                ma = this._axis;
            }
            iter = AxisFactory.createAxisIterator(ma, ma.getMinorTic());
            iter.iterateMinorScale();
            while (iter.next()) {
                double minorTicWorld = iter.getValue();
                double minorTicPos = iter.getLocalValue();
                int ix = ioff + (int)minorTicPos;
                if (ix > vprc.height + ioff || ix < ioff) continue;
                g.drawLine(rc.width, ix, rc.width - this._drawProp.minorTicLength, ix);
            }
        }
    }

    @Override
    protected void drawTicsTop(Graphics g) {
        int ix;
        LogAxisIterator iter;
        Rectangle rc = this.getBounds();
        Rectangle vprc = this._viewport.getBounds();
        int space = 2;
        FontMetrics metrics = g.getFontMetrics();
        int ioff = vprc.x - rc.x;
        if (this._drawProp.drawMajorTics) {
            g.setColor(this._drawProp.axisTicColor);
            iter = new LogAxisIterator((LogAxis)this._axis, this._axis.getMajorTic());
            while (iter.next()) {
                ix = ioff + iter.getLocalValue();
                g.drawLine(ix, 0, ix, this._drawProp.majorTicLength);
            }
        }
        if (this._drawProp.drawMajorTics && this._drawProp.drawMajorTicLabels) {
            g.setColor(this._drawProp.axisTicColor);
            double val = this._axis.getActMax() / this._axis.getThousScale();
            String xtxt = RMAIO.setPrecision2(val, this._axis.getSigFig());
            int delx = Math.abs(this._axis.w2l(this._axis.getMajorTic()) - this._axis.w2l(1.0));
            int iskip = delx != 0 ? metrics.getHeight() / delx + 1 : metrics.getHeight() + 1;
            LogAxisIterator iter2 = new LogAxisIterator((LogAxis)this._axis, this._axis.getMajorTic());
            while (iter2.next()) {
                int ix2 = ioff + iter2.getLocalValue();
                String txt = iter2.getValueString();
                int iy = this._drawProp.majorTicLength + space + metrics.getMaxAscent();
                Gfx2dDrawUtil.drawString(this, g, txt, ix2 - metrics.stringWidth(txt) / 2, iy);
            }
        }
        if (this._drawProp.drawMinorTics) {
            g.setColor(this._drawProp.axisTicColor);
            iter = new LogAxisIterator((LogAxis)this._axis, this._axis.getMinorTic());
            iter.iterateMinorScale();
            while (iter.next()) {
                ix = ioff + iter.getLocalValue();
                if (ix > vprc.height + ioff) continue;
                g.drawLine(ix, 0, ix, this._drawProp.minorTicLength);
            }
        }
    }

    @Override
    protected void drawTicsBottom(Graphics g) {
    }
}

